/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;

public class RefactoringHelper {
    public static int indexOfContent(String needle, String haystack, int hayOffset, int len, IDocument doc, int docOffset) {
        String a;
        if (hayOffset < 0) {
            return 0;
        }
        do {
            if ((hayOffset = haystack.indexOf(needle, hayOffset)) != -1) continue;
            return -1;
        } while (!"__dftl_partition_content_type".equals(a = RfBatchUtils.getTypedRegion(doc, hayOffset + docOffset).getType()) && ++hayOffset < len);
        return hayOffset;
    }

    public static int indexOfContent(String needle, String haystack, int hayOffset, int len, IDocument doc, int docOffset, boolean wordBoundry) {
        String a;
        if (hayOffset < 0) {
            return 0;
        }
        Pattern p = wordBoundry ? Pattern.compile("\\b" + needle + "\\b") : Pattern.compile(needle);
        Matcher m = p.matcher(haystack);
        do {
            boolean found;
            if (!(found = m.find(hayOffset))) {
                return -1;
            }
            hayOffset = m.start();
        } while (!"__dftl_partition_content_type".equals(a = RfBatchUtils.getTypedRegion(doc, hayOffset + docOffset).getType()) && ++hayOffset < len);
        return hayOffset;
    }

    public static int indexOfContentWithSLComment(String needle, String haystack, int hayOffset, int len, IDocument doc, int docOffset) {
        String a;
        if (hayOffset < 0) {
            return 0;
        }
        do {
            if ((hayOffset = haystack.indexOf(needle, hayOffset)) != -1) continue;
            return -1;
        } while (!"__dftl_partition_content_type".equals(a = RfBatchUtils.getTypedRegion(doc, hayOffset + docOffset).getType()) && !"__vlog_sl_comment".equals(a) && ++hayOffset < len);
        return hayOffset;
    }

    public static int lastIndexOfContent(String needle, String haystack, int hayOffset, int len, IDocument doc, int docOffset) {
        String a;
        if (hayOffset < 0) {
            return 0;
        }
        do {
            if ((hayOffset = haystack.lastIndexOf(needle, hayOffset)) != -1) continue;
            return -1;
        } while (!"__dftl_partition_content_type".equals(a = RfBatchUtils.getTypedRegion(doc, hayOffset + docOffset).getType()) && --hayOffset >= 0);
        return hayOffset;
    }

    public static int closingBracket(String haystack, int hayOffset, IDocument doc, int docOffset) {
        int opened = 0;
        boolean atLeastOne = false;
        int i = 0;
        while (i + hayOffset < haystack.length()) {
            String a;
            if (haystack.charAt(i + hayOffset) == '(') {
                a = RfBatchUtils.getTypedRegion(doc, docOffset + hayOffset + i).getType();
                if ("__dftl_partition_content_type".equals(a)) {
                    ++opened;
                    atLeastOne = true;
                }
            } else if (haystack.charAt(i + hayOffset) == ')' && "__dftl_partition_content_type".equals(a = RfBatchUtils.getTypedRegion(doc, docOffset + hayOffset + i).getType())) {
                --opened;
            }
            if (atLeastOne && opened == 0) {
                return i + hayOffset;
            }
            ++i;
        }
        return -1;
    }

    public static int goBackwardOverWandT(String line, int offset) {
        char c;
        do {
            if (--offset >= 0) continue;
            return 0;
        } while (((c = line.charAt(offset)) == ' ' || c == '\t') && offset > 0);
        return offset + 1;
    }

    public static int goForwardOverWandTandN(String line, int offset) {
        char c;
        while (((c = line.charAt(offset)) == ' ' || c == '\t' || c == '\n') && ++offset < line.length()) {
        }
        return offset - 1;
    }

    public static ArrayList<RfInstance> filterDuplicates(List<RfInstance> insts) {
        ArrayList<RfInstance> noDuplicates = new ArrayList<RfInstance>();
        for (RfInstance instance : insts) {
            boolean found = false;
            for (RfInstance noDup : noDuplicates) {
                if (!RefactoringHelper.equalRfNamedElement(instance, noDup)) continue;
                found = true;
                break;
            }
            if (found) continue;
            noDuplicates.add(instance);
        }
        return noDuplicates;
    }

    public static List<RfInstance> getAllInstances(RfProject rfProject) {
        ArrayList<RfInstance> result = new ArrayList<RfInstance>();
        RfModule[] rfModuleArray = rfProject.getAllModules();
        int n = rfModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            RfModule module = rfModuleArray[n2];
            List<RfInstance> instances = module.getLocalMembers(RfInstance.class);
            if (instances != null && !instances.isEmpty()) {
                result.addAll(instances);
            }
            ++n2;
        }
        return result;
    }

    public static List<RfPortDef> getModulePortDefs(RfNamedElement module) {
        ArrayList<RfPortDef> defs = new ArrayList<RfPortDef>();
        List<RfPort> ports = module.getPortsWithPrefix("", 2);
        for (RfPort port : ports) {
            for (RfDefElement def : port.getDeclarations()) {
                RfPortDef def2;
                if (!(def instanceof RfPortDef) || !(def2 = (RfPortDef)def).isInListOfPorts()) continue;
                defs.add(def2);
            }
        }
        return defs;
    }

    public static boolean equalRfNamedElement(RfNamedElement a, RfNamedElement b) {
        return a == b || a.getName().equals(b.getName()) && a.getLine() == b.getLine();
    }
}

