/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;

public class RfTreeElementWrapper
extends IDVTElementWrapper {
    private static final int INITIAL_CAPACITY = 4;
    protected List<RfTreeElementWrapper> fChildren;
    private boolean fOverlayStatus;
    private boolean fAccessDecoratorEnable;
    private RfTreeElementWrapper fSelected;
    private RfTreeElementWrapper fParent;
    private boolean fGrayIcon;
    private Object fItem;
    private int fExpanded;
    private long uniqueID;
    private String fTreeName;
    private IRfNamedElement fInstanceType;
    private IRfNamedElement fComponent;
    private BindingRuleWrapper fBindResult;
    private IRfNamedElement fEntity;
    private Object fGoToElement;

    public void addChild(IDVTElementWrapper child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<RfTreeElementWrapper>(4);
        }
        ((RfTreeElementWrapper)child).setParent(this);
        this.fChildren.add((RfTreeElementWrapper)child);
    }

    public RfTreeElementWrapper(Object element, boolean access) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = access;
    }

    public RfTreeElementWrapper(Object element) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = false;
    }

    public RfTreeElementWrapper() {
        super(null);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            if (this.fElement instanceof VlogFileInstance) {
                return RfUtils.getFile((VlogFileInstance)this.fElement, this.getProject());
            }
        } else if (adapter == RfNamedElement.class ? this.fElement instanceof RfNamedElement : adapter == RfDefElement.class && this.fElement instanceof RfDefElement) {
            return this.fElement;
        }
        return null;
    }

    public boolean getOverlayStatus() {
        return this.fOverlayStatus;
    }

    public void setOverlayStatus(boolean status) {
        this.fOverlayStatus = status;
    }

    public boolean getAccessDecoratorEnable() {
        return this.fAccessDecoratorEnable;
    }

    public RfTreeElementWrapper getSelectedElement() {
        return this.fSelected;
    }

    public void setSelectedElement(Object selected) {
        if (selected == null || selected instanceof RfTreeElementWrapper) {
            this.fSelected = (RfTreeElementWrapper)((Object)selected);
        }
    }

    protected void setParent(RfTreeElementWrapper parent) {
        this.fParent = parent;
    }

    public void setParent(IDVTElementWrapper parent) {
        if (parent instanceof RfTreeElementWrapper || parent == null) {
            this.setParent((RfTreeElementWrapper)parent);
        }
    }

    public RfTreeElementWrapper getParent() {
        return this.fParent;
    }

    public void setGrayIcon(boolean grayIcon) {
        this.fGrayIcon = grayIcon;
    }

    public boolean isGrayIcon() {
        return this.fGrayIcon;
    }

    public void setItem(Object item) {
        this.fItem = item;
    }

    public Object getItem() {
        return this.fItem;
    }

    public void setExpanded(int expanded) {
        this.fExpanded = expanded;
    }

    public int getExpanded() {
        return this.fExpanded;
    }

    public void setInstanceType(IRfDesignElement instanceType) {
        this.fInstanceType = instanceType;
    }

    public IRfNamedElement getInstanceType() {
        return this.fInstanceType;
    }

    public void setUniqueID(long id) {
        this.uniqueID = id;
    }

    public long getUniqueID() {
        return this.uniqueID;
    }

    public void setAssociatedElements(IRfNamedElement component, BindingRuleWrapper bindResult, IRfNamedElement entity) {
        this.fComponent = component;
        this.fBindResult = bindResult;
        this.fEntity = entity;
    }

    public IRfNamedElement getConnectComponent() {
        return this.fComponent;
    }

    public BindingRuleWrapper getConnectBind() {
        return this.fBindResult;
    }

    public IRfNamedElement getConnectDesign() {
        return this.fEntity;
    }

    public IDVTElementWrapper create() {
        RfTreeElementWrapper element = new RfTreeElementWrapper(this.fElement);
        element.setInstanceType((IRfDesignElement)this.fInstanceType);
        return element;
    }

    public void deepClean() {
        if (this.fChildren != null) {
            for (RfTreeElementWrapper child : this.fChildren) {
                child.deepClean();
            }
        }
        this.fChildren = null;
        this.fParent = null;
        this.fSelected = null;
        this.fBindResult = null;
        this.fAdditionalInfo = null;
        this.fComponent = null;
        this.fElement = null;
        this.fEntity = null;
        this.fItem = null;
        this.fInstanceType = null;
        this.fProject = null;
    }

    public void setTreeName(String treeName) {
        this.fTreeName = treeName;
    }

    public String getTreeName() {
        return this.fTreeName;
    }

    public List<RfTreeElementWrapper> getChildren() {
        return this.fChildren;
    }

    public IDVTElementWrapper getFirstChild() {
        return this.fChildren == null || this.fChildren.isEmpty() ? null : (IDVTElementWrapper)this.fChildren.get(0);
    }

    public <T extends IDVTElementWrapper> void addChildren(List<T> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (IDVTElementWrapper elementWrapper : children) {
            this.addChild(elementWrapper);
        }
    }

    public <T extends IDVTElementWrapper> void setChildren(List<T> children) {
        this.fChildren = children;
    }

    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    public void removeChild(IDVTElementWrapper child) {
        if (!this.hasChildren()) {
            return;
        }
        this.fChildren.remove(child);
    }

    public IProject getProject() {
        IRfNamedElement namedElement;
        if (this.fProject != null) {
            return this.fProject;
        }
        if (this.fElement instanceof IAdaptable && (namedElement = (IRfNamedElement)((IAdaptable)this.fElement).getAdapter(IRfNamedElement.class)) != null) {
            IRfSingleLangProject rfProject = namedElement.getRfProject();
            if (rfProject != null) {
                this.fProject = rfProject.getProject();
                return this.fProject;
            }
            return null;
        }
        return super.getProject();
    }

    public String toString() {
        Object rfElement = this.getRfElement();
        return rfElement != null ? rfElement.toString() : "";
    }

    public Object getGoToElement() {
        return this.fGoToElement;
    }

    public void setGoToElement(Object fgoToElement) {
        this.fGoToElement = fgoToElement;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }
}

