/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;

public class RfVHUtils {
    public static final RfXvmFactory getXvmFactory(IProject project) {
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return rfProject.getXvmFactory();
    }

    public static final RfXvmFactory getRawXvmFactory(IProject project) {
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return rfProject.getRawXvmFactory();
    }

    public static final RfXvmObject getXvmObject(IProject project, RfElementPath elementPath) {
        if (project == null || elementPath == null) {
            return null;
        }
        RfNamedElement element = (RfNamedElement)elementPath.toNamedElement(project);
        if (!(element instanceof RfClass)) {
            return null;
        }
        return RfVHUtils.getXvmObject(project, (RfClass)element);
    }

    public static final RfXvmObject getXvmObject(IProject project, RfClass rfClass) {
        if (project == null || rfClass == null) {
            return null;
        }
        RfXvmFactory factory = RfVHUtils.getXvmFactory(project);
        if (factory == null) {
            return null;
        }
        if (factory.isEmpty()) {
            return null;
        }
        return factory.getRegisteredObject(rfClass);
    }

    public static final RfXvmFactory.XVMPath getXVMPath(List<String> names, List<String> types) {
        if (names == null || names.isEmpty() || types == null || types.isEmpty()) {
            return null;
        }
        RfXvmFactory.XVMPath path = new RfXvmFactory.XVMPath();
        int i = 0;
        while (i < names.size()) {
            String name = names.get(i);
            String type = types.size() > i ? types.get(i) : "";
            path.addPoint(name, type);
            ++i;
        }
        return path;
    }

    public static final RfXvmFactory.XVMPath getXVMPath(RfXvmFactory.RfXVMPath rfXVMPath) {
        if (rfXVMPath.getTop() == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> types = new ArrayList<String>();
        names.add(rfXVMPath.getTop().getName());
        types.add(rfXVMPath.getTop().getName());
        if (rfXVMPath.getInstances() == null || rfXVMPath.getInstances().isEmpty()) {
            return RfVHUtils.getXVMPath(names, types);
        }
        for (RfXvmObjectInstance rfXvmObjectInstance : rfXVMPath.getInstances()) {
            names.add(rfXvmObjectInstance.getName());
            types.add(rfXvmObjectInstance.getObject().getName());
        }
        return RfVHUtils.getXVMPath(names, types);
    }

    public static final RfXvmBase getXVMObject(RfXvmFactory.XVMPath path, IProject project) {
        if (path == null || project == null) {
            return null;
        }
        RfXvmFactory.XVMPath.XVMPathIterator iterator = path.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        RfXvmFactory.XVMPath.XVMPathPoint first = iterator.next();
        RfXvmFactory factory = RfVHUtils.getXvmFactory(project);
        if (factory == null) {
            return null;
        }
        if (path.length() == 1) {
            return factory.getRegisteredObject(first.type);
        }
        do {
            RfXvmObjectInstance lastInstance;
            RfXvmObject object;
            if ((object = factory.getRegisteredObject(first.type)) == null || (lastInstance = RfVHUtils.findXVMComponent(iterator.clone(), RfXvmFactory.getChildInstances(object), new HashSet<RfClass>())) == null) continue;
            return lastInstance;
        } while (iterator.hasNext() && (first = iterator.next()) != null);
        return null;
    }

    private static final RfXvmObjectInstance findXVMComponent(RfXvmFactory.XVMPath.XVMPathIterator pathIterator, List<RfXvmObjectInstance> childInstances, Set<RfClass> visited) {
        if (pathIterator == null || !pathIterator.hasNext() || childInstances == null || childInstances.isEmpty()) {
            return null;
        }
        RfXvmFactory.XVMPath.XVMPathPoint next = pathIterator.next();
        RfXvmObjectInstance closest = null;
        for (RfXvmObjectInstance child : childInstances) {
            String childName = child.getName();
            if (childName == null || !next.name.equals(childName)) continue;
            closest = child;
            break;
        }
        if (closest != null) {
            if (!pathIterator.hasNext()) {
                return closest;
            }
            return RfVHUtils.findXVMComponent(pathIterator, RfXvmFactory.getChildInstances(closest.getObject()), visited);
        }
        int minLD = Integer.MAX_VALUE;
        for (RfXvmObjectInstance child : childInstances) {
            String typeName = child.getObject().getRfClass().getName();
            if (typeName == null || !next.type.equals(typeName)) continue;
            String childName = child.getName();
            if (childName == null) {
                closest = child;
                continue;
            }
            int ld = RfVHUtils.levenshteinDistance(childName, next.name);
            if (ld >= next.name.length() / 2 || minLD <= ld) continue;
            minLD = ld;
            closest = child;
        }
        if (closest != null) {
            if (!pathIterator.hasNext()) {
                return closest;
            }
            return RfVHUtils.findXVMComponent(pathIterator, RfXvmFactory.getChildInstances(closest.getObject()), visited);
        }
        return null;
    }

    private static final int levenshteinDistance(String s, String t) {
        if (s.equals(t)) {
            return 0;
        }
        if (s.length() == 0) {
            return t.length();
        }
        if (t.length() == 0) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        int i = 0;
        while (i < v0.length) {
            v0[i] = i;
            ++i;
        }
        i = 0;
        while (i < s.length()) {
            v1[0] = i + 1;
            int j = 0;
            while (j < t.length()) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = Math.min(v1[j] + 1, Math.min(v0[j + 1] + 1, v0[j] + cost));
                ++j;
            }
            j = 0;
            while (j < v0.length) {
                v0[j] = v1[j];
                ++j;
            }
            ++i;
        }
        return v1[t.length()];
    }
}

