/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.ElementListSelectionDialog;
import ro.amiq.dvt.utils.FilteredList;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;

public class RfVHViewUtils {
    private static final String OPEN_CREATE_CALL = "Open the create call";
    private static final String PLEASE_SELECT_A_CREATE_CALL = "Please select the create call you want to open";

    public static void openCreateCall(List<RfXvmFactory.XVMCreateCall> createCalls, boolean withDialog, final IProject project) {
        if (createCalls == null || createCalls.isEmpty()) {
            return;
        }
        LinkedHashSet<GoToInfo> goTos = new LinkedHashSet<GoToInfo>();
        for (RfXvmFactory.XVMCreateCall createCall : createCalls) {
            GoToInfo[] goToInfoArray = createCall.getGoTos();
            int n = goToInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                GoToInfo goTo = goToInfoArray[n2];
                goTos.add(goTo);
                ++n2;
            }
        }
        if (goTos.isEmpty()) {
            return;
        }
        if (goTos.size() == 1) {
            ((GoToInfo)goTos.iterator().next()).open(project, true);
            return;
        }
        if (!withDialog) {
            Object[] array = goTos.toArray();
            ((GoToInfo)array[array.length - 1]).open(project, true);
            return;
        }
        Shell shell = DVTUiUtils.getActiveWorkbenchShell();
        if (shell == null) {
            return;
        }
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof GoToInfo)) {
                    return null;
                }
                GoToInfo goTo = (GoToInfo)element;
                IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, goTo.filePath);
                return "At line " + goTo.line + " ... " + DVTFileUtils.getInstance().getLineFromFile(iFile, goTo.line).trim().replaceAll("\\s+", " ");
            }

            public Image getImage(Object element) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider){

            protected FilteredList createFilteredList(Composite parent2) {
                FilteredList list = super.createFilteredList(parent2);
                list.setFilterMatcher(new FilteredList.FilterMatcher(){
                    private StringMatcher fLocalMatcher;

                    public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        this.fLocalMatcher = ViewsUtils.createCamelCaseOrRegexMatcher((String)pattern, (boolean)ignoreCase, (boolean)ignoreWildCards);
                    }

                    public boolean match(Object element) {
                        return ViewsUtils.matchCamelCaseOrRegex((StringMatcher)this.fLocalMatcher, (String)fFilteredList.getLabelProvider().getText(element));
                    }
                });
                return list;
            }
        };
        dialog.setTitle(OPEN_CREATE_CALL);
        dialog.setAutoResizeable(true);
        dialog.setMessage(PLEASE_SELECT_A_CREATE_CALL);
        dialog.setMultipleSelection(false);
        dialog.setElements(goTos.toArray());
        if (dialog.open() == 1) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return;
        }
        if (!(result[0] instanceof GoToInfo)) {
            return;
        }
        ((GoToInfo)result[0]).open(project, true);
    }
}

