/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.vlogdt.model.reflection.views.SequenceTreeCommentJobCommon;

public class SequenceTreeCommentJob
extends SequenceTreeCommentJobCommon {
    private static SequenceTreeCommentJob INSTANCE;
    private static final Object SYNC_OBJECT;
    private DocumentManager documentManager;
    private BlockingQueue<IDVTElementWrapper> wrappersToProcess = new LinkedBlockingQueue<IDVTElementWrapper>();

    static {
        SYNC_OBJECT = new Object();
    }

    private SequenceTreeCommentJob(String name) {
        super(name);
        this.documentManager = new DocumentManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequenceTreeCommentJob getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new SequenceTreeCommentJob("UVM_SEQ_TREE_COMMENT_JOB");
            }
        }
        return INSTANCE;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.documentManager.activate();
            while (!this.wrappersToProcess.isEmpty()) {
                if (monitor.isCanceled()) {
                    this.wrappersToProcess.clear();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                IDVTElementWrapper wrapper = (IDVTElementWrapper)this.wrappersToProcess.poll();
                TreeItem item = (TreeItem)wrapper.getItem();
                if (item == null) continue;
                AtomicReference<String> comment = this.computeComment(wrapper, this.documentManager);
                if (comment == null) {
                    return null;
                }
                try {
                    Display display = Display.getDefault();
                    display.asyncExec(() -> {
                        if (item.isDisposed()) {
                            return;
                        }
                        item.setText(1, ViewsUtils.trimText((String)((String)comment.get()), (int)100, (boolean)true));
                    });
                    continue;
                }
                catch (BadLocationException | BadPartitioningException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
                break;
            }
        }
        finally {
            this.documentManager.deactivate();
        }
        return Status.OK_STATUS;
    }

    public void queueWrapper(IDVTElementWrapper wrapper) {
        this.wrappersToProcess.offer(wrapper);
    }
}

