/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.views.MethodCallAdditionalInfo;
import ro.amiq.vlogdt.model.reflection.views.VlogUVMSequenceTreeUtils;

public abstract class SequenceTreeCommentJobCommon
extends Job {
    protected static final int BUFFER_SIZE = 100;
    protected static final String JOB_NAME = "UVM_SEQ_TREE_COMMENT_JOB";

    protected SequenceTreeCommentJobCommon(String name) {
        super(name);
    }

    protected String getCommentFromHid(RfHid hid) {
        if (hid == null) {
            return "";
        }
        Hid fieldHid = hid.getParentHid();
        if (fieldHid == null) {
            return "";
        }
        IRfNamedElement field = fieldHid.getElement();
        if (!(field instanceof RfField)) {
            return "";
        }
        return this.getCommentFromFieldElement((RfField)field);
    }

    protected String getCommentFromFieldElement(RfField field) {
        String comment = field.getComment();
        if (!comment.trim().isEmpty()) {
            return comment;
        }
        IRfNamedElement fieldType = field.getAssociatedType();
        if (fieldType == null) {
            return "";
        }
        return fieldType.getComment();
    }

    protected String getCommentFromDocument(IDocument iDocument, int startLine, int endOffset) {
        String inlineComment = DVTDocumentUtils.getInlineComment((IDocument)iDocument, (int)endOffset, (String)"__vlog_partitioning");
        String aboveComment = DVTDocumentUtils.getAboveComment((IDocument)iDocument, (int)(startLine - 1), (String)"__vlog_partitioning");
        return DVTDocumentUtils.getFormattedComment((String)BaseUtils.appendInlineAndAboveComments((String)inlineComment, (String)aboveComment));
    }

    protected AtomicReference<String> computeComment(IDVTElementWrapper wrapper, DocumentManager documentManager) throws BadLocationException, BadPartitioningException {
        Object additionalInfo = wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO);
        if (!(additionalInfo instanceof MethodCallAdditionalInfo)) {
            return null;
        }
        MethodCallAdditionalInfo methodCallInfo = (MethodCallAdditionalInfo)additionalInfo;
        IDocument document = documentManager.getDocument(new ParserPath(methodCallInfo.getParserPath()), false, methodCallInfo.getProject());
        int startLineOffset = document.getLineOffset(methodCallInfo.getStartLine() - 1);
        int endOffset = -1;
        switch (methodCallInfo.getCallType()) {
            case METHOD_CALL: {
                int closedBoundaryOffset = VlogUVMSequenceTreeUtils.getClosedBoundaryOffset(methodCallInfo.getHid());
                if (closedBoundaryOffset != -1) {
                    endOffset = DVTDocumentUtils.getCharOffset((char)';', (int)closedBoundaryOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
                }
                if (endOffset == -1) break;
                ++endOffset;
                break;
            }
            case MACRO: {
                endOffset = VlogUVMSequenceTreeUtils.getCallEndOffset(document, startLineOffset, "__vlog_partitioning");
                break;
            }
            case FORK_OR_PROCESS: {
                endOffset = VlogUVMSequenceTreeUtils.getBlockEndOffset(document, startLineOffset, "__vlog_partitioning");
                break;
            }
        }
        AtomicReference<String> comment = new AtomicReference<String>(this.getCommentFromDocument(document, methodCallInfo.getStartLine(), endOffset));
        if (comment.get() == null || comment.get().trim().isEmpty()) {
            comment.set(methodCallInfo.getHid() != null ? this.getCommentFromHid(methodCallInfo.getHid()) : (methodCallInfo.getMacroSequenceField() != null ? this.getCommentFromFieldElement(methodCallInfo.getMacroSequenceField()) : ""));
        }
        return comment;
    }
}

