/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;

public class THViewLabelProvider
extends TypesViewLabelProvider {
    private boolean fIsForUVMBrowserMembers;

    public THViewLabelProvider(boolean isForUVMBrowserMembers) {
        this.setForUVMBrowserMembers(isForUVMBrowserMembers);
    }

    @Override
    public String getText(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return "";
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        Object element = rfWrapper.getRfElement();
        if (element instanceof VlogLanguageElement) {
            return String.valueOf(LanguageKind.VLOG.VIEW_NAME) + " " + ((VlogLanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof RfTreeElementWrapper) {
            return (String)((RfTreeElementWrapper)((Object)element)).getRfElement();
        }
        if (element instanceof String) {
            return (String)element;
        }
        String result = "";
        if (element instanceof RfNamedElement) {
            RfNamedElement namedElement = (RfNamedElement)element;
            if (namedElement instanceof RfClass) {
                return namedElement.getQualifiedName(7 | (PrefConst.getTHViewPrependPackage() ? 0 : 16));
            }
            result = namedElement instanceof RfFunction ? DVTStringUtil.appendString((Object[])new Object[]{namedElement.getName(), "()"}) : namedElement.getName();
            if (this.fIsForUVMBrowserMembers) {
                if (!PrefConst.getUVMBrowserViewShowUVMMembers() && PrefConst.getUVMBrowserViewShowDefinitionLayer() && !(namedElement instanceof RfClass)) {
                    String clazzName = namedElement.getEnclosingScope().getName();
                    result = String.valueOf(result) + "  [" + clazzName + "]";
                }
            } else if (PrefConst.getTHViewShowDefinitionLayer() && !(namedElement instanceof RfClass) && namedElement.getEnclosingScope() != null) {
                String clazzName = namedElement.getEnclosingScope().getName();
                result = String.valueOf(result) + "  [" + clazzName + "]";
            }
        }
        return result;
    }

    @Override
    public Image getImage(Object wrapper) {
        if (wrapper instanceof RfTreeElementWrapper) {
            Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (rfElement instanceof RfDummyElement) {
                if (((RfDummyElement)rfElement).getName().equals("[...recurrence detected]")) {
                    return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
                }
                return DVTImages.imageCache.getImage(DVTImages.NONE);
            }
            if (rfElement instanceof RfPredefinedFunction) {
                Image result = null;
                result = !((RfPredefinedFunction)rfElement).isPredefinedOverridden() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_PMETHOD) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
                if (this.fDecorator != null) {
                    return this.fDecorator.decorateImage(result, wrapper);
                }
                return result;
            }
            if (this.fIsForUVMBrowserMembers && rfElement instanceof RfField) {
                DataType fieldDataType;
                RfField field = (RfField)rfElement;
                Image result = THViewLabelProvider.getImageForUVMField(field);
                if (RfXvmFactory.isPortForXvmObject(field)) {
                    result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_TLM_PORTS, 1));
                }
                if ((fieldDataType = field.getDataType()) != null && fieldDataType.getUnpackedDimension() != null && !fieldDataType.getUnpackedDimension().isEmpty()) {
                    result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_ARRAY, 3));
                }
                if (this.fDecorator != null) {
                    return this.fDecorator.decorateImage(result, wrapper);
                }
                return result;
            }
        }
        return super.getImage(wrapper);
    }

    public static Image getImageForUVMField(RfField field) {
        RfXvmObject xvmClass;
        if (field.getAssociatedType() instanceof RfInterface) {
            return DVTImages.imageCache.getImage(DVTImages.XVM_VIRTUAL_INTERFACE);
        }
        if (!(field.getEnclosingScope() instanceof RfClass)) {
            return field.getImage();
        }
        RfClass clazz = (RfClass)field.getEnclosingScope();
        RfProject rfProject = clazz.getRfProject();
        if (rfProject == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        RfXvmFactory xvmFactory = rfProject.getXvmFactory();
        RfXvmObject rfXvmObject = xvmClass = xvmFactory == null ? null : xvmFactory.getRegisteredObject(clazz);
        if (xvmClass == null) {
            return field.getImage();
        }
        for (RfXvmObjectInstance xvmObjectInstance : RfXvmFactory.getChildInstances(xvmClass)) {
            if (xvmObjectInstance.getNamedElement() != field) continue;
            if (xvmObjectInstance.getObject() instanceof RfXvmComponent) {
                return DVTImages.imageCache.getImage(DVTImages.XVM_COMPONENT_INSTANCE);
            }
            return DVTImages.imageCache.getImage(DVTImages.CLASS_INSTANCE);
        }
        for (RfXvmField xvmField : RfXvmFactory.getRegisteredFields(xvmClass)) {
            if (xvmField.getNamedElement() != field) continue;
            return DVTImages.imageCache.getImage(DVTImages.XVM_FIELD_REGISTERED);
        }
        return field.getImage();
    }

    public boolean isForUVMComponentsMembers() {
        return this.fIsForUVMBrowserMembers;
    }

    public void setForUVMBrowserMembers(boolean fIsForUVMBrowserMembers) {
        this.fIsForUVMBrowserMembers = fIsForUVMBrowserMembers;
    }
}

