/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTRfLabelProvider;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfPackage;

public class TypesViewMembersLabelProvider
extends DVTRfLabelProvider {
    public String getNamedElementText(IRfNamedElement element) {
        String defaultName = element.getName();
        if (element.isShallowCompiled()) {
            defaultName = "[S] " + defaultName;
        } else if (element.isIncrementalShallowCompiled()) {
            defaultName = "[iS] " + defaultName;
        }
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return defaultName;
        }
        RfMixedLangProject mixedLangProject = rfProject.getMixedLangProjectParent();
        if (mixedLangProject == null) {
            return defaultName;
        }
        try {
            IELParamValue value;
            RfPackage searchScope;
            boolean isEnum;
            boolean isParam = ELUtils.isVLOGParam((IRfNamedElement)element);
            boolean bl = isEnum = element instanceof RfField && ((RfField)element).isEnumElement();
            if (!isParam && !isEnum) {
                return defaultName;
            }
            ELManager manager = rfProject.getELManager();
            ELConstantsManager constantsManager = mixedLangProject.getElabConstantsManager();
            ELParamValues externalConstants = constantsManager.getExternalConstants((IRfNamedElement)(searchScope = isEnum ? ((RfField)element).getEnclosingPackage() : (IRfNamedElement)element.getEnclosingScope()));
            if (externalConstants != null && (value = externalConstants.getValueDirectly(element.getName())) != null) {
                ELParamValuesHidEvaluator evaluator = ELParamValues.create((boolean)true).getHidEvaluator(manager);
                BitVectorContext paramContext = ELUtils.makeEvaluatorContext((IHidEvaluator)evaluator, (IRfNamedElement)element, null, (ELManager)manager);
                String actualValue = value.toNiceString(paramContext, PrefConst.getParamRadix(), true, false);
                return String.valueOf(defaultName) + " = " + actualValue;
            }
            return defaultName;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return defaultName;
        }
    }
}

