/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.actions.history.IVHHistoryItem;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItemUVMElabStatus;

public class VHHistoryItem
extends HistoryItem
implements IVHHistoryItem {
    private String projectName;
    private boolean isInterpreterActive;
    private boolean hasUVMElabModel;
    private String testName;
    private boolean xvmAlreadyRegistered;
    private VHHistoryItemUVMElabStatus uvmElabStatus;

    private VHHistoryItem(String projectName, RfElementPath elementPath) {
        super("[" + projectName + "] " + elementPath.toNiceString());
        this.objectQName = elementPath;
        this.projectName = projectName;
        this.testName = elementPath.getElementName();
    }

    public static HistoryItem parseHistoryItem(String projectName, RfElementPath elementPath) {
        if (projectName == null || elementPath == null) {
            return null;
        }
        IProject project = Utils.getProject((String)projectName);
        if (project == null) {
            DVTLogger.INSTANCE.logInfo("Unexpected history item for the Verification Hierarchy View: [" + projectName + "] " + elementPath.toNiceString());
            return null;
        }
        return new VHHistoryItem(project.getName(), elementPath);
    }

    public static HistoryItem parseHistoryItem(String projectName, String objectQName) {
        if (projectName == null || objectQName == null) {
            return null;
        }
        RfElementPath elementPath = RfElementPath.fromString((String)objectQName, VHHistoryItem.class);
        if (!RfElementPath.isValid((RfElementPath)elementPath)) {
            DVTLogger.INSTANCE.logInfo("Unexpected history item for the Verification Hierarchy View: [" + projectName + "] " + objectQName);
            return null;
        }
        return VHHistoryItem.parseHistoryItem(projectName, elementPath);
    }

    public boolean equals(Object hi) {
        if (hi instanceof VHHistoryItem) {
            VHHistoryItem vhi = (VHHistoryItem)((Object)hi);
            return this.objectQName.equals((Object)vhi.getObjectQName()) && this.projectName.equals(vhi.getProjectName()) && this.hasUVMElabModel == vhi.hasUVMElabModel;
        }
        return false;
    }

    public RfElementPath getObjectQName() {
        return this.objectQName;
    }

    public LanguageKind getLanguage() {
        return LanguageKind.VLOG;
    }

    public HistoryItem copy(boolean isInterpreterActive, boolean hasUVMElabModel) {
        VHHistoryItem copy = new VHHistoryItem(this.projectName, this.objectQName);
        copy.isInterpreterActive = isInterpreterActive;
        copy.hasUVMElabModel = hasUVMElabModel;
        copy.addTimestamp(this.getTimestamp());
        if (this.isXVMAlreadyRegistered()) {
            copy.markAsXVMAlreadyRegistered();
        }
        copy.setUvmElabStatus(this.getUvmElabStatus());
        return copy;
    }

    public boolean isInterpreterActive() {
        return this.isInterpreterActive;
    }

    public boolean hasUVMElabModel() {
        return this.hasUVMElabModel;
    }

    public VHHistoryItemUVMElabStatus getUvmElabStatus() {
        return this.uvmElabStatus;
    }

    public void setUvmElabStatus(VHHistoryItemUVMElabStatus uvmElabStatus) {
        this.uvmElabStatus = uvmElabStatus;
    }

    public IRfNamedElement getNamedElement() {
        if (this.objectQName == null) {
            return null;
        }
        return this.objectQName.toNamedElement(this.getProject());
    }

    public int hashCode() {
        return super.hashCode() + this.projectName.hashCode() + this.objectQName.hashCode();
    }

    public String toString() {
        return this.objectQName.toString();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public IProject getProject() {
        if (this.projectName == null) {
            return null;
        }
        return Utils.getProject((String)this.projectName);
    }

    public String getElementName() {
        IRfNamedElement namedElement = this.objectQName.toNamedElement(this.getProject());
        if (!(namedElement instanceof RfClass)) {
            return this.testName;
        }
        String fullyQualifiedElementName = ((RfClass)namedElement).computeXVMFactoryRegisterId();
        if (fullyQualifiedElementName != null) {
            return fullyQualifiedElementName;
        }
        return this.testName;
    }

    public String getTestName() {
        return this.getElementName();
    }

    public void markAsXVMAlreadyRegistered() {
        this.xvmAlreadyRegistered = true;
    }

    public boolean isXVMAlreadyRegistered() {
        return this.xvmAlreadyRegistered;
    }
}

