/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;

public class VHLabelImageCommon {
    public static Image getImage(RfXvmBase base) {
        if (base == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        boolean isArray = false;
        boolean isTlm = false;
        Image result = null;
        switch (RfXvmFactory.getObjectType(base)) {
            case COMPONENT_INSTANCE: {
                isArray = ((RfXvmObjectInstance)base).isArray();
                result = DVTImages.imageCache.getImage(DVTImages.XVM_COMPONENT_INSTANCE);
                break;
            }
            case OBJECT_INSTANCE: {
                isArray = ((RfXvmObjectInstance)base).isArray();
                result = DVTImages.imageCache.getImage(DVTImages.CLASS_INSTANCE);
                break;
            }
            case ROOT: {
                result = DVTImages.imageCache.getImage(DVTImages.XVM_ROOT);
                break;
            }
            case TEST: {
                result = DVTImages.imageCache.getImage(DVTImages.XVM_TEST);
                break;
            }
            case COMPONENT: {
                result = DVTImages.imageCache.getImage(DVTImages.XVM_CLASS_COMPONENT);
                break;
            }
            case OBJECT: {
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
                break;
            }
            case PORT: {
                isTlm = true;
                isArray = ((RfXvmPort)base).isArray();
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
                break;
            }
            case FIELD: {
                isArray = ((RfXvmPort)base).isArray();
                result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
                break;
            }
            case UNKNOWN: {
                result = DVTImages.imageCache.getImage(DVTImages.NONE);
            }
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (isArray) {
            result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_ARRAY, 3));
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (isTlm) {
            result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_TLM_PORTS, 1));
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        return result;
    }
}

