/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VHLabelImageCommon;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;

public class VHLabelProvider
extends VlogLabelProvider
implements IVHLabelProvider {
    public Image getImage(Object element) {
        if (DummyElement.RECURRENCE_NODE.equals(element)) {
            return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
        }
        Object obj = null;
        if (element instanceof IDVTElementWrapper) {
            obj = ((IDVTElementWrapper)element).getRfElement();
            if (obj instanceof VHHistoryItem) {
                RfXvmObject object = this.computeXvmObjectFromHistoryItem((VHHistoryItem)((Object)obj));
                if (object == null) {
                    return DVTImages.imageCache.getImage(DVTImages.NONE);
                }
                obj = object;
            }
        } else {
            obj = element;
        }
        if (obj instanceof RfXvmBase) {
            return VHLabelImageCommon.getImage((RfXvmBase)obj);
        }
        if (obj instanceof RfDummyElement && "[...recurrence detected]".equals(((RfDummyElement)obj).getName())) {
            return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    private RfXvmObject computeXvmObjectFromHistoryItem(VHHistoryItem vhi) {
        String projectName = vhi.getProjectName();
        RfElementPath objectQName = vhi.getObjectQName();
        if (projectName == null || objectQName == null) {
            return null;
        }
        IProject project = Utils.getProject((String)projectName);
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return RfVHUtils.getXvmObject(project, objectQName);
    }

    public String getText(Object element) {
        if (DummyElement.RECURRENCE_NODE.equals(element)) {
            return DummyElement.RECURRENCE_NODE.getName();
        }
        Object elem = null;
        if (element instanceof VHHistoryItem || element instanceof DVTTreeElementWrapper && ((DVTTreeElementWrapper)element).getRfElement() instanceof VHHistoryItem) {
            VHHistoryItem vhi = element instanceof VHHistoryItem ? (VHHistoryItem)((Object)element) : (VHHistoryItem)((Object)((DVTTreeElementWrapper)element).getRfElement());
            RfXvmObject object = this.computeXvmObjectFromHistoryItem(vhi);
            if (object == null) {
                return "";
            }
            elem = object;
        } else if (element instanceof RfXvmBase) {
            elem = element;
        } else {
            if (!(element instanceof IDVTElementWrapper)) {
                return "";
            }
            IDVTElementWrapper w = (IDVTElementWrapper)element;
            elem = w.getRfElement();
            if (w.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
                this.setBoldFont(w);
            }
        }
        String instName = "";
        String packName = "";
        String objName = "";
        RfXvmObject obj = null;
        if (elem instanceof RfXvmObjectInstance) {
            RfXvmObjectInstance inst = (RfXvmObjectInstance)elem;
            instName = inst.getName();
            obj = inst.getObject();
        } else if (elem instanceof RfXvmObject) {
            obj = (RfXvmObject)elem;
        } else if (elem instanceof RfDummyElement) {
            return ((RfDummyElement)elem).getName();
        }
        if (elem instanceof RfXvmPort) {
            return elem.toString();
        }
        if (obj == null) {
            return this.internalGetText(instName, packName, objName);
        }
        objName = obj.getName();
        RfClass rfClass = obj.getRfClass();
        String shallowLabel = null;
        if (rfClass != null) {
            if (rfClass.isShallowCompiled()) {
                shallowLabel = "[S] ";
            } else if (rfClass.isIncrementalShallowCompiled()) {
                shallowLabel = "[iS] ";
            }
        }
        if (rfClass != null && shallowLabel != null) {
            if (!instName.isEmpty()) {
                instName = String.valueOf(shallowLabel) + instName;
            } else {
                objName = String.valueOf(shallowLabel) + objName;
            }
        }
        if (PrefConst.getVHViewPrependPackage() && rfClass != null && rfClass.getEnclosingPackage() != null) {
            packName = rfClass.getEnclosingPackage().getName();
        }
        return this.internalGetText(instName, packName, objName);
    }

    private String internalGetText(String instName, String packName, String objName) {
        boolean hasPackName;
        StringBuilder result = new StringBuilder("");
        boolean hasInstName = instName != null && !instName.isEmpty();
        boolean hasObjName = objName != null && !objName.isEmpty();
        boolean bl = hasPackName = packName != null && !packName.isEmpty();
        if (hasInstName) {
            result.append(instName);
            if (hasObjName) {
                result.append(" : ");
            }
        }
        if (hasPackName) {
            result.append(packName);
            if (hasObjName) {
                result.append("::");
            }
        }
        if (hasObjName) {
            result.append(objName);
        }
        return result.toString();
    }
}

