/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.DummyTopSelectionHistoryItem;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItemUVMElabStatus;
import ro.amiq.vlogdt.model.reflection.views.VHLabelImageCommon;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;

public class VHTopDialogLabelProvider
extends VlogLabelProvider {
    public Image getImage(Object element) {
        if (!(element instanceof VHHistoryItem)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        VHHistoryItem hi = (VHHistoryItem)((Object)element);
        IProject project = Utils.getProject((String)hi.getProjectName());
        return VHLabelImageCommon.getImage(RfVHUtils.getXvmObject(project, hi.getObjectQName()));
    }

    public String getText(Object element) {
        if (element == null || !(element instanceof VHHistoryItem)) {
            return "";
        }
        RfElementPath objectQName = ((VHHistoryItem)((Object)element)).getObjectQName();
        if (!RfElementPath.isValid((RfElementPath)objectQName)) {
            return "";
        }
        String elementText = null;
        IRfNamedElement namedElement = objectQName.toNamedElement(((VHHistoryItem)((Object)element)).getProject());
        if (namedElement instanceof RfClass) {
            elementText = ((RfClass)namedElement).computeXVMFactoryRegisterId();
        }
        if (elementText == null) {
            elementText = objectQName.getElementName();
        }
        if (((VHHistoryItem)((Object)element)).hasUVMElabModel()) {
            return "[>]" + elementText;
        }
        return elementText;
    }

    private String repeat(int n) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < n) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof DummyTopSelectionHistoryItem) {
            return columnIndex == 0 ? ((DummyTopSelectionHistoryItem)element).getElementName() : "";
        }
        if (element == null || !(element instanceof VHHistoryItem)) {
            return "";
        }
        VHHistoryItem hi = (VHHistoryItem)((Object)element);
        RfElementPath objectQName = hi.getObjectQName();
        if (!RfElementPath.isValid((RfElementPath)objectQName)) {
            return "";
        }
        IProject project = hi.getProject();
        if (columnIndex == 0) {
            IRfNamedElement namedElement = objectQName.toNamedElement(project);
            String elementText = null;
            if (namedElement instanceof RfClass) {
                elementText = ((RfClass)namedElement).computeXVMFactoryRegisterId();
            }
            if (elementText == null) {
                elementText = objectQName.getElementName();
            }
            if (hi.isXVMAlreadyRegistered()) {
                elementText = String.valueOf(elementText) + " [! " + namedElement.getFullNameLabel() + " ]";
            }
            return elementText;
        }
        if (columnIndex == 1 && hi.hasUVMElabModel()) {
            if (hi.getUvmElabStatus() == null) {
                return "unknown elab status";
            }
            return String.valueOf(hi.getUvmElabStatus() == VHHistoryItemUVMElabStatus.SUCCESS ? "runtime elab snapshot @" : "runtime elab failed snapshot @ ") + hi.getTimestamp();
        }
        return "";
    }
}

