/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VHLabelProvider;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;

public class VHViewUtil {
    private static final Comparator<RfTreeElementWrapper> fLexicalSorter = new Comparator<RfTreeElementWrapper>(){

        @Override
        public int compare(RfTreeElementWrapper w1, RfTreeElementWrapper w2) {
            Object o1 = w1.getRfElement();
            Object o2 = w2.getRfElement();
            boolean firstIsInstance = o1 instanceof RfXvmObjectInstance;
            boolean secondIsInstance = o2 instanceof RfXvmObjectInstance;
            if (firstIsInstance && secondIsInstance) {
                return ((RfXvmObjectInstance)o1).getName().compareTo(((RfXvmObjectInstance)o2).getName());
            }
            if (firstIsInstance) {
                return -1;
            }
            if (secondIsInstance) {
                return 1;
            }
            return 0;
        }
    };

    public static void getRecursiveInstancesXXVMTreeComponent(Set<RfClass> visited, RfTreeElementWrapper parent, XXVMComponent component, boolean sorting, boolean prependPackage, UpdateJob updateJob, IVHViewContributor viewContributor) {
        List<RfTreeElementWrapper> children;
        RfClass rfClass;
        if (component == null) {
            return;
        }
        if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
            return;
        }
        RfClass rfClass2 = rfClass = component.getRfClass() instanceof RfClass ? (RfClass)component.getRfClass() : null;
        if (visited.contains(rfClass)) {
            parent.addChild(new RfTreeElementWrapper(new RfDummyElement("[...recurrence detected]")));
            return;
        }
        visited.add(rfClass);
        for (IXXVMComponent childInstance : component.getChildren()) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(childInstance);
            parent.addChild(wrapper);
            if (prependPackage) {
                wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
            }
            VHViewUtil.getRecursiveInstancesXXVMTreeComponent(new HashSet<RfClass>(visited), wrapper, (XXVMComponent)childInstance, sorting, prependPackage, updateJob, viewContributor);
        }
        if (sorting && (children = parent.getChildren()) != null) {
            Collections.sort(children, fLexicalSorter);
        }
    }

    public static void getRecursiveInstances(Set<RfClass> visited, RfTreeElementWrapper parent, RfXvmObject object, boolean sorting, boolean prependPackage, boolean showComponentsOnly, UpdateJob updateJob, IVHViewContributor viewContributor) {
        List<RfTreeElementWrapper> children;
        if (object == null) {
            return;
        }
        if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
            return;
        }
        if (visited.contains(object.getRfClass())) {
            parent.addChild(new RfTreeElementWrapper(new RfDummyElement("[...recurrence detected]")));
            return;
        }
        VHLabelProvider labelProvider = new VHLabelProvider();
        visited.add(object.getRfClass());
        for (RfXvmObjectInstance childInstance : RfXvmFactory.getChildInstances(object)) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(childInstance);
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.VERIFICATION_HIERARCHY, (IRfNamedElement)childInstance.getNamedElement(), () -> labelProvider.getText((Object)wrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (viewContributor == null) continue;
                viewContributor.setHasGUIFilteredTree(true);
                continue;
            }
            if (showComponentsOnly && !RfXvmBase.Type.COMPONENT_INSTANCE.equals((Object)RfXvmFactory.getObjectType(childInstance))) continue;
            parent.addChild(wrapper);
            if (prependPackage) {
                wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
            }
            VHViewUtil.getRecursiveInstances(new HashSet<RfClass>(visited), wrapper, childInstance.getObject(), sorting, prependPackage, showComponentsOnly, updateJob, viewContributor);
        }
        if (sorting && (children = parent.getChildren()) != null) {
            Collections.sort(children, fLexicalSorter);
        }
    }
}

