/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.views.CallHierarchyTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogCallHierarchyLabelProviderCommon;

public class VlogCallHierarchyLabelProvider
extends VlogCallHierarchyLabelProviderCommon {
    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0 && columnIndex != 2) {
            return null;
        }
        if (!(element instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        CallHierarchyTreeElementWrapper wrapper = (CallHierarchyTreeElementWrapper)((Object)element);
        Object rfElement = wrapper.getRfElement();
        if (wrapper.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.UPDATING) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                switch (wrapper.getWrapperKind()) {
                    case MACRO: {
                        return DVTImages.imageCache.getImage(DVTImages.MACROS);
                    }
                    case RECURRENCE: {
                        return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
                    }
                    case POTENTIAL: {
                        return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(DVTImages.imageCache.getImage(DVTImages.OUTLINE_PMETHOD), DVTImages.OVR_ERROR, 2));
                    }
                    case ACTION_BLOCK: {
                        RfActionBlock actionBlock = (RfActionBlock)wrapper.getRfElement();
                        if (actionBlock.isConditional() || actionBlock.isCase() || actionBlock.isCaseItem()) {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONDITIONAL);
                        }
                        if (actionBlock.isSimpleForkJoin()) {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FORK_JOIN);
                        }
                        if (!actionBlock.isAnonymous()) {
                            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ALWAYS);
                        }
                    }
                    case OVERRIDE: {
                        if (!(rfElement instanceof RfFunction)) break;
                        RfFunction function = (RfFunction)rfElement;
                        if (!function.isFunction()) {
                            return this.getDefaultLabelDecorator().decorateImage(DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK), element);
                        }
                        return this.getDefaultLabelDecorator().decorateImage(DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION), element);
                    }
                }
                if (rfElement instanceof RfPredefinedFunction) {
                    if (((RfPredefinedFunction)rfElement).isConstructor()) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PCONSTRUCTOR);
                    }
                    if (!((RfPredefinedFunction)rfElement).isFunction()) {
                        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PTASK);
                    }
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_PMETHOD);
                }
                if (rfElement instanceof RfFunction) {
                    RfFunction function = (RfFunction)rfElement;
                    Image result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
                    if (function.isLet()) {
                        result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_LET);
                    } else if (function.isConstructor()) {
                        result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRUCTOR);
                    } else if (!function.isFunction()) {
                        result = DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK);
                    }
                    if (wrapper.isStaticAccess() && !function.isLet()) {
                        result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_STATIC, 1));
                    }
                    return result;
                }
                if (rfElement instanceof RfField) {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
                }
            }
            case 2: {
                String text = this.getColumnText(element, 2);
                if (text == null || text.isEmpty()) {
                    return null;
                }
                IFile file = null;
                if (((CallHierarchyTreeElementWrapper)((Object)element)).getHidOccurrence() != null || ((CallHierarchyTreeElementWrapper)((Object)element)).getMacroCallFile() != null) {
                    return DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
                }
                RfFileDef rfFileDef = ((RfNamedElement)rfElement).getFile();
                if (rfFileDef != null) {
                    file = (IFile)rfFileDef.getFileAdapter();
                }
                if (file == null) {
                    return DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE_GRAY);
                }
                Image result = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        return DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE_LINKED);
                    }
                    parent = parent.getParent();
                }
                return result;
            }
        }
        return null;
    }
}

