/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.views.CallHierarchyTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;

public abstract class VlogCallHierarchyLabelProviderCommon
extends VlogLabelProvider {
    protected static final String RSQUARE_BRACKET = "]";
    protected static final String LSQUARE_BRACKET = "[";
    protected static final String LBRACKET = "(";
    protected static final String RBRACKET = ")";
    protected static final String FUNCTION_CALL_BRACKETS = "()";
    protected static final String EMPTY_STR = "";
    protected static final String ONE_SPACE = " ";
    protected static final String NORMAL_ACCESS = ".";
    protected static final String COLON = ":";
    protected static final String STATIC_ACCESS = "::";
    protected static final String SEPARATOR = ", ";
    protected static final String DOTS = "...";
    protected static final String IF = "if";
    protected static final String ELSE = "else";
    protected static final String CASE = "case";
    protected static final String FORK = "fork";
    protected static final String MACRO = "macro";
    protected static final String BEGIN_END = "begin end";
    protected static final String SUPER = "super";
    protected static final String JOIN = "join";
    protected static final String JOIN_NONE = "join_none";
    protected static final String JOIN_ANY = "join_any";
    protected static final String CHILD_OVERRIDE = "child override";
    protected boolean setBold = true;

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        String result = this.getColumnText(element, 0);
        if (result == null) {
            return EMPTY_STR;
        }
        return result;
    }

    protected String internalGetText(String overrideAccess, String instName, String packName, String enclosingScope, String returnType, boolean isSuper, String access) {
        boolean hasReturnType;
        StringBuilder result = new StringBuilder(EMPTY_STR);
        boolean hasOverrideAccess = overrideAccess != null && !overrideAccess.isEmpty();
        boolean hasInstName = instName != null && !instName.isEmpty();
        boolean hasPackName = packName != null && !packName.isEmpty();
        boolean hasEnclosingScope = enclosingScope != null && !enclosingScope.isEmpty();
        boolean bl = hasReturnType = returnType != null && !returnType.isEmpty();
        if (isSuper) {
            result.append("[super] ");
        }
        if (hasOverrideAccess) {
            result.append(LSQUARE_BRACKET + overrideAccess + ONE_SPACE + CHILD_OVERRIDE + RSQUARE_BRACKET + ONE_SPACE);
        }
        if (hasPackName) {
            result.append(packName);
            result.append(STATIC_ACCESS);
        }
        if (hasEnclosingScope) {
            result.append(enclosingScope);
            result.append(access);
        }
        if (hasInstName) {
            result.append(instName);
        }
        if (hasReturnType) {
            result.append(" : ");
            result.append(returnType);
        }
        return result.toString();
    }

    public abstract Image getColumnImage(Object var1, int var2);

    public String getTextUtil(Object element, int columnIndex) {
        this.setBold = false;
        String result = this.getColumnText(element, columnIndex);
        this.setBold = true;
        return result == null ? EMPTY_STR : result;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof CallHierarchyTreeElementWrapper)) {
            return null;
        }
        CallHierarchyTreeElementWrapper wrapper = (CallHierarchyTreeElementWrapper)((Object)element);
        if (!(wrapper.getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        RfNamedElement namedElement = (RfNamedElement)wrapper.getRfElement();
        if (namedElement == null) {
            return null;
        }
        RfDefElement namedElementImplementation = namedElement.getImplementation();
        RfDefElement namedElementDeclaration = namedElement.getDeclaration();
        CallHierarchyTreeElementWrapper.WrapperKind wrapperKind = wrapper.getWrapperKind();
        HidOccurrence wrapperHidOccurrence = wrapper.getHidOccurrence();
        RfFileDef namedElementFile = namedElement.getFile();
        String wrapperParserPath = wrapper.getParserPath();
        List<Integer> wrapperMatchLines = wrapper.getMatchLines();
        if (this.setBold && wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(wrapper);
        }
        switch (wrapperKind) {
            case MACRO: {
                switch (columnIndex) {
                    case 0: {
                        String elementName = namedElement instanceof RfDummyElement ? ((RfDummyElement)namedElement).getName() : MACRO;
                        return this.internalGetText(null, elementName, null, null, null, false, null);
                    }
                    case 1: {
                        return String.valueOf(wrapper.getMacroLine());
                    }
                    case 2: {
                        IFile macroFile = wrapper.getMacroCallFile();
                        return macroFile == null ? EMPTY_STR : macroFile.getLocation().lastSegment();
                    }
                }
                return null;
            }
            case RECURRENCE: {
                boolean isRfResultImplicit = namedElement instanceof RfResultImplicitVariable;
                switch (columnIndex) {
                    case 0: {
                        String enclosingScope = isRfResultImplicit ? namedElement.getEnclosingScope().getEnclosingScope().getName() : namedElement.getEnclosingScope().getName();
                        String elementName = String.valueOf(namedElement.getName()) + FUNCTION_CALL_BRACKETS;
                        String access = wrapper.isStaticAccess() ? STATIC_ACCESS : NORMAL_ACCESS;
                        return this.internalGetText(null, elementName, null, enclosingScope, null, false, access);
                    }
                    case 1: {
                        if (wrapperHidOccurrence != null) {
                            return String.valueOf(wrapperHidOccurrence.getLine());
                        }
                        if (wrapperMatchLines != null && !wrapperMatchLines.isEmpty()) {
                            return DVTStringUtil.join(wrapperMatchLines, (String)SEPARATOR);
                        }
                        if (namedElementImplementation != null) {
                            return String.valueOf(namedElementImplementation.getStartLine());
                        }
                        if (namedElementDeclaration != null) {
                            return String.valueOf(namedElementDeclaration.getStartLine());
                        }
                        return null;
                    }
                    case 2: {
                        if (wrapperParserPath != null) {
                            return Path.fromOSString((String)wrapperParserPath).lastSegment();
                        }
                        if (namedElementFile != null) {
                            return namedElementFile.getName();
                        }
                        return null;
                    }
                    case 3: {
                        return this.getColumnText((Object)wrapper.getRecurenceWrapper(), 3);
                    }
                }
                return null;
            }
            case UPDATING: {
                if (!(namedElement instanceof RfDummyElement)) {
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        return ((RfDummyElement)namedElement).getName();
                    }
                }
                return null;
            }
            case POTENTIAL: {
                RfHid hid = (RfHid)wrapper.getHid();
                switch (columnIndex) {
                    case 0: {
                        if (hid == null) {
                            return null;
                        }
                        return String.valueOf(hid.getName()) + FUNCTION_CALL_BRACKETS;
                    }
                    case 1: {
                        if (wrapperHidOccurrence != null) {
                            return null;
                        }
                    }
                    case 2: {
                        if (wrapperParserPath != null) {
                            return Path.fromOSString((String)wrapperParserPath).lastSegment();
                        }
                        if (namedElementFile == null) break;
                        return namedElementFile.getName();
                    }
                    case 3: {
                        return ViewsUtilsCommon.trimText((String)namedElement.getComment(), (int)100, (boolean)true);
                    }
                    default: {
                        return null;
                    }
                }
            }
            case ACTION_BLOCK: {
                if (!(namedElement instanceof RfActionBlock)) {
                    return null;
                }
                RfActionBlock block = (RfActionBlock)namedElement;
                int line = block.getLine();
                if (line <= 0) {
                    Hid wrapperHid = wrapper.getHid();
                    if (wrapper.getHid() != null && wrapperHid.getOccurrence() != null) {
                        line = wrapper.getHid().getOccurrence().getLine();
                    } else if (wrapperHidOccurrence != null) {
                        line = wrapperHidOccurrence.getLine();
                    }
                }
                String path = EMPTY_STR;
                if (block.getFile() != null && block.getFile().getParserPath() != null) {
                    path = block.getFile().getParserPath().toString();
                }
                switch (columnIndex) {
                    case 0: {
                        String elementName = null;
                        if (block.isStatementLabel()) {
                            elementName = block.getName();
                        } else if ((block.getBlockQualifiers() & IRfActionBlockElement.BlockQualifier.IF.value()) != 0L) {
                            elementName = "if (" + block.getExpression() + RBRACKET;
                        } else if ((block.getBlockQualifiers() & IRfActionBlockElement.BlockQualifier.ELSE.value()) != 0L) {
                            elementName = ELSE;
                        } else if ((block.getBlockQualifiers() & IRfActionBlockElement.BlockQualifier.ELSIF.value()) != 0L) {
                            elementName = "else if (" + block.getExpression() + RBRACKET;
                        } else if (block.isCase()) {
                            elementName = "case (" + block.getExpression() + RBRACKET;
                        } else if (block.isCaseItem()) {
                            elementName = String.valueOf(block.getExpression()) + COLON;
                        } else if (block.isSimpleBeginEnd()) {
                            elementName = BEGIN_END;
                        }
                        if (block.hasForkJoin()) {
                            elementName = elementName != null ? elementName.concat(" ... fork") : FORK;
                            if (block.isForkJoin()) {
                                elementName = elementName.concat(" ... join");
                            }
                            if (block.isForkJoinAny()) {
                                elementName = elementName.concat(" ... join_any");
                            }
                            if (block.isForkJoinNone()) {
                                elementName = elementName.concat(" ... join_none");
                            }
                        }
                        if (!block.isStatementLabel() && !block.isAnonymous()) {
                            elementName = elementName != null ? elementName.concat(" : " + block.getName()) : block.getName();
                        }
                        if (elementName == null) break;
                        return this.internalGetText(null, elementName, null, null, null, false, NORMAL_ACCESS);
                    }
                    case 1: {
                        return String.valueOf(line);
                    }
                    case 2: {
                        if (path != null) {
                            return Path.fromOSString((String)path).lastSegment();
                        }
                        if (block.getFile() == null) break;
                        return block.getFile().getName();
                    }
                    case 3: {
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
                return null;
            }
            case OVERRIDE: 
            case NORMAL: {
                String packName = EMPTY_STR;
                RfNamedElement enclosingScope = namedElement.getEnclosingScope();
                String enclosingScopeName = EMPTY_STR;
                if (enclosingScope instanceof RfComputedListType) {
                    enclosingScopeName = enclosingScope.getQualifiedName((IRfScopeElement)null, (ElementPath)null, 23);
                } else if (enclosingScope != null) {
                    enclosingScopeName = enclosingScope.getName();
                }
                if (enclosingScope instanceof RfStruct) {
                    enclosingScopeName = ((RfStruct)enclosingScope).getAliasName();
                }
                if (enclosingScope instanceof RfPackage) {
                    packName = enclosingScope.getName();
                    enclosingScopeName = EMPTY_STR;
                }
                switch (columnIndex) {
                    case 0: {
                        RfPackage currentPackage;
                        String overrideParentName = wrapper.getOverrideParentName();
                        String elementName = namedElement.getName();
                        String returnType = EMPTY_STR;
                        if (namedElement instanceof RfFunction) {
                            RfFunction function = (RfFunction)namedElement;
                            elementName = String.valueOf(elementName) + FUNCTION_CALL_BRACKETS;
                            if (!function.isLet() && !function.isConstructor() && function.getDataType() != null) {
                                returnType = function.getDataType().toString();
                            }
                        }
                        String access = wrapper.isStaticAccess() ? STATIC_ACCESS : NORMAL_ACCESS;
                        boolean isSuper = wrapper.getHid() != null && wrapper.getHid().getParentHid() != null && SUPER.equals(wrapper.getHid().getParentHid().getName());
                        boolean callHierarchyViewPrependPackage = PrefConst.getCallHierarchyViewPrependPackage();
                        if (callHierarchyViewPrependPackage && (currentPackage = namedElement.getEnclosingPackage()) != null) {
                            packName = currentPackage.getName();
                        }
                        return this.internalGetText(overrideParentName, elementName, packName, enclosingScopeName, returnType, isSuper, access);
                    }
                    case 1: {
                        if (wrapperHidOccurrence != null) {
                            return String.valueOf(wrapperHidOccurrence.getLine());
                        }
                        if (wrapperMatchLines != null && !wrapperMatchLines.isEmpty()) {
                            return DVTStringUtil.join(wrapperMatchLines, (String)SEPARATOR);
                        }
                        if (namedElementImplementation != null) {
                            return String.valueOf(namedElementImplementation.getStartLine());
                        }
                        if (namedElementDeclaration != null) {
                            return String.valueOf(namedElementDeclaration.getStartLine());
                        }
                        return null;
                    }
                    case 2: {
                        if (wrapperParserPath != null) {
                            return Path.fromOSString((String)wrapperParserPath).lastSegment();
                        }
                        if (namedElementImplementation != null) {
                            RfFileDef file = namedElementImplementation.getDefFile();
                            return file != null ? file.getName() : null;
                        }
                        if (namedElementDeclaration != null) {
                            RfFileDef file = namedElementDeclaration.getDefFile();
                            return file != null ? file.getName() : null;
                        }
                        return null;
                    }
                    case 3: {
                        return ViewsUtilsCommon.trimText((String)namedElement.getComment(), (int)100, (boolean)true);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(ONE_SPACE).append(this.getColumnText(element, 1));
        return result.toString();
    }
}

