/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.model.reflection.views.CallHierarchyStateWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersTopFilePatternExpander;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyComputeStrategy;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyViewInput;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyViewInputConfigurator;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.typehierarchy.GotoDataContainer;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.views.CallHierarchyTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogCallHierarchyViewContributorCommon;
import ro.amiq.vlogdt.model.reflection.views.VlogCallerHierarchyFunctionCallInfo;
import ro.amiq.vlogdt.model.reflection.views.VlogInspectViewContributor;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogCallHierarchyViewContributor
extends VlogCallHierarchyViewContributorCommon {
    private static final String STATIC_ACCESS_SYMBOL = "::";
    private static final String EMPTY_STRING = "";
    private static final String ONE_SPACE = " ";
    protected List<GUIFilter> fExpandedXVMFilters;
    protected static final String FUNCTION_DECLARATION_COMMENT = "Function declaration:";
    protected static final String FUNCTION_CALL_COMMENT = "function call:";
    protected static final String OVERRIDE = "override";
    protected static final EnumSet<CallHierarchyTreeElementWrapper.WrapperKind> validWrappersForInspectViewCallInformation = EnumSet.of(CallHierarchyTreeElementWrapper.WrapperKind.NORMAL, CallHierarchyTreeElementWrapper.WrapperKind.OVERRIDE);

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        if (namedElement == null) {
            return EMPTY_STRING;
        }
        String comment = namedElement.getComment();
        if (comment == null) {
            return EMPTY_STRING;
        }
        return DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)comment, (String)ONE_SPACE);
    }

    protected RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public CallHierarchyViewInput getInput(CallHierarchyViewInputConfigurator inputConfigurator) {
        this.fHasGUIFilteredMembers = false;
        this.fIsPrependPackage = inputConfigurator.isPrependPackage();
        this.fCallHierarchyComputeStrategy = inputConfigurator.getStrategy();
        String bulkDataInfo = EMPTY_STRING;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        CallHierarchyViewInput emptyResult = new CallHierarchyViewInput(this.fHasGUIFilteredMembers, Collections.emptyList(), bulkDataInfo);
        try {
            this.fHasGUIFilteredMembers = false;
            if (!inputConfigurator.getHistoryItem().getLanguage().equals((Object)LanguageKind.VLOG)) {
                return emptyResult;
            }
            IProject project = inputConfigurator.getSource();
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return emptyResult;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return emptyResult;
            }
            if (inputConfigurator.getJob() == null) {
                return emptyResult;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return emptyResult;
            }
            this.updateExpandedXVMFilters(project);
            UpdateViewEvent ev = (UpdateViewEvent)inputConfigurator.getHistoryItem();
            IDVTElementWrapper root = this.toWrappers(rfProject, ev.getElementName(), (List)ev.getElementScope(), inputConfigurator.getJob(), ev.getElementType());
            bulkDataInfo = this.fLabelProvider.getTextUtil(root, 0);
            if (root == null) {
                return emptyResult;
            }
            this.filterNonTerminalLeafsAndApplyContentFilters(root);
            elements.add(root);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (elements.isEmpty()) {
            return emptyResult;
        }
        Object rootRfElem = ((IDVTElementWrapper)elements.get(0)).getRfElement();
        if (!bulkDataInfo.contains(STATIC_ACCESS_SYMBOL) && rootRfElem instanceof RfNamedElement) {
            RfPackage rootNamedElemPackage = ((RfNamedElement)rootRfElem).getEnclosingPackage();
            String packageName = null;
            if (rootNamedElemPackage != null) {
                packageName = rootNamedElemPackage.getName();
            }
            if (packageName != null) {
                bulkDataInfo = packageName.concat(STATIC_ACCESS_SYMBOL).concat(bulkDataInfo);
            }
        }
        return new CallHierarchyViewInput(this.fHasGUIFilteredMembers, elements, bulkDataInfo);
    }

    public void filterByName(IDVTElementWrapper wrapper, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        if (wrapper == null) {
            return;
        }
        ViewsUtils.hierarchicalSearch((IDVTElementWrapper)wrapper, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness, (boolean)true);
    }

    public void gotoElement(IProject project, Object dataContainer) {
        if (!(dataContainer instanceof GotoDataContainer)) {
            return;
        }
        GotoDataContainer gtContainer = (GotoDataContainer)dataContainer;
        IDVTElementWrapper iWrapper = gtContainer.getWrapper();
        if (!(iWrapper instanceof CallHierarchyTreeElementWrapper)) {
            return;
        }
        CallHierarchyTreeElementWrapper wrapper = (CallHierarchyTreeElementWrapper)iWrapper;
        RfNamedElement element = (RfNamedElement)wrapper.getRfElement();
        if (element == null) {
            return;
        }
        if (element instanceof RfActionBlock) {
            RfNamedElementActionHyperlink createOpenAction = RfUtils.createOpenAction(element, project, null);
            if (createOpenAction != null) {
                createOpenAction.open();
            }
            return;
        }
        ParserPath parserPath = new ParserPath(wrapper.getParserPath());
        if (parserPath.path == null || parserPath.isEmpty()) {
            RfDefElement elementImplementation = element.getImplementation();
            RfDefElement elementDeclaration = element.getDeclaration();
            if (elementImplementation == null && elementDeclaration == null) {
                return;
            }
            ParserPath parserPath2 = parserPath = elementImplementation != null ? elementImplementation.getParserPath() : elementDeclaration.getParserPath();
        }
        if (wrapper.hasHidOccurrence()) {
            DVTFileUtils.getInstance().openEditorWithOffset(new File(parserPath.path), wrapper.getHidOccurrence().getOffset(), element.getName().length(), true, "ro.amiq.vlogdt.ui.editor.VlogEditor");
        } else if (wrapper.getFirstOffset() != -1) {
            DVTFileUtils.getInstance().openEditorWithOffset(new File(parserPath.path), wrapper.getFirstOffset(), wrapper.getName().length(), true, "ro.amiq.vlogdt.ui.editor.VlogEditor");
        } else {
            VlogFileUtils.getInstance().openFile(project, parserPath.path, this.getLine(wrapper), element.getName());
        }
    }

    protected void updateExpandedXVMFilters(IProject project) {
        this.fExpandedXVMFilters = DVTPredefinedGUIFilters.getXVMFilter();
        DVTGUIFiltersTopFilePatternExpander.expand(this.fExpandedXVMFilters, (IProject)project);
    }

    @Override
    protected Set<SearchHit> getFunctionCallHitsCaller(final IRfSingleLangProject rfProject, IRfNamedElement currentNode) {
        if (currentNode == null || rfProject == null) {
            return Collections.emptySet();
        }
        IReportHitsListener<SearchHit> callerHierarchyHitsListener = new IReportHitsListener<SearchHit>(){
            Set<SearchHit> allMatches = new TreeSet<SearchHit>(new Comparator<SearchHit>(){

                @Override
                public int compare(SearchHit h1, SearchHit h2) {
                    return h1.getLine() != h2.getLine() ? h1.getLine() - h2.getLine() : h1.getOffset() - h2.getOffset();
                }
            });

            public void addMatch(SearchHit match) {
                if (match == null) {
                    return;
                }
                IRfDefElement scopeDef = RfSearchUtils.getScope((IProject)rfProject.getProject(), (ParserPath)match.getParserPath(), (int)match.getLine(), (int)match.getOffset());
                match.setScopeDef(scopeDef);
                this.allMatches.add(match);
            }

            public Set<SearchHit> getMatches() {
                return this.allMatches;
            }
        };
        HashMap searched = new HashMap();
        NullProgressMonitor monitor = new NullProgressMonitor();
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles(searched), (IProgressMonitor)monitor);
        RfSearchUtils.computeReferences((IReportHitsListener)callerHierarchyHitsListener, (IProject)rfProject.getProject(), (IRfNamedElement)currentNode, null, (String)currentNode.getName(), (IProgressMonitor)monitor, searched, (FileSynchedAndAvailableManager)fileManager, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        return callerHierarchyHitsListener.getMatches();
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getTextUtil(element, 0));
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset) {
        RfNamedElement element;
        IProject project;
        block20: {
            IDocument document;
            RfProject rfProject;
            IFile file;
            VlogEditor vlogEditor;
            block19: {
                IDocumentProvider documentProvider;
                IEditorInput editorInput;
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        try {
                                            if (editor instanceof VlogEditor) break block13;
                                            return null;
                                        }
                                        catch (Exception e) {
                                            DVTLogger.INSTANCE.logError((Throwable)e);
                                            return null;
                                        }
                                    }
                                    vlogEditor = (VlogEditor)editor;
                                    editorInput = vlogEditor.getEditorInput();
                                    if (editorInput != null) break block14;
                                    return null;
                                }
                                file = (IFile)editorInput.getAdapter(IFile.class);
                                if (file != null) break block15;
                                return null;
                            }
                            project = file.getProject();
                            if (project != null) break block16;
                            return null;
                        }
                        rfProject = RfManager.getInstance().getRfProject(project);
                        if (rfProject != null) break block17;
                        return null;
                    }
                    documentProvider = vlogEditor.getDocumentProvider();
                    if (documentProvider != null) break block18;
                    return null;
                }
                document = documentProvider.getDocument((Object)editorInput);
                if (document != null) break block19;
                return null;
            }
            element = null;
            RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(rfProject, (ITextEditor)vlogEditor, document, cursorOffset);
            if (elementAndScope == null || elementAndScope.getNamedElement() == null) {
                RfFileDef fileDef = rfProject.getFile((IResource)file);
                if (fileDef != null) {
                    RfDefElement lineScope = fileDef.getScope(cursorOffset, false);
                    element = VlogQuickViewersUtil.getEnclosingFunctionOrClass(lineScope, true);
                }
            } else {
                element = elementAndScope.getNamedElement();
            }
            if (element instanceof RfFunction || element instanceof RfField) break block20;
            return null;
        }
        this.fStateWrapper = null;
        UpdateViewEvent updateEvent = VlogQuickViewersUtil.createViewUpdateEvent(element, project, 6);
        return updateEvent;
    }

    public void expandXLevels(IDVTElementWrapper rootWrapper, int levels, IDVTJob job) {
        if (ViewsUtils.isCanceled((IDVTJob)job)) {
            return;
        }
        if (levels <= 0) {
            return;
        }
        this.expandFromWrapper(rootWrapper, null, job);
        this.filterNonTerminalLeafsAndApplyContentFilters(rootWrapper);
        if (!rootWrapper.hasChildren()) {
            return;
        }
        for (IDVTElementWrapper child : rootWrapper.getChildren()) {
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            this.expandXLevels(child, levels - 1, job);
        }
    }

    public void goToWrapperDeclaration(IDVTElementWrapper wrapper, IProject project) {
        CallHierarchyTreeElementWrapper callWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(editor instanceof VlogEditor)) {
            return;
        }
        VlogEditor vlogEditor = (VlogEditor)editor;
        IEditorInput editorInput = vlogEditor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IFile file = callWrapper.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.MACRO ? callWrapper.getMacroCallFile() : (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return;
        }
        IProject iProject = file.getProject();
        if (iProject == null) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(iProject);
        if (rfProject == null) {
            return;
        }
        IDocumentProvider documentProvider = vlogEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (document == null) {
            return;
        }
        RfNamedElement rfElement = callWrapper.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.MACRO ? rfProject.getMacroBeforeLineInFile(((RfDummyElement)callWrapper.getRfElement()).getName().substring(1), parserPath, callWrapper.getMacroLine()) : (callWrapper.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.RECURRENCE ? (RfNamedElement)callWrapper.getRecurenceWrapper().getRfElement() : (RfNamedElement)wrapper.getRfElement());
        RfNamedElementActionHyperlink hyperLink = RfUtils.createOpenAction(rfElement, project, (IRegion)RfBatchUtils.getTypedRegion(document, rfElement.getStartOffset()));
        if (hyperLink == null) {
            return;
        }
        hyperLink.open();
    }

    @Override
    public CallHierarchyStateWrapper createStateTree(IDVTElementWrapper wrapper) {
        if (wrapper == null || !(wrapper instanceof CallHierarchyTreeElementWrapper)) {
            return null;
        }
        return this.createStateTree(wrapper, new CallHierarchyStateWrapper(this.fLabelProvider.getTextUtil(wrapper, 0), (DVTBaseLabelProvider)this.fLabelProvider));
    }

    protected CallHierarchyStateWrapper createStateTree(IDVTElementWrapper wrapper, CallHierarchyStateWrapper stateWrapper) {
        if (wrapper.hasChildren()) {
            for (IDVTElementWrapper child : wrapper.getChildren()) {
                if (child == null) continue;
                CallHierarchyStateWrapper stateChild = new CallHierarchyStateWrapper(this.fLabelProvider.getTextUtil(child, 0), (DVTBaseLabelProvider)this.fLabelProvider);
                stateWrapper.addChild(stateChild);
                if (child.getExpanded() == -2) continue;
                this.createStateTree(child, stateChild);
            }
        }
        return stateWrapper;
    }

    public boolean canGoToDeclarationOnWrapper(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        RfNamedElement namedElement = (RfNamedElement)wrapper.getRfElement();
        if (!(namedElement instanceof RfFunction)) {
            return false;
        }
        boolean isPotential = ((CallHierarchyTreeElementWrapper)wrapper).getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.POTENTIAL;
        boolean isPredefined = ((RfFunction)namedElement).isPredefined();
        return !isPredefined && !isPotential;
    }

    public InspectViewInput getInspectContent(IDVTElementWrapper wrapper, IDVTElementWrapper originalWrapper, IProject project) {
        if (!(wrapper instanceof CallHierarchyTreeElementWrapper)) {
            return null;
        }
        if (((CallHierarchyTreeElementWrapper)wrapper).getHierarchyStrategy() == CallHierarchyComputeStrategy.CALLER) {
            return this.getCallerInspectInput(wrapper, project);
        }
        return this.getCalleeInspectInput(wrapper, originalWrapper, project);
    }

    protected InspectViewInput getCallerInspectInput(IDVTElementWrapper wrapper, IProject project) {
        if (project == null || !(wrapper instanceof CallHierarchyTreeElementWrapper)) {
            return null;
        }
        CallHierarchyTreeElementWrapper cWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        String parserPath = cWrapper.getParserPath();
        if (parserPath == null || parserPath.isEmpty() || cWrapper.getMatchLines() == null || cWrapper.getMatchLines().isEmpty()) {
            return null;
        }
        Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>> linesAndInfos = cWrapper.getMatchLinesAndInfos();
        if (linesAndInfos == null) {
            return null;
        }
        ArrayList<InspectViewGoToInfo> goToInfos = new ArrayList<InspectViewGoToInfo>();
        for (Map.Entry<Integer, List<VlogCallerHierarchyFunctionCallInfo>> entry : linesAndInfos.entrySet()) {
            int line = entry.getKey();
            List<VlogCallerHierarchyFunctionCallInfo> infos = entry.getValue();
            boolean isOverride = false;
            for (VlogCallerHierarchyFunctionCallInfo callInfo : infos) {
                if (!callInfo.IsOverride()) continue;
                isOverride = true;
                break;
            }
            StringBuilder callComment = new StringBuilder();
            if (cWrapper.getName() != null) {
                callComment.append("\"").append(cWrapper.getName()).append("\" ");
            }
            if (isOverride) {
                callComment.append(callComment.length() != 0 ? OVERRIDE : StringUtils.capitalize((String)OVERRIDE)).append(ONE_SPACE);
            }
            callComment.append(callComment.length() != 0 ? FUNCTION_CALL_COMMENT : StringUtils.capitalize((String)FUNCTION_CALL_COMMENT));
            goToInfos.add(new InspectViewGoToInfo(new GoToInfo(parserPath, -1, -1, line, line, EMPTY_STRING, LanguageKind.VLOG), null, callComment.toString()));
        }
        return DVTInspectViewUtils.getInstance().processGoToInfos(goToInfos, project, LanguageKind.VLOG, false);
    }

    protected InspectViewInput getCalleeInspectInput(IDVTElementWrapper wrapper, IDVTElementWrapper originalWrapper, IProject project) {
        RfFunction function;
        if (project == null || !(wrapper instanceof CallHierarchyTreeElementWrapper)) {
            return null;
        }
        CallHierarchyTreeElementWrapper cWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        RfNamedElement element = (RfNamedElement)cWrapper.getRfElement();
        if (element == null) {
            return null;
        }
        CallHierarchyTreeElementWrapper.WrapperKind type = cWrapper.getWrapperKind();
        if (type == CallHierarchyTreeElementWrapper.WrapperKind.MACRO) {
            VlogMacroInfo macroInfo = cWrapper.getMacroInfo();
            if (macroInfo == null) {
                return null;
            }
            int macroCallOffset = cWrapper.hasHidOccurrence() ? cWrapper.getHidOccurrence().getOffset() : this.getOffset(wrapper);
            return VlogInspectViewContributor.processMacro(project, macroInfo, macroCallOffset, cWrapper.getParserPath());
        }
        if (type == CallHierarchyTreeElementWrapper.WrapperKind.RECURRENCE) {
            return this.getInspectContent(cWrapper.getRecurenceWrapper(), wrapper, project);
        }
        RfDefElement declaration = element.getDeclaration();
        if (declaration == null) {
            return null;
        }
        if (element instanceof RfFunction && (function = (RfFunction)element).isExtern()) {
            declaration = function.getImplementation();
        }
        ArrayList<InspectViewGoToInfo> goToInfos = new ArrayList<InspectViewGoToInfo>();
        goToInfos.add(new InspectViewGoToInfo(GoToInfo.sourceOf((IRfDefElement)declaration, (String)element.getName()), null, FUNCTION_DECLARATION_COMMENT));
        if (!validWrappersForInspectViewCallInformation.contains((Object)type)) {
            return DVTInspectViewUtils.getInstance().processGoToInfos(goToInfos, project, LanguageKind.VLOG);
        }
        String parserPath = cWrapper.getParserPath();
        if (parserPath == null || parserPath.isEmpty()) {
            return DVTInspectViewUtils.getInstance().processGoToInfos(goToInfos, project, LanguageKind.VLOG);
        }
        int line = originalWrapper != null ? this.getLine(originalWrapper) : this.getLine(wrapper);
        if (line < 0) {
            return DVTInspectViewUtils.getInstance().processGoToInfos(goToInfos, project, LanguageKind.VLOG);
        }
        goToInfos.add(new InspectViewGoToInfo(new GoToInfo(parserPath, -1, -1, line, line, EMPTY_STRING, LanguageKind.VLOG), null, FUNCTION_CALL_COMMENT));
        return DVTInspectViewUtils.getInstance().processGoToInfos(goToInfos, project, LanguageKind.VLOG, false);
    }

    public void setStateWrapper(CallHierarchyStateWrapper stateWrapper) {
        this.fStateWrapper = stateWrapper;
    }
}

