/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.model.reflection.views.CallHierarchyStateWrapper;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyComputeStrategy;
import ro.amiq.dvt.ui.views.callhierarchy.ICallHierarchyViewContributor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.views.CallHierarchyTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogCallHierarchyLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogCallerHierarchyFunctionCallInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.search.new_engine.SearchMatchKindsWrapper;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public abstract class VlogCallHierarchyViewContributorCommon
implements ICallHierarchyViewContributor {
    protected static final String STATIC_ACCESS_SYMBOL = "::";
    protected static final String EMPTY_STRING = "";
    protected boolean fIsPrependPackage;
    protected boolean fShowConditionals = true;
    protected boolean fShowForks = true;
    protected boolean fShowOverrides = true;
    protected boolean fShowNamedBeginEnds = true;
    protected boolean fHasGUIFilteredMembers;
    protected CallHierarchyStateWrapper fStateWrapper;
    protected CallHierarchyComputeStrategy fCallHierarchyComputeStrategy;
    protected VlogCallHierarchyLabelProvider fLabelProvider = new VlogCallHierarchyLabelProvider();
    public static final Set<HidFlatteningOption> METHOD_CALLS_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_CONSTANTS));
    List<Class<? extends RfNamedElement>> SCOPE_CLASSES = Arrays.asList(RfActionBlock.class, RfAssertExpect.class);

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    protected void expandLastState(IDVTElementWrapper wrapper, CallHierarchyStateWrapper stateWrapper, RfProject rfProject, IDVTJob job) {
        if (ViewsUtils.isCanceled((IDVTJob)job)) {
            return;
        }
        this.expandFromWrapper(wrapper, rfProject, job);
        for (IDVTElementWrapper child : wrapper.getChildren()) {
            CallHierarchyStateWrapper statePair;
            if (child == null || stateWrapper == null || (statePair = stateWrapper.findPair(child)) == null || !statePair.hasChildren()) continue;
            this.expandLastState(child, statePair, rfProject, job);
        }
    }

    protected void expandFromWrapper(IDVTElementWrapper wrapper, RfProject rfProject, IDVTJob job) {
        if (!(wrapper instanceof CallHierarchyTreeElementWrapper)) {
            return;
        }
        wrapper.setExpanded(0);
        boolean childrenComputed = (Boolean)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.CHILDREN_COMPUTED);
        if (childrenComputed) {
            return;
        }
        if (rfProject == null) {
            IRfSingleLangProject irfProject = ((IRfNamedElement)wrapper.getRfElement(IRfNamedElement.class)).getRfProject();
            if (!(irfProject instanceof RfProject)) {
                return;
            }
            rfProject = (RfProject)irfProject;
        }
        List<RfTreeElementWrapper> children = null;
        children = this.fCallHierarchyComputeStrategy == CallHierarchyComputeStrategy.CALLER ? this.computeCallerHierarchyNodes(wrapper, rfProject, this.fCallHierarchyComputeStrategy) : this.getChildrenFunctionCallHids((RfTreeElementWrapper)wrapper, null, rfProject, 1, job, this.fCallHierarchyComputeStrategy);
        if (children == null) {
            return;
        }
        if (wrapper.hasChildren()) {
            ((CallHierarchyTreeElementWrapper)wrapper).getChildren().clear();
        }
        if (!children.isEmpty()) {
            wrapper.addChildren(children);
            if (this.fCallHierarchyComputeStrategy == CallHierarchyComputeStrategy.CALLER) {
                this.applyCallerFilters(wrapper);
            } else {
                this.applyCalleeFilters(wrapper);
            }
        }
        wrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.CHILDREN_COMPUTED, (Object)true);
    }

    public void updateFilterOptions() {
        this.fShowConditionals = !PrefConst.getCallHierarchyViewHideConditionals();
        this.fShowForks = !PrefConst.getCallHierarchyViewHideForks();
        this.fShowOverrides = !PrefConst.getCallHierarchyViewHideOverrides();
        this.fShowNamedBeginEnds = !PrefConst.getCallHierarchyViewHideNamedBlocks();
    }

    public void applyCalleeFilters(IDVTElementWrapper wrapper) {
        if (wrapper.getChildren() == null) {
            return;
        }
        ArrayList originalChildren = new ArrayList(wrapper.getChildren());
        for (IDVTElementWrapper child : originalChildren) {
            this.filterConditionals(child);
        }
        this.filterActionBlockLeafs(wrapper);
        this.applyVirtualFunctionFilters(wrapper);
        this.groupByMacros(wrapper);
        this.sort(wrapper);
        this.sortByActualOrder(wrapper);
    }

    public void applyCallerFilters(IDVTElementWrapper wrapper) {
        if (this.fShowOverrides || !(wrapper instanceof CallHierarchyTreeElementWrapper)) {
            return;
        }
        CallHierarchyTreeElementWrapper cWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        if (cWrapper.getHierarchyStrategy() != CallHierarchyComputeStrategy.CALLER) {
            return;
        }
        this.filterCallerOverrides(cWrapper, true);
    }

    protected boolean filterCallerOverrides(CallHierarchyTreeElementWrapper wrapper, boolean isRoot) {
        List<RfTreeElementWrapper> children;
        if (!isRoot) {
            Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>> linesAndInfos = wrapper.getMatchLinesAndInfos();
            if (linesAndInfos == null) {
                return true;
            }
            Iterator<List<VlogCallerHierarchyFunctionCallInfo>> listInfoIterator = linesAndInfos.values().iterator();
            while (listInfoIterator.hasNext()) {
                List<VlogCallerHierarchyFunctionCallInfo> infos = listInfoIterator.next();
                Iterator<VlogCallerHierarchyFunctionCallInfo> infoIterator = infos.iterator();
                while (infoIterator.hasNext()) {
                    VlogCallerHierarchyFunctionCallInfo info = infoIterator.next();
                    if (!info.IsOverride()) continue;
                    infoIterator.remove();
                }
                if (!infos.isEmpty()) continue;
                listInfoIterator.remove();
            }
            if (linesAndInfos.isEmpty()) {
                return true;
            }
        }
        if ((children = wrapper.getChildren()) == null || children.isEmpty()) {
            return false;
        }
        Iterator<RfTreeElementWrapper> childIterator = children.iterator();
        while (childIterator.hasNext()) {
            IDVTElementWrapper child = childIterator.next();
            if (((CallHierarchyTreeElementWrapper)child).getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.UPDATING) {
                return false;
            }
            boolean shouldRemove = this.filterCallerOverrides((CallHierarchyTreeElementWrapper)child, false);
            if (!shouldRemove) continue;
            childIterator.remove();
        }
        return false;
    }

    protected void sortByActualOrder(IDVTElementWrapper wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        RfTreeElementWrapper rootWrapper = (RfTreeElementWrapper)wrapper;
        List<RfTreeElementWrapper> children = rootWrapper.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        this.breakMainProblem(children, 0, children.size() - 1);
        for (RfTreeElementWrapper child : children) {
            this.sortByActualOrder(child);
        }
    }

    protected boolean isParameter(CallHierarchyTreeElementWrapper wrapper) {
        if (wrapper.getHidOccurrence() == null) {
            return false;
        }
        return wrapper.getHidOccurrence().hasQualifier(HidQualifier.HID_IS_ACTUAL_PART);
    }

    public boolean isCallInParameters(CallHierarchyTreeElementWrapper mainCall, CallHierarchyTreeElementWrapper check) {
        Hid mainCallHid = mainCall.getHid();
        if (mainCallHid == null || check.getHid() == null) {
            return false;
        }
        if (mainCallHid.hasAccesses() && this.isParameter(check)) {
            ListContainer accesses = mainCallHid.getAccesses();
            if (accesses == null) {
                return false;
            }
            for (HidAccess access : accesses) {
                List argumentValues;
                if (!(access instanceof IHidAccessArgs) || access.getOccurrence() == null || !access.getOccurrence().equals((Object)mainCall.getHidOccurrence()) || (argumentValues = ((IHidAccessArgs)access).getArgumentValues()) == null) continue;
                for (IHidObject arg : argumentValues) {
                    Set result = MethodCallUtils.getValueHids((IHidObject)arg, METHOD_CALLS_HID_FLATTENING);
                    if (!result.contains(check.getHid())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void breakMainProblem(List<RfTreeElementWrapper> children, int startOffset, int endOffset) {
        if (children == null || children.isEmpty()) {
            return;
        }
        if (endOffset <= startOffset) {
            return;
        }
        int startSubProblemOffset = 0;
        int endSubProblemOffset = 0;
        int i = startOffset;
        int j = 0;
        while (i < endOffset) {
            startSubProblemOffset = i;
            endSubProblemOffset = i;
            j = i + 1;
            while (j <= endOffset && this.isCallInParameters((CallHierarchyTreeElementWrapper)children.get(startSubProblemOffset), (CallHierarchyTreeElementWrapper)children.get(j))) {
                endSubProblemOffset = j++;
            }
            if (endSubProblemOffset > startSubProblemOffset) {
                this.solveSubProblem(children, startSubProblemOffset, endSubProblemOffset);
                i = endSubProblemOffset + 1;
                continue;
            }
            ++i;
        }
    }

    protected void solveSubProblem(List<RfTreeElementWrapper> children, int startOffset, int endOffset) {
        RfTreeElementWrapper mainCall = children.get(startOffset);
        int i = startOffset + 1;
        while (i <= endOffset) {
            children.set(i - 1, children.get(i));
            ++i;
        }
        children.set(endOffset, mainCall);
        this.breakMainProblem(children, startOffset, endOffset - 1);
    }

    protected void groupByMacros(IDVTElementWrapper wrapper) {
        if (wrapper == null || !wrapper.hasChildren()) {
            return;
        }
        HashMap<Integer, IDVTElementWrapper> macroNodesByOffset = new HashMap<Integer, IDVTElementWrapper>();
        ArrayList childrenWorkingCopy = new ArrayList(wrapper.getChildren());
        ArrayList<IDVTElementWrapper> children = new ArrayList<IDVTElementWrapper>();
        boolean updateChildren = false;
        for (IDVTElementWrapper child : childrenWorkingCopy) {
            if (!this.wrapperInsideMacro(child)) {
                children.add(child);
                continue;
            }
            updateChildren = true;
            int offset = this.getOffset(child);
            IDVTElementWrapper macroNode = (IDVTElementWrapper)macroNodesByOffset.get(offset);
            if (macroNode == null) {
                macroNode = this.makeMacroWrapperFromChildWrapper(child);
                if (macroNode == null || !this.keep(macroNode)) continue;
                macroNodesByOffset.put(offset, macroNode);
                children.add(macroNode);
                macroNode.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.CHILDREN_COMPUTED, (Object)true);
            }
            macroNode.addChild(child);
        }
        if (updateChildren) {
            wrapper.setChildren(children);
        }
    }

    protected CallHierarchyTreeElementWrapper makeMacroWrapperFromChildWrapper(IDVTElementWrapper child) {
        CallHierarchyTreeElementWrapper wrapper = (CallHierarchyTreeElementWrapper)child;
        RfNamedElement namedElement = (RfNamedElement)child.getRfElement();
        String parserPath = namedElement instanceof RfActionBlock ? namedElement.getDeclaration().getParserPath().path : wrapper.getParserPath();
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(wrapper.getProject(), parserPath);
        if (iFile == null) {
            return null;
        }
        int line = this.getLine(child);
        String macroName = DVTFileUtils.getInstance().getLineFromFile(iFile, line);
        int indexOfStartMacro = macroName.indexOf("`");
        if (indexOfStartMacro < 0) {
            return null;
        }
        int indexOfParanthesis = -1;
        int stringLength = macroName.length();
        int i = indexOfStartMacro + 1;
        while (i < stringLength) {
            if (macroName.charAt(i) == '(') {
                indexOfParanthesis = i;
                break;
            }
            ++i;
        }
        macroName = indexOfParanthesis < 0 ? macroName.substring(macroName.indexOf(96)) : macroName.substring(macroName.indexOf(96), indexOfParanthesis);
        RfProject rfProject = RfManager.getInstance().getRfProject(wrapper.getProject());
        CallHierarchyTreeElementWrapper result = this.makeCalleeWrapper(new RfDummyElement(macroName, rfProject), parserPath, null, null, CallHierarchyTreeElementWrapper.WrapperKind.MACRO);
        result.setMacroLine(line);
        result.setMacroOffset(this.getOffset(child));
        result.setMacroCallFile(iFile);
        VlogMacroInfo macro = rfProject.getMacroBeforeLineInFile(macroName.substring(1), new ParserPath(parserPath), line);
        result.setMacroInfo(macro);
        result.setParent((RfTreeElementWrapper)child.getParent());
        return result;
    }

    protected boolean wrapperInsideMacro(IDVTElementWrapper wrapper) {
        int parentOffset;
        int wrapperVOffset = this.getVirtualOffset(wrapper);
        if (wrapperVOffset < 0) {
            return false;
        }
        IDVTElementWrapper parent = wrapper.getParent();
        if (wrapper.getParent() == null) {
            return false;
        }
        int parentVOffset = this.getVirtualOffset(parent);
        if (parentVOffset < 0) {
            return true;
        }
        int wrapperOffset = this.getOffset(wrapper);
        return wrapperOffset != (parentOffset = this.getOffset(parent));
    }

    protected boolean keep(IDVTElementWrapper node) {
        IDVTElementWrapper parent = node.getParent();
        if (parent == null) {
            return true;
        }
        Object rfElement = parent.getRfElement();
        if (rfElement instanceof RfFunction || rfElement instanceof RfDummyElement) {
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CALL_HIERARCHY, (IRfNamedElement)((RfNamedElement)rfElement), () -> this.fLabelProvider.getTextUtil(node, 0)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                this.fHasGUIFilteredMembers = true;
                return false;
            }
            return true;
        }
        if (rfElement instanceof RfActionBlock) {
            return true;
        }
        return rfElement instanceof RfField;
    }

    public boolean filterNonTerminalLeafsAndApplyContentFilters(IDVTElementWrapper node) {
        if (!node.hasChildren()) {
            return !this.keep(node);
        }
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            IDVTElementWrapper child = (IDVTElementWrapper)iterator.next();
            if (!this.filterNonTerminalLeafsAndApplyContentFilters(child)) continue;
            iterator.remove();
        }
        return !this.keep(node);
    }

    protected RfFunction getFunction(RfProject project, String elementName, List<RfNameTypeScopeHelper> elementScope) {
        try {
            IRfScopeElement classScope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
            RfFunction candidate = ((RfNamedElement)classScope).getFunctionWithPrefix(elementName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (candidate == null) {
                candidate = ((RfNamedElement)classScope).getTaskWithPrefix(elementName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (candidate == null) {
                candidate = ((RfNamedElement)classScope).getConstructorWithPrefix(elementName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            return candidate;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected IRfNamedElement getField(RfProject project, String elementName, List<RfNameTypeScopeHelper> elementScope) {
        IRfScopeElement classScope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                return candidate instanceof RfField;
            }

            public boolean allowEnumElement() {
                return true;
            }

            public int resultMaxSize() {
                return 1;
            }
        };
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        ((RfNamedElement)classScope).getElementsWithPrefix(result, elementName, 1, 1, false, IRfNamedElement.AccessModifier.SHOW_PRIVATE, elementFilter);
        return !result.isEmpty() ? (IRfNamedElement)result.get(0) : null;
    }

    public List<RfTreeElementWrapper> computeCallerHierarchyNodes(IDVTElementWrapper wrapper, IRfSingleLangProject rfProject, CallHierarchyComputeStrategy hierarchyStrategy) {
        IRfNamedElement currentNode = (IRfNamedElement)wrapper.getRfElement();
        if (currentNode == null || rfProject == null) {
            return Collections.emptyList();
        }
        Set<SearchHit> results = this.getFunctionCallHitsCaller(rfProject, currentNode);
        LinkedHashMap<IRfScopeElement, Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>>> matchLinesAndInfos = new LinkedHashMap<IRfScopeElement, Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>>>();
        HashMap<IRfScopeElement, String> matchPaths = new HashMap<IRfScopeElement, String>();
        for (SearchHit searchHit : results) {
            int hitLine;
            Map hitLinesAndInfos;
            boolean isOverride;
            SearchMatchKindsWrapper matchKind;
            IRfDefElement scopeDef;
            if (searchHit.isPossibleMatch() || !(searchHit instanceof VlogSearchHit) || (scopeDef = searchHit.getScopeDef()) == null) continue;
            IRfNamedElement hitScope = scopeDef.getNamedElement();
            while (hitScope != null && !(hitScope instanceof RfFunction)) {
                hitScope = hitScope.getEnclosingScope();
            }
            if (hitScope == null || (matchKind = ((VlogSearchHit)searchHit).getSearchMatchKind()) == null) continue;
            RfFunction.FunctionCallKind functionCallKind = matchKind.getFunctionCallKind();
            boolean bl = isOverride = functionCallKind == RfFunction.FunctionCallKind.OVERRIDDEN;
            if (matchLinesAndInfos.get(hitScope) == null) {
                matchLinesAndInfos.put((IRfScopeElement)hitScope, new LinkedHashMap());
            }
            if ((hitLinesAndInfos = (Map)matchLinesAndInfos.get(hitScope)).get(hitLine = searchHit.getLine()) == null) {
                hitLinesAndInfos.put(hitLine, new ArrayList());
            }
            ((List)hitLinesAndInfos.get(hitLine)).add(new VlogCallerHierarchyFunctionCallInfo(searchHit.getOffset(), isOverride));
            if (matchPaths.get(hitScope) != null) continue;
            matchPaths.put((IRfScopeElement)hitScope, searchHit.getParserPath().path);
        }
        return this.createChildrenFromScopeEntries(wrapper, currentNode, matchLinesAndInfos, matchPaths, hierarchyStrategy);
    }

    protected Set<SearchHit> getFunctionCallHitsCaller(final IRfSingleLangProject rfProject, IRfNamedElement currentNode) {
        if (currentNode == null || rfProject == null) {
            return Collections.emptySet();
        }
        IReportHitsListener<SearchHit> callerHierarchyHitsListener = new IReportHitsListener<SearchHit>(){
            Set<SearchHit> allMatches = new TreeSet<SearchHit>((h1, h2) -> h1.getLine() != h2.getLine() ? h1.getLine() - h2.getLine() : h1.getOffset() - h2.getOffset());

            public void addMatch(SearchHit match) {
                if (match == null) {
                    return;
                }
                IRfDefElement scopeDef = RfSearchUtils.getScope((IProject)rfProject.getProject(), (ParserPath)match.getParserPath(), (int)match.getLine(), (int)match.getOffset());
                match.setScopeDef(scopeDef);
                this.allMatches.add(match);
            }

            public Set<SearchHit> getMatches() {
                return this.allMatches;
            }
        };
        HashMap searched = new HashMap();
        NullProgressMonitor monitor = new NullProgressMonitor();
        FileSynchedAndAvailableManager fileManager = new FileSynchedAndAvailableManager(RfReferencesUtils.getSearchedFiles(searched), (IProgressMonitor)monitor);
        RfSearchUtils.computeReferences((IReportHitsListener)callerHierarchyHitsListener, (IProject)rfProject.getProject(), (IRfNamedElement)currentNode, null, (String)currentNode.getName(), (IProgressMonitor)monitor, searched, (FileSynchedAndAvailableManager)fileManager, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        return callerHierarchyHitsListener.getMatches();
    }

    protected List<RfTreeElementWrapper> createChildrenFromScopeEntries(IDVTElementWrapper wrapper, IRfNamedElement currentNode, Map<IRfScopeElement, Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>>> matchLinesAndInfos, Map<IRfScopeElement, String> matchPaths, CallHierarchyComputeStrategy hierarchyStrategy) {
        if (currentNode == null || matchLinesAndInfos == null || matchPaths == null || hierarchyStrategy == null || !(wrapper instanceof RfTreeElementWrapper)) {
            return Collections.emptyList();
        }
        ArrayList<RfTreeElementWrapper> children = new ArrayList<RfTreeElementWrapper>();
        for (Map.Entry<IRfScopeElement, Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>>> entry : matchLinesAndInfos.entrySet()) {
            Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>> linesAndInfos = entry.getValue();
            if (linesAndInfos == null || linesAndInfos.isEmpty()) continue;
            RfTreeElementWrapper currentWrapper = (RfTreeElementWrapper)wrapper;
            CallHierarchyTreeElementWrapper childWrapper = null;
            IRfScopeElement hitScope = entry.getKey();
            String hitPath = matchPaths.get(hitScope);
            RfTreeElementWrapper recurrenceWrapper = this.checkForLoops(currentWrapper, (RfFunction)hitScope);
            if (recurrenceWrapper != null) {
                childWrapper = this.makeCallerWrapper((IRfNamedElement)hitScope, hitPath, currentNode.getName(), linesAndInfos, CallHierarchyTreeElementWrapper.WrapperKind.RECURRENCE);
                childWrapper.setRecurenceWrapper(recurrenceWrapper);
                children.add(childWrapper);
                childWrapper.setParent(currentWrapper);
                continue;
            }
            childWrapper = this.makeCallerWrapper((IRfNamedElement)hitScope, hitPath, currentNode.getName(), linesAndInfos, CallHierarchyTreeElementWrapper.WrapperKind.NORMAL);
            ArrayList<CallHierarchyTreeElementWrapper> grandChildren = new ArrayList<CallHierarchyTreeElementWrapper>();
            grandChildren.add(this.makeWrapper(new RfDummyElement("Updating..."), CallHierarchyTreeElementWrapper.WrapperKind.UPDATING, hierarchyStrategy));
            childWrapper.addChildren(grandChildren);
            children.add(childWrapper);
            childWrapper.setParent(currentWrapper);
        }
        return children;
    }

    public List<RfTreeElementWrapper> getChildrenFunctionCallHids(final RfTreeElementWrapper currentWrapper, RfNamedElement currentNode, final RfProject rfProject, final int depth, final IDVTJob job, final CallHierarchyComputeStrategy hierarchyStrategy) {
        final ArrayList<RfTreeElementWrapper> result = new ArrayList<RfTreeElementWrapper>();
        if (currentNode == null) {
            currentNode = (RfNamedElement)currentWrapper.getRfElement();
        }
        if (job != null && ViewsUtils.isCanceled((IDVTJob)job)) {
            return result;
        }
        if (depth <= 0 && !(currentNode instanceof RfActionBlock)) {
            if (this.elementHasChildren(currentNode, rfProject)) {
                result.add(this.makeWrapper(new RfDummyElement("Updating..."), CallHierarchyTreeElementWrapper.WrapperKind.UPDATING, hierarchyStrategy));
            }
            return result;
        }
        if (currentNode == null || rfProject == null) {
            return Collections.emptyList();
        }
        List<RfNamedElement> innerScopes = this.getInnerScopes(currentNode);
        for (RfNamedElement element : innerScopes) {
            boolean isActionBlock;
            RfTreeElementWrapper wrapper = currentWrapper;
            boolean bl = isActionBlock = element instanceof RfActionBlock && (!((RfActionBlock)element).isElse() || !(element.getEnclosingScope() instanceof RfAssertExpect));
            if (isActionBlock) {
                wrapper = this.makeCalleeWrapper(element, null, null, null, CallHierarchyTreeElementWrapper.WrapperKind.ACTION_BLOCK);
                wrapper.setParent(currentWrapper);
            }
            List<RfTreeElementWrapper> children = this.getChildrenFunctionCallHids(wrapper, element, rfProject, isActionBlock ? depth - 1 : depth, job, hierarchyStrategy);
            if (isActionBlock) {
                wrapper.addChildren(children);
                result.add(wrapper);
                continue;
            }
            result.addAll(children);
        }
        RfHidHolder hidHolder = currentNode.getHidHolder();
        if (hidHolder == null) {
            return result;
        }
        Map hidsMap = hidHolder.getHidObjectsMap();
        if (hidsMap == null) {
            return result;
        }
        Set hidsEntries = hidsMap.entrySet();
        if (hidsEntries == null) {
            return result;
        }
        HashSet<HidOccurrence> uniqueOccurrences = new HashSet<HidOccurrence>();
        for (Map.Entry entry : hidsEntries) {
            final String path = ((ParserPath)entry.getKey()).path;
            ListContainer hidsContainer = (ListContainer)entry.getValue();
            for (IHidObject hid : hidsContainer) {
                HidOccurrence occurrence;
                if (!(hid instanceof Hid) || uniqueOccurrences.contains(occurrence = ((Hid)hid).getOccurrence())) continue;
                uniqueOccurrences.add(occurrence);
                RfHidVisitor visitor = new RfHidVisitor(){

                    public boolean visit(RfHid hid) {
                        List<Object> childWrappers = Collections.emptyList();
                        childWrappers = VlogCallHierarchyViewContributorCommon.this.createHidWrapper(rfProject, hid, currentWrapper, path, depth - 1, job, hierarchyStrategy);
                        if (childWrappers == null) {
                            return true;
                        }
                        result.addAll(childWrappers);
                        return true;
                    }
                };
                hid.visitHidObject((IRfSingleLangProject)rfProject, (IHidVisitor)visitor);
            }
        }
        return result;
    }

    protected List<RfNamedElement> getInnerScopes(RfNamedElement currentNode) {
        ArrayList<RfNamedElement> innerScopes = new ArrayList<RfNamedElement>();
        for (Class<? extends RfNamedElement> clazz : this.SCOPE_CLASSES) {
            List<? extends RfNamedElement> localMembers = currentNode.getLocalMembers(clazz);
            if (localMembers == null) continue;
            innerScopes.addAll(localMembers);
        }
        Collection<RfFunctionCall> functionCalls = currentNode.getLocalFunctionCalls();
        if (functionCalls != null) {
            for (RfFunctionCall functionCall : functionCalls) {
                if (!functionCall.hasWith()) continue;
                for (Class<? extends RfNamedElement> clazz : this.SCOPE_CLASSES) {
                    List<? extends RfNamedElement> localMembers = functionCall.getLocalMembers(clazz);
                    if (localMembers == null) continue;
                    innerScopes.addAll(localMembers);
                }
            }
        }
        return innerScopes;
    }

    protected boolean elementHasChildren(RfNamedElement namedElement, RfProject rfProject) {
        List<RfAssertExpect> assertBlocks;
        List<RfActionBlock> actionBlocks;
        Map hidsMap;
        if (namedElement == null || rfProject == null) {
            return false;
        }
        RfHidHolder hidHolder = namedElement.getHidHolder();
        if (hidHolder != null && (hidsMap = hidHolder.getHidObjectsMap()) != null && !hidsMap.isEmpty()) {
            for (ListContainer hidsContainer : hidsMap.values()) {
                for (IHidObject hid : hidsContainer) {
                    if (!(hid instanceof Hid)) continue;
                    final boolean[] hasFunctionCalls = new boolean[1];
                    if (this.hidIsFunctionCall((Hid)hid)) {
                        return true;
                    }
                    RfHidVisitor visitor = new RfHidVisitor(){

                        public boolean visit(RfHid hid) {
                            if (VlogCallHierarchyViewContributorCommon.this.hidIsFunctionCall(hid)) {
                                hasFunctionCalls[0] = true;
                                return false;
                            }
                            return true;
                        }
                    };
                    hid.visitHidObject((IRfSingleLangProject)rfProject, (IHidVisitor)visitor);
                    if (!hasFunctionCalls[0]) continue;
                    return true;
                }
            }
        }
        if ((actionBlocks = namedElement.getLocalMembers(RfActionBlock.class)) != null) {
            for (RfActionBlock rfActionBlock : actionBlocks) {
                if (!rfActionBlock.isAnonymous()) {
                    return true;
                }
                if (!this.elementHasChildren(rfActionBlock, rfProject)) continue;
                return true;
            }
        }
        if ((assertBlocks = namedElement.getLocalMembers(RfAssertExpect.class)) != null) {
            for (RfAssertExpect assertBlock : assertBlocks) {
                if (!assertBlock.isAnonymous()) {
                    return true;
                }
                if (!this.elementHasChildren(assertBlock, rfProject)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hidIsFunctionCall(Hid hid) {
        IRfNamedElement namedElement = hid.getElement();
        if (!(namedElement instanceof RfFunction) && hid.isPotentialMethodCall()) {
            return true;
        }
        if (namedElement == null) {
            return false;
        }
        return namedElement instanceof RfFunction;
    }

    protected List<RfFunction> getVirtualFunctionChildren(RfFunction function) {
        RfNamedElement enclosingScope = function.getEnclosingScope();
        if (!(enclosingScope instanceof RfClass)) {
            return Collections.emptyList();
        }
        ArrayList<RfFunction> result = new ArrayList<RfFunction>();
        String name = function.getName();
        LinkedHashSet<RfClass> computeClassFamily = function.computeClassFamily();
        result.addAll(computeClassFamily.stream().map(clazz -> clazz.getLocalMember(RfFunction.class, name, true)).filter(func -> func != null).collect(Collectors.toSet()));
        result.sort((o1, o2) -> o1.getEnclosingScope().getName().compareTo(o2.getEnclosingScope().getName()));
        return result;
    }

    protected RfTreeElementWrapper checkForLoops(RfTreeElementWrapper currentWrapper, RfFunction childFunction) {
        while (currentWrapper != null) {
            RfNamedElement rfElement = (RfNamedElement)currentWrapper.getRfElement();
            if (rfElement == childFunction) {
                return currentWrapper;
            }
            currentWrapper = currentWrapper.getParent();
        }
        return null;
    }

    protected List<RfTreeElementWrapper> createHidWrapper(RfProject rfProject, Hid hid, RfTreeElementWrapper currentWrapper, String path, int depth, IDVTJob job, CallHierarchyComputeStrategy hierarchyType) {
        IRfNamedElement element = hid.getElement();
        HidAccess parentAccess = hid.getParentAccess();
        if (hid.isPotentialMethodCall() && hid.getElement() == null && parentAccess != null && parentAccess.getAssociatedType() instanceof RfSpecializedClass) {
            element = parentAccess.getAssociatedType().semanticGetMember(hid.getName(), null, null, null, null, false, true, false);
        }
        if (element instanceof RfFunction) {
            RfTreeElementWrapper recurrenceWrapper;
            RfNamedElement tmp;
            RfFunction childFunction = (RfFunction)element;
            if (childFunction.getEnclosingScope() instanceof IRfSpecializedTypeElement && (tmp = childFunction.getElementInGenericScope()) != null) {
                childFunction = (RfFunction)tmp;
            }
            if ((recurrenceWrapper = this.checkForLoops(currentWrapper, childFunction)) != null) {
                List<RfTreeElementWrapper> result = this.createOccurrencesWrappers(hid, path, childFunction, CallHierarchyTreeElementWrapper.WrapperKind.RECURRENCE, hierarchyType);
                for (RfTreeElementWrapper wrapper : result) {
                    ((CallHierarchyTreeElementWrapper)wrapper).setRecurenceWrapper(recurrenceWrapper);
                }
                return result;
            }
            ArrayList<RfTreeElementWrapper> result = new ArrayList<RfTreeElementWrapper>();
            List<Object> virtualFunctionChildren = new ArrayList<RfFunction>();
            Hid parentHid = hid.getParentHid();
            boolean isStaticAccess = false;
            if (parentAccess != null && parentAccess.toString().endsWith(STATIC_ACCESS_SYMBOL) && childFunction.isObjectStatic()) {
                isStaticAccess = true;
            }
            if (parentHid != null && parentHid.getElement() != null && "super".equals(parentHid.getElement().getName())) {
                virtualFunctionChildren.add(childFunction);
            } else if (this.fShowOverrides && childFunction.getEnclosingScope() instanceof RfClass && childFunction.isVirtual()) {
                virtualFunctionChildren = this.getVirtualFunctionChildren(childFunction);
            } else {
                virtualFunctionChildren.add(childFunction);
            }
            HidOccurrence occurrence = hid.getOccurrence();
            if (virtualFunctionChildren.size() == 1) {
                RfFunction rfFunction = (RfFunction)virtualFunctionChildren.get(0);
                List<RfTreeElementWrapper> children = null;
                if (occurrence != null) {
                    CallHierarchyTreeElementWrapper wrapper = this.makeCalleeWrapper(rfFunction, path, hid, occurrence, CallHierarchyTreeElementWrapper.WrapperKind.NORMAL);
                    wrapper.setParent(currentWrapper);
                    if (!(wrapper.getRfElement() instanceof RfFunction) || !((RfFunction)wrapper.getRfElement()).isLet()) {
                        wrapper.setStaticAccess(isStaticAccess);
                    }
                    children = this.getChildrenFunctionCallHids(wrapper, null, rfProject, depth - 1, job, hierarchyType);
                    wrapper.addChildren(children);
                    result.add(wrapper);
                }
            } else {
                for (RfFunction rfFunction : virtualFunctionChildren) {
                    CallHierarchyTreeElementWrapper wrapper;
                    RfNamedElement tmp2;
                    List<RfTreeElementWrapper> children = null;
                    if (childFunction.getEnclosingScope() instanceof IRfSpecializedTypeElement && (tmp2 = childFunction.getElementInGenericScope()) != null) {
                        childFunction = (RfFunction)tmp2;
                    }
                    if (occurrence == null) continue;
                    recurrenceWrapper = this.checkForLoops(currentWrapper, rfFunction);
                    if (recurrenceWrapper != null) {
                        wrapper = this.makeCalleeWrapper(rfFunction, path, hid, occurrence, CallHierarchyTreeElementWrapper.WrapperKind.RECURRENCE);
                        wrapper.setRecurenceWrapper(recurrenceWrapper);
                    } else {
                        wrapper = this.makeCalleeWrapper(rfFunction, path, hid, occurrence, CallHierarchyTreeElementWrapper.WrapperKind.OVERRIDE);
                        wrapper.setParent(currentWrapper);
                        children = this.getChildrenFunctionCallHids(wrapper, null, rfProject, depth - 1, job, hierarchyType);
                        wrapper.addChildren(children);
                    }
                    if (rfFunction != childFunction) {
                        wrapper.setOverrides(true);
                        wrapper.setOverrideParentName(childFunction.getEnclosingScope().getName());
                    }
                    result.add(wrapper);
                }
            }
            return result;
        }
        if (hid.isPotentialMethodCall()) {
            List<RfTreeElementWrapper> wrappers = this.createOccurrencesWrappers(hid, path, new RfDummyElement(EMPTY_STRING), CallHierarchyTreeElementWrapper.WrapperKind.POTENTIAL, hierarchyType);
            for (RfTreeElementWrapper wrapper : wrappers) {
                wrapper.setProject(rfProject.getProject());
            }
            return wrappers;
        }
        return null;
    }

    protected List<RfTreeElementWrapper> createOccurrencesWrappers(Hid hid, String path, IRfNamedElement childFunction, CallHierarchyTreeElementWrapper.WrapperKind wrapperKind, CallHierarchyComputeStrategy hierarchyType) {
        ArrayList<RfTreeElementWrapper> allPotentialOccurences = new ArrayList<RfTreeElementWrapper>();
        HidOccurrence hidOccurrence = hid.getOccurrence();
        if (hidOccurrence != null) {
            allPotentialOccurences.add(this.makeCalleeWrapper(childFunction, path, hid, hidOccurrence, wrapperKind));
        }
        return allPotentialOccurences;
    }

    protected void filterConditionals(IDVTElementWrapper wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        RfNamedElement namedElement = (RfNamedElement)wrapper.getRfElement();
        boolean isActionBlock = namedElement instanceof RfActionBlock;
        if (wrapper.hasChildren()) {
            ArrayList children = new ArrayList(wrapper.getChildren());
            for (RfTreeElementWrapper child : children) {
                this.filterConditionals(child);
            }
        }
        if (!isActionBlock) {
            return;
        }
        RfActionBlock actionBlock = (RfActionBlock)namedElement;
        if ((actionBlock.isConditional() || actionBlock.isCase() || actionBlock.isCaseItem()) && this.fShowConditionals) {
            return;
        }
        if (actionBlock.hasForkJoin() && this.fShowForks) {
            return;
        }
        if ((actionBlock.isStatementLabel() || !actionBlock.isAnonymous()) && this.fShowNamedBeginEnds) {
            return;
        }
        RfTreeElementWrapper parent = (RfTreeElementWrapper)wrapper.getParent();
        if (wrapper.hasChildren()) {
            parent.addChildren(wrapper.getChildren());
        }
        parent.removeChild(wrapper);
    }

    protected IDVTElementWrapper toWrappers(RfProject rfProject, String elementName, List<RfNameTypeScopeHelper> elementScope, IDVTJob job, int elementType) {
        IRfNamedElement root;
        Object object = root = elementType == 2 ? this.getField(rfProject, elementName, elementScope) : this.getFunction(rfProject, elementName, elementScope);
        if (root == null) {
            return null;
        }
        CallHierarchyTreeElementWrapper rootWrapper = this.makeWrapper(root, CallHierarchyTreeElementWrapper.WrapperKind.NORMAL, this.fCallHierarchyComputeStrategy);
        ArrayList<CallHierarchyTreeElementWrapper> children = new ArrayList<CallHierarchyTreeElementWrapper>();
        if (this.fCallHierarchyComputeStrategy == CallHierarchyComputeStrategy.CALLER || this.fCallHierarchyComputeStrategy == CallHierarchyComputeStrategy.CALLEE && elementType != 2 && this.elementHasChildren((RfFunction)root, rfProject)) {
            children.add(this.makeWrapper(new RfDummyElement("Updating..."), CallHierarchyTreeElementWrapper.WrapperKind.UPDATING, this.fCallHierarchyComputeStrategy));
        }
        if (children.isEmpty()) {
            return rootWrapper;
        }
        rootWrapper.addChildren(children);
        if (this.fStateWrapper == null) {
            this.expandFromWrapper(rootWrapper, rfProject, job);
        } else {
            this.expandLastState(rootWrapper, this.fStateWrapper, rfProject, job);
        }
        if (TestHelper.isTestMode()) {
            this.expandXLevels(rootWrapper, 10, job);
        }
        return rootWrapper;
    }

    protected void sort(IDVTElementWrapper wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        RfTreeElementWrapper rootWrapper = (RfTreeElementWrapper)wrapper;
        List<RfTreeElementWrapper> children = rootWrapper.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        Collections.sort(rootWrapper.getChildren(), (wrapper1, wrapper2) -> {
            int offset2;
            int offset1;
            RfActionBlock ab2;
            int line2;
            if (wrapper1 == null || wrapper2 == null || !(wrapper1 instanceof CallHierarchyTreeElementWrapper) || !(wrapper2 instanceof CallHierarchyTreeElementWrapper) || wrapper1.getRfElement() == null) {
                return -1;
            }
            CallHierarchyTreeElementWrapper cWrapper1 = (CallHierarchyTreeElementWrapper)((Object)wrapper1);
            CallHierarchyTreeElementWrapper cWrapper2 = (CallHierarchyTreeElementWrapper)((Object)wrapper2);
            int line1 = this.getLine((IDVTElementWrapper)wrapper1);
            if (line1 != (line2 = this.getLine((IDVTElementWrapper)wrapper2))) {
                return line1 - line2;
            }
            if (cWrapper1.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.ACTION_BLOCK && cWrapper2.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.NORMAL) {
                RfActionBlock ab1 = (RfActionBlock)cWrapper1.getRfElement();
                if (ab1.isCase() || ab1.isConditional()) {
                    cWrapper2.setIsConditionalMethod(ab1.getExpression().contains(((RfNamedElement)cWrapper2.getRfElement()).getName()));
                }
            } else if (cWrapper2.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.ACTION_BLOCK && cWrapper1.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.NORMAL && ((ab2 = (RfActionBlock)cWrapper2.getRfElement()).isCase() || ab2.isConditional())) {
                cWrapper1.setIsConditionalMethod(ab2.getExpression().contains(((RfNamedElement)cWrapper1.getRfElement()).getName()));
            }
            if ((offset1 = this.getOffset((IDVTElementWrapper)wrapper1)) != (offset2 = this.getOffset((IDVTElementWrapper)wrapper2))) {
                return offset1 - offset2;
            }
            return this.getVirtualOffset((IDVTElementWrapper)wrapper1) - this.getVirtualOffset((IDVTElementWrapper)wrapper2);
        });
        for (RfTreeElementWrapper child : rootWrapper.getChildren()) {
            this.sort(child);
        }
    }

    protected int getVirtualOffset(IDVTElementWrapper wrapper) {
        CallHierarchyTreeElementWrapper callWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        RfNamedElement namedElement = (RfNamedElement)callWrapper.getRfElement();
        if (callWrapper.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.MACRO) {
            return 0;
        }
        if (callWrapper.hasHidOccurrence()) {
            return callWrapper.getHidOccurrence().getVirtualOffset();
        }
        if (namedElement instanceof RfActionBlock && (RfActionBlockDef)namedElement.getDeclaration() != null) {
            return ((RfActionBlockDef)namedElement.getDeclaration()).getStartVirtualOffset();
        }
        return -1;
    }

    protected int getOffset(IDVTElementWrapper wrapper) {
        CallHierarchyTreeElementWrapper callWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        RfNamedElement namedElement = (RfNamedElement)callWrapper.getRfElement();
        if (callWrapper.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.MACRO) {
            return callWrapper.getMacroOffset();
        }
        if (callWrapper.hasHidOccurrence()) {
            return callWrapper.getHidOccurrence().getOffset();
        }
        return namedElement.getStartOffset();
    }

    public int getLine(IDVTElementWrapper wrapper) {
        CallHierarchyTreeElementWrapper callWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        RfNamedElement namedElement = (RfNamedElement)callWrapper.getRfElement();
        List<Integer> wrapperMatchLines = callWrapper.getMatchLines();
        if (wrapperMatchLines != null && !wrapperMatchLines.isEmpty()) {
            return wrapperMatchLines.get(0);
        }
        if (callWrapper.getWrapperKind() == CallHierarchyTreeElementWrapper.WrapperKind.MACRO) {
            return callWrapper.getMacroLine();
        }
        if (callWrapper.hasHidOccurrence()) {
            return callWrapper.getHidOccurrence().getLine();
        }
        if (callWrapper.getRfElement() instanceof RfFunction) {
            RfFunction func = (RfFunction)callWrapper.getRfElement();
            RfDefElement funcImplementation = func.getImplementation();
            RfDefElement funcDeclaration = func.getDeclaration();
            if (funcImplementation == null && funcDeclaration == null) {
                return namedElement.getLine();
            }
            return funcImplementation != null ? funcImplementation.getStartLine() : funcDeclaration.getStartLine();
        }
        if (callWrapper.getRfElement() instanceof RfDummyElement) {
            RfDummyElement rfDummyElement = (RfDummyElement)callWrapper.getRfElement();
            return rfDummyElement.getImplementation() != null ? rfDummyElement.getImplementation().getStartLine() : 0;
        }
        return namedElement.getLine();
    }

    protected boolean filterActionBlockLeafs(IDVTElementWrapper wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return false;
        }
        RfTreeElementWrapper rootWrapper = (RfTreeElementWrapper)wrapper;
        if (!rootWrapper.hasChildren()) {
            return this.isAnonymousActionBlock(rootWrapper);
        }
        boolean result = true;
        Iterator<RfTreeElementWrapper> iterator = rootWrapper.getChildren().iterator();
        while (iterator.hasNext()) {
            RfTreeElementWrapper childWrapper = iterator.next();
            boolean childIsActionBlock = this.filterActionBlockLeafs(childWrapper);
            if (childIsActionBlock) {
                iterator.remove();
            }
            boolean bl = result = result && childIsActionBlock;
        }
        return this.isAnonymousActionBlock(rootWrapper) && result;
    }

    protected boolean isAnonymousActionBlock(RfTreeElementWrapper wrapper) {
        return wrapper.getRfElement() instanceof RfActionBlock && ((RfActionBlock)wrapper.getRfElement()).isAnonymous();
    }

    public CallHierarchyTreeElementWrapper makeWrapper(IRfNamedElement element, CallHierarchyTreeElementWrapper.WrapperKind wrapperKind, CallHierarchyComputeStrategy strategy) {
        CallHierarchyTreeElementWrapper result = new CallHierarchyTreeElementWrapper(element, wrapperKind, strategy);
        if (this.fIsPrependPackage) {
            result.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
        }
        return result;
    }

    protected CallHierarchyTreeElementWrapper makeCalleeWrapper(IRfNamedElement element, String path, Hid hid, HidOccurrence hidOccurrence, CallHierarchyTreeElementWrapper.WrapperKind wrapperKind) {
        CallHierarchyTreeElementWrapper result = new CallHierarchyTreeElementWrapper((Object)element, path, hid, hidOccurrence, wrapperKind);
        if (this.fIsPrependPackage) {
            result.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
        }
        return result;
    }

    protected CallHierarchyTreeElementWrapper makeCallerWrapper(IRfNamedElement element, String path, String name, Map<Integer, List<VlogCallerHierarchyFunctionCallInfo>> linesAndInfos, CallHierarchyTreeElementWrapper.WrapperKind wrapperKind) {
        CallHierarchyTreeElementWrapper result = new CallHierarchyTreeElementWrapper((Object)element, path, name, linesAndInfos, wrapperKind);
        if (this.fIsPrependPackage) {
            result.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
        }
        return result;
    }

    protected void applyVirtualFunctionFilters(IDVTElementWrapper wrapper) {
        if (this.fShowOverrides) {
            return;
        }
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        RfTreeElementWrapper rootWrapper = (RfTreeElementWrapper)wrapper;
        this.applyVirtualFunctionsFiltersSpecificWrappers(rootWrapper);
    }

    protected void applyVirtualFunctionsFiltersSpecificWrappers(RfTreeElementWrapper wrapper) {
        if (((CallHierarchyTreeElementWrapper)wrapper).hasOverrides() && wrapper.getParent() != null) {
            wrapper.getParent().removeChild(wrapper);
            return;
        }
        if (wrapper.getChildren() == null || wrapper.getChildren().isEmpty()) {
            return;
        }
        ArrayList<RfTreeElementWrapper> children = new ArrayList<RfTreeElementWrapper>(wrapper.getChildren());
        for (RfTreeElementWrapper child : children) {
            this.applyVirtualFunctionsFiltersSpecificWrappers(child);
        }
    }

    public IDVTElementWrapper copyWrapperWithUpdatingNode(IDVTElementWrapper wrapper) {
        CallHierarchyTreeElementWrapper callWrapper = (CallHierarchyTreeElementWrapper)wrapper;
        CallHierarchyTreeElementWrapper copy = new CallHierarchyTreeElementWrapper(callWrapper);
        copy.addChild(this.makeWrapper(new RfDummyElement("Updating..."), CallHierarchyTreeElementWrapper.WrapperKind.UPDATING, this.fCallHierarchyComputeStrategy));
        copy.setExpanded(0);
        return copy;
    }

    public IDVTElementWrapper getRecurrenceWrapper(IDVTElementWrapper wrapper) {
        return ((CallHierarchyTreeElementWrapper)wrapper).getRecurenceWrapper();
    }

    public void triggerRefresh(IDVTElementWrapper wrapper, boolean applyFilters) {
        if (applyFilters) {
            this.filterNonTerminalLeafsAndApplyContentFilters(wrapper);
            if (wrapper instanceof CallHierarchyTreeElementWrapper) {
                CallHierarchyTreeElementWrapper treeWrapper = (CallHierarchyTreeElementWrapper)wrapper;
                if (treeWrapper.getHierarchyStrategy() == CallHierarchyComputeStrategy.CALLER) {
                    this.applyCallerFilters(treeWrapper);
                } else {
                    this.applyCalleeFilters(treeWrapper);
                }
            }
        }
        this.fStateWrapper = this.createStateTree(wrapper);
    }

    public abstract CallHierarchyStateWrapper createStateTree(IDVTElementWrapper var1);
}

