/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.checks.ChecksViewInput;
import ro.amiq.dvt.ui.views.checks.ChecksViewInputConfigurator;
import ro.amiq.dvt.ui.views.checks.IChecksViewContributor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.ChecksViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VlogChecksViewContributor
implements IChecksViewContributor {
    private ChecksViewLabelProvider fLabelProvider = new ChecksViewLabelProvider();
    private int fNrTotalChecks = 0;
    private int fNrNotFilteredChecks = 0;
    private int fNrOfImmediateAssertions = 0;
    private int fNrOfConcurrentAssertions = 0;
    private int fNrOfImmediateAssumptions = 0;
    private int fNrOfConcurrentAssumptions = 0;
    private int fNrOfExpects = 0;
    private boolean fHasGUIFilteredElements;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfAssertExpect) {
            actionHyperlink = RfUtils.createOpenAction((RfAssertExpect)element, project, null);
        } else if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)element, project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public ChecksViewInput getInput(ChecksViewInputConfigurator inputConfig) {
        this.fNrTotalChecks = 0;
        this.fNrNotFilteredChecks = 0;
        this.fNrOfImmediateAssertions = 0;
        this.fNrOfConcurrentAssertions = 0;
        this.fNrOfImmediateAssumptions = 0;
        this.fNrOfConcurrentAssumptions = 0;
        this.fNrOfExpects = 0;
        this.fHasGUIFilteredElements = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!(inputConfig.getSource() instanceof IProject)) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            IProject project = (IProject)inputConfig.getSource();
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
            }
            boolean hideDuplicates = BuildConfigManager.isHideDuplicateTypesView((IProject)rfProject.getProject());
            List<IDVTElementWrapper> wrappers = this.toWrappers(rfProject, inputConfig.getSearchSegments(), inputConfig.getSearchStrictness(), true, true, true, true, hideDuplicates, inputConfig.getUpdateJob());
            if (wrappers != null && !wrappers.isEmpty()) {
                this.internalSort(wrappers, inputConfig.isSortByType());
                if (inputConfig.isShowLanguageNameAsRootElement()) {
                    StringBuilder infoText = new StringBuilder("[");
                    if (this.fNrTotalChecks == this.fNrNotFilteredChecks) {
                        infoText.append(this.fNrTotalChecks);
                    } else {
                        infoText.append(this.fNrNotFilteredChecks).append("/").append(this.fNrTotalChecks);
                    }
                    infoText.append(ViewsUtils.getUnitName((String)"check", (int)this.fNrTotalChecks, (String)" ", (String)"")).append("]");
                    RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VlogLanguageElement<String>(String.valueOf(LanguageKind.VLOG.VIEW_NAME) + " " + infoText.toString()));
                    elements.add(languageWrapper);
                    languageWrapper.addChildren(wrappers);
                } else {
                    elements.addAll(wrappers);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        ChecksViewInput checksViewInput = new ChecksViewInput(this.fNrTotalChecks, this.fNrNotFilteredChecks, elements, this.fHasGUIFilteredElements);
        checksViewInput.setNrOfVlogConcurrentAssertions(this.fNrOfConcurrentAssertions);
        checksViewInput.setNrOfVlogImmediateAssertions(this.fNrOfImmediateAssertions);
        checksViewInput.setNrOfVlogConcurrentAssumptions(this.fNrOfConcurrentAssumptions);
        checksViewInput.setNrOfVlogImmediateAssumptions(this.fNrOfImmediateAssumptions);
        checksViewInput.setNrOfVlogExpects(this.fNrOfExpects);
        return checksViewInput;
    }

    private List<IDVTElementWrapper> toWrappers(RfProject rfProject, StringMatcher[] searchSegments, boolean[] searchStrictness, boolean collectExpect, boolean collectAssumptions, boolean collectChecks, boolean collectAssertions, boolean hideDuplicates, UpdateJob updateJob) {
        IDVTElementWrapper root = this.toWrappersRecursive(rfProject, rfProject, searchSegments, searchStrictness, collectExpect, collectAssumptions, collectChecks, collectAssertions, hideDuplicates, updateJob, new HashSet<RfNamedElement>(), new HashSet<RfNamedElement>());
        if (root == null || !root.hasChildren()) {
            return null;
        }
        RfTreeElementWrapper noLibsRoot = new RfTreeElementWrapper("");
        for (IDVTElementWrapper wrapper : root.getChildren()) {
            if (wrapper.getRfElement() instanceof RfLibrary) {
                noLibsRoot.addChildren(wrapper.getChildren());
                continue;
            }
            noLibsRoot.addChild(wrapper);
        }
        ViewsUtils.hierarchicalSearch((IDVTElementWrapper)noLibsRoot, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
        this.fNrNotFilteredChecks = this.countAssertions(noLibsRoot);
        return noLibsRoot.getChildren();
    }

    private IDVTElementWrapper toWrappersRecursive(RfProject rfProject, RfNamedElement root, StringMatcher[] searchSegments, boolean[] searchStrictness, boolean collectExpect, boolean collectAssumptions, boolean collectChecks, boolean collectAssertions, boolean hideDuplicates, UpdateJob updateJob, HashSet<RfNamedElement> filteredParents, HashSet<RfNamedElement> elementParents) {
        List<RfNamedElement> children = this.getChildTypesAndAssertionContainersAndAssertions(rfProject, root, hideDuplicates);
        if (children.isEmpty()) {
            if (!(root instanceof RfAssertExpect)) {
                return null;
            }
            for (RfNamedElement myParent : elementParents) {
                if (!filteredParents.contains(myParent)) continue;
                this.fHasGUIFilteredElements = true;
                return null;
            }
            RfAssertExpect assertExpect = (RfAssertExpect)root;
            RfTreeElementWrapper myWrapper = new RfTreeElementWrapper(root);
            if (assertExpect.isAnonymous()) {
                myWrapper.setTreeName(assertExpect.getExpressionText());
            } else {
                myWrapper.setTreeName(String.valueOf(assertExpect.getName()) + " : " + assertExpect.getExpressionText());
            }
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CHECKS, (IRfNamedElement)assertExpect, () -> this.fLabelProvider.getText((Object)myWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                this.fHasGUIFilteredElements = true;
                return null;
            }
            if (assertExpect.isAssume() && assertExpect.isConcurrentAssertionStatement()) {
                ++this.fNrOfConcurrentAssumptions;
            } else if (assertExpect.isAssume()) {
                ++this.fNrOfImmediateAssumptions;
            } else if (assertExpect.isAssert() && assertExpect.isConcurrentAssertionStatement()) {
                ++this.fNrOfConcurrentAssertions;
            } else if (assertExpect.isAssert()) {
                ++this.fNrOfImmediateAssertions;
            } else if (assertExpect.isExpect()) {
                ++this.fNrOfExpects;
            }
            if (!assertExpect.isCover()) {
                ++this.fNrTotalChecks;
            }
            if (this.shouldFilter(assertExpect)) {
                return null;
            }
            ++this.fNrNotFilteredChecks;
            return myWrapper;
        }
        if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.CHECKS, (IRfNamedElement)root, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(root))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            filteredParents.add(root);
        }
        ArrayList<IDVTElementWrapper> myChildren = new ArrayList<IDVTElementWrapper>();
        if (!children.isEmpty()) {
            elementParents.add(root);
        }
        for (RfNamedElement child : children) {
            IDVTElementWrapper childWrapper;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(child);
            if (child instanceof RfAssertExpect) {
                if (child.isAnonymous()) {
                    wrapper.setTreeName(((RfAssertExpect)child).getExpressionText());
                } else {
                    wrapper.setTreeName(String.valueOf(child.getName()) + " : " + ((RfAssertExpect)child).getExpressionText());
                }
            }
            if ((childWrapper = this.toWrappersRecursive(rfProject, child, searchSegments, searchStrictness, collectExpect, collectAssumptions, collectChecks, collectAssertions, hideDuplicates, updateJob, filteredParents, elementParents)) == null) continue;
            myChildren.add(childWrapper);
        }
        if (!children.isEmpty()) {
            elementParents.remove(root);
        }
        if (myChildren.isEmpty()) {
            return null;
        }
        RfTreeElementWrapper myWrapper = new RfTreeElementWrapper(root);
        myWrapper.addChildren(myChildren);
        return myWrapper;
    }

    private List<RfNamedElement> getChildTypesAndAssertionContainersAndAssertions(RfProject rfProject, RfNamedElement root, boolean hideDuplicates) {
        List<RfAssertExpect> allAsserts;
        List<RfNamedElement> assertContainers;
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (rfProject == null || rfProject.getProject() == null) {
            return result;
        }
        List<RfNamedElement> localTypes = rfProject.getLocalTypes(root, false, false, hideDuplicates);
        if (localTypes != null && !localTypes.isEmpty()) {
            result.addAll(localTypes);
        }
        if ((assertContainers = this.getAllAssertContainers(root)) != null && !assertContainers.isEmpty()) {
            result.addAll(assertContainers);
        }
        if ((allAsserts = root.getAssertsExpectsWithPrefix("", 2, 1)) != null && !allAsserts.isEmpty()) {
            result.addAll(allAsserts);
        }
        return result;
    }

    private List<RfNamedElement> getAllAssertContainers(RfNamedElement parent) {
        List<RfConstraint> constraints;
        List<RfCovergroup> covergroups;
        List<RfPropertySequence> properties;
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (parent == null) {
            return result;
        }
        List<RfFunction> allFunctions = parent.getLocalMembers(RfFunction.class);
        if (allFunctions != null) {
            result.addAll(allFunctions);
        }
        if ((properties = parent.getLocalMembers(RfPropertySequence.class)) != null) {
            result.addAll(properties);
        }
        if ((covergroups = parent.getLocalMembers(RfCovergroup.class)) != null) {
            result.addAll(covergroups);
        }
        if ((constraints = parent.getLocalMembers(RfConstraint.class)) != null) {
            result.addAll(constraints);
        }
        return result;
    }

    private boolean shouldFilter(RfAssertExpect assertExpect) {
        if (assertExpect.isCover()) {
            return true;
        }
        if (assertExpect.isExpect() && PrefConst.getChecksViewVlogdtHideExpects()) {
            return true;
        }
        if (assertExpect.isAssume() && (assertExpect.isConcurrentAssertionStatement() ? PrefConst.getChecksViewVlogdtHideConcurrentAssumptions() : PrefConst.getChecksViewVlogdtHideImmediateAssumptions())) {
            return true;
        }
        return assertExpect.isAssert() && (assertExpect.isConcurrentAssertionStatement() ? PrefConst.getChecksViewVlogdtHideConcurrentAssertions() : PrefConst.getChecksViewVlogdtHideImmediateAssertions());
    }

    private int countAssertions(IDVTElementWrapper root) {
        if (root == null) {
            return 0;
        }
        if (root.getRfElement() instanceof RfAssertExpect) {
            return 1;
        }
        int result = 0;
        if (!root.hasChildren()) {
            return result;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            result += this.countAssertions(child);
        }
        return result;
    }

    private void internalSort(List<IDVTElementWrapper> wrappers, boolean sortByType) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        if (sortByType) {
            Collections.sort(wrappers, VlogQuickViewersUtil.getSortByTypeComparator(this.fLabelProvider));
        } else {
            Collections.sort(wrappers, VlogQuickViewersUtil.getSortByNameComparator(this.fLabelProvider));
        }
        for (IDVTElementWrapper wrapper : wrappers) {
            this.internalSort(wrapper.getChildren(), sortByType);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfAssertExpect) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element)) || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getColumnText(element, 1));
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }
}

