/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogCompileOrderViewContributorCommon;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogCompileOrderViewContributor
extends VlogCompileOrderViewContributorCommon {
    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (object == null || !(object instanceof VlogFileInstance)) {
                return;
            }
            VlogFileInstance instance = (VlogFileInstance)object;
            String name = instance.getShortFileName();
            if (name.startsWith("__vlog__") && name.endsWith(".libfile")) {
                return;
            }
            IFile file = RfUtils.getFile(instance, project);
            if (file != null) {
                VlogFileUtils.getInstance().openEditor(file, 0, null);
            } else {
                VlogFileUtils.getInstance().openFile(project, instance.getParserPath().path, 0, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void gotoFile(IProject project, int line, VlogFileInstance inc) {
        IFile file = RfUtils.getFile(inc, project);
        try {
            file.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, (Object)inc);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        VlogFileUtils.getInstance().openEditor(file, line, null);
    }

    @Override
    protected void gotoTopFile(BuildFilePathLine includedTopFile, IFile buildFile) {
        VlogFileUtils.getInstance().openEditor(buildFile, includedTopFile.getBuildFileLine(), null);
    }

    @Override
    protected IFile getBuildFile(IProject project, BuildFilePathLine includedTopFile) {
        return DVTFileUtils.getInstance().getProjectFile(project, includedTopFile.getPath());
    }

    @Override
    protected void buildNoFilesWithErrorsContent(IProject project, RfTreeElementWrapper newRoot) {
        newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement(project.getName())));
        newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement("does not contain")));
        newRoot.addChild(new RfTreeElementWrapper(new RfDummyElement("any SystemVerilog files with errors!")));
    }

    public TreePath getTreePath(IDVTFileInstance fileInstance, boolean addLanguageRoot) {
        if (!(fileInstance instanceof VlogFileInstance)) {
            return null;
        }
        VlogFileInstance vlogFileInstance = (VlogFileInstance)fileInstance;
        ArrayList<String> segments = new ArrayList<String>();
        ArrayList<VlogFileInstance> fileInstances = new ArrayList<VlogFileInstance>();
        while (vlogFileInstance != null) {
            if (vlogFileInstance.isBuildConfigFileInstance() && vlogFileInstance.getIncludingScope().getIncludingInstance() == null) break;
            segments.add(String.valueOf(vlogFileInstance.getShortFileName()) + (vlogFileInstance.getIndex() > 0 ? " [" + vlogFileInstance.getIndex() + "]" : ""));
            fileInstances.add(vlogFileInstance);
            VlogIncludingScope includingScope = vlogFileInstance.getIncludingScope();
            if (includingScope == null) break;
            vlogFileInstance = includingScope.getIncludingInstance();
        }
        TreePath parent = TreePath.TOP_DUMMY_TREE_PATH;
        if (addLanguageRoot) {
            RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VlogLanguageElement<String>(""));
            languageWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.IS_DUMMY, true);
            parent = TreePath.child((TreePath)parent, (String)LanguageKind.VLOG.VIEW_NAME, (int)0);
            parent.setElement((Object)languageWrapper);
        }
        Collections.reverse(segments);
        Collections.reverse(fileInstances);
        int i = 0;
        while (i < segments.size()) {
            RfTreeElementWrapper elementWrapper = new RfTreeElementWrapper(fileInstances.get(i));
            elementWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.IS_DUMMY, true);
            parent = TreePath.child((TreePath)parent, (String)((String)segments.get(i)), (int)0);
            parent.setElement((Object)elementWrapper);
            ++i;
        }
        return parent;
    }
}

