/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.guifilters.DVTCompileOrderGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.compileorder.BaseCompileOrderViewContributor;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.CompileOrderLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.utils.SourceFileToBuildFileMapping;

public abstract class VlogCompileOrderViewContributorCommon
extends BaseCompileOrderViewContributor {
    private CompileOrderLabelProvider fLabelProvider = new CompileOrderLabelProvider();

    private CompileOrderInfo getCompileOrderData(RfTreeElementWrapper root, List<VlogFileInstance> fileInstances, CompileOrderViewInputConfigurator configurator, CompileOrderViewInput input) {
        HashSet<ParserPath> uniqueFiles = new HashSet<ParserPath>();
        CompileOrderInfo result = new CompileOrderInfo();
        this.toWrappers(root, fileInstances, uniqueFiles, new HashSet<String>(), null, configurator, result, input);
        result.nofUniques = uniqueFiles.size();
        return result;
    }

    private void toWrappers(RfTreeElementWrapper root, List<VlogFileInstance> fileInstances, Set<ParserPath> uniqueFiles, HashSet<String> libFilesSet, RfTreeElementWrapper libInstance, CompileOrderViewInputConfigurator configurator, CompileOrderInfo result, CompileOrderViewInput input) {
        try {
            if (root == null || fileInstances == null || fileInstances.isEmpty()) {
                return;
            }
            if (input == null || configurator == null || configurator.isCanceled()) {
                return;
            }
            result.nofTotal += fileInstances.size();
            boolean ignoreContentFilters = configurator.ignoreContentFilters();
            IRfFilterableTreeAccessor view = configurator.getView();
            for (VlogFileInstance instance : fileInstances) {
                if (instance == null) continue;
                if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                    return;
                }
                RfTreeElementWrapper child = new RfTreeElementWrapper(instance);
                child.setProject(configurator.getProject());
                String text = this.getLabelProvider((Object)child).getText((Object)child);
                DVTGUIFilterMatcher.ITextProvider textProvider = () -> text;
                String name = instance.getShortFileName();
                if (instance.isOptimizeSkip()) {
                    ++result.nofSkipped;
                }
                if (name.startsWith("__vlog__") && name.endsWith(".libfile")) {
                    if (libInstance == null) {
                        libInstance = child;
                        if (!configurator.isCollectingSymbols()) {
                            root.addChild(child);
                        }
                    } else {
                        child = libInstance;
                    }
                    --result.nofTotal;
                } else {
                    uniqueFiles.add(instance.getParserPath());
                    if (root == libInstance) {
                        if (!libFilesSet.contains(text)) {
                            if (!ignoreContentFilters && DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)configurator.getProject(), (IDVTFileInstance)instance, (DVTGUIFilterMatcher.ITextProvider)textProvider) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                                input.setHasGUIFilteredElements(true);
                                --result.nofTotal;
                                if (input.hasSearchedElementFiltered()) continue;
                                if (ViewsUtils.matchesPath((Object)((Object)child), (IRfFilterableTreeAccessor)view)) {
                                    input.setHasSearchedElementFiltered(true);
                                    continue;
                                }
                                if (instance.getIncludedInstances().isEmpty()) continue;
                                input.setHasSearchedElementFiltered(this.hasFilteredSearchedLocalMember(instance, view));
                                continue;
                            }
                            if (this.shouldAddFile((ISymbolCollectorPrerequisite)child, configurator)) {
                                libFilesSet.add(text);
                                root.addChild(child);
                            }
                        } else {
                            --result.nofTotal;
                        }
                    } else {
                        if (!ignoreContentFilters && DVTCompileOrderGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COMPILE_ORDER, (IProject)configurator.getProject(), (IDVTFileInstance)instance, (DVTGUIFilterMatcher.ITextProvider)textProvider) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                            input.setHasGUIFilteredElements(true);
                            --result.nofTotal;
                            if (input.hasSearchedElementFiltered()) continue;
                            if (ViewsUtils.matchesPath((Object)((Object)child), (IRfFilterableTreeAccessor)view)) {
                                input.setHasSearchedElementFiltered(true);
                                continue;
                            }
                            if (instance.getIncludedInstances().isEmpty()) continue;
                            input.setHasSearchedElementFiltered(this.hasFilteredSearchedLocalMember(instance, view));
                            continue;
                        }
                        if (this.shouldAddFile((ISymbolCollectorPrerequisite)child, configurator)) {
                            root.addChild(child);
                        }
                    }
                }
                if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                    return;
                }
                RfTreeElementWrapper nextRoot = configurator.isCollectingSymbols() ? root : child;
                this.toWrappers(nextRoot, instance.getIncludedInstances(), uniqueFiles, libFilesSet, libInstance, configurator, result, input);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean hasFilteredSearchedLocalMember(VlogFileInstance parentInstance, IRfFilterableTreeAccessor view) {
        List<VlogFileInstance> childInstances = parentInstance.getIncludedInstances();
        if (childInstances.isEmpty()) {
            return false;
        }
        for (VlogFileInstance instance : childInstances) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(instance)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(instance, view)) continue;
            return true;
        }
        return false;
    }

    public CompileOrderViewInput getInput(CompileOrderViewInputConfigurator sourceConfigurator) {
        try {
            CompileOrderViewInput input = CompileOrderViewInput.emptyInput();
            IProject project = sourceConfigurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return input;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return input;
            }
            VlogFileInstance topInstance = rfProject.getPreprocessingTable().getTopFileInstance();
            RfTreeElementWrapper root = new RfTreeElementWrapper();
            if (topInstance != null) {
                CompileOrderInfo compileInfo = this.getCompileOrderData(root, topInstance.getIncludedInstances(), sourceConfigurator, input);
                if (compileInfo.nofTotal == 0) {
                    return input;
                }
                input.setElementCount(compileInfo.nofTotal);
                ViewsUtils.hierarchicalSearch((IDVTElementWrapper)root, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)sourceConfigurator.getUpdateJob(), (StringMatcher[])sourceConfigurator.getSearchSegments(), (boolean[])sourceConfigurator.getSearchStrictness());
                if (sourceConfigurator.hasShowFilesWithErrors()) {
                    RfTreeElementWrapper newRoot = new RfTreeElementWrapper();
                    this.filterOutElementsWithoutErrors(root, newRoot, project, sourceConfigurator.getUpdateJob());
                    List<RfTreeElementWrapper> children = newRoot.getChildren();
                    if (children != null) {
                        children.stream().forEach(e -> e.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true));
                        Collections.sort(children, (o1, o2) -> ((VlogFileInstance)o1.getRfElement()).getIndex() - ((VlogFileInstance)o2.getRfElement()).getIndex());
                    } else {
                        this.buildNoFilesWithErrorsContent(project, newRoot);
                    }
                    root = newRoot;
                }
                if (sourceConfigurator.hasShowFilesWithErrors() || sourceConfigurator.getSearchSegments() != null && sourceConfigurator.getSearchSegments().length != 0) {
                    this.countElements(root, input, sourceConfigurator.getUpdateJob());
                } else {
                    input.setNotFilteredElementCount(input.getElementCount());
                }
                compileInfo.nofNotFiltered = input.getNotFilteredElementCount();
                input.setTableInfo(compileInfo.toString());
            }
            if (input.getElementCount() == 0 || root.getChildren() != null && root.getChildren().isEmpty()) {
                return input;
            }
            if (sourceConfigurator.isShowLanguageNameAsRootElement()) {
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VlogLanguageElement<String>(String.valueOf(LanguageKind.VLOG.VIEW_NAME) + " " + input.getTableInfo()));
                input.getElements().add(languageWrapper);
                if (root.getChildren() != null) {
                    languageWrapper.addChildren(root.getChildren());
                }
            } else if (root.getChildren() != null) {
                input.getElements().addAll(root.getChildren());
            }
            return input;
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
            return CompileOrderViewInput.emptyInput();
        }
    }

    private void countElements(IDVTElementWrapper root, CompileOrderViewInput input, UpdateJob updateJob) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof VlogFileInstance && root.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
            input.incrementNotFilteredElementCount();
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            this.countElements(child, input, updateJob);
        }
    }

    private void filterOutElementsWithoutErrors(RfTreeElementWrapper root, RfTreeElementWrapper newRoot, IProject project, UpdateJob updateJob) {
        List<RfTreeElementWrapper> children = root.getChildren();
        VlogFileInstance rfElement = (VlogFileInstance)root.getRfElement();
        boolean hasErrors = false;
        if (rfElement != null) {
            hasErrors = Utils.hasErrors((IProject)project, (String)DVTFileUtils.getInstance().parser2resource(project, rfElement.getParserPath()), (LanguageKind)LanguageKind.VLOG);
        }
        if (children == null || children.isEmpty()) {
            if (hasErrors) {
                newRoot.addChild(root);
            }
            return;
        }
        Iterator<RfTreeElementWrapper> iterator = children.iterator();
        while (iterator.hasNext()) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            RfTreeElementWrapper child = iterator.next();
            this.filterOutElementsWithoutErrors(child, newRoot, project, updateJob);
            iterator.remove();
        }
        if (hasErrors) {
            newRoot.addChild(root);
        }
    }

    public void gotoInclude(IProject project, IDVTElementWrapper wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = wrapper.getRfElement();
            if (object == null || !(object instanceof VlogFileInstance)) {
                return;
            }
            RfTreeElementWrapper selelm = (RfTreeElementWrapper)wrapper;
            VlogFileInstance fileInstance = (VlogFileInstance)selelm.getRfElement();
            VlogIncludingScope includingScope = fileInstance.getIncludingScope();
            int line = includingScope.getIncludingLine();
            VlogFileInstance inc = includingScope.getIncludingInstance();
            if (!this.isBuildFile(inc, project)) {
                this.gotoFile(project, line, inc);
            } else {
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                SourceFileToBuildFileMapping sourceFileToBuildMapping = rfProject.getSourceFileToBuildFileMapping();
                if (sourceFileToBuildMapping == null) {
                    return;
                }
                Map<Integer, BuildFilePathLine> includedTopFilesMap = sourceFileToBuildMapping.getIncludedTopFilesMap().get(fileInstance.getInvocNumber());
                if (includedTopFilesMap == null) {
                    return;
                }
                BuildFilePathLine includedTopFile = includedTopFilesMap.get(includingScope.getIncludingLine());
                if (includedTopFile != null) {
                    IFile buildFile = this.getBuildFile(project, includedTopFile);
                    if (buildFile == null) {
                        return;
                    }
                    this.gotoTopFile(includedTopFile, buildFile);
                    return;
                }
                Map<String, BuildFilePathLine> includedLibrariesMap = sourceFileToBuildMapping.getIncludedLibrariesMap().get(fileInstance.getInvocNumber());
                if (includedLibrariesMap == null) {
                    return;
                }
                BuildFilePathLine inclLibrary = includedLibrariesMap.get(fileInstance.getParserPath().path);
                if (inclLibrary == null) {
                    return;
                }
                IFile buildFile = this.getBuildFile(project, inclLibrary);
                if (buildFile == null) {
                    return;
                }
                this.gotoTopFile(inclLibrary, buildFile);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof VlogLanguageElement) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
    }

    public InspectViewInput getInspectContent(IDVTElementWrapper wrapper) {
        IFile file;
        block9: {
            VlogFileInstance instance;
            block8: {
                Object object;
                block7: {
                    block6: {
                        try {
                            if (wrapper instanceof RfTreeElementWrapper) break block6;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    object = wrapper.getRfElement();
                    if (object != null && object instanceof VlogFileInstance) break block7;
                    return null;
                }
                instance = (VlogFileInstance)object;
                String name = instance.getShortFileName();
                if (name == null || !name.startsWith("__vlog__") || !name.endsWith(".libfile")) break block8;
                return null;
            }
            file = RfUtils.getFile(instance, wrapper.getProject());
            if (file != null) break block9;
            return null;
        }
        return DVTInspectViewUtils.getInstance().processFile(file);
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper || adapted instanceof VlogFileInstance;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : namedElement.getComment();
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public String getShortFileName(IDVTElementWrapper element) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return "";
        }
        Object object = element.getRfElement();
        if (object == null || !(object instanceof VlogFileInstance)) {
            return "";
        }
        VlogFileInstance instance = (VlogFileInstance)object;
        String name = instance.getShortFileName();
        return name == null ? "" : name;
    }

    public boolean canShowGotoIncludeMenu(IDVTElementWrapper element) {
        return !(element.getRfElement() instanceof VlogLanguageElement);
    }

    public void gotoImport(IProject project, IDVTElementWrapper wrapper) {
    }

    public boolean canShowGotoImportMenu(IDVTElementWrapper element) {
        return false;
    }

    protected boolean isBuildFile(VlogFileInstance instance, IProject project) {
        IFile file = RfUtils.getFile(instance, project);
        return file == null;
    }

    protected abstract void gotoFile(IProject var1, int var2, VlogFileInstance var3);

    protected abstract IFile getBuildFile(IProject var1, BuildFilePathLine var2);

    protected abstract void gotoTopFile(BuildFilePathLine var1, IFile var2);

    protected abstract void buildNoFilesWithErrorsContent(IProject var1, RfTreeElementWrapper var2);

    private static class CompileOrderInfo {
        private int nofTotal;
        private int nofSkipped;
        private int nofUniques;
        private int nofNotFiltered;

        private CompileOrderInfo() {
        }

        public String toString() {
            if (this.nofTotal != this.nofNotFiltered) {
                return "[" + this.nofNotFiltered + "/" + this.nofTotal + " total, " + this.nofUniques + " unique, " + this.nofSkipped + " optimized]";
            }
            return "[" + this.nofTotal + " total, " + this.nofUniques + " unique, " + this.nofSkipped + " optimized]";
        }
    }
}

