/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInput;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInputConfigurator;
import ro.amiq.dvt.ui.views.coverage.ICoverageViewContributor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.CoverageViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VlogCoverageViewContributor
implements ICoverageViewContributor {
    private CoverageViewLabelProvider fLabelProvider = new CoverageViewLabelProvider();
    private int fNrTotalCoverGroups = 0;
    private int fNrNotFilteredCoverGroups = 0;
    private int fNrTotalCoverItems = 0;
    private int fNrNotFilteredCoverItems = 0;
    private int fNrTotalCoverAsserts = 0;
    private int fNrNotFilteredCoverAsserts = 0;
    private boolean fHasGUIFilteredElements;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (object == null || !(object instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement element = (RfNamedElement)object;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(element, project, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public CoverageViewInput getInput(CoverageViewInputConfigurator inputSourceConfigurator) {
        this.fNrTotalCoverGroups = 0;
        this.fNrNotFilteredCoverGroups = 0;
        this.fNrTotalCoverItems = 0;
        this.fNrNotFilteredCoverItems = 0;
        this.fNrTotalCoverAsserts = 0;
        this.fNrNotFilteredCoverAsserts = 0;
        this.fHasGUIFilteredElements = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!(inputSourceConfigurator.getSource() instanceof IProject)) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, this.fNrTotalCoverAsserts, this.fNrNotFilteredCoverAsserts, elements, this.fHasGUIFilteredElements);
            }
            IProject project = (IProject)inputSourceConfigurator.getSource();
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, this.fNrTotalCoverAsserts, this.fNrNotFilteredCoverAsserts, elements, this.fHasGUIFilteredElements);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, this.fNrTotalCoverAsserts, this.fNrNotFilteredCoverAsserts, elements, this.fHasGUIFilteredElements);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, this.fNrTotalCoverAsserts, this.fNrNotFilteredCoverAsserts, elements, this.fHasGUIFilteredElements);
            }
            RfCovergroup[] allCoverGroupsArray = rfProject.getAllCovergroups();
            if (allCoverGroupsArray == null) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, this.fNrTotalCoverAsserts, this.fNrNotFilteredCoverAsserts, elements, this.fHasGUIFilteredElements);
            }
            List<IDVTElementWrapper> wrappers = this.toWrappers(rfProject, inputSourceConfigurator.getSearchSegments(), inputSourceConfigurator.getSearchStrictness(), inputSourceConfigurator.getUpdateJob());
            if (wrappers == null || wrappers.isEmpty()) {
                return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, this.fNrTotalCoverAsserts, this.fNrNotFilteredCoverAsserts, elements, this.fHasGUIFilteredElements);
            }
            this.internalSort(wrappers, inputSourceConfigurator.isSortByType());
            if (inputSourceConfigurator.isShowLanguageNameAsRootElement()) {
                StringBuilder infoText = new StringBuilder("[");
                if (this.fNrTotalCoverGroups == this.fNrNotFilteredCoverGroups) {
                    infoText.append(this.fNrTotalCoverGroups);
                } else {
                    infoText.append(this.fNrNotFilteredCoverGroups).append("/").append(this.fNrTotalCoverGroups);
                }
                infoText.append(ViewsUtils.getUnitName((String)"cover group", (int)this.fNrTotalCoverGroups, (String)" ", (String)"")).append("][");
                if (this.fNrTotalCoverItems == this.fNrNotFilteredCoverItems) {
                    infoText.append(this.fNrTotalCoverItems);
                } else {
                    infoText.append(this.fNrNotFilteredCoverItems).append("/").append(this.fNrTotalCoverItems);
                }
                infoText.append(ViewsUtils.getUnitName((String)"cover item", (int)this.fNrTotalCoverItems, (String)" ", (String)"")).append("]");
                if (this.fNrTotalCoverAsserts != 0) {
                    infoText.append("[");
                    if (this.fNrTotalCoverAsserts == this.fNrNotFilteredCoverAsserts) {
                        infoText.append(this.fNrTotalCoverAsserts);
                    } else {
                        infoText.append(this.fNrNotFilteredCoverAsserts).append("/").append(this.fNrTotalCoverAsserts);
                    }
                    infoText.append(ViewsUtils.getUnitName((String)"cover assertion", (int)this.fNrTotalCoverAsserts, (String)" ", (String)"")).append("]");
                }
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VlogLanguageElement<String>(String.valueOf(LanguageKind.VLOG.VIEW_NAME) + " " + infoText.toString()));
                elements.add(languageWrapper);
                languageWrapper.addChildren(wrappers);
            } else {
                elements.addAll(wrappers);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new CoverageViewInput(this.fNrTotalCoverGroups, this.fNrNotFilteredCoverGroups, this.fNrTotalCoverItems, this.fNrNotFilteredCoverItems, this.fNrTotalCoverAsserts, this.fNrNotFilteredCoverAsserts, elements, this.fHasGUIFilteredElements);
    }

    private List<IDVTElementWrapper> toWrappers(RfProject rfProject, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        IDVTElementWrapper root = this.toWrappersRecursive(rfProject, rfProject, searchSegments, searchStrictness, updateJob, new HashSet<RfNamedElement>(), new HashSet<RfNamedElement>(), BuildConfigManager.isHideDuplicateTypesView((IProject)rfProject.getProject()));
        if (root == null || !root.hasChildren()) {
            return null;
        }
        RfTreeElementWrapper noLibsRoot = new RfTreeElementWrapper("");
        for (IDVTElementWrapper wrapper : root.getChildren()) {
            if (wrapper.getRfElement() instanceof RfLibrary) {
                noLibsRoot.addChildren(wrapper.getChildren());
                continue;
            }
            noLibsRoot.addChild(wrapper);
        }
        ViewsUtils.hierarchicalSearch((IDVTElementWrapper)noLibsRoot, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
        this.countCoverGorupsAndItems(noLibsRoot);
        return noLibsRoot.getChildren();
    }

    private IDVTElementWrapper toWrappersRecursive(RfProject rfProject, RfNamedElement root, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob, HashSet<RfNamedElement> filteredParents, HashSet<RfNamedElement> elementParents, boolean hideDuplicates) {
        if (root instanceof RfCovergroup) {
            List<RfField> fields;
            for (RfNamedElement myParent : elementParents) {
                if (!filteredParents.contains(myParent)) continue;
                this.fHasGUIFilteredElements = true;
                return null;
            }
            RfCovergroup cg = (RfCovergroup)root;
            RfTreeElementWrapper cgWrapper = new RfTreeElementWrapper(cg);
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)root, () -> this.fLabelProvider.getText((Object)cgWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                this.fHasGUIFilteredElements = true;
                return null;
            }
            List<RfCoverpoint> coverpoints = cg.getLocalMembers(RfCoverpoint.class);
            if (coverpoints != null && !coverpoints.isEmpty()) {
                for (RfCoverpoint rfCoverpoint : coverpoints) {
                    RfTreeElementWrapper tempWrapper;
                    if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)rfCoverpoint, () -> this.lambda$1(tempWrapper = new RfTreeElementWrapper(rfCoverpoint))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    cgWrapper.addChild(tempWrapper);
                }
            }
            if ((fields = cg.getFields()) != null && !fields.isEmpty()) {
                for (RfField rfField : fields) {
                    RfTreeElementWrapper tempWrapper;
                    if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)rfField, () -> this.lambda$2(tempWrapper = new RfTreeElementWrapper(rfField))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                        this.fHasGUIFilteredElements = true;
                        continue;
                    }
                    cgWrapper.addChild(tempWrapper);
                }
            }
            ++this.fNrTotalCoverGroups;
            if (cgWrapper.hasChildren()) {
                this.fNrTotalCoverItems += cgWrapper.getChildren().size();
            }
            return cgWrapper;
        }
        List<RfNamedElement> children = this.getChildTypesAndCoverGroupContainersAndCoverGroup(rfProject, root, hideDuplicates);
        if (children.isEmpty()) {
            RfAssertExpect assertExpect;
            if (root instanceof RfAssertExpect && (assertExpect = (RfAssertExpect)root).isCover()) {
                RfTreeElementWrapper assertWrapper = new RfTreeElementWrapper(assertExpect);
                if (assertExpect.isAnonymous()) {
                    assertWrapper.setTreeName(assertExpect.getExpressionText());
                } else {
                    assertWrapper.setTreeName(String.valueOf(assertExpect.getName()) + " : " + assertExpect.getExpressionText());
                }
                for (RfNamedElement myParent : elementParents) {
                    if (!filteredParents.contains(myParent)) continue;
                    this.fHasGUIFilteredElements = true;
                    return null;
                }
                ++this.fNrTotalCoverAsserts;
                return assertWrapper;
            }
            return null;
        }
        if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.COVERAGE, (IRfNamedElement)root, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(root))) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            filteredParents.add(root);
        }
        ArrayList<IDVTElementWrapper> myChildren = new ArrayList<IDVTElementWrapper>();
        if (!children.isEmpty()) {
            elementParents.add(root);
        }
        for (RfNamedElement child : children) {
            IDVTElementWrapper childWrapper = this.toWrappersRecursive(rfProject, child, searchSegments, searchStrictness, updateJob, filteredParents, elementParents, hideDuplicates);
            if (childWrapper == null) continue;
            myChildren.add(childWrapper);
        }
        if (!children.isEmpty()) {
            elementParents.remove(root);
        }
        if (myChildren.isEmpty()) {
            return null;
        }
        RfTreeElementWrapper myWrapper = new RfTreeElementWrapper(root);
        myWrapper.addChildren(myChildren);
        return myWrapper;
    }

    private List<RfNamedElement> getChildTypesAndCoverGroupContainersAndCoverGroup(RfProject rfProject, RfNamedElement root, boolean hideDuplicates) {
        List<RfAssertExpect> allAsserts;
        List<RfFunction> assertContainers;
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (rfProject == null || rfProject.getProject() == null) {
            return result;
        }
        List<RfNamedElement> localTypes = rfProject.getLocalTypes(root, false, false, hideDuplicates);
        if (localTypes != null) {
            result.addAll(localTypes);
        }
        if ((assertContainers = root.getLocalMembers(RfFunction.class)) != null && !assertContainers.isEmpty()) {
            result.addAll(assertContainers);
        }
        if ((allAsserts = root.getAssertsExpectsWithPrefix("", 2, 1)) != null && !allAsserts.isEmpty()) {
            result.addAll(allAsserts);
        }
        return result;
    }

    private void countCoverGorupsAndItems(IDVTElementWrapper root) {
        if (root == null) {
            return;
        }
        if (root.getRfElement() instanceof RfCovergroup) {
            ++this.fNrNotFilteredCoverGroups;
            if (root.hasChildren()) {
                this.fNrNotFilteredCoverItems += root.getChildren().size();
            }
            return;
        }
        if (root.getRfElement() instanceof RfAssertExpect) {
            ++this.fNrNotFilteredCoverAsserts;
        }
        if (!root.hasChildren()) {
            return;
        }
        List children = root.getChildren();
        for (IDVTElementWrapper child : children) {
            this.countCoverGorupsAndItems(child);
        }
    }

    private void internalSort(List<IDVTElementWrapper> wrappers, boolean sortByType) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        if (sortByType) {
            Collections.sort(wrappers, VlogQuickViewersUtil.getSortByTypeComparator(this.fLabelProvider));
        } else {
            Collections.sort(wrappers, VlogQuickViewersUtil.getSortByNameComparator(this.fLabelProvider));
        }
        for (IDVTElementWrapper wrapper : wrappers) {
            this.internalSort(wrapper.getChildren(), sortByType);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfCovergroup || rfElement instanceof RfCoverpoint || rfElement instanceof RfField) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element)) || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getColumnText(element, 1));
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    private /* synthetic */ String lambda$1(RfTreeElementWrapper rfTreeElementWrapper) {
        return this.fLabelProvider.getText((Object)rfTreeElementWrapper);
    }

    private /* synthetic */ String lambda$2(RfTreeElementWrapper rfTreeElementWrapper) {
        return this.fLabelProvider.getText((Object)rfTreeElementWrapper);
    }
}

