/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.model.preproc.PreprocConst;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.trace.connections.WhyViewElement;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.BaseInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.FileCompileInfo;
import ro.amiq.dvt.ui.views.inspect.IWaveformViewerInspectViewInputContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.inspect.InspectViewInputBuilder;
import ro.amiq.dvt.ui.views.inspect.InspectViewPosition;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpander;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;

public abstract class VlogInspectViewContributorCommon
extends BaseInspectViewContributor
implements IWaveformViewerInspectViewInputContributor {
    private static final Pattern WS = Pattern.compile("\\s");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([\\d]*'s?[bBdDoOhH] *)?[0-9A-Fa-fxXzZ_.?-]+");
    private static final HashSet<Character> possibleCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('\''), Character.valueOf('h'), Character.valueOf('s'), Character.valueOf('o'), Character.valueOf('d'), Character.valueOf('x'), Character.valueOf('_'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('H'), Character.valueOf('S'), Character.valueOf('O'), Character.valueOf('D'), Character.valueOf('X'), Character.valueOf('z'), Character.valueOf('Z'), Character.valueOf('.'), Character.valueOf('?')));
    private static final String INSPECT_VIEW_PREDEFINED_FUNCTION_INFO_LINE = "// Predefined function\n";
    private static final int PREDEFINED_COMMENT_NEWLINE_STEP = 40;
    private static final int SCAN_LIMIT = 1000;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public InspectViewInput getInput(InspectViewUpdateEvent event) {
        InspectViewInput result;
        block9: {
            IProject iProject;
            block8: {
                block7: {
                    block6: {
                        result = null;
                        if (event.getLanguage().equals((Object)LanguageKind.VLOG)) break block6;
                        return null;
                    }
                    iProject = event.getProject();
                    if (iProject != null && iProject.isAccessible() && iProject.hasNature("ro.amiq.vlogdt.VlogNature")) break block7;
                    return null;
                }
                if (DVTPlugin.getDefault().collect().c(iProject, "F7376")) break block8;
                return null;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(iProject);
            if (rfProject != null) break block9;
            return null;
        }
        try {
            result = this.getInspectContent(event);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private InspectViewInput getInspectContent(InspectViewUpdateEvent event) {
        IRfNamedElement element;
        if (event.hasInfos()) {
            return this.getInspectFromDiagram(event);
        }
        IProject project = event.getProject();
        Object selectedElement = event.getElement();
        String powerDomain = null;
        String pfRule = null;
        if (event.getType() == InspectViewUpdateEventCommon.TYPE.WRAPPER && selectedElement instanceof IDVTElementWrapper) {
            powerDomain = (String)((IDVTElementWrapper)selectedElement).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.POWER_DOMAIN_NAME);
            pfRule = (String)((IDVTElementWrapper)selectedElement).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PF_RULE_NAME);
            if (pfRule != null) {
                String clampValue = (String)((IDVTElementWrapper)selectedElement).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.CLAMP_VALUE);
                pfRule = clampValue != null ? "Isolation strategy: " + pfRule + " [Clamp value: " + clampValue + "]" : "Retention rule: " + pfRule;
            }
            selectedElement = ((IDVTElementWrapper)selectedElement).getRfElement();
        }
        if (selectedElement instanceof IRfNamedElement) {
            element = (IRfNamedElement)selectedElement;
            return this.processNamedElement(project, element, event, powerDomain, pfRule);
        }
        if (selectedElement instanceof IRfDefElement) {
            IRfDefElement def = (IRfDefElement)selectedElement;
            return DVTInspectViewUtils.getInstance().processDefElement(project, def, "//", powerDomain, 0, null);
        }
        if (selectedElement instanceof WhyViewElement) {
            element = (WhyViewElement)selectedElement;
            if (element.getStatement() != null) {
                return DVTInspectViewUtils.getInstance().processGoToInfos(Arrays.asList(new InspectViewGoToInfo(element.getStatement().goToInfo)), project, LanguageKind.VLOG);
            }
            if (element.point != null && element.point.signal != null) {
                return DVTInspectViewUtils.getInstance().processDefElement(project, element.point.signal.getDeclaration(), "//", powerDomain, 0, null);
            }
        } else if (selectedElement instanceof PreprocDiffManager.PreprocMacro) {
            return VlogInspectViewContributorCommon.processPreprocMacro(project, (PreprocDiffManager.PreprocMacro)selectedElement, event.getCallParserPath());
        }
        return null;
    }

    protected static InspectViewInput processPredefinedFunction(IProject project, RfPredefinedFunction element) {
        String predefinedComment = VlogInspectViewContributorCommon.processPredefinedComment(element.getComment());
        String functionSignature = element.getSignature();
        String inspectViewContent = DVTInspectViewUtils.getInstance().formatContent(INSPECT_VIEW_PREDEFINED_FUNCTION_INFO_LINE + predefinedComment + "\n" + functionSignature, project, true);
        InspectViewInput result = new InspectViewInput(inspectViewContent);
        result.addFileNamePosition((Position)new DVTPosition(0, INSPECT_VIEW_PREDEFINED_FUNCTION_INFO_LINE.length()));
        result.addContentPosition((Position)new DVTPosition(INSPECT_VIEW_PREDEFINED_FUNCTION_INFO_LINE.length(), inspectViewContent.length()));
        result.setMaxDigitsNumber(2);
        result.setLineNumberContent(null);
        return result;
    }

    private static String processPredefinedComment(String comment) {
        if (comment == null || comment.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder("// ");
        int index = 0;
        int step = 40;
        while (index < comment.length()) {
            result.append(comment.substring(index, index + Math.min(step, comment.length() - index))).append("\n").append(index < comment.length() - step ? "// " : "");
            index += step;
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InspectViewInput processMacro(IProject project, VlogMacroInfo macroInfo, int macroCallOffset, String callParserPath) {
        if (macroCallOffset < 0) {
            return VlogInspectViewContributorCommon.processMacroDefinition(project, macroInfo, true);
        }
        try {
            IFile file;
            if (callParserPath != null) {
                file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, callParserPath);
            } else {
                IEditorPart editor = DVTInspectViewUtils.getInstance().getActiveEditor();
                if (!(editor instanceof VlogEditor)) {
                    return null;
                }
                VlogEditor vlogEditor = (VlogEditor)editor;
                file = (IFile)vlogEditor.getAdapter(IResource.class);
            }
            if (file == null) {
                return null;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            return (InspectViewInput)DVTFileUtils.getInstance().withDocument(file, document -> {
                InspectViewInput callInput;
                String macroCallInfo;
                String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject((IProject)project);
                InspectViewInput result = new InspectViewInput("", lineDelimiter);
                int macroCallLine = DVTFileUtils.getInstance().getLineFromOffset(file, macroCallOffset);
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                if (rfProject == null) {
                    return null;
                }
                result.appendInput(VlogInspectViewContributorCommon.processMacroDefinition(project, macroInfo, false));
                int newCallOffset = macroCallOffset;
                try {
                    IRegion lineInformationOfOffset = document.getLineInformationOfOffset(macroCallOffset);
                    newCallOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, "`", lineInformationOfOffset.getOffset(), macroCallOffset, false);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                IRegion region = RfBatchUtils.getMacroRegionAtOffset(rfProject, parserPath, document, newCallOffset, 1000);
                String macroCallContent = null;
                if (region != null) {
                    TextSelection selection = new TextSelection(document, region.getOffset(), region.getLength());
                    macroCallContent = DVTInspectViewUtils.getInstance().formatContent(selection.getText(), project, false);
                    macroCallInfo = DVTInspectViewUtils.getInstance().getInfoLine(project, "Macro call", file, "//", -1);
                    callInput = new InspectViewInput(String.valueOf(macroCallInfo) + macroCallContent);
                    Position[] positions = DVTInspectViewUtils.getInstance().getBackgroundAndHyperlinkPositions(result.getContentLength(), macroCallInfo, file, macroCallLine);
                    if (positions != null) {
                        callInput.addFileNamePosition(positions[0]);
                        callInput.addHyperlinkPosition((InspectViewPosition)positions[1]);
                    }
                } else {
                    return VlogInspectViewContributorCommon.processMacroDefinition(project, macroInfo, true);
                }
                int noLines = macroCallContent.split(lineDelimiter).length;
                callInput.addContentPosition((Position)new DVTPosition(result.getContentLength() + macroCallInfo.length(), macroCallContent.length()));
                callInput.setMaxDigitsNumber(DVTInspectViewUtils.getInstance().getDigits(macroCallLine));
                callInput.setLineNumberContent(DVTInspectViewUtils.getInstance().getLineNumberContent(macroCallLine, macroCallLine + noLines - 1, true, macroCallInfo));
                result.appendInput(callInput);
                VlogFileInstance tops = rfProject.getPreprocessingTable().getTopFileInstance();
                if (tops == null) {
                    return null;
                }
                String expandedMacro = null;
                try {
                    expandedMacro = MacroExpander.expand(new MacroScanner(), null, tops, macroCallContent, rfProject, "__vlog_partitioning", 1, macroCallLine, parserPath, true, false);
                    List<MacroScanner.Match> macroMatches = new MacroScanner().getMacroMatches(expandedMacro, rfProject, macroCallLine, parserPath, new HashSet<String>(), false);
                    if (macroMatches != null && !macroMatches.isEmpty()) {
                        expandedMacro = MacroExpander.expand(new MacroScanner(), null, tops, macroCallContent, rfProject, "__vlog_partitioning", Integer.MAX_VALUE, macroCallLine, parserPath, true, false);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                if (expandedMacro == null || expandedMacro.isEmpty()) {
                    return VlogInspectViewContributorCommon.processMacroDefinition(project, macroInfo, true);
                }
                String fileInfo = "// Macro expansion \n";
                String numberInformation = DVTInspectViewUtils.getInstance().printNumberInDifferentBases(expandedMacro, LanguageKind.VLOG, "Number : ", false);
                if (!numberInformation.isEmpty()) {
                    expandedMacro = numberInformation;
                }
                InspectViewInput expandedInput = new InspectViewInput(String.valueOf(fileInfo) + DVTInspectViewUtils.getInstance().formatContent(expandedMacro, project, false), lineDelimiter);
                Position[] positions = DVTInspectViewUtils.getInstance().getBackgroundAndHyperlinkPositions(result.getContentLength(), fileInfo, file, macroCallLine);
                if (positions != null) {
                    expandedInput.addFileNamePosition(positions[0]);
                    expandedInput.addContentPosition((Position)new DVTPosition(result.getContentLength() + fileInfo.length(), expandedMacro.length()));
                }
                result.appendInput(expandedInput);
                return result;
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static InspectViewInput processMacroDefinition(IProject project, VlogMacroInfo macroInfo, boolean addNumberInformation) {
        String numberInformation;
        int aboveCommentStartLine;
        int contextLines;
        int origStartLine = macroInfo.getLine();
        int origEndLine = macroInfo.getEndLine();
        if (origStartLine < 0 || origEndLine < 0 || origStartLine > origEndLine) {
            return null;
        }
        int n = contextLines = origStartLine == origEndLine ? DVTInspectViewUtils.getInstance().getInspectContextLines() : 0;
        if (origEndLine - origStartLine + 1 > 1000) {
            origEndLine = origStartLine + 1000;
        }
        if (macroInfo.getCommentBlock() != null && (aboveCommentStartLine = macroInfo.getCommentBlock().getAboveCommentStartLine()) >= 0 && aboveCommentStartLine <= origEndLine) {
            origStartLine = aboveCommentStartLine;
        }
        boolean addContextLines = origStartLine >= contextLines + 1 && contextLines > 0;
        int startLine = addContextLines ? origStartLine - contextLines : origStartLine;
        int endLine = origEndLine + contextLines;
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, macroInfo.getFileInstance().getParserPath().path);
        if (iFile == null) {
            return null;
        }
        String fileData = DVTFileUtils.getInstance().getLinesFromFile(iFile, startLine, endLine, null);
        if (fileData == null || fileData.equals("")) {
            return null;
        }
        String fileInfo = DVTInspectViewUtils.getInstance().getInfoLine(project, "Macro definition", iFile, "//", -1);
        String content = String.valueOf(fileInfo) + fileData + "\n";
        content = DVTInspectViewUtils.getInstance().formatContent(content, project, true);
        InspectViewInput result = new InspectViewInput(content);
        Position[] positions = DVTInspectViewUtils.getInstance().getBackgroundAndHyperlinkPositions(0, fileInfo, iFile, macroInfo.getLine());
        if (positions != null) {
            result.addFileNamePosition(positions[0]);
            result.addHyperlinkPosition((InspectViewPosition)positions[1]);
        }
        if (addNumberInformation && !(numberInformation = VlogInspectViewContributorCommon.getNumberInformation(macroInfo, project, iFile, startLine)).isEmpty()) {
            String allNumberInformation = DVTStringUtil.appendString((Object[])new Object[]{"// Macro expansion", "\n", numberInformation});
            int numberInformationOffset = content.length() + 1;
            result.addFileNamePosition((Position)new DVTPosition(numberInformationOffset, numberInformation.indexOf("\n")));
            result.setContent(content + "\n" + allNumberInformation);
        }
        int contentStartLine = addContextLines ? origStartLine - startLine + 1 : 1;
        int contentEndLine = addContextLines ? origEndLine - startLine + 1 : origEndLine - origStartLine + 1;
        result.addContentPositions(DVTInspectViewUtils.getInstance().getPaintedPositions(new Document(content), contentStartLine, contentEndLine));
        result.setMaxDigitsNumber(DVTInspectViewUtils.getInstance().getDigits(endLine));
        result.setLineNumberContent(DVTInspectViewUtils.getInstance().getLineNumberContent(startLine, endLine, true, fileInfo));
        return result;
    }

    private static String getNumberInformation(VlogMacroInfo macroInfo, IProject project, IFile file, int callLine) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        VlogFileInstance topFI = rfProject.getPreprocessingTable().getTopFileInstance();
        String macroCallContent = "`" + macroInfo.getName();
        String value = null;
        ParserPath path = DVTFileUtils.getInstance().resource2parser((IResource)file);
        try {
            value = MacroExpander.expand(new MacroScanner(), null, topFI, macroCallContent, rfProject, "__vlog_partitioning", 1, 15000, path, true, false);
            List<MacroScanner.Match> macroMatches = new MacroScanner().getMacroMatches(value, rfProject, callLine, path, new HashSet<String>(), false);
            if (macroMatches != null && !macroMatches.isEmpty()) {
                value = MacroExpander.expand(new MacroScanner(), null, topFI, macroCallContent, rfProject, "__vlog_partitioning", Integer.MAX_VALUE, 15000, path, true, false);
            }
        }
        catch (VlogException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        value = value == null ? value : value.replace(";", "");
        value = value == null ? value : value.replace(" ", "");
        return DVTInspectViewUtils.getInstance().printNumberInDifferentBases(value, LanguageKind.VLOG, "Number : ", false);
    }

    private static InspectViewInput processPreprocMacro(IProject project, PreprocDiffManager.PreprocMacro preprocMacro, String filePath) {
        PreprocConstCommon.PreprocFileType preprocFileType = PreprocUtils.getInstance().getPreprocFileType(project, new ParserPath(filePath));
        if (preprocFileType == null) {
            return null;
        }
        PreprocConstCommon.PreprocFileType mappedFileType = preprocFileType.getMappedFileType();
        String mappedFilePath = preprocFileType.getMappedFilePath(project, filePath);
        if (mappedFilePath == null) {
            return null;
        }
        IFile mappedFile = DVTFileUtils.getInstance().findProjectFile(project, mappedFilePath);
        if (mappedFile == null) {
            return null;
        }
        boolean isEmptyMappedRegion = preprocMacro.isEmptyRegion(mappedFileType);
        String infoLine = PreprocConst.getInspectViewInfoLine((PreprocConstCommon.PreprocFileType)preprocFileType, (boolean)isEmptyMappedRegion);
        if (infoLine == null) {
            return null;
        }
        String preprocMacroInfo = DVTInspectViewUtils.getInstance().getInfoLine(project, infoLine, mappedFile, "//", -1);
        int contentStartLine = DVTFileUtils.getInstance().getLineFromOffset(mappedFile, preprocMacro.getStartOffset(mappedFileType));
        Position[] positions = DVTInspectViewUtils.getInstance().getBackgroundAndHyperlinkPositions(0, preprocMacroInfo, mappedFile, contentStartLine);
        if (positions == null || positions.length != 2) {
            return null;
        }
        if (isEmptyMappedRegion) {
            InspectViewInput result = new InspectViewInput(preprocMacroInfo);
            result.addFileNamePosition(positions[0]);
            result.addHyperlinkPosition((InspectViewPosition)positions[1]);
            return result;
        }
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject((IProject)project);
        String content = PreprocDiffManager.INSTANCE.getPreprocMacroCodeRegion(preprocMacro, mappedFileType, mappedFilePath);
        if (content == null) {
            return null;
        }
        int contentNOfLines = content.split(lineDelimiter).length;
        InspectViewInput result = new InspectViewInput(String.valueOf(preprocMacroInfo) + content, lineDelimiter);
        result.addFileNamePosition(positions[0]);
        result.addHyperlinkPosition((InspectViewPosition)positions[1]);
        result.addContentPosition((Position)new DVTPosition(preprocMacroInfo.length(), content.length()));
        result.setMaxDigitsNumber(DVTInspectViewUtils.getInstance().getDigits(contentStartLine + contentNOfLines));
        result.setLineNumberContent(DVTInspectViewUtils.getInstance().getLineNumberContent(contentStartLine, contentStartLine + contentNOfLines - 1, true, preprocMacroInfo));
        return result;
    }

    public InspectViewUpdateEvent createEventFromPreliminary(InspectViewUpdateEvent preliminaryEvent) {
        RfFileDef fileDef;
        int cursorOffset;
        IDocument document;
        RfProject rfProject;
        IFile file;
        block11: {
            String filePath;
            PreprocDiffManager.PreprocMacro preprocMacro;
            block10: {
                Object preliminaryEventElement;
                block9: {
                    try {
                        preliminaryEventElement = preliminaryEvent.getElement();
                        if (preliminaryEventElement instanceof List) break block9;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                List preliminaryData = (List)preliminaryEventElement;
                file = (IFile)preliminaryData.get(0);
                rfProject = (RfProject)preliminaryData.get(1);
                document = (IDocument)preliminaryData.get(2);
                cursorOffset = preliminaryEvent.getCallOffset();
                if (file != null && rfProject != null && document != null) break block10;
                return null;
            }
            IProject project = file.getProject();
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (PreprocUtils.getInstance().isMappedFile(project, parserPath) && (preprocMacro = PreprocDiffManager.INSTANCE.computePVlogMacroAtOffset(project, filePath = parserPath.path, cursorOffset)) != null) {
                return new InspectViewUpdateEvent((Object)preprocMacro, LanguageKind.VLOG, cursorOffset, filePath, project, InspectViewUpdateEventCommon.TYPE.EDITOR);
            }
            fileDef = rfProject.getFile((IResource)file);
            if (fileDef != null && fileDef.getParserPath() != null) break block11;
            return null;
        }
        String filePath = fileDef.getParserPath().path;
        IRfNamedElement element = null;
        RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(rfProject, file, document, cursorOffset, null);
        if (elementAndScope == null || elementAndScope.getIRfNamedElement() == null) {
            String number = this.findNumberAtOffset(cursorOffset, document);
            if (number != null && DVTStringUtil.parseNumberVLOG((String)number, (Number)Float.valueOf(Float.MAX_VALUE), (boolean)true).floatValue() != Float.MAX_VALUE) {
                return new InspectViewUpdateEvent((Object)number, LanguageKind.VLOG, cursorOffset, filePath, file.getProject(), InspectViewUpdateEventCommon.TYPE.NUMBER);
            }
        } else {
            element = elementAndScope.getIRfNamedElement();
        }
        InspectViewUpdateEvent returnEvent = null;
        returnEvent = element == null ? new InspectViewUpdateEvent(file, InspectViewUpdateEventCommon.TYPE.FILE) : new InspectViewUpdateEvent((Object)element, element.getLanguageKind(), cursorOffset, filePath, file.getProject(), InspectViewUpdateEventCommon.TYPE.EDITOR);
        return returnEvent;
    }

    public FileCompileInfo getCompileInfo(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        if (iFile.getProject() == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(iFile.getProject());
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)iFile);
        if (parserPath == null) {
            return null;
        }
        VlogPreprocessingInfo preprocessingTable = rfProject.getPreprocessingTable();
        if (preprocessingTable == null) {
            return null;
        }
        VlogFileInstance topInstance = preprocessingTable.getTopFileInstance();
        if (topInstance == null) {
            return null;
        }
        List<VlogFileInstance> fileInstances = topInstance.getFileInstances(parserPath);
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        ArrayList<Integer> compileIndices = new ArrayList<Integer>();
        ArrayList<IBuildConfigParserConstants.LanguageSyntax> languageSyntaxes = new ArrayList<IBuildConfigParserConstants.LanguageSyntax>();
        for (VlogFileInstance fileInstance : fileInstances) {
            if (fileInstance.getIndex() < 0) continue;
            compileIndices.add(fileInstance.getIndex());
            languageSyntaxes.add(fileInstance.getLanguageSyntax());
        }
        return compileIndices.isEmpty() ? null : new FileCompileInfo(compileIndices, languageSyntaxes);
    }

    private String findNumberAtOffset(int originalOffset, IDocument document) throws BadLocationException {
        char c;
        int startOffset;
        if (document == null || originalOffset < 0) {
            return null;
        }
        int length = document.getLength();
        int endOffset = originalOffset;
        boolean isTickLeft = this.isTickLeft(startOffset, document);
        boolean tickFound = false;
        for (startOffset = originalOffset; startOffset >= 0; --startOffset) {
            c = document.getChar(startOffset);
            if (c == '\'') {
                tickFound = true;
            }
            if (!possibleCharacters.contains(Character.valueOf(c)) && (c != ' ' || tickFound || !isTickLeft)) break;
        }
        tickFound = false;
        while (endOffset < length) {
            c = document.getChar(endOffset);
            if (c == '\'') {
                tickFound = true;
            }
            if (!possibleCharacters.contains(Character.valueOf(c)) && (c != ' ' || !tickFound && !isTickLeft)) break;
            ++endOffset;
        }
        if (startOffset == endOffset) {
            return null;
        }
        String number = document.get(startOffset + 1, endOffset - startOffset - 1);
        return this.isNumber(number = DVTStringUtil.replaceAll((Pattern)WS, (CharSequence)number, (String)"")) ? number : null;
    }

    private boolean isTickLeft(int startOffset, IDocument document) throws BadLocationException {
        int length = document.getLength();
        boolean tickFound = false;
        while (startOffset >= 0 && startOffset < length) {
            char c = document.getChar(startOffset);
            if (!possibleCharacters.contains(Character.valueOf(c)) && ' ' != c) break;
            tickFound |= c == '\'';
            --startOffset;
        }
        return tickFound;
    }

    private boolean isNumber(String numberAtOffset) {
        return numberAtOffset != null && DVTStringUtil.matches((Pattern)NUMBER_PATTERN, (CharSequence)numberAtOffset);
    }

    public List<String> getLinterProblemsViewTitleAndDescription(Object linterHit) {
        ArrayList<String> result = new ArrayList<String>();
        if (linterHit instanceof OVMComplianceCheckHit) {
            OVMComplianceCheckHit hit = (OVMComplianceCheckHit)linterHit;
            OVMComplianceCheck check = hit.getCheck();
            result.add(String.valueOf(check.getName()) + ": " + check.getTitle());
            result.add(check.getCheckDescriptionToPrint());
        }
        return result;
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset) {
        IDocument document;
        RfProject rfProject;
        IProject project;
        IFile file;
        block15: {
            IDocumentProvider documentProvider;
            IEditorInput editorInput;
            block14: {
                VlogEditor vlogEditor;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        if (editor instanceof VlogEditor) break block9;
                                        return null;
                                    }
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        return null;
                                    }
                                }
                                vlogEditor = (VlogEditor)editor;
                                editorInput = vlogEditor.getEditorInput();
                                if (editorInput != null) break block10;
                                return null;
                            }
                            file = (IFile)editorInput.getAdapter(IFile.class);
                            if (file != null) break block11;
                            return null;
                        }
                        project = file.getProject();
                        if (project != null) break block12;
                        return null;
                    }
                    rfProject = RfManager.getInstance().getRfProject(project);
                    if (rfProject != null) break block13;
                    return null;
                }
                documentProvider = vlogEditor.getDocumentProvider();
                if (documentProvider != null) break block14;
                return null;
            }
            document = documentProvider.getDocument((Object)editorInput);
            if (document != null) break block15;
            return null;
        }
        cursorOffset = cursorOffset >= document.getLength() ? document.getLength() - 1 : cursorOffset;
        List<Object> object = Arrays.asList(file, rfProject, document);
        return new InspectViewUpdateEvent(object, LanguageKind.VLOG, cursorOffset, null, project, InspectViewUpdateEventCommon.TYPE.PRELIMINARY_EDITOR);
    }

    public IRfNamedElementAndScope getNamedElementAndScope(IEditorPart activeEditor, int offset) {
        if (!(activeEditor instanceof VlogEditor var3_4)) {
            return null;
        }
        RfProject project = vlogEditor.getRfProject();
        if (project == null) {
            return null;
        }
        IFile currentFile = vlogEditor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument((ITextEditor)vlogEditor);
        if (document == null) {
            return null;
        }
        return RfUtils.getRfElement(project, currentFile, document, offset, (DVTEditor)vlogEditor);
    }

    public InspectViewInput processNamedElement(IProject project, IRfNamedElement element, InspectViewUpdateEvent event, String powerDomain, String pfRule) {
        String callParserPath;
        int callOffset = event != null ? event.getCallOffset() : -1;
        String string = callParserPath = event != null ? event.getCallParserPath() : "";
        if (element instanceof VlogMacroInfo) {
            return VlogInspectViewContributorCommon.processMacro(project, (VlogMacroInfo)element, callOffset, callParserPath);
        }
        if (element instanceof RfTypeAlias && ((RfTypeAlias)element).getTranslatedType() instanceof RfStruct) {
            return this.processNamedElement(project, ((RfTypeAlias)element).getTranslatedType(), event, powerDomain, pfRule);
        }
        if (element instanceof RfField && ((RfField)element).getResolvedType(true) instanceof RfStruct) {
            return this.processNamedElement(project, ((RfField)element).getAssociatedType(), event, powerDomain, pfRule);
        }
        if (element instanceof RfInstance.RfInstanceList && ((RfInstance.RfInstanceList)element).getAssociatedType() != null) {
            return this.processNamedElement(project, ((RfInstance.RfInstanceList)element).getAssociatedType(), event, powerDomain, pfRule);
        }
        RfDefElement declaration = (RfDefElement)element.getDeclaration();
        if (element instanceof RfPredefinedFunction) {
            return VlogInspectViewContributorCommon.processPredefinedFunction(project, (RfPredefinedFunction)element);
        }
        if (element instanceof RfFunction) {
            RfFunction function = (RfFunction)element;
            if (function.isExtern()) {
                declaration = function.getImplementation();
            }
        } else if (powerDomain == null && (element instanceof RfInstance || element instanceof RfPort)) {
            IEditorPart editor = DVTInspectViewUtils.getInstance().getActiveEditor();
            if (editor instanceof DVTEditor) {
                IDocument document = DVTFileUtils.getInstance().getDocument((ITextEditor)editor);
                RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(element.getRfProject(), ((DVTEditor)editor).getCurrentFile(), document, callOffset, (DVTEditor)editor);
                if (namedElementAndScope != null && editor instanceof VlogEditor) {
                    powerDomain = DVTPFUtils.getPowerDomainsForInstanceOrPortUsingDPM((IDVTBreadcrumbHost)((VlogEditor)editor), (IRfNamedElement)element, (String)"\n", (int)callOffset, (IRfScopeElement)namedElementAndScope.getScope());
                }
            }
        } else if (element instanceof IRfFieldElement) {
            if (((IRfFieldElement)element).isEnumRangeElement()) {
                return null;
            }
            if (ELUtils.isActualValueConstant((IRfNamedElement)element)) {
                InspectViewInputBuilder inputBuilder = new InspectViewInputBuilder().appendInput(DVTInspectViewUtils.getInstance().processConstant((IRfFieldElement)element, project, event, "//")).appendInput(this.getWaveformInspectViewInput(project, element, callOffset));
                return inputBuilder.getInput();
            }
        }
        if (powerDomain != null && !powerDomain.isEmpty()) {
            powerDomain = "Low Power Information:\n" + powerDomain;
        }
        if (pfRule != null) {
            String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject((IProject)project);
            powerDomain = String.valueOf(powerDomain) + lineDelimiter + pfRule + lineDelimiter;
        }
        InspectViewInput inputResult = null;
        if (element instanceof RfPort) {
            inputResult = DVTInspectViewUtils.getInstance().processDefElements(element.getDeclarations(), project, "//", powerDomain, 0, null);
        }
        if (inputResult == null) {
            inputResult = DVTInspectViewUtils.getInstance().processDefElement(project, (IRfDefElement)declaration, "//", powerDomain, 0, null);
        }
        InspectViewInputBuilder inputBuilder = new InspectViewInputBuilder().appendInput(inputResult).appendInput(this.getWaveformInspectViewInput(project, element, callOffset));
        return inputBuilder.getInput();
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }
}

