/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.layers.LayersViewInput;
import ro.amiq.dvt.ui.views.layers.LayersViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLayersViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VlogLayersViewContributor
implements ILayersViewContributor {
    private VlogLayersViewLabelProvider fLabelProvider = new VlogLayersViewLabelProvider();
    private int fNrTotalLayers = 0;
    private int fNrTotalFiles = 0;
    private int fNrNotFilteredLayers = 0;
    private int fNrNotFilteredFiles = 0;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfDefElement) {
            actionHyperlink = RfUtils.createOpenAction((RfDefElement)element, project, null);
        } else if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)element, project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public LayersViewInput getQuickViewInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(true);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        this.fNrNotFilteredLayers = 0;
        this.fNrNotFilteredFiles = 0;
        String bulkDataInfo = "";
        Object namedElement = null;
        boolean showScopeColumn = false;
        List<Object> elements = new ArrayList();
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.VLOG)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfElementPair elementPair = this.getLayersData(rfProject, inputConfig.getStringMather(), ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), true, inputConfig.getUpdateJob());
            if (elementPair.fElements == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, bulkDataInfo);
            }
            elements = this.toQuickViewWrappers(elementPair.fElements, inputConfig);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
    }

    private List<IDVTElementWrapper> toQuickViewWrappers(List<IDVTElementWrapper> elements, LayersViewInputConfigurator inputConfig) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        UpdateJob updateJob = inputConfig.getUpdateJob();
        try {
            for (IDVTElementWrapper wrapper : elements) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                Object tmpElment = wrapper.getRfElement();
                if (!(tmpElment instanceof RfDefElement)) continue;
                RfDefElement rfDefElem = (RfDefElement)tmpElment;
                RfNamedElement namedElement = rfDefElem.getNamedElement();
                RfTreeElementWrapper lastWrapper = new RfTreeElementWrapper(rfDefElem);
                RfNamedElement encScope = namedElement.getEnclosingScope();
                while (encScope != null && !(encScope instanceof RfProject)) {
                    RfTreeElementWrapper tmpWrapper = new RfTreeElementWrapper(encScope);
                    tmpWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SHOW_LINE_NUMBERS, "false");
                    tmpWrapper.addChild(lastWrapper);
                    lastWrapper = tmpWrapper;
                    encScope = encScope.getEnclosingScope();
                }
                this.addToFullTreeHelper(result, lastWrapper, updateJob);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void addToFullTreeHelper(List<IDVTElementWrapper> allWrappers, IDVTElementWrapper currentWrapper, UpdateJob updateJob) {
        boolean found = false;
        IDVTElementWrapper foundWrapper = null;
        for (IDVTElementWrapper tmpWrapper : allWrappers) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            if (!this.fLabelProvider.getText(tmpWrapper).equals(this.fLabelProvider.getText(currentWrapper))) continue;
            found = true;
            foundWrapper = tmpWrapper;
            break;
        }
        if (!found) {
            allWrappers.add(currentWrapper);
            return;
        }
        if (foundWrapper != null) {
            List currentChildren = currentWrapper.getChildren();
            if (currentChildren == null || currentChildren.isEmpty()) {
                return;
            }
            List foundChildren = foundWrapper.getChildren();
            if (foundChildren == null || foundChildren.isEmpty()) {
                foundWrapper.addChildren(currentChildren);
                return;
            }
            for (IDVTElementWrapper currentChild : currentChildren) {
                this.addToFullTreeHelper(foundChildren, currentChild, updateJob);
            }
        }
    }

    public LayersViewInput getInput(LayersViewInputConfigurator inputConfig) {
        this.fLabelProvider.setUsedByQuickLayersView(false);
        this.fNrTotalLayers = 0;
        this.fNrTotalFiles = 0;
        this.fNrNotFilteredLayers = 0;
        this.fNrNotFilteredFiles = 0;
        String bulkDataInfo = "";
        RfNamedElement namedElement = null;
        boolean showScopeColumn = false;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        try {
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.VLOG)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
            }
            int elementType = ev.getElementType();
            RfElementPair elementPair = this.getLayersData(rfProject, inputConfig.getStringMather(), ev.getElementName(), elementType, (List)ev.getElementScope(), false, inputConfig.getUpdateJob());
            List<IDVTElementWrapper> wrappers = elementPair.fElements;
            namedElement = elementPair.fNamedElement;
            if (wrappers == null) {
                return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, null, elements, showScopeColumn, bulkDataInfo);
            }
            if (elementType == 4 || elementType == 8 || elementType == 2 || elementType == 16 || elementType == 32768) {
                showScopeColumn = true;
            }
            elements.addAll(wrappers);
            bulkDataInfo = namedElement == null ? "" : namedElement.getSignature();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LayersViewInput(this.fNrTotalLayers, this.fNrTotalFiles, this.fNrNotFilteredLayers, this.fNrNotFilteredFiles, namedElement, elements, showScopeColumn, bulkDataInfo);
    }

    private int getFilesNo(List<IDVTElementWrapper> wrappedElements) {
        HashSet<ParserPath> set = new HashSet<ParserPath>();
        int i = 0;
        while (i < wrappedElements.size()) {
            RfDefElement element = (RfDefElement)wrappedElements.get(i).getRfElement();
            set.add(element.getDefFile().getParserPath());
            ++i;
        }
        return set.size();
    }

    private RfElementPair getLayersData(RfProject project, StringMatcher matcher, String elementName, int elementType, List<RfNameTypeScopeHelper> elementScope, boolean triggeredFromQuickView, UpdateJob updateJob) {
        RfNamedElement namedElement = null;
        NullProtectedList<RfDefElement> elementDefs = new NullProtectedList<RfDefElement>();
        List<IDVTElementWrapper> wrappers = new ArrayList<IDVTElementWrapper>();
        try {
            if (project == null) {
                return new RfElementPair(namedElement, wrappers);
            }
            IRfScopeElement scope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
            if (scope == null || !(scope instanceof IRfScope)) {
                return new RfElementPair(namedElement, wrappers);
            }
            if (elementType == 32) {
                List<RfNamedElement> macros = project.getMacrosWithPrefix(elementName, 1);
                if (macros != null && !macros.isEmpty()) {
                    for (RfNamedElement macro : macros) {
                        for (final VlogMacroInfo macroInfo : ((VlogMacroInfo)macro).getMacroZoneLayers()) {
                            RfFileDef fileDef;
                            ParserPath parserPath;
                            VlogFileInstance fileInstance = macroInfo.getFileInstance();
                            if (fileInstance == null || (parserPath = fileInstance.getParserPath()) == null || (fileDef = project.getFileDefUsingParserPath(parserPath)) == null) continue;
                            LineInfo lineInfo = new LineInfo(macroInfo.getLine(), -1, -1);
                            elementDefs.add(new RfDefElement(fileDef, elementName, lineInfo, lineInfo, macroInfo.getCommentBlock(), null){
                                private static final long serialVersionUID = 1L;

                                @Override
                                public RfNamedElement getNamedElement() {
                                    return macroInfo;
                                }

                                public String getInfo() {
                                    return macroInfo.getSignature();
                                }
                            });
                        }
                    }
                }
            } else if (elementType == 16 || elementType == 2 || elementType == 4 || elementType == 8 || elementType == 32768) {
                boolean showSubtypeLayers;
                RfNamedElement temp = null;
                boolean showSupertypeLayers = PrefConst.getLayersViewShowVlogTypeLayers() || PrefConst.getLayersViewShowVlogSupertypeLayers();
                boolean bl = showSubtypeLayers = PrefConst.getLayersViewShowVlogTypeLayers() || PrefConst.getLayersViewShowVlogSubtypeLayers();
                if (scope instanceof RfClass) {
                    RfClass parentClass = (RfClass)scope;
                    HashSet<RfClass> visitedInterfaces = new HashSet<RfClass>();
                    ArrayList<RfDefElement> parentInterfacesFunctions = new ArrayList<RfDefElement>();
                    do {
                        if (elementType == 16 || elementType == 2) {
                            temp = parentClass.getLocalMember(RfField.class, elementName, false);
                        } else if (elementType == 4 || elementType == 8) {
                            temp = parentClass.getLocalMember(RfFunction.class, elementName, false);
                        } else if (elementType == 32768) {
                            temp = parentClass.getLocalMember(RfConstraint.class, elementName, false);
                        }
                        if (temp != null) {
                            if (namedElement == null) {
                                namedElement = temp;
                            }
                            RfDefElement addFirst = null;
                            for (RfDefElement def : temp.getDeclarations()) {
                                if (elementDefs.contains(def)) continue;
                                if (def instanceof RfFunctionDef && ((RfFunctionDef)def).isPrototype()) {
                                    addFirst = def;
                                    continue;
                                }
                                if (def instanceof RfConstraintDef && ((RfConstraintDef)def).isPrototype()) {
                                    addFirst = def;
                                    continue;
                                }
                                elementDefs.add(0, def);
                            }
                            if (addFirst != null) {
                                elementDefs.add(0, addFirst);
                            }
                        }
                        if (!showSupertypeLayers) continue;
                        this.getSupertypeLayers(parentInterfacesFunctions, visitedInterfaces, parentClass, elementName, elementType);
                    } while (showSupertypeLayers && (parentClass = parentClass.getParent()) != null);
                    elementDefs.addAll(0, parentInterfacesFunctions);
                    if (showSubtypeLayers) {
                        Set<RfClass> visitedClasses = Collections.newSetFromMap(new IdentityHashMap());
                        this.getSubtypeLayers(elementDefs, visitedClasses, (RfClass)scope, elementName, elementType);
                    }
                } else if (scope instanceof RfNamedElement) {
                    RfNamedElement namedScope = (RfNamedElement)scope;
                    if (elementType == 16 || elementType == 2) {
                        temp = namedScope.getLocalMember(RfField.class, elementName, false);
                    } else if (elementType == 4 || elementType == 8) {
                        temp = namedScope.getLocalMember(RfFunction.class, elementName, false);
                    }
                    if (temp != null) {
                        namedElement = temp;
                        for (RfDefElement def : temp.getDeclarations()) {
                            if (elementDefs.contains(def)) continue;
                            elementDefs.add(def);
                        }
                    }
                }
            } else if (elementType == 1) {
                if (scope instanceof RfClass) {
                    namedElement = (RfClass)scope;
                    for (RfDefElement def : namedElement.getDeclarations()) {
                        if (elementDefs.contains(def)) continue;
                        elementDefs.add(def);
                    }
                }
            } else if (elementType == 1024) {
                if (scope instanceof RfInstance) {
                    namedElement = (RfInstance)scope;
                    for (RfDefElement def : namedElement.getDeclarations()) {
                        if (elementDefs.contains(def)) continue;
                        elementDefs.add(def);
                    }
                }
            } else if (elementType == 256) {
                if (scope instanceof RfProgram) {
                    namedElement = (RfProgram)scope;
                    for (RfDefElement def : namedElement.getDeclarations()) {
                        if (elementDefs.contains(def)) continue;
                        elementDefs.add(def);
                    }
                }
            } else if (elementType == 128) {
                if (scope instanceof RfModule) {
                    namedElement = (RfModule)scope;
                    for (RfDefElement def : namedElement.getDeclarations()) {
                        if (elementDefs.contains(def)) continue;
                        elementDefs.add(def);
                    }
                }
            } else if (elementType == 512) {
                if (scope instanceof RfInterface) {
                    namedElement = (RfInterface)scope;
                    for (RfDefElement def : namedElement.getDeclarations()) {
                        if (elementDefs.contains(def)) continue;
                        elementDefs.add(def);
                    }
                }
            } else if (elementType == 4096) {
                if (scope instanceof RfPrimitive) {
                    namedElement = (RfPrimitive)scope;
                    for (RfDefElement def : namedElement.getDeclarations()) {
                        if (elementDefs.contains(def)) continue;
                        elementDefs.add(def);
                    }
                }
            } else if (elementType == 8192) {
                if (scope instanceof RfChecker) {
                    namedElement = (RfChecker)scope;
                    for (RfDefElement def : namedElement.getDeclarations()) {
                        if (elementDefs.contains(def)) continue;
                        elementDefs.add(def);
                    }
                }
            } else if (elementType == 2048 && scope instanceof RfPackage) {
                namedElement = (RfPackage)scope;
                for (RfDefElement def : namedElement.getDeclarations()) {
                    if (elementDefs.contains(def)) continue;
                    elementDefs.add(def);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        for (RfDefElement rfDefElement : elementDefs) {
            wrappers.add(new RfTreeElementWrapper(rfDefElement));
        }
        this.fNrTotalLayers = wrappers.size();
        this.fNrTotalFiles = this.getFilesNo(wrappers);
        if (matcher != null) {
            wrappers = this.filterElements(wrappers, matcher, triggeredFromQuickView, elementType);
        }
        this.fNrNotFilteredLayers = wrappers.size();
        this.fNrNotFilteredFiles = this.getFilesNo(wrappers);
        return new RfElementPair(namedElement, wrappers);
    }

    private void getSupertypeLayers(List<RfDefElement> elementDefs, Set<RfClass> visitedInterfaces, RfClass baseClass, String elementName, int elementType) {
        if (visitedInterfaces.contains(baseClass)) {
            return;
        }
        visitedInterfaces.add(baseClass);
        List<RfClass> parentInterfaces = baseClass.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return;
        }
        for (RfClass interfaze : parentInterfaces) {
            RfNamedElement namedElement = null;
            namedElement = interfaze.getLocalMember(RfFunction.class, elementName, false);
            if (namedElement != null) {
                for (RfDefElement def : namedElement.getDeclarations()) {
                    if (elementDefs.contains(def)) continue;
                    elementDefs.add(0, def);
                }
            }
            this.getSupertypeLayers(elementDefs, visitedInterfaces, interfaze, elementName, elementType);
        }
    }

    private void getSubtypeLayers(List<RfDefElement> elementDefs, Set<RfClass> visitedClasses, RfClass baseClass, String elementName, int elementType) {
        if (visitedClasses.contains(baseClass)) {
            return;
        }
        visitedClasses.add(baseClass);
        Set<RfClass> children = baseClass.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            RfNamedElement namedElement = null;
            if (elementType == 16 || elementType == 2) {
                namedElement = child.getLocalMember(RfField.class, elementName, false);
            } else if (elementType == 4 || elementType == 8) {
                namedElement = child.getLocalMember(RfFunction.class, elementName, false);
            } else if (elementType == 32768) {
                namedElement = child.getLocalMember(RfConstraint.class, elementName, false);
            }
            if (namedElement != null) {
                for (RfDefElement def : namedElement.getDeclarations()) {
                    if (elementDefs.contains(def)) continue;
                    elementDefs.add(def);
                }
            }
            this.getSubtypeLayers(elementDefs, visitedClasses, child, elementName, elementType);
        }
    }

    private List<IDVTElementWrapper> filterElements(List<IDVTElementWrapper> elements, StringMatcher matcher, boolean triggeredFromQuickView, int elementType) {
        if (matcher == null) {
            return elements;
        }
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper wrapper : elements) {
            this.fLabelProvider.setUsedByQuickLayersView(triggeredFromQuickView);
            String name = this.fLabelProvider.getColumnText(wrapper, 0);
            String scope = elementType == 4 || elementType == 8 || elementType == 2 || elementType == 16 || elementType == 32768 ? this.fLabelProvider.getColumnText(wrapper, 1) : "";
            String comment = triggeredFromQuickView ? "" : this.fLabelProvider.getColumnText(wrapper, 2);
            String fileName = this.fLabelProvider.getColumnText(wrapper, 3);
            String linenr = this.fLabelProvider.getColumnText(wrapper, 4);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)scope) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)comment) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)fileName) && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)linenr)) continue;
            result.add(wrapper);
        }
        return result;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof RfFileDef) {
            return false;
        }
        if (referenceData instanceof UpdateViewEvent) {
            UpdateViewEvent updateEvent = (UpdateViewEvent)referenceData;
            if (updateEvent.getFileName() == null) {
                return false;
            }
            return this.fLabelProvider.getColumnText(element, 4).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 5).equals(String.valueOf(updateEvent.getOffset())) || this.fLabelProvider.getColumnText(element, 3).equals(updateEvent.getFileName()) && this.fLabelProvider.getColumnText(element, 4).equals(String.valueOf(updateEvent.getOffset()));
        }
        if (referenceData instanceof RfTreeElementWrapper) {
            return this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4)) && this.fLabelProvider.getColumnText(element, 5).equals(this.fLabelProvider.getColumnText(referenceData, 5)) || this.fLabelProvider.getColumnText(element, 3).equals(this.fLabelProvider.getColumnText(referenceData, 3)) && this.fLabelProvider.getColumnText(element, 4).equals(this.fLabelProvider.getColumnText(referenceData, 4));
        }
        if (rfElement instanceof RfDefElement) {
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
        }
        return false;
    }

    public void collectEMethodLayers(List<IDVTElementWrapper> allLayers) {
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursor) {
        RfNamedElement namedElement;
        IDocument document;
        IProject project;
        IFile file;
        block21: {
            block20: {
                RfWNamedElementAndScope elementAndScope;
                block19: {
                    RfProject rfProject;
                    VlogEditor vlogEditor;
                    block18: {
                        IDocumentProvider documentProvider;
                        IEditorInput editorInput;
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                try {
                                                    if (editor instanceof VlogEditor) break block12;
                                                    return null;
                                                }
                                                catch (Exception e) {
                                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                                    return null;
                                                }
                                            }
                                            vlogEditor = (VlogEditor)editor;
                                            editorInput = vlogEditor.getEditorInput();
                                            if (editorInput != null) break block13;
                                            return null;
                                        }
                                        file = (IFile)editorInput.getAdapter(IFile.class);
                                        if (file != null) break block14;
                                        return null;
                                    }
                                    project = file.getProject();
                                    if (project != null) break block15;
                                    return null;
                                }
                                rfProject = RfManager.getInstance().getRfProject(project);
                                if (rfProject != null) break block16;
                                return null;
                            }
                            documentProvider = vlogEditor.getDocumentProvider();
                            if (documentProvider != null) break block17;
                            return null;
                        }
                        document = documentProvider.getDocument((Object)editorInput);
                        if (document != null) break block18;
                        return null;
                    }
                    elementAndScope = RfUtils.getRfElement(rfProject, (ITextEditor)vlogEditor, document, cursor);
                    if (elementAndScope != null) break block19;
                    return null;
                }
                namedElement = elementAndScope.getNamedElement();
                if (namedElement != null) break block20;
                return null;
            }
            if (!(namedElement instanceof RfTypeAlias) && !(namedElement instanceof RfCovergroup)) break block21;
            return null;
        }
        UpdateViewEvent updateEvent = VlogQuickViewersUtil.createViewUpdateEvent(namedElement, project, 1);
        updateEvent.setOffset(document.getLineOfOffset(cursor) + 1);
        updateEvent.setFileName(file.getName());
        return updateEvent;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    static class RfElementPair {
        RfNamedElement fNamedElement;
        List<IDVTElementWrapper> fElements;

        public RfElementPair(RfNamedElement namedElement, List<IDVTElementWrapper> elementDefs) {
            this.fNamedElement = namedElement;
            this.fElements = elementDefs;
        }
    }
}

