/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTVlogMacroGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.macros.IMacrosViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.macros.MacrosWrapper;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.IRfMacroVisitor;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.MacroViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VlogMacrosViewContributor
implements IMacrosViewContributor {
    public static final Comparator<Object> MACROS_COMPARATOR = (o1, o2) -> {
        if (!(o1 instanceof IRfNamedElement) || !(o2 instanceof IRfNamedElement)) {
            return -1;
        }
        return ((IRfNamedElement)o1).getName().compareTo(((IRfNamedElement)o2).getName());
    };
    private MacroViewLabelProvider labelProvider = new MacroViewLabelProvider();

    public MacrosWrapper getLanguageMacrosWrapper(IProject project, IRfFilterableTreeAccessor view, IProgressMonitor monitor) {
        try {
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature") || monitor.isCanceled()) {
                return this.newEmptyMacrosWrapper();
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return this.newEmptyMacrosWrapper();
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return this.newEmptyMacrosWrapper();
            }
            Collection<VlogMacroInfo> allMacros = this.getAllMacrosNoDuplicates(rfProject, null, monitor);
            if (allMacros == null || allMacros.isEmpty()) {
                return this.newEmptyMacrosWrapper();
            }
            return this.computeMacrosWrapper(allMacros, rfProject, view, monitor);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.newEmptyMacrosWrapper();
        }
    }

    private MacrosWrapper newEmptyMacrosWrapper() {
        return new MacrosWrapper(new VlogLanguageElement<String>(this.getLanguageKind().VIEW_NAME));
    }

    private Collection<VlogMacroInfo> getAllMacrosNoDuplicates(RfProject rfProject, SymbolCollectorConfigurator symbolConfigurator, IProgressMonitor monitor) {
        HashMap result = new HashMap();
        IRfMacroVisitor visitor = macroInfo -> {
            List<VlogMacroInfo> layers = macroInfo.getMacroZoneLayers();
            if (layers != null) {
                for (VlogMacroInfo layer : layers) {
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    if (symbolConfigurator != null && symbolConfigurator.shouldStopCollecting()) {
                        return false;
                    }
                    if (!this.shouldCollectMacro(layer, symbolConfigurator)) continue;
                    if (symbolConfigurator != null && !result.containsKey(layer.getName())) {
                        symbolConfigurator.countNewSymbol();
                    }
                    result.put(layer.getName(), layer);
                }
            }
            return true;
        };
        rfProject.visitMacros(visitor);
        return result.values();
    }

    private boolean shouldCollectMacro(VlogMacroInfo macro, SymbolCollectorConfigurator symbolConfigurator) {
        if (macro == null || macro.isPredefined() || macro.isUndef()) {
            return false;
        }
        if (symbolConfigurator == null) {
            return true;
        }
        if (!this.shouldCollectSymbol((ISymbolCollectorPrerequisite)macro, symbolConfigurator)) {
            return false;
        }
        if (symbolConfigurator.ignoreContentFilters()) {
            return true;
        }
        IProject project = symbolConfigurator.getProject();
        if (project == null) {
            return false;
        }
        ParserPath parserPath = macro.getMacroParserPath();
        if (parserPath == null) {
            return false;
        }
        List filters = DVTViewManager.getGuiFilters((IProject)project);
        return DVTVlogMacroGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.MACRO, (String)parserPath.toString(), (List)filters, (IProject)project, (String)macro.getName()) == DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED;
    }

    private MacrosWrapper computeMacrosWrapper(Collection<VlogMacroInfo> allMacros, RfProject rfProject, IRfFilterableTreeAccessor view, IProgressMonitor monitor) {
        try {
            IProject project = rfProject.getProject();
            List filters = DVTViewManager.getGuiFilters((IProject)project);
            MacrosWrapper result = this.newEmptyMacrosWrapper();
            LinkedHashMap macrosByCategory = result.getAllMacrosByCategory();
            LinkedHashMap<CategoryWrapper, TreeSet<Object>> categoryToMacroSet = new LinkedHashMap<CategoryWrapper, TreeSet<Object>>();
            VlogMacroType[] vlogMacroTypeArray = VlogMacroType.values();
            int n = vlogMacroTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                VlogMacroType vlogMacroType = vlogMacroTypeArray[n2];
                categoryToMacroSet.put(vlogMacroType.getCategoryWrapper(), new TreeSet<Object>(MACROS_COMPARATOR));
                ++n2;
            }
            for (VlogMacroInfo vlogMacroInfo : allMacros) {
                ParserPath parserPath;
                if (monitor.isCanceled()) break;
                VlogFileInstance fileInstance = vlogMacroInfo.getFileInstance();
                if (fileInstance == null || (parserPath = fileInstance.getParserPath()) == null) continue;
                String parserPathString = parserPath.toString();
                if (DVTVlogMacroGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.MACRO, (String)parserPathString, (List)filters, (IProject)project, (String)vlogMacroInfo.getName()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (!result.hasSearchedElementFiltered() && view != null && ViewsUtils.matchesPath((Object)new DVTTreeElementWrapper((Object)vlogMacroInfo), (IRfFilterableTreeAccessor)view)) {
                        result.setHasSearchedElementFiltered(true);
                    }
                    result.setHasGUIFilteredElements(true);
                    continue;
                }
                if (vlogMacroInfo.isIfndefGuard()) {
                    result.incrementNofIfndefGuard();
                } else if (vlogMacroInfo.isUndefConfigMacro()) {
                    result.incrementNofConfigUndefMacro();
                } else if (vlogMacroInfo.isDefinedConfigMacro()) {
                    result.incrementNofConfigDefinedMacro();
                } else {
                    result.incrementNofReplMacro();
                }
                result.incrementNofMacros();
                ((TreeSet)categoryToMacroSet.get(vlogMacroInfo.getCategory())).add(vlogMacroInfo);
            }
            for (Map.Entry entry : categoryToMacroSet.entrySet()) {
                macrosByCategory.put((IRfNamedElement)entry.getKey(), new ArrayList((Collection)entry.getValue()));
                ((TreeSet)entry.getValue()).clear();
            }
            categoryToMacroSet.clear();
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.newEmptyMacrosWrapper();
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfNamedElement || adapted instanceof VlogLanguageElement || adapted instanceof DVTTreeElementWrapper && (((DVTTreeElementWrapper)adapted).getRfElement() instanceof RfNamedElement || ((DVTTreeElementWrapper)adapted).getRfElement() instanceof VlogLanguageElement);
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.labelProvider;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : namedElement.getComment();
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (wrapper == null || !(wrapper instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement tmp = (RfNamedElement)wrapper;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(tmp, project, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (!(rfElement instanceof VlogMacroInfo)) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.labelProvider.getText(element));
    }

    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator configurator) {
        if (configurator == null || configurator.isSymbolCollectionCanceled()) {
            return Collections.emptyList();
        }
        IProject project = configurator.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return Collections.emptyList();
        }
        Collection<VlogMacroInfo> allMacros = this.getAllMacrosNoDuplicates(rfProject, configurator, (IProgressMonitor)new NullProgressMonitor());
        if (allMacros == null || allMacros.isEmpty()) {
            return Collections.emptyList();
        }
        return this.computeMacrosPrerequisites(allMacros);
    }

    private List<ISymbolCollectorPrerequisite> computeMacrosPrerequisites(Collection<VlogMacroInfo> macros) {
        if (macros == null || macros.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<CategoryWrapper, TreeSet<Object>> categoryToMacroSet = new LinkedHashMap<CategoryWrapper, TreeSet<Object>>();
        VlogMacroType[] vlogMacroTypeArray = VlogMacroType.values();
        int n = vlogMacroTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VlogMacroType macroType = vlogMacroTypeArray[n2];
            categoryToMacroSet.put(macroType.getCategoryWrapper(), new TreeSet<Object>(MACROS_COMPARATOR));
            ++n2;
        }
        for (VlogMacroInfo macro : macros) {
            CategoryWrapper category = macro.getCategory();
            if (category == null) continue;
            ((TreeSet)categoryToMacroSet.get(category)).add(macro);
        }
        ArrayList<ISymbolCollectorPrerequisite> prerequisites = new ArrayList<ISymbolCollectorPrerequisite>(macros.size());
        for (TreeSet macroSet : categoryToMacroSet.values()) {
            prerequisites.addAll(macroSet);
        }
        return prerequisites;
    }

    public static class CategoryWrapper
    extends RfNamedElement {
        private static final long serialVersionUID = 1L;
        private VlogMacroType macroType;

        private CategoryWrapper(VlogMacroType type) {
            super(type.displayName, false);
            this.macroType = type;
        }

        @Override
        public String getSignature(RfTypesResolver resolver) {
            return this.macroType.displayName;
        }
    }

    public static enum VlogMacroType {
        REPLACEMENT("Defines"),
        DEF_CONFIGURATION("If(n)def Controls"),
        IFNDEF_GUARD("Ifndef Guards");

        private final String displayName;
        private final CategoryWrapper categoryWrapper;

        private VlogMacroType(String displayName) {
            this.displayName = displayName;
            this.categoryWrapper = new CategoryWrapper(this);
        }

        public CategoryWrapper getCategoryWrapper() {
            return this.categoryWrapper;
        }
    }
}

