/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewMessages;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.ui.views.semantic.HidHolderView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovercross;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.RfGUIEnclosingScopeUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.views.DHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VlogHHViewContributor;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtilCommon;

public class VlogQuickViewersUtil
extends VlogQuickViewersUtilCommon {
    private static VlogQuickViewersUtil fInstance;
    private static final Object fSyncInstance;
    private static Map<IFile, WaitEditorActiveJob> fWaitEditorJobs;
    private static final Object FAMILY_MODULE_REPARSE;
    private TreeItem fBestMatch;

    static {
        fSyncInstance = new Object();
        fWaitEditorJobs = new ConcurrentHashMap<IFile, WaitEditorActiveJob>();
        FAMILY_MODULE_REPARSE = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogQuickViewersUtil getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VlogQuickViewersUtil();
            }
        }
        return fInstance;
    }

    public void scheduleReparseIfNonTop(ITextEditor editor) {
        IProject project = Utils.getProject((ITextEditor)editor);
        if (project == null) {
            return;
        }
        if (BuildConfigManager.isNonTopFileCompilationDisabled((IProject)project)) {
            return;
        }
        IFile resource = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        if (resource == null) {
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)resource);
        if (parserPath == null) {
            return;
        }
        if (PreprocUtils.getInstance().shouldSkipCompilation(project, parserPath)) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        RfMixedLangProject rfMixedProject = rfProject.getMixedLangProjectParent();
        if (rfMixedProject == null) {
            return;
        }
        if (RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !rfMixedProject.isBuildDone()) {
            return;
        }
        if (!RfProjectState.BUILT.equals((Object)rfProject.getProjectState()) && !RfProjectState.RESTORED.equals((Object)rfProject.getProjectState())) {
            return;
        }
        boolean isCompiled = rfProject.isCompiled(parserPath);
        if (isCompiled) {
            return;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)resource);
        if (fileDef == null && !this.isWaitEditorJobScheduled(resource)) {
            WaitEditorActiveJob fWaitEditorJob = new WaitEditorActiveJob();
            fWaitEditorJob.setFile(resource);
            fWaitEditorJobs.put(resource, fWaitEditorJob);
            fWaitEditorJob.schedule(0L);
        }
    }

    private boolean isWaitEditorJobScheduled(IFile file) {
        if (file == null) {
            return false;
        }
        return fWaitEditorJobs.containsKey(file);
    }

    public void removeWaitEditorJob(IFile file) {
        if (file == null) {
            return;
        }
        fWaitEditorJobs.remove(file);
    }

    public TreeItem getSymbolAtLine(Tree tree, int line) {
        TreeItem item = this.getSymbolChildAtLine(tree, line);
        if (item == null) {
            item = this.fBestMatch;
        }
        return item;
    }

    private TreeItem getSymbolChildAtLine(Object parent, int line) {
        TreeItem[] items = null;
        if (parent instanceof Tree) {
            items = ((Tree)parent).getItems();
        } else if (parent instanceof TreeItem) {
            items = ((TreeItem)parent).getItems();
        }
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                Object data;
                TreeItem item = items[i];
                if (!item.isDisposed() && (data = item.getData()) != null) {
                    Object element = ((RfTreeElementWrapper)((Object)data)).getRfElement();
                    if (element == null || !(element instanceof RfDefElement)) {
                        return null;
                    }
                    RfDefElement os = (RfDefElement)element;
                    if (line == os.getStartLine()) {
                        return item;
                    }
                    if (os.getStartLine() < line && (this.fBestMatch == null || this.fBestMatch.isDisposed() || ((RfDefElement)((RfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() > line || ((RfDefElement)((RfTreeElementWrapper)((Object)this.fBestMatch.getData())).getRfElement()).getStartLine() < os.getStartLine())) {
                        this.fBestMatch = item;
                    }
                    if ((item = this.getSymbolChildAtLine(item, line)) != null) {
                        return item;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static Comparator<IDVTElementWrapper> getSortByTypeComparator(final VlogLabelProvider labelProvider) {
        return new Comparator<IDVTElementWrapper>(){

            public COMPARATOR_TYPES category(IDVTElementWrapper wrapper) {
                if (wrapper instanceof RfTreeElementWrapper) {
                    Object elem = wrapper.getRfElement();
                    if (elem instanceof RfPackage) {
                        return COMPARATOR_TYPES.PACKAGE;
                    }
                    if (elem instanceof RfTypeAlias) {
                        return COMPARATOR_TYPES.TYPE_ALIAS;
                    }
                    if (elem instanceof RfFunction) {
                        return COMPARATOR_TYPES.FUNCTION;
                    }
                    if (elem instanceof RfInterface) {
                        return COMPARATOR_TYPES.INTERFACE;
                    }
                    if (elem instanceof RfProgram) {
                        return COMPARATOR_TYPES.PROGRAM;
                    }
                    if (elem instanceof RfClass) {
                        return COMPARATOR_TYPES.CLASS;
                    }
                    if (elem instanceof RfModule) {
                        return COMPARATOR_TYPES.MODULE;
                    }
                    if (elem instanceof RfCovergroup) {
                        return COMPARATOR_TYPES.COVEGROUP;
                    }
                    if (elem instanceof RfPropertySequence) {
                        return COMPARATOR_TYPES.PROPERTY_SEQUENCE;
                    }
                    if (elem instanceof RfChecker) {
                        return COMPARATOR_TYPES.CHECKER;
                    }
                    if (elem instanceof RfConstraint) {
                        return COMPARATOR_TYPES.CONSTRAINT;
                    }
                    if (elem instanceof RfAssertExpect) {
                        RfAssertExpect assertExpect = (RfAssertExpect)elem;
                        if (assertExpect.isAssume()) {
                            if (assertExpect.isConcurrentAssertionStatement()) {
                                return COMPARATOR_TYPES.CONCURRENT_ASSUMPTION;
                            }
                            if (assertExpect.isDeferred()) {
                                return COMPARATOR_TYPES.IMMEDIATE_ASSUMPTION_DEFERRED;
                            }
                            return COMPARATOR_TYPES.IMMEDIATE_ASSUMPTION;
                        }
                        if (assertExpect.isAssert()) {
                            if (assertExpect.isConcurrentAssertionStatement()) {
                                return COMPARATOR_TYPES.CONCURRENT_ASSERTION;
                            }
                            if (assertExpect.isDeferred()) {
                                return COMPARATOR_TYPES.IMMEDIATE_ASSERTION_DEFERRED;
                            }
                            return COMPARATOR_TYPES.IMMEDIATE_ASSERTION;
                        }
                    }
                    if (elem instanceof RfCovercross) {
                        return COMPARATOR_TYPES.COVER_CROSS;
                    }
                    if (elem instanceof RfCoverpoint) {
                        return COMPARATOR_TYPES.COVER_ITEM;
                    }
                    if (elem instanceof RfField) {
                        return COMPARATOR_TYPES.FIELD;
                    }
                }
                return COMPARATOR_TYPES.OTHER;
            }

            @Override
            public int compare(IDVTElementWrapper e1, IDVTElementWrapper e2) {
                int cat2;
                Object obj1 = e1.getRfElement();
                Object obj2 = e2.getRfElement();
                String treeName1 = ((RfTreeElementWrapper)e1).getTreeName();
                String treeName2 = ((RfTreeElementWrapper)e2).getTreeName();
                if (obj1 instanceof String && obj2 instanceof String) {
                    return ((String)obj1).compareTo((String)obj2);
                }
                if (!(obj1 instanceof RfNamedElement) || !(obj2 instanceof RfNamedElement)) {
                    return 0;
                }
                int cat1 = this.category(e1).ordinal();
                if (cat1 != (cat2 = this.category(e2).ordinal())) {
                    return cat1 - cat2;
                }
                if (treeName1 != null && !treeName1.isEmpty() && treeName2 != null && !treeName2.isEmpty()) {
                    return treeName1.compareTo(treeName2);
                }
                return labelProvider.getText(e1).compareTo(labelProvider.getText(e2));
            }
        };
    }

    public static Comparator<IDVTElementWrapper> getSortByNameComparator(VlogLabelProvider labelProvider) {
        return (e1, e2) -> {
            Object obj1 = e1.getRfElement();
            Object obj2 = e2.getRfElement();
            String treeName1 = ((RfTreeElementWrapper)((Object)e1)).getTreeName();
            String treeName2 = ((RfTreeElementWrapper)((Object)e2)).getTreeName();
            if (treeName1 != null && !treeName1.isEmpty() && treeName2 != null && !treeName2.isEmpty()) {
                return treeName1.compareTo(treeName2);
            }
            if (obj1 instanceof RfNamedElement && obj2 instanceof RfNamedElement) {
                return ((RfNamedElement)obj1).getName().compareTo(((RfNamedElement)obj2).getName());
            }
            if (obj1 instanceof String && obj2 instanceof String) {
                return ((String)obj1).compareTo((String)obj2);
            }
            return 0;
        };
    }

    public void updateLayersView(RfClass currentClass, RfNamedElement namedElement, IProject project, DVTViewEvent.EventKind kind, String sourceId, boolean updateHistory, boolean forceVisible) {
        UpdateViewEvent updateEvent = VlogQuickViewersUtil.createViewUpdateEvent(namedElement, project, updateHistory ? 1 : 0);
        DVTViewEvent viewEvent = new DVTViewEvent(kind, sourceId, new ViewDataContainer(project, (HistoryItem)updateEvent));
        ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.LayersView", (DVTViewEvent)viewEvent, (boolean)forceVisible);
    }

    public void updateUVMSequenceTreeView(IRfNamedElement namedElement, IProject project, DVTViewEvent.EventKind kind, String sourceId, boolean updateHistory, boolean forceVisible) {
        UpdateViewEvent updateEvent = VlogQuickViewersUtil.createViewUpdateEvent(namedElement, project, updateHistory ? 5 : 0);
        DVTViewEvent viewEvent = new DVTViewEvent(kind, sourceId, new ViewDataContainer(project, (HistoryItem)updateEvent));
        ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.UVMSequenceTreeView", (DVTViewEvent)viewEvent, (boolean)forceVisible);
    }

    public void updateTypeHierarchyViewer(IRfNamedElement namedElement, IProject project, DVTViewEvent.EventKind kind, String sourceId, boolean updateHistory, boolean forceVisible) {
        try {
            if (namedElement instanceof RfField) {
                namedElement = ((RfField)namedElement).getAssociatedType();
            } else if (!(namedElement instanceof RfClass)) {
                return;
            }
            if (namedElement == null) {
                return;
            }
            UpdateViewEvent updateEvent = VlogQuickViewersUtil.createViewUpdateEvent(namedElement, project, updateHistory ? 2 : 0);
            DVTViewEvent viewEvent = new DVTViewEvent(kind, sourceId, new ViewDataContainer(project, (HistoryItem)updateEvent));
            ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.TypeHierarchyView", (DVTViewEvent)viewEvent, (boolean)forceVisible);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateCallHierarchyViewer(IRfNamedElement namedElement, IProject project, DVTViewEvent.EventKind kind, String sourceId, boolean updateHistory, boolean forceVisible) {
        try {
            if (!(namedElement instanceof RfFunction)) {
                return;
            }
            UpdateViewEvent updateEvent = VlogQuickViewersUtil.createViewUpdateEvent(namedElement, project, updateHistory ? 6 : 0);
            DVTViewEvent viewEvent = new DVTViewEvent(kind, sourceId, new ViewDataContainer(project, (HistoryItem)updateEvent));
            ViewsUtils.notifyViewById((String)"ro.amiq.dvt.ui.views.CallHierarchyView", (DVTViewEvent)viewEvent, (boolean)forceVisible);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static int matchTypeForDesignHierarchyViewer(IRfNamedElement namedElement) {
        if (namedElement instanceof RfModule) {
            return 128;
        }
        if (namedElement instanceof RfProgram) {
            return 256;
        }
        if (namedElement instanceof RfInterface) {
            return 512;
        }
        if (namedElement instanceof RfChecker) {
            return 8192;
        }
        if (namedElement instanceof RfField && ((RfField)namedElement).isInstance()) {
            return 1024;
        }
        if (namedElement != null && !(namedElement instanceof RfNamedElement)) {
            return 65536;
        }
        return 0;
    }

    public void updateVerificationHierarchyViewer(IRfNamedElement namedElement, IProject project, boolean saveAsHistoryItem) {
        if (namedElement == null || project == null) {
            return;
        }
        RfElementPath xvmObjectQName = null;
        if (namedElement instanceof RfField) {
            RfField field = (RfField)namedElement;
            namedElement = field.getAssociatedType();
        }
        HashSet<IRfNamedElement> visited = new HashSet<IRfNamedElement>();
        visited.add(namedElement);
        while (namedElement instanceof IRfListType || namedElement instanceof IRfTypeAliasElement) {
            if (visited.contains(namedElement = ((IRfAssociatedTypeElement)namedElement).getAssociatedType())) break;
            visited.add(namedElement);
        }
        if (namedElement instanceof RfClass) {
            xvmObjectQName = RfElementPath.path((IRfNamedElement)namedElement);
        }
        if (xvmObjectQName == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextSV);
            return;
        }
        HistoryItem item = VHHistoryItem.parseHistoryItem(project.getName(), xvmObjectQName);
        if (item == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextSV);
            return;
        }
        VerificationHierarchyView view = (VerificationHierarchyView)ViewsUtils.getViewById((String)"ro.amiq.dvt.ui.views.VerificationHierarchyView", (boolean)true);
        if (view == null) {
            return;
        }
        view.setUpAndUpdate(item, saveAsHistoryItem);
    }

    public IRfNamedElement getElementAtExactCursor() {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        IDocument document = Utils.getDocumentFromEditor((ITextEditor)((ITextEditor)editor));
        if (document == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        int offset = ((DVTEditor)editor).getCursor();
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, file, document, offset, (DVTEditor)editor);
        if (namedElementAndScope != null) {
            return namedElementAndScope.getIRfNamedElement();
        }
        return null;
    }

    private IRfNamedElement getElementAtVagueCursor() {
        IEditorPart editor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(editor instanceof DVTEditor)) {
            return null;
        }
        DVTEditor dvtEditor = (DVTEditor)editor;
        IRfScope scope = RfGUIEnclosingScopeUtils.getScope((ITextEditor)dvtEditor, dvtEditor.getCursor(), true, true, null);
        if (!(scope instanceof RfDefElement)) {
            return null;
        }
        return ((RfDefElement)scope).getNamedElement();
    }

    public void openVerificationHierarchyForElementAtCursor() {
        IRfNamedElement namedElement = this.getElementAtExactCursor();
        if (namedElement == null) {
            VHViewUtils.popDialog((int)2, (String)VHViewMessages.fVHPopUpDialogTextSV);
            return;
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.updateVerificationHierarchyViewer(namedElement, rfProject.getProject(), true);
    }

    public void openHidHolderForElementAtCursor() {
        ViewDataContainer data = new ViewDataContainer(null, null);
        IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        IRfNamedElement namedElement = this.getElementAtVagueCursor();
        if (namedElement instanceof RfNamedElement && namedElement.getRfProject() != null) {
            project = namedElement.getRfProject().getProject();
            data.setHistoryItem((HistoryItem)new VlogHHViewContributor.VlogHHHistoryItem(RfElementPath.path((IRfNamedElement)namedElement), project));
        }
        data.setProject(project);
        HidHolderView view = (HidHolderView)ViewsUtils.getViewById((String)"ro.amiq.dvt.tests.ui.views.HidHolderView", (boolean)true);
        if (view == null) {
            return;
        }
        view.setInput(data);
        view.update(null);
    }

    public HistoryItem createDHHistoryItem(DVTXmlSaveConfig config, IProject project, boolean isElab, HistoryItemType historyItemType) {
        if (project == null) {
            return null;
        }
        String inputElementName = config.getInputElementName();
        String inputConfigurationName = isElab ? null : config.getInputConfigurationName();
        List inputElementScope = config.getElementScope();
        String label = "[" + project.getName() + "] ";
        if (historyItemType == HistoryItemType.SHOW_INSTANCES_IN_DESIGN_HIERARCHY) {
            label = String.valueOf(label) + "Instances of ";
        }
        if (config.getTreePath() != null) {
            label = String.valueOf(label) + inputElementName + " (" + config.getTreePath().toString() + ")";
            return new DHHistoryItem(label, project.getName(), inputElementName, inputConfigurationName, inputElementScope, historyItemType);
        }
        label = String.valueOf(label) + inputElementName;
        return new DHHistoryItem(label, project.getName(), inputElementName, inputConfigurationName, inputElementScope, historyItemType);
    }

    public static enum COMPARATOR_TYPES {
        PACKAGE,
        TYPE_ALIAS,
        FUNCTION,
        INTERFACE,
        CHECKER,
        PROGRAM,
        CLASS,
        MODULE,
        COVEGROUP,
        PROPERTY_SEQUENCE,
        CONSTRAINT,
        CONCURRENT_ASSERTION,
        IMMEDIATE_ASSERTION,
        IMMEDIATE_ASSERTION_DEFERRED,
        CONCURRENT_ASSUMPTION,
        IMMEDIATE_ASSUMPTION,
        IMMEDIATE_ASSUMPTION_DEFERRED,
        COVER_CROSS,
        COVER_ITEM,
        FIELD,
        OTHER;

    }

    static class WaitEditorActiveJob
    extends Job {
        private IFile fFile;

        public WaitEditorActiveJob() {
            super("Wait Editor");
            this.setPriority(50);
            this.setSystem(true);
        }

        public void setFile(IFile file) {
            this.fFile = file;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_MODULE_REPARSE;
        }

        public boolean shouldSchedule() {
            boolean shouldSchedule;
            boolean bl = shouldSchedule = super.shouldSchedule() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldSchedule) {
                fWaitEditorJobs.remove(this.fFile);
            }
            return shouldSchedule;
        }

        public boolean shouldRun() {
            boolean shouldRun;
            boolean bl = shouldRun = super.shouldRun() && ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (!shouldRun) {
                fWaitEditorJobs.remove(this.fFile);
            }
            return shouldRun;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    IVlogModule vlogFile = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(this.fFile);
                    vlogFile.scheduleReparse(false, true, 0L, true);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    fWaitEditorJobs.remove(this.fFile);
                }
            }
            finally {
                fWaitEditorJobs.remove(this.fFile);
            }
            return Status.OK_STATUS;
        }
    }
}

