/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfScalarType;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

public class VlogQuickViewersUtilCommon {
    public static IRfNamedElement getNamedElementForDH(IRfNamedElement elementAtCursor) {
        return DesignUtils.toGenericDesignElement((IRfNamedElement)elementAtCursor);
    }

    public static IRfNamedElement getEnclosingFunctionOrClass(IRfScope initialScope, boolean ignoreFunctions) {
        if (!(initialScope instanceof IRfDefElement)) {
            return null;
        }
        RfNamedElement scope = (RfNamedElement)((IRfDefElement)initialScope).getNamedElement();
        if (scope == null) {
            return null;
        }
        do {
            if (!ignoreFunctions && scope instanceof RfFunction) {
                return scope;
            }
            if (!(scope instanceof RfClass)) continue;
            return scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public static UpdateViewEvent createViewUpdateEvent(String text, String projectName, String elementName, List<? extends DVTRfNameTypeScopeHelper> elementScope, int elementType, int updateHistory) {
        return new UpdateViewEvent(text, projectName, elementType, elementName, elementScope, LanguageKind.VLOG, updateHistory);
    }

    public static UpdateViewEvent createViewUpdateEvent(IRfNamedElement source, IProject project, int updateHistory) {
        String sig;
        String info = "";
        if (source != null && (sig = source.getSignature()) != null) {
            info = sig.replace("\n", "");
        }
        return VlogQuickViewersUtilCommon.createViewUpdateEvent(info, source, project, updateHistory);
    }

    public static UpdateViewEvent createViewUpdateEvent(String text, IRfNamedElement source, IProject project, int updateHistory) {
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
        }
        String elementName = null;
        List<? extends DVTRfNameTypeScopeHelper> elementScope = null;
        if (source != null) {
            elementName = source.getName();
            elementScope = RfScopeUtil.getDefOfScopeElement((IRfScopeElement)source);
        }
        int elementType = VlogQuickViewersUtilCommon.getType(source);
        return new UpdateViewEvent(text, projectName, elementType, elementName, elementScope, LanguageKind.VLOG, updateHistory);
    }

    public static int getType(IRfNamedElement source) {
        if (source instanceof RfModule) {
            return 128;
        }
        if (source instanceof RfProgram) {
            return 256;
        }
        if (source instanceof RfInterface) {
            return 512;
        }
        if (source instanceof RfPackage) {
            return 2048;
        }
        if (source instanceof RfPrimitive) {
            return 4096;
        }
        if (source instanceof RfClass) {
            return 1;
        }
        if (source instanceof RfInstance) {
            return 1024;
        }
        if (source instanceof RfField && ((RfField)source).isEvent()) {
            return 16;
        }
        if (source instanceof RfFunction && ((RfFunction)source).isTask()) {
            return 8;
        }
        if (source instanceof RfFunction) {
            return 4;
        }
        if (source instanceof RfConstraint) {
            return 32768;
        }
        if (source instanceof RfScalarType) {
            return 64;
        }
        if (source instanceof VlogMacroInfo) {
            return 32;
        }
        if (source instanceof RfChecker) {
            return 8192;
        }
        if (source instanceof RfField) {
            return 2;
        }
        return 0;
    }
}

