/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.IInspectViewInputContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.registers.RegistersView;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegBlock;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;

public class VlogRegistersInspectViewContributor
implements IInspectViewInputContributor {
    public boolean canHandle(SelectionChangedEvent event) {
        return event.getSource() instanceof RegistersView;
    }

    public InspectViewInput getInput(InspectViewUpdateEvent event) {
        if (event == null) {
            return null;
        }
        if (event.getType() != InspectViewUpdateEventCommon.TYPE.WRAPPER) {
            return null;
        }
        IDVTElementWrapper wrapper = (IDVTElementWrapper)event.getElement();
        IProject project = event.getProject();
        if (project == null) {
            return null;
        }
        if (!this.c(project)) {
            return null;
        }
        Object obj = wrapper.getRfElement();
        if (obj instanceof TreePath) {
            obj = ((TreePath)obj).getElement();
        }
        if (!(obj instanceof XXVMRegBlock)) {
            return null;
        }
        XXVMRegBlock regBlock = (XXVMRegBlock)obj;
        if (!regBlock.isBlockRegisters()) {
            return null;
        }
        ArrayList<InspectViewGoToInfo> infos = new ArrayList<InspectViewGoToInfo>();
        List<RfXvmFactory.XVMCreateCall> createCalls = regBlock.getCreateCalls();
        if (createCalls != null && !createCalls.isEmpty()) {
            for (RfXvmFactory.XVMCreateCall xvmCreateCall : createCalls) {
                GoToInfo[] goTos = xvmCreateCall.getGoTos();
                if (goTos == null || goTos.length == 0) continue;
                int i = 0;
                while (i < goTos.length) {
                    infos.add(new InspectViewGoToInfo(goTos[i]));
                    ++i;
                }
            }
        } else {
            GoToInfo goToInfo = regBlock.getGoToInfo();
            if (goToInfo != null) {
                infos.add(new InspectViewGoToInfo(goToInfo));
            }
        }
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        return DVTInspectViewUtils.getInstance().processGoToInfos(infos, project, LanguageKind.VLOG);
    }

    private boolean c(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F7376");
    }
}

