/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.LimitExceededException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEvent;
import ro.amiq.dvt.ui.views.lazy.tree.DVTModelEventType;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModelStateListener;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.registers.IRegistersViewContributor;
import ro.amiq.dvt.ui.views.registers.RegistersView;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegBlock;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegister;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidImplicitLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.views.IVlogRegistersViewContributor;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtilsCommon;

public abstract class VlogRegistersViewContributorCommon
implements IVlogRegistersViewContributor {
    private List<IDVTModelStateListener> stateListeners = new ArrayList<IDVTModelStateListener>();
    private static final String RIGHTS = "rights";
    private static final String ADD_REG = "add_reg";
    private long totalRegisterCount;
    private List<RfXvmObjectInstance> xvmRegisterRoots;
    private final Map<IProject, VlogRegistersCache> cache = new HashMap<IProject, VlogRegistersCache>();

    public void sortRegisters(List<IXXVMRegBlock> regs, boolean sortByName) {
        IRegistersViewContributor.sortRegistersListByName(regs);
    }

    private synchronized VlogRegistersCache getOrComputeProjectCache(IProject project) {
        VlogRegistersCache projectCache = this.cache.get(project);
        if (projectCache != null) {
            return projectCache.init();
        }
        projectCache = new VlogRegistersCache(project);
        this.cache.put(project, projectCache.init());
        return projectCache;
    }

    public void resetState() {
        for (VlogRegistersCache projectCache : this.cache.values()) {
            if (projectCache == null) continue;
            projectCache.clean();
        }
        this.cache.clear();
        this.xvmRegisterRoots = null;
        this.totalRegisterCount = 0L;
    }

    public List<? extends IXXVMRegBlock> computeRegistersModelTree(IProject project, IProgressMonitor monitor) {
        this.totalRegisterCount = 0L;
        ArrayList<XXVMRegBlock> regBlocks = new ArrayList<XXVMRegBlock>();
        RfXvmFactory xvmFactory = RfVHUtils.getXvmFactory(project);
        if (xvmFactory == null || !xvmFactory.isInitDone()) {
            return Collections.emptyList();
        }
        if (this.xvmRegisterRoots == null) {
            this.xvmRegisterRoots = this.internalComputeXVMRegisterRoots(project, monitor);
        }
        for (RfXvmObjectInstance rootBase : this.xvmRegisterRoots) {
            RfXvmObject registeredObject;
            XXVMRegBlock parentRegBlock = null;
            RfXvmObject rfXvmObject = rootBase.getObject();
            parentRegBlock = VlogRegistersViewContributorCommon.xvmInstanceToBlock(rootBase, null);
            if (parentRegBlock == null || rfXvmObject == null || (registeredObject = xvmFactory.getRegisteredObject(rfXvmObject.getRfClass())) == null) continue;
            this.recursiveComputeRegistersTree(parentRegBlock, project);
            regBlocks.add(parentRegBlock);
        }
        return regBlocks;
    }

    private void recursiveComputeRegistersTree(XXVMRegBlock parentRegBlock, IProject project) {
        VlogRegistersCache projectCache = this.getOrComputeProjectCache(project);
        RfClass xvmRegBlock = VlogRegistersCache.getXvmRegBlock(projectCache);
        RfClass xvmReg = VlogRegistersCache.getXvmReg(projectCache);
        RfXvmFactory xvmFactory = RfVHUtils.getXvmFactory(project);
        if (xvmFactory == null || !xvmFactory.isInitDone()) {
            return;
        }
        IRfNamedElement namedElement = parentRegBlock.getRfClass();
        RfXvmObject registeredObject = xvmFactory.getRegisteredObject((RfClass)namedElement);
        if (registeredObject == null) {
            return;
        }
        List<RfXvmObjectInstance> childInstances = RfXvmFactory.getChildInstances(registeredObject);
        for (RfXvmObjectInstance child : childInstances) {
            RfXvmObject object = child.getObject();
            RfClass rfClass = object.getRfClass();
            if (rfClass.isChildOfClass(xvmRegBlock)) {
                XXVMRegBlock childRegBlock = VlogRegistersViewContributorCommon.xvmInstanceToBlock(child, parentRegBlock);
                this.recursiveComputeRegistersTree(childRegBlock, project);
                parentRegBlock.addChildren(childRegBlock);
                continue;
            }
            if (!rfClass.isChildOfClass(xvmReg)) continue;
            parentRegBlock.addChildren(VlogRegistersViewContributorCommon.xvmInstanceToRegister(child, null, parentRegBlock));
            ++this.totalRegisterCount;
        }
        IRegistersViewContributor.sortRegistersListByName(parentRegBlock.getChildren());
    }

    public List<TreePath> createRootTreePath(IProgressMonitor monitor, IProject project) {
        if (this.xvmRegisterRoots == null) {
            this.xvmRegisterRoots = this.internalComputeXVMRegisterRoots(project, monitor);
        }
        if (this.xvmRegisterRoots == null || this.xvmRegisterRoots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        int index = 0;
        for (RfXvmObjectInstance rootBase : this.xvmRegisterRoots) {
            XXVMRegBlock xvmBlock = VlogRegistersViewContributorCommon.xvmInstanceToBlock(rootBase, null);
            TreePath xvmRegPath = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)xvmBlock.getRegisterFullName(), (int)index++);
            xvmRegPath.setElement((Object)xvmBlock);
            result.add(xvmRegPath);
        }
        return result;
    }

    private List<RfXvmObjectInstance> internalComputeXVMRegisterRoots(IProject project, IProgressMonitor monitor) {
        RfXvmFactory xvmFactory = RfVHUtils.getXvmFactory(project);
        if (xvmFactory == null || !xvmFactory.isInitDone()) {
            return null;
        }
        VlogRegistersCache projectCache = this.getOrComputeProjectCache(project);
        RfClass xvmReg = VlogRegistersCache.getXvmReg(projectCache);
        RfClass xvmRegBlock = VlogRegistersCache.getXvmRegBlock(projectCache);
        if (xvmReg == null || xvmRegBlock == null) {
            return null;
        }
        IdentityHashMap registerModels = new IdentityHashMap();
        IdentityHashMap<RfXvmObject, List<RfXvmObjectInstance>> xvmInstancesMap = new IdentityHashMap<RfXvmObject, List<RfXvmObjectInstance>>();
        LinkedHashSet<RfClass> children = new LinkedHashSet<RfClass>();
        xvmRegBlock.getChildrenRecursive(children);
        if (children == null || children.isEmpty()) {
            return null;
        }
        HashSet<RfXvmObject> roots = new HashSet<RfXvmObject>();
        for (RfClass rfClass : children) {
            Object childInstances;
            List<RfXvmObjectInstance> xvmInstances;
            RfXvmObject object = xvmFactory.getRegisteredObject(rfClass);
            if (object == null || (xvmInstances = ((VlogVHBreadcrumbUtilsCommon)VlogVHBreadcrumbUtils.getInstance()).computeXVMInstances(XVlogContributorUtils.xGetRfProject(project), object, Integer.MAX_VALUE, monitor)) == null || xvmInstances.isEmpty() || (childInstances = RfXvmFactory.getChildInstances(object)) == null || childInstances.isEmpty()) continue;
            ArrayList<RfXvmObjectInstance> regBlocksInstances = new ArrayList<RfXvmObjectInstance>();
            Iterator iterator = childInstances.iterator();
            while (iterator.hasNext()) {
                RfXvmObjectInstance instance = (RfXvmObjectInstance)iterator.next();
                RfClass rfClass2 = instance.getObject().getRfClass();
                if (rfClass2 == null || !rfClass2.isChildOfClass(xvmRegBlock) || rfClass2.isChildOfClass(xvmReg)) continue;
                regBlocksInstances.add(instance);
            }
            roots.add(object);
            registerModels.put(object, regBlocksInstances);
            xvmInstancesMap.put(object, xvmInstances);
        }
        if (registerModels.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : new LinkedHashSet(registerModels.entrySet())) {
            List subModels = (List)entry.getValue();
            if (subModels == null || subModels.isEmpty()) continue;
            for (RfXvmObjectInstance subInstance : subModels) {
                try {
                    this.removeSubInstances(xvmReg, xvmRegBlock, roots, subInstance.getObject(), 0);
                }
                catch (LimitExceededException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        ArrayList arrayList = new ArrayList(roots);
        arrayList.sort((r1, r2) -> r1.getName().compareTo(r2.getName()));
        ArrayList xvmRegBlockInstances = new ArrayList();
        this.totalRegisterCount = 0L;
        for (RfXvmObject rfXvmObject : arrayList) {
            List xvmInstances = (List)xvmInstancesMap.get(rfXvmObject);
            if (xvmInstances == null || xvmInstances.isEmpty()) continue;
            xvmRegBlockInstances.addAll(xvmInstances);
            try {
                this.totalRegisterCount += (long)xvmInstances.size() * this.countInnerRegisters((RfXvmObjectInstance)xvmInstances.get(0), xvmRegBlock, xvmReg, 0);
            }
            catch (LimitExceededException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        this.notifyStateListeners(new DVTModelEvent(DVTModelEventType.MODEL_COMPUTING_DONE));
        ArrayList<RfXvmObjectInstance> xvmObjectBases = new ArrayList<RfXvmObjectInstance>();
        Collections.sort(xvmRegBlockInstances, (c1, c2) -> c1.getName().compareTo(c2.getName()));
        xvmObjectBases.addAll(xvmRegBlockInstances);
        return xvmObjectBases;
    }

    private long countInnerRegisters(RfXvmObjectInstance parentInstance, RfClass xvmRegBlock, RfClass xvmReg, int count) throws LimitExceededException {
        if (count >= Integer.MAX_VALUE) {
            throw new LimitExceededException("Limit excedeed while counting registers model roots!");
        }
        if (parentInstance == null) {
            return 0L;
        }
        RfXvmObject parentObject = parentInstance.getObject();
        if (parentObject == null) {
            return 0L;
        }
        List<RfXvmObjectInstance> childInstances = RfXvmFactory.getChildInstances(parentObject);
        if (childInstances == null || childInstances.isEmpty()) {
            return 0L;
        }
        long currentNo = 0L;
        for (RfXvmObjectInstance instance : childInstances) {
            RfXvmObject object = instance.getObject();
            if (object == null || object.getRfClass() == null) continue;
            RfClass rfClass = object.getRfClass();
            if (rfClass.isChildOfClass(xvmRegBlock) && !rfClass.isChildOfClass(xvmReg)) {
                currentNo += this.countInnerRegisters(instance, xvmRegBlock, xvmReg, ++count);
                continue;
            }
            if (!rfClass.isChildOfClass(xvmReg)) continue;
            ++currentNo;
        }
        return currentNo;
    }

    private void removeSubInstances(RfClass xvmReg, RfClass xvmRegBlock, Set<RfXvmObject> roots, RfXvmObject object, int count) throws LimitExceededException {
        if (count >= Integer.MAX_VALUE) {
            throw new LimitExceededException("Limit excedeed while computing registers model roots!");
        }
        roots.remove(object);
        List<RfXvmObjectInstance> childInstances = RfXvmFactory.getChildInstances(object);
        if (childInstances == null || childInstances.isEmpty()) {
            return;
        }
        for (RfXvmObjectInstance instance : childInstances) {
            RfXvmObject objInstance = instance.getObject();
            RfClass rfClass = objInstance.getRfClass();
            if (rfClass == null || !rfClass.isChildOfClass(xvmRegBlock) || rfClass.isChildOfClass(xvmReg)) continue;
            this.removeSubInstances(xvmReg, xvmRegBlock, roots, objInstance, ++count);
        }
    }

    public List<XXVMRegister> computeRegistersModelFlat(IProject project, IProgressMonitor monitor) {
        if (this.xvmRegisterRoots == null) {
            this.xvmRegisterRoots = this.internalComputeXVMRegisterRoots(project, monitor);
        }
        if (this.xvmRegisterRoots == null || this.xvmRegisterRoots.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<RfXvmObjectInstance, HashMap<String, RfXvmObjectInstance>> leafs = new LinkedHashMap<RfXvmObjectInstance, HashMap<String, RfXvmObjectInstance>>();
        for (RfXvmObjectInstance rfXvmInstace : this.xvmRegisterRoots) {
            List<RfXvmObjectInstance> childInstances = RfXvmFactory.getChildInstances(rfXvmInstace.getObject());
            if (childInstances == null || childInstances.isEmpty()) continue;
            ArrayDeque<String> currentPath = new ArrayDeque<String>();
            currentPath.add(rfXvmInstace.getName());
            HashMap<String, RfXvmObjectInstance> modelRegisterLeafs = new HashMap<String, RfXvmObjectInstance>();
            try {
                this.internalComputeRegisterLeafs(childInstances, modelRegisterLeafs, currentPath, 0, project, monitor);
            }
            catch (LimitExceededException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            leafs.put(rfXvmInstace, modelRegisterLeafs);
        }
        ArrayList<XXVMRegister> registers = new ArrayList<XXVMRegister>();
        for (Map.Entry leafsEntry : leafs.entrySet()) {
            ArrayList<XXVMRegister> localRegisters = new ArrayList<XXVMRegister>();
            Map instancesMap = (Map)leafsEntry.getValue();
            if (instancesMap == null || instancesMap.isEmpty()) continue;
            for (Map.Entry instanceEntry : instancesMap.entrySet()) {
                String fullName = (String)instanceEntry.getKey();
                RfXvmObjectInstance instance = (RfXvmObjectInstance)instanceEntry.getValue();
                XXVMRegister register = VlogRegistersViewContributorCommon.xvmInstanceToRegister(instance, fullName, null);
                register.setCreateCalls(instance.getCreateCalls());
                localRegisters.add(register);
            }
            Collections.sort(localRegisters, (r1, r2) -> r1.getRegisterFullName().compareTo(r2.getRegisterFullName()));
            registers.addAll(localRegisters);
            this.totalRegisterCount = registers.size();
            this.notifyStateListeners(new DVTModelEvent(DVTModelEventType.MODEL_COMPUTING_DONE));
        }
        return registers;
    }

    private void internalComputeRegisterLeafs(List<RfXvmObjectInstance> xvmRegBlockInstances, Map<String, RfXvmObjectInstance> leafs, Deque<String> currentPath, int depth, IProject project, IProgressMonitor monitor) throws LimitExceededException {
        if (depth >= Integer.MAX_VALUE) {
            throw new LimitExceededException("Limit exceeded when trying to compute register leafs");
        }
        if (monitor.isCanceled()) {
            return;
        }
        VlogRegistersCache projectCache = this.getOrComputeProjectCache(project);
        RfClass xvmRegBlock = VlogRegistersCache.getXvmRegBlock(projectCache);
        RfClass xvmReg = VlogRegistersCache.getXvmReg(projectCache);
        if (xvmReg == null || xvmRegBlock == null) {
            return;
        }
        for (RfXvmObjectInstance rfXvmInstance : xvmRegBlockInstances) {
            List<RfXvmObjectInstance> childInstances;
            if (monitor.isCanceled()) {
                return;
            }
            currentPath.add(rfXvmInstance.getName());
            if (monitor.isCanceled()) {
                return;
            }
            RfClass rfClass = rfXvmInstance.getObject().getRfClass();
            if (rfClass == null) continue;
            if (rfClass.isChildOfClass(xvmReg)) {
                ArrayList<String> path = new ArrayList<String>(currentPath);
                String registerPath = DVTStringUtil.join(path, (String)".");
                leafs.put(registerPath, rfXvmInstance);
                currentPath.removeLast();
                continue;
            }
            if (rfClass.isChildOfClass(xvmRegBlock) && (childInstances = RfXvmFactory.getChildInstances(rfXvmInstance.getObject())) != null && !childInstances.isEmpty()) {
                this.internalComputeRegisterLeafs(childInstances, leafs, currentPath, ++depth, project, monitor);
            }
            currentPath.removeLast();
        }
    }

    public List<Object> getChildrenForElement(Object top, boolean sortByName, IProject project, IProgressMonitor monitor) {
        if (!this.c(project)) {
            return null;
        }
        RfXvmFactory xvmFactory = RfVHUtils.getXvmFactory(project);
        if (xvmFactory == null || !xvmFactory.isInitDone()) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (monitor.isCanceled()) {
            return null;
        }
        VlogRegistersCache projectCache = this.getOrComputeProjectCache(project);
        RfClass xvmRegBlock = VlogRegistersCache.getXvmRegBlock(projectCache);
        RfClass xvmReg = VlogRegistersCache.getXvmReg(projectCache);
        if (xvmReg == null || xvmRegBlock == null) {
            return null;
        }
        if (!(top instanceof IXXVMRegBlock)) {
            return Collections.emptyList();
        }
        RfXvmObject registeredObject = xvmFactory.getRegisteredObject((RfClass)((IXXVMRegBlock)top).getRfClass());
        if (registeredObject == null) {
            return result;
        }
        List<RfXvmObjectInstance> childInstances = RfXvmFactory.getChildInstances(registeredObject);
        for (RfXvmObjectInstance childInstance : childInstances) {
            if (monitor.isCanceled()) {
                return result;
            }
            RfXvmObject object = childInstance.getObject();
            RfClass rfClass = object.getRfClass();
            if (rfClass == null) continue;
            if (rfClass.isChildOfClass(xvmRegBlock)) {
                result.add(VlogRegistersViewContributorCommon.xvmInstanceToBlock(childInstance, (IXXVMRegBlock)top));
                continue;
            }
            if (!rfClass.isChildOfClass(xvmReg)) continue;
            result.add(VlogRegistersViewContributorCommon.xvmInstanceToRegister(childInstance, null, (IXXVMRegBlock)top));
        }
        IRegistersViewContributor.sortRegistersListByName(result);
        return result;
    }

    private static XXVMRegBlock xvmInstanceToBlock(RfXvmObjectInstance instance, IXXVMRegBlock parentBlock) {
        RfField field;
        XXVMRegBlock regBlock = new XXVMRegBlock(instance.getName(), parentBlock);
        RfXvmObject object = instance.getObject();
        if (object != null) {
            regBlock.setRfClass(object.getNamedElement());
        }
        if ((field = instance.getLHField()) != null) {
            regBlock.setRfNamedElement(field);
            regBlock.setComment(ViewsUtils.trimText((String)field.getComment(), (int)100, (boolean)true));
        }
        regBlock.setCreateCalls(instance.getCreateCalls());
        return regBlock;
    }

    private static XXVMRegister xvmInstanceToRegister(RfXvmObjectInstance instance, String fullName, IXXVMRegBlock parentBlock) {
        RfXvmObject object = instance.getObject();
        String regiterRights = "";
        RfField rfField = instance.getLHField();
        regiterRights = VlogRegistersViewContributorCommon.computeBitFieldRights(rfField);
        if (regiterRights != null && regiterRights.startsWith("\"") && regiterRights.endsWith("\"") && regiterRights.length() > 1) {
            regiterRights = regiterRights.substring(1, regiterRights.length() - 1);
        }
        XXVMRegister reg = new XXVMRegister(instance.getName(), fullName != null ? fullName : (rfField != null ? rfField.getFullNameLabel() : ""), ELParamValues.ParamValueNumber.of((DVTNumber)VlogBitVector.ZERO64), regiterRights, null, rfField != null ? rfField.getComment() : "", parentBlock, rfField, object.getRfClass());
        reg.setCreateCalls(instance.getCreateCalls());
        reg.setComment(ViewsUtils.trimText((String)(rfField != null ? rfField.getComment() : ""), (int)100, (boolean)true));
        return reg;
    }

    private static String computeBitFieldRights(RfField rfField) {
        if (rfField == null) {
            return "";
        }
        RfClass rfClass = rfField.getEnclosingScope(RfClass.class);
        if (rfClass == null) {
            return "";
        }
        Set<MethodCall> addRegMethodCalls = RfClass.getRegisterConfigureCalls(rfClass, ADD_REG);
        ELManager manager = new ELManager(rfClass.getRfProject().getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig((boolean)false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), (boolean)false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
        ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
        for (MethodCall addRegCall : addRegMethodCalls) {
            Iterator iterator;
            Map argumentValuesMapRaw = addRegCall.argumentValuesMapRaw;
            if (argumentValuesMapRaw == null || (iterator = argumentValuesMapRaw.values().iterator()) == null || !iterator.hasNext()) continue;
            IHidObject rgHid = (IHidObject)iterator.next();
            if (rgHid instanceof RfHidAccess) {
                rgHid = ((RfHidAccess)rgHid).getParentHid();
            }
            if (!(rgHid instanceof Hid)) continue;
            String name = ((Hid)rgHid).getName();
            if (!rfField.getName().equals(name)) continue;
            for (Map.Entry argument : argumentValuesMapRaw.entrySet()) {
                if (!RIGHTS.equals(((IRfFieldElement)argument.getKey()).getName())) continue;
                IHidObject value = (IHidObject)argument.getValue();
                if (value instanceof IRfHidImplicitLayer && ((IRfHidImplicitLayer)value).isStringLiteral()) {
                    return value.toString();
                }
                IELParamValue evaluatedValue = XUtils.getValue((ELParamValueScope)ELUtils.evaluate((IHidObject)value, (IHidEvaluator)evaluator, (BitVectorContext)BitVectorContext.of((IRfNamedElement)((IRfNamedElement)argument.getKey()), (boolean)false), (IHidEvaluationGuardian)IHidEvaluationGuardian.DUMMY_EVAL_GUARDIAN));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)evaluatedValue)) {
                    return "";
                }
                return ELUtils.valueToString((IELParamValue)evaluatedValue);
            }
        }
        return "";
    }

    public String getTreeLabelText(HistoryItem historyItem) {
        return "";
    }

    public boolean isModelBuildDone(IProject project) {
        if (project == null) {
            return false;
        }
        RfXvmFactory factory = RfVHUtils.getRawXvmFactory(project);
        if (factory == null) {
            return false;
        }
        return factory.isInitDone();
    }

    public void buildModel(IProject project) {
        RfVHUtils.getXvmFactory(project);
    }

    public long getTotalRegisterCount() {
        return this.totalRegisterCount;
    }

    public void addListener(DVTLazyView view) {
        if (!(view instanceof RegistersView)) {
            return;
        }
        this.stateListeners.add((IDVTModelStateListener)view);
    }

    public void notifyStateListeners(DVTModelEvent event) {
        for (IDVTModelStateListener l : this.stateListeners) {
            l.stateChanged(event);
        }
    }

    public void clearStateListeners() {
        this.stateListeners.clear();
    }

    public void cleanRegisterRoots() {
        this.xvmRegisterRoots = null;
        this.totalRegisterCount = 0L;
    }

    private static class VlogRegistersCache {
        private IProject project;
        private RfClass xvmReg;
        private RfClass xvmRegBlock;
        private String xvmPrefix;
        private boolean init;
        private static final Set<Class<? extends IRfNamedElement>> INCLUDE_PKGS = new HashSet<Class>(Arrays.asList(RfPackage.class));

        public VlogRegistersCache(IProject project) {
            this.project = project;
        }

        public VlogRegistersCache init() {
            if (this.init) {
                return this;
            }
            RfXvmFactory rawXvmFactory = RfVHUtils.getXvmFactory(this.project);
            if (!rawXvmFactory.isInitDone()) {
                return this;
            }
            RfProject rfProject = XVlogContributorUtils.xGetRfProject(this.project);
            if (rfProject == null) {
                return this;
            }
            IRfNamedElement xvmPkgElement = rfProject.getMember("uvm_pkg", INCLUDE_PKGS, null, true, false, false, false, true);
            if (xvmPkgElement != null) {
                this.xvmPrefix = "uvm";
            } else {
                xvmPkgElement = rfProject.getMember("ovm_pkg", INCLUDE_PKGS, null, true, false, false, false, true);
                if (xvmPkgElement != null) {
                    this.xvmPrefix = "ovm";
                }
            }
            if (!(xvmPkgElement instanceof RfPackage)) {
                return null;
            }
            IRfNamedElement xvmRegBlock = xvmPkgElement.getLocalMember(null, String.valueOf(this.xvmPrefix) + "_reg_block", null);
            if (!(xvmRegBlock instanceof RfClass)) {
                DVTLogger.INSTANCE.logError("Static Registers View: Failed to find " + this.xvmPrefix + "_reg_block in " + xvmPkgElement.getName());
                return null;
            }
            IRfNamedElement xvmReg = xvmPkgElement.getLocalMember(null, String.valueOf(this.xvmPrefix) + "_reg", null);
            if (!(xvmReg instanceof RfClass)) {
                DVTLogger.INSTANCE.logError("Static RegistersView: Failed to find " + this.xvmPrefix + "_reg in " + xvmPkgElement.getName());
                return null;
            }
            this.xvmRegBlock = (RfClass)xvmRegBlock;
            this.xvmReg = (RfClass)xvmReg;
            this.init = true;
            return this;
        }

        public RfClass getXvmReg() {
            return this.xvmReg;
        }

        public RfClass getXvmRegBlock() {
            return this.xvmRegBlock;
        }

        public static RfClass getXvmRegBlock(VlogRegistersCache cache) {
            return cache == null ? null : cache.getXvmRegBlock();
        }

        public static RfClass getXvmReg(VlogRegistersCache cache) {
            return cache == null ? null : cache.getXvmReg();
        }

        public void clean() {
            this.xvmRegBlock = null;
            this.xvmReg = null;
            this.xvmPrefix = null;
            this.init = false;
        }
    }
}

