/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.editor.DVTFileStatusContext;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.FileSynchedAndAvailableManager;
import ro.amiq.dvt.ui.search.PortSignalEnum;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.views.ISearchContributor;
import ro.amiq.dvt.utils.SearchedElementWrapper;
import ro.amiq.vlogdt.model.IVlogModel;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfThisImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfEnclosingScopeUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.model.reflection.views.PortConnectionsHidOperatorVisitor;
import ro.amiq.vlogdt.ui.editor.VlogDocumentSetupParticipant;
import ro.amiq.vlogdt.ui.refactor.rename.VlogFileStatusContext;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameAcrossDesignHierarchyDelegate;

public abstract class VlogSearchContributorCommon
implements ISearchContributor {
    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature("ro.amiq.vlogdt.VlogNature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void installPartitionerForFile(IDocument document) {
        VlogDocumentSetupParticipant setupParticipant = new VlogDocumentSetupParticipant();
        setupParticipant.setup(document);
    }

    public boolean hasValidPartitioner(IDocument document) {
        try {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            IDocumentPartitioner partitioner = extension3.getDocumentPartitioner("__vlog_partitioning");
            if (partitioner != null) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean isInstantiable(IRfNamedElement element) {
        IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind((Object)element);
        switch (designKind) {
            case VHDL_ARCHITECTURE: 
            case VHDL_ENTITY: 
            case VHDL_CONFIGURATION: 
            case VLOG_MODULE: 
            case VLOG_PROGRAM: 
            case VLOG_INTERFACE: 
            case VLOG_PRIMITIVE: {
                return true;
            }
        }
        return false;
    }

    public String getScopeInfo(IProject project, ParserPath parserPath, int line, int offset) {
        return RfEnclosingScopeUtils.getScopeInfo(project, parserPath, offset);
    }

    public IRfDefElement getScope(IProject project, ParserPath parserPath, int line, int offset) {
        return RfEnclosingScopeUtils.getScope(project, parserPath, offset, true);
    }

    public boolean validContentType(IDocument document, int index) {
        block11: {
            String[] partitionings;
            block10: {
                block9: {
                    block8: {
                        if (index < document.getLength()) break block8;
                        return false;
                    }
                    if (index != -1) break block9;
                    return false;
                }
                partitionings = ((IDocumentExtension3)document).getPartitionings();
                if (partitionings != null) break block10;
                return false;
            }
            boolean hasPartition = false;
            String[] stringArray = partitionings;
            int n = partitionings.length;
            int n2 = 0;
            while (n2 < n) {
                String partitioning = stringArray[n2];
                if (partitioning.equals("__vlog_partitioning")) {
                    hasPartition = true;
                    break;
                }
                ++n2;
            }
            if (hasPartition) break block11;
            return false;
        }
        try {
            String contentType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", index, false);
            return contentType.equals("__dftl_partition_content_type") || contentType.equals("__vlog_escaped_id");
        }
        catch (BadLocationException | BadPartitioningException throwable) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * Exception decompiling
     */
    public void reportReferenceMatches(IReportHitsListener<SearchHit> listener, IProgressMonitor monitor, IRfSingleLangProject singleLangProject, IRfNamedElement namedElement, IHidEvaluator evaluator, String searchedString, Map<IProject, Set<ParserPath>> searchedFiles, FileSynchedAndAvailableManager fileManager, boolean includeDeclarations, boolean forRefactoring, boolean isStrictVirtual, Map<Integer, List<SearchedElementWrapper>> searchedElementsRelativeDepthPairs, RenameAcrossHierarchyInfo renameWrapper, SearchedElementWrapper elementWrapper, boolean skipImplicitComponentEntityAssociation, boolean disableHitInMacroArgument) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isTypeElement(IRfNamedElement namedElement) {
        return namedElement instanceof RfCovergroup || namedElement instanceof RfPackage || namedElement instanceof RfInterface || namedElement instanceof RfTypeAlias || namedElement instanceof RfProgram || namedElement instanceof RfClass || namedElement instanceof RfModule || namedElement instanceof RfModport || namedElement instanceof RfLibrary || namedElement instanceof RfForwardTypedef;
    }

    public IRfNamedElement getElementFromString(IProject project, String elementString) {
        return RfBatchUtils.getNamedElementFromString(project, elementString, true);
    }

    public IDVTFile getIDVTFile(IFile file) {
        IVlogModel vlogModel = VlogModelManager.getInstance().getVlogModel();
        if (vlogModel == null) {
            return null;
        }
        return vlogModel.getVlogModule(file);
    }

    public String getNature() {
        return "ro.amiq.vlogdt.VlogNature";
    }

    public PortSignalEnum getPortOrSignalEnum(IRfNamedElement namedElement) {
        if (namedElement instanceof RfPort) {
            return PortSignalEnum.PORT_MATCH;
        }
        if (namedElement instanceof RfField && ((RfField)namedElement).isSignal()) {
            return PortSignalEnum.SIGNAL_MATCH;
        }
        return PortSignalEnum.NO_MATCH;
    }

    public boolean hasPortConnections(IRfNamedElement namedElement, IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return false;
        }
        PortConnectionsHidOperatorVisitor portConnectionsHidOperatorVisitor = new PortConnectionsHidOperatorVisitor(namedElement);
        Set<IRfNamedElement> referencedScopes = VlogRfReferencesUtils.getAllDependencies(namedElement, rfProject, false, false, false);
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (enclosingScope instanceof IRfNamedElement) {
            referencedScopes.add((IRfNamedElement)enclosingScope);
        }
        if (referencedScopes == null || referencedScopes.isEmpty()) {
            return false;
        }
        for (IRfNamedElement reference : referencedScopes) {
            if (portConnectionsHidOperatorVisitor.hasPortConnections()) {
                return true;
            }
            reference.visitHidObject(null, (IHidVisitor)portConnectionsHidOperatorVisitor);
        }
        return portConnectionsHidOperatorVisitor.hasPortConnections();
    }

    public DVTRenameDelegate getRenameAcrossHierarchyDelegate(DVTRenameRefactorInfo refactorInfo) {
        return new VlogRenameAcrossDesignHierarchyDelegate(refactorInfo);
    }

    public DVTFileStatusContext getFileStatusContext() {
        return new VlogFileStatusContext();
    }

    public IStatus getConflictingStatus(String newName, IProject project, IRfNamedElement namedElement, IRfScopeElement enclosingScope) {
        if (!(enclosingScope instanceof IRfNamedElement)) {
            return Status.OK_STATUS;
        }
        return VlogRfReferencesUtils.checkOtherElements(newName, project, namedElement, (IRfNamedElement)enclosingScope, true);
    }

    public boolean isPredefinedElement(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfThisImplicitVariable) {
            return true;
        }
        if (!namedElement.isPredefined()) {
            return false;
        }
        if (namedElement instanceof RfPredefinedField) {
            return !((RfPredefinedField)namedElement).isNamedArrayMethodItem();
        }
        return true;
    }

    public boolean isPrecompiledElement(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        return namedElement.isPrecompiledDB();
    }
}

