/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.typehierarchy.ITHViewContributor;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInput;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogTHViewContributorCommon;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.ui.editor.override.VlogOveriddenElementInserter;
import ro.amiq.vlogdt.ui.editor.utils.VlogMethodsInsertConfigurationProvider;

public class VlogTHViewContributor
extends VlogTHViewContributorCommon
implements ITHViewContributor {
    private static final HashSet<String> RANDOM_PREDEFINED_FUNCTIONS = new HashSet<String>(Arrays.asList("pre_randomize", "post_randomize"));
    private boolean fHasGUIFilteredMembers;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object dataContainer) {
        RfNamedElementActionHyperlink actionHiperlink = this.getActionHiperlink(project, dataContainer);
        if (actionHiperlink != null) {
            actionHiperlink.open();
        }
    }

    public THViewInput getInput(THViewInputConfigurator inputConfig) {
        Object namedElement = null;
        List<Object> hierarchyElements = new ArrayList();
        List<Object> memberElements = new ArrayList();
        this.fHasGUIFilteredMembers = false;
        try {
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.VLOG)) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            if (!inputConfig.isTriggeredForQuickView() && ev.getElementType() != 1) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            memberElements = this.getMembersData(rfProject, inputConfig.getMembersStringMatcher(), ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getUpdateJob());
            if (inputConfig.getUpdateOnlyMembers()) {
                memberElements = this.getMembersData(rfProject, inputConfig.getMembersStringMatcher(), ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getUpdateJob());
            } else {
                hierarchyElements = this.getHierarchyData(rfProject, inputConfig.getHierarchyStringMatcher(), inputConfig.isTriggeredForQuickView(), ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getUpdateJob());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
    }

    protected RfClass getClazz(UpdateViewEvent event) {
        IProject project = Utils.getProject((String)event.getProjectName());
        if (!project.isAccessible()) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return this.getClazz(rfProject, event.getElementName(), (List)event.getElementScope());
    }

    private List<IDVTElementWrapper> getMembersData(RfProject project, StringMatcher matcher, String elementName, int elementType, List<RfNameTypeScopeHelper> elementScope, UpdateJob updateJob) {
        RfClass clazz = this.getClazz(project, elementName, elementScope);
        List<IDVTElementWrapper> membersData = this.getMembersWrappers(clazz, updateJob);
        ArrayList<IDVTElementWrapper> filteredMembers = new ArrayList<IDVTElementWrapper>();
        if (matcher != null) {
            for (IDVTElementWrapper element : membersData) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return new ArrayList<IDVTElementWrapper>();
                }
                String name = "";
                if (element.getRfElement() instanceof RfNamedElement) {
                    name = ((RfNamedElement)element.getRfElement()).getName();
                }
                if (name == null || !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name)) continue;
                filteredMembers.add(element);
            }
            membersData = filteredMembers;
        }
        return membersData;
    }

    public List<IDVTElementWrapper> getMembersWrappers(RfClass clazz, UpdateJob updateJob) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        try {
            RfNamedElement[] sorted;
            if (clazz == null) {
                return result;
            }
            NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
            LexicalSorter lexicalSorter = new LexicalSorter();
            List<RfField> fields = this.getFields(clazz);
            if (PrefConst.getTHViewSortByCategory()) {
                RfNamedElement[] sorted2 = fields.toArray(new RfNamedElement[fields.size()]);
                Arrays.sort(sorted2, lexicalSorter);
                elements.addAll(Arrays.asList(sorted2));
            } else {
                elements.addAll(fields);
            }
            if (PrefConst.getTHViewSortByCategory()) {
                NullProtectedList<RfFunction> methods = new NullProtectedList<RfFunction>();
                methods.addAll(this.getConstructor(clazz));
                methods.addAll(this.getFunctions(clazz));
                methods.addAll(this.getTasks(clazz));
                sorted = methods.toArray(new RfNamedElement[methods.size()]);
                Arrays.sort(sorted, lexicalSorter);
                elements.addAll(Arrays.asList(sorted));
            } else {
                elements.addAll(this.getConstructor(clazz));
                elements.addAll(this.getFunctions(clazz));
                elements.addAll(this.getTasks(clazz));
            }
            List<RfField> events = this.getEvents(clazz);
            if (PrefConst.getTHViewSortByCategory()) {
                sorted = events.toArray(new RfNamedElement[events.size()]);
                Arrays.sort(sorted, lexicalSorter);
                elements.addAll(Arrays.asList(sorted));
            } else {
                elements.addAll(events);
            }
            if (!PrefConst.getTHViewSortByCategory()) {
                Collections.sort(elements, lexicalSorter);
            }
            for (RfNamedElement namedElement : elements) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                if (!PrefConst.getTHViewShowPredefined() && namedElement instanceof RfPredefinedFunction && !((RfPredefinedFunction)namedElement).isPredefinedOverridden()) continue;
                DVTGUIFilterMatcher.GUIFilterResult filterResult = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPE_HIERARCHY_MEMBERS, (IRfNamedElement)namedElement, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(namedElement)));
                if (filterResult != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (filterResult == DVTGUIFilterMatcher.GUIFilterResult.PREFERENCE) continue;
                    this.fHasGUIFilteredMembers = true;
                    continue;
                }
                if (PrefConst.getTHViewShowOnlyPublic() && !namedElement.isPublic()) continue;
                RfTreeElementWrapper wrapper = new RfTreeElementWrapper(namedElement, true);
                result.add(wrapper);
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return result;
        }
    }

    private List<RfField> getFields(RfClass clazz) {
        boolean showInherited = PrefConst.getTHViewShowAllInherited();
        if (showInherited) {
            return clazz.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return clazz.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private List<RfField> getEvents(RfClass clazz) {
        boolean showInherited = PrefConst.getTHViewShowAllInherited();
        if (showInherited) {
            return clazz.getEventsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return clazz.getEventsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private List<RfFunction> getFunctions(RfClass clazz) {
        boolean showInherited = PrefConst.getTHViewShowAllInherited();
        if (showInherited) {
            List<RfFunction> result = clazz.getFunctionsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (clazz.isInterfaceClass()) {
                NullProtectedList<RfFunction> tempResult = new NullProtectedList<RfFunction>();
                tempResult.addAll(result);
                for (RfFunction func : result) {
                    HashSet<RfClass> visited = new HashSet<RfClass>();
                    visited.add(clazz);
                    this.getRecursiveFunctionFromParents(visited, tempResult, clazz, func);
                }
                return tempResult;
            }
            return result;
        }
        return clazz.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private void getRecursiveFunctionFromParents(Set<RfClass> visited, List<RfFunction> result, RfClass clazz, RfFunction func) {
        if (clazz.getParentInterfaces() == null) {
            return;
        }
        for (RfClass parent : clazz.getParentInterfaces()) {
            if (visited.contains(parent)) continue;
            visited.add(parent);
            List<RfFunction> parentFunctions = parent.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            for (RfFunction function : parentFunctions) {
                if (!function.getName().equals(func.getName()) || function.equals(func) || function.isPredefined()) continue;
                result.add(function);
            }
            this.getRecursiveFunctionFromParents(visited, result, parent, func);
        }
    }

    private List<RfFunction> getTasks(RfClass clazz) {
        boolean showInherited = PrefConst.getTHViewShowAllInherited();
        if (showInherited) {
            return clazz.getTasksWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return clazz.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private List<RfFunction> getConstructor(RfClass clazz) {
        return clazz.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return false;
        }
        if (matcher != null) {
            return ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
        }
        if (referenceData instanceof UpdateViewEvent) {
            UpdateViewEvent event = (UpdateViewEvent)referenceData;
            if (!(rfElement instanceof RfClass)) {
                return false;
            }
            RfClass clazz = (RfClass)rfElement;
            RfClass eventClazz = this.getClazz(event);
            if (eventClazz == null) {
                return false;
            }
            return clazz.getName().equals(eventClazz.getName());
        }
        if (referenceData instanceof RfTreeElementWrapper) {
            RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)referenceData);
            Object refElement = rfWrapper.getRfElement();
            if (!(refElement instanceof RfClass)) {
                return false;
            }
            if (!(rfElement instanceof RfClass)) {
                return false;
            }
            RfClass clazz = (RfClass)rfElement;
            RfClass refClazz = (RfClass)refElement;
            return clazz.getName().equals(refClazz.getName());
        }
        return true;
    }

    public void overrideMethod(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
        try {
            if (!(memberWrapper.getRfElement() instanceof RfFunction)) {
                return;
            }
            if (!(hierarchyWrapper.getRfElement() instanceof RfClass)) {
                return;
            }
            RfFunction currentFunction = (RfFunction)((RfNamedElement)memberWrapper.getRfElement());
            RfClass currentClass = (RfClass)((RfNamedElement)hierarchyWrapper.getRfElement());
            if (!this.canShowOverrideMethodMenuEntry(hierarchyWrapper, memberWrapper)) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog messageDialog = new MessageDialog(shell, "Override Methods", null, String.valueOf(currentFunction.getName()) + " is already overidden in " + currentClass.getName(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                messageDialog.open();
                return;
            }
            RfDefElement declaration = currentClass.getDeclaration();
            if (declaration == null) {
                return;
            }
            IResource file = declaration.getFileAdapter();
            if (file == null || !file.exists() || !file.isAccessible()) {
                return;
            }
            int line = declaration.getEndLine();
            IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttribute("lineNumber", line);
            IEditorPart edp = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
            ITextEditor textEditor = (ITextEditor)edp.getAdapter(ITextEditor.class);
            ArrayList<RfFunction> functionsList = new ArrayList<RfFunction>(1);
            functionsList.add(currentFunction);
            VlogMethodsInsertConfigurationProvider configurator = new VlogMethodsInsertConfigurationProvider(currentClass, functionsList, (DVTEditor)textEditor, 0, false);
            VlogOveriddenElementInserter.getInstance().insertSignatures(configurator);
            marker.delete();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean canShowOverrideMethodMenuEntry(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
        if (!(memberWrapper.getRfElement() instanceof RfFunction)) {
            return false;
        }
        if (!(hierarchyWrapper.getRfElement() instanceof RfClass)) {
            return false;
        }
        RfFunction currentFunction = (RfFunction)((RfNamedElement)memberWrapper.getRfElement());
        RfClass currentClass = (RfClass)((RfNamedElement)hierarchyWrapper.getRfElement());
        if (RANDOM_PREDEFINED_FUNCTIONS.contains(currentFunction.getName()) && currentFunction.hasNoDefs(false)) {
            return true;
        }
        if (currentFunction instanceof RfPredefinedFunction) {
            return false;
        }
        RfFunction locFunction = currentClass.getLocalMember(RfFunction.class, currentFunction.getName(), false);
        if (locFunction == null) {
            return true;
        }
        if (locFunction instanceof RfPredefinedFunction) {
            RfPredefinedFunction pFunction = (RfPredefinedFunction)locFunction;
            return !pFunction.isPredefinedOverridden();
        }
        return false;
    }

    public boolean shouldOverrideShowPredefined(IDVTElementWrapper element) {
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    @Override
    protected IDocument provideDocument(VlogEditor editor, IEditorInput editorInput) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        if (document == null) {
            return null;
        }
        return document;
    }

    @Override
    protected boolean getTHViewShowSupertype() {
        return PrefConst.getTHViewShowSupertype();
    }

    @Override
    protected boolean getTHViewShowSubtype() {
        return PrefConst.getTHViewShowSubtype();
    }

    private static class LexicalSorter
    implements Comparator<RfNamedElement> {
        private LexicalSorter() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        }
    }
}

