/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.typehierarchy.GotoDataContainer;
import ro.amiq.dvt.ui.views.typehierarchy.ITHViewContributor;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.THViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtilCommon;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class VlogTHViewContributorCommon
implements ITHViewContributor {
    protected static final RfTreeElementWrapper DELETED_ELEMENT = new RfTreeElementWrapper();
    protected static final Comparator<RfClass> CLASS_INTERFACE_COMPARATOR = (c1, c2) -> {
        if (c1.isInterfaceClass() && !c2.isInterfaceClass()) {
            return 1;
        }
        if (!c1.isInterfaceClass() && c2.isInterfaceClass()) {
            return -1;
        }
        return c1.getName().compareTo(c2.getName());
    };
    protected THViewLabelProvider fLabelProvider = new THViewLabelProvider(false);

    protected abstract boolean getTHViewShowSupertype();

    protected abstract boolean getTHViewShowSubtype();

    protected abstract IDocument provideDocument(VlogEditor var1, IEditorInput var2);

    public List<IDVTElementWrapper> getHierarchyData(RfProject project, StringMatcher matcher, boolean triggeredForQuickView, String elementName, int elementType, List<RfNameTypeScopeHelper> elementScope, UpdateJob updateJob) {
        RfClass candidate;
        boolean isConstraint;
        String memberName = null;
        boolean isTask = elementType == 8;
        boolean isFunction = elementType == 4 || isTask;
        boolean bl = isConstraint = elementType == 32768;
        if (triggeredForQuickView && (elementType == 8 || elementType == 4 || elementType == 32768)) {
            memberName = elementName;
        }
        if ((candidate = this.getClazz(project, elementName, elementScope)) == null) {
            return new ArrayList<IDVTElementWrapper>();
        }
        List<IDVTElementWrapper> hData = this.getHierarchy(candidate, memberName, isFunction, isTask, isConstraint, updateJob);
        if (hData == null) {
            return new ArrayList<IDVTElementWrapper>();
        }
        if (matcher != null) {
            this.filterInput(hData, matcher, updateJob);
        }
        return hData;
    }

    protected RfClass getClazz(RfProject project, String elementName, List<RfNameTypeScopeHelper> elementScope) {
        IRfScopeElement classScope;
        block4: {
            try {
                classScope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
                if (classScope != null && classScope instanceof IRfScope) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        RfClass candidate = ((IRfScope)classScope).getClassWithPrefix(elementName, 1, 1);
        if (classScope instanceof RfClass && candidate == null) {
            candidate = (RfClass)classScope;
        }
        return candidate;
    }

    private void filterInput(List<IDVTElementWrapper> input, StringMatcher matcher, UpdateJob updateJob) {
        ArrayList<IDVTElementWrapper> toRemove = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper wrapper : input) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            if (wrapper.getChildren() != null && !wrapper.getChildren().isEmpty()) {
                this.filterInput(wrapper.getChildren(), matcher, updateJob);
            }
            if (wrapper.getChildren() != null && !wrapper.getChildren().isEmpty() || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(wrapper))) continue;
            toRemove.add(wrapper);
        }
        input.removeAll(toRemove);
    }

    public List<IDVTElementWrapper> getHierarchy(RfClass clazz, String elementName, boolean isFunction, boolean isTask, boolean isConstraint, UpdateJob updateJob) {
        if (clazz == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<IDVTElementWrapper>();
        try {
            boolean isShowSubtype = this.getTHViewShowSubtype();
            boolean isShowSupertype = this.getTHViewShowSupertype();
            Set<RfSpecializedClass> specializations = clazz.getSpecializations();
            clazz = specializations != null && specializations.size() > 1 ? clazz : clazz.getDefaultSpecialization(null);
            Collection<RfClass> leafClasses = this.collectLeafClasses(clazz, updateJob, elementName);
            if (!leafClasses.isEmpty()) {
                for (RfClass leafClass : leafClasses) {
                    RfTreeElementWrapper root;
                    if (isShowSupertype) {
                        if (clazz.isInterfaceClass()) {
                            root = new RfTreeElementWrapper(clazz);
                            root.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true);
                            this.getRecursiveInterfaceClassParentsSupertype(root, updateJob, isFunction, isTask, elementName, clazz);
                            result.add((Object)root);
                            continue;
                        }
                        RfClass candidate = leafClass;
                        while (!this.equalsGenericClass(candidate, clazz) && (candidate = candidate.getParent()) != null) {
                        }
                        RfTreeElementWrapper root2 = new RfTreeElementWrapper(candidate);
                        root2.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true);
                        this.getRecursiveClassParentsSupertype(root2, updateJob, isFunction, isTask, elementName, clazz);
                        result.add((Object)root2);
                        continue;
                    }
                    root = this.getRecursiveClassParents(leafClass, updateJob, isFunction, isTask, isConstraint, elementName, isShowSubtype, clazz);
                    result.add((IDVTElementWrapper)root);
                }
            }
            ArrayList<IDVTElementWrapper> temp = new ArrayList<IDVTElementWrapper>();
            if (result.size() > 1) {
                int i = 0;
                while (i < result.size()) {
                    IDVTElementWrapper nodeI = (IDVTElementWrapper)result.get(i);
                    if (DELETED_ELEMENT != nodeI) {
                        temp.add(nodeI);
                        String nodeIText = this.fLabelProvider.getText(nodeI);
                        int j = i + 1;
                        while (j < result.size()) {
                            IDVTElementWrapper nodeJ = (IDVTElementWrapper)result.get(j);
                            String nodeJText = this.fLabelProvider.getText(nodeJ);
                            if (nodeIText.equals(nodeJText)) {
                                result.set(j, (Object)DELETED_ELEMENT);
                                this.addChildren(nodeI, nodeJ);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                result = temp;
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return result;
        }
    }

    protected void getRecursiveClassParentsSupertype(RfTreeElementWrapper root, UpdateJob updateJob, boolean isFunction, boolean isTask, String functionName, RfClass inputClazz) {
        RfClass clazz = (RfClass)root.getRfElement();
        if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
            return;
        }
        RfClass parentClass = clazz.getParent();
        if (parentClass != null) {
            RfTreeElementWrapper parentClassWrapper = new RfTreeElementWrapper(parentClass);
            if (isFunction) {
                RfFunction function;
                RfFunction rfFunction = function = isTask ? parentClass.getLocalTask(functionName) : parentClass.getLocalFunction(functionName);
                if (function instanceof RfPredefinedFunction) {
                    RfPredefinedFunction predefinedFunction = (RfPredefinedFunction)function;
                    if (!predefinedFunction.isPredefinedOverridden()) {
                        parentClassWrapper.setGrayIcon(true);
                    }
                } else if (function == null) {
                    parentClassWrapper.setGrayIcon(true);
                }
            }
            if (this.equalsGenericClass((RfClass)parentClassWrapper.getRfElement(), inputClazz)) {
                parentClassWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true);
            }
            this.getRecursiveClassParentsSupertype(parentClassWrapper, updateJob, isFunction, isTask, functionName, inputClazz);
            root.addChild(parentClassWrapper);
        }
        if (clazz.getParentInterfaces() != null) {
            this.getRecursiveInterfaceClassParentsSupertype(root, updateJob, isFunction, isTask, functionName, inputClazz);
        }
    }

    protected void getRecursiveInterfaceClassParentsSupertype(RfTreeElementWrapper root, UpdateJob updateJob, boolean isFunction, boolean isTask, String functionName, RfClass inputClazz) {
        RfClass clazz = (RfClass)root.getRfElement();
        if (clazz.getParentInterfaces() == null) {
            return;
        }
        ArrayList<RfClass> parent_interfaces = new ArrayList<RfClass>(clazz.getParentInterfaces());
        Collections.sort(parent_interfaces, CLASS_INTERFACE_COMPARATOR);
        for (RfClass interfaze : parent_interfaces) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            RfTreeElementWrapper interfaceWrapper = new RfTreeElementWrapper(interfaze);
            if (isFunction) {
                RfFunction function;
                RfFunction rfFunction = function = isTask ? interfaze.getLocalTask(functionName) : interfaze.getLocalFunction(functionName);
                if (function instanceof RfPredefinedFunction) {
                    RfPredefinedFunction predefinedFunction = (RfPredefinedFunction)function;
                    if (!predefinedFunction.isPredefinedOverridden()) {
                        interfaceWrapper.setGrayIcon(true);
                    }
                } else if (function == null) {
                    interfaceWrapper.setGrayIcon(true);
                }
            }
            if (this.equalsGenericClass((RfClass)interfaceWrapper.getRfElement(), inputClazz)) {
                interfaceWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true);
            }
            this.getRecursiveInterfaceClassParentsSupertype(interfaceWrapper, updateJob, isFunction, isTask, functionName, inputClazz);
            root.addChild(interfaceWrapper);
        }
    }

    protected Collection<RfClass> collectLeafClasses(RfClass inputClazz, UpdateJob updateJob, String name) {
        LinkedHashSet<RfClass> leafClasses = new LinkedHashSet<RfClass>();
        this.collectLeafClassesRecursive(leafClasses, new HashSet<RfClass>(), inputClazz, updateJob, name);
        Iterator leafIterator = leafClasses.iterator();
        block0: while (leafIterator.hasNext()) {
            RfClass parent = (RfClass)leafIterator.next();
            do {
                List<RfClass> parentInterfaces;
                if ((parentInterfaces = parent.getParentInterfaces()) != null && !parentInterfaces.isEmpty()) {
                    for (RfClass parentInterface : parentInterfaces) {
                        if (this.equalsGenericClass(inputClazz, parentInterface)) continue block0;
                    }
                }
                if (this.equalsGenericClass(inputClazz, parent)) continue block0;
            } while ((parent = this.getParent(inputClazz, parent)) != null);
            leafIterator.remove();
        }
        return leafClasses;
    }

    protected void collectLeafClassesRecursive(Collection<RfClass> result, Set<RfClass> visited, RfClass clazz, UpdateJob updateJob, String name) {
        Set<RfSpecializedClass> specializedChildren = clazz.getSpecializations();
        if (specializedChildren == null || specializedChildren.isEmpty()) {
            Set<RfClass> set = clazz.getChildren();
            if (set == null || set.isEmpty()) {
                result.add(clazz);
                return;
            }
            if (visited.contains(clazz)) {
                result.add(clazz);
                return;
            }
            visited.add(clazz);
            for (RfClass child : set) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return;
                }
                this.collectLeafClassesRecursive(result, new HashSet<RfClass>(visited), child, updateJob, name);
            }
            return;
        }
        if (visited.contains(clazz)) {
            result.add(clazz);
            return;
        }
        visited.add(clazz);
        for (RfClass rfClass : specializedChildren) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            this.collectLeafClassesRecursive(result, new HashSet<RfClass>(visited), rfClass, updateJob, name);
        }
    }

    protected RfTreeElementWrapper getRecursiveClassParents(RfClass clazz, UpdateJob updateJob, boolean isFunction, boolean isTask, boolean isConstraint, String name, boolean isShowSubtype, RfClass inputClazz) {
        RfClass parent = clazz;
        RfTreeElementWrapper prevClassWrapper = null;
        do {
            RfTreeElementWrapper currClassWrapper = new RfTreeElementWrapper(parent);
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) break;
            if (isConstraint) {
                RfConstraint constraint = parent.getLocalMember(RfConstraint.class, name, true);
                if (constraint == null) {
                    currClassWrapper.setGrayIcon(true);
                }
            } else if (isFunction) {
                RfFunction function;
                RfFunction rfFunction = function = isTask ? parent.getLocalTask(name) : parent.getLocalFunction(name);
                if (function instanceof RfPredefinedFunction) {
                    RfPredefinedFunction predefinedFunction = (RfPredefinedFunction)function;
                    if (!predefinedFunction.isPredefinedOverridden()) {
                        currClassWrapper.setGrayIcon(true);
                    }
                } else if (function == null) {
                    currClassWrapper.setGrayIcon(true);
                }
            } else {
                if (this.equalsGenericClass((RfClass)currClassWrapper.getRfElement(), inputClazz)) {
                    currClassWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true);
                }
                if (inputClazz.isInterfaceClass() && !parent.isChildOfClassOrInterface(inputClazz)) {
                    currClassWrapper.setGrayIcon(true);
                }
            }
            if (prevClassWrapper != null) {
                if (isFunction || isConstraint || isTask) {
                    if (prevClassWrapper.hasChildren() || !prevClassWrapper.isGrayIcon()) {
                        currClassWrapper.addChild(prevClassWrapper);
                    }
                } else {
                    currClassWrapper.addChild(prevClassWrapper);
                }
            }
            prevClassWrapper = currClassWrapper;
        } while ((!isShowSubtype || inputClazz == null || !this.hasUniqueParent(prevClassWrapper, inputClazz)) && (parent = this.getParent(inputClazz, parent)) != null);
        return prevClassWrapper;
    }

    protected boolean equalsGenericClass(RfClass class1, RfClass class2) {
        if (class1.getGenericClass() == class2.getGenericClass()) {
            return true;
        }
        if (class1.getName().equals(class2.getName())) {
            RfNamedElement enclosingOfClass2;
            RfNamedElement enclosingOfClass1 = class1.getEnclosingScope();
            if (enclosingOfClass1 == (enclosingOfClass2 = class2.getEnclosingScope())) {
                return true;
            }
            if (enclosingOfClass1 instanceof RfClass && enclosingOfClass2 instanceof RfClass) {
                return this.equalsGenericClass((RfClass)enclosingOfClass1, (RfClass)enclosingOfClass2);
            }
            return false;
        }
        return false;
    }

    protected void addChildren(IDVTElementWrapper dst, IDVTElementWrapper src) {
        List dstChildren = dst.getChildren();
        List srcChildren = src.getChildren();
        if (srcChildren == null || srcChildren.isEmpty()) {
            return;
        }
        if (dstChildren == null || dstChildren.isEmpty()) {
            dst.setChildren(srcChildren);
            return;
        }
        ArrayList<IDVTElementWrapper> children = new ArrayList<IDVTElementWrapper>(dstChildren.size() + srcChildren.size());
        children.addAll(dstChildren);
        int i = 0;
        while (i < srcChildren.size()) {
            block5: {
                IDVTElementWrapper srcChild = (IDVTElementWrapper)srcChildren.get(i);
                String srcChildText = this.fLabelProvider.getText(srcChild);
                int j = 0;
                while (j < dstChildren.size()) {
                    IDVTElementWrapper dstChild = (IDVTElementWrapper)dstChildren.get(j);
                    String dstChildText = this.fLabelProvider.getText(dstChild);
                    if (srcChildText.equals(dstChildText)) {
                        this.addChildren(dstChild, srcChild);
                        break block5;
                    }
                    ++j;
                }
                children.add(srcChild);
            }
            ++i;
        }
        dst.setChildren(children);
    }

    protected RfClass getParent(RfClass parentInterfaceClass, RfClass clazz) {
        if (parentInterfaceClass == null || !parentInterfaceClass.isInterfaceClass()) {
            return clazz.getParent();
        }
        List<RfClass> parentInterfaces = clazz.getParentInterfaces();
        if (parentInterfaces == null || parentInterfaces.isEmpty()) {
            return clazz.getParent();
        }
        for (RfClass parentInterface : parentInterfaces) {
            if (parentInterface.getGenericClass() == parentInterfaceClass.getGenericClass()) {
                return parentInterface;
            }
            if (this.getParent(parentInterfaceClass, parentInterface) == null) continue;
            return parentInterface;
        }
        return clazz.getParent();
    }

    protected boolean hasUniqueParent(RfTreeElementWrapper classWrapper, RfClass inputClazz) {
        RfClass clazz = (RfClass)classWrapper.getRfElement();
        if (this.equalsGenericClass(clazz, inputClazz)) {
            RfClass parent = clazz;
            while ((parent = this.getParent(inputClazz, parent)) != null) {
                if (!this.equalsGenericClass(parent, inputClazz)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public HistoryItem createHistoryItemForWrapper(IDVTElementWrapper wrapper, IProject project, int updateHistory) {
        Object namedElement;
        block5: {
            block4: {
                try {
                    if (wrapper instanceof RfTreeElementWrapper) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            RfTreeElementWrapper treeElementWrapper = (RfTreeElementWrapper)wrapper;
            namedElement = treeElementWrapper.getRfElement();
            if (namedElement != null && namedElement instanceof RfClass) break block5;
            return null;
        }
        RfClass rfClass = (RfClass)namedElement;
        List<? extends DVTRfNameTypeScopeHelper> scope = RfScopeUtil.getDefOfScopeElement(rfClass);
        String text = "[" + project.getName() + "] " + (rfClass.getEnclosingScope() == null ? "" : String.valueOf(rfClass.getEnclosingScope().getName()) + " :: ") + rfClass.getName();
        return VlogQuickViewersUtilCommon.createViewUpdateEvent(text, project.getName(), rfClass.getName(), scope, 1, updateHistory);
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursor, boolean ignoreMethods) {
        RfNamedElement element;
        IProject project;
        block23: {
            block22: {
                RfWNamedElementAndScope elementAndScope;
                RfProject rfProject;
                block21: {
                    IDocument document;
                    IFile file;
                    VlogEditor vlogEditor;
                    block20: {
                        IEditorInput editorInput;
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            try {
                                                if (editor instanceof VlogEditor) break block15;
                                                return null;
                                            }
                                            catch (Exception e) {
                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                return null;
                                            }
                                        }
                                        vlogEditor = (VlogEditor)editor;
                                        editorInput = vlogEditor.getEditorInput();
                                        if (editorInput != null) break block16;
                                        return null;
                                    }
                                    file = (IFile)editorInput.getAdapter(IFile.class);
                                    if (file != null) break block17;
                                    return null;
                                }
                                project = file.getProject();
                                if (project != null) break block18;
                                return null;
                            }
                            rfProject = RfManager.getInstance().getRfProject(project);
                            if (rfProject != null) break block19;
                            return null;
                        }
                        document = this.provideDocument(vlogEditor, editorInput);
                        if (document != null) break block20;
                        return null;
                    }
                    element = null;
                    elementAndScope = RfUtils.getRfElement(rfProject, (ITextEditor)vlogEditor, document, cursor);
                    if (elementAndScope == null || elementAndScope.getNamedElement() == null) {
                        char bchar;
                        RfFileDef fileDef = rfProject.getFile((IResource)file);
                        char achar = document.getChar(cursor);
                        char c = bchar = cursor > 0 ? (char)document.getChar(cursor - 1) : (char)' ';
                        if (fileDef != null && (Character.isWhitespace(bchar) || Character.isWhitespace(achar))) {
                            RfDefElement lineScope = fileDef.getScope(cursor, false);
                            element = VlogQuickViewersUtilCommon.getEnclosingFunctionOrClass(lineScope, true);
                        }
                    } else {
                        element = elementAndScope.getNamedElement();
                    }
                    if (element != null) break block21;
                    return null;
                }
                RfTypesResolver resolver = RfTypesResolver.create(elementAndScope == null ? null : elementAndScope.getScope(), rfProject, 8);
                if (element instanceof RfField) {
                    element = ((RfField)element).getAssociatedType(resolver);
                }
                if (element instanceof RfClass || element instanceof RfFunction || element instanceof RfConstraint) break block22;
                return null;
            }
            if (!(element instanceof RfFunction) || !ignoreMethods) break block23;
            return null;
        }
        return VlogQuickViewersUtilCommon.createViewUpdateEvent(element, project, 2);
    }

    public RfNamedElementActionHyperlink getActionHiperlink(IProject project, Object dataContainer) {
        UpdateViewEvent uvEvent;
        int elementType;
        if (!(dataContainer instanceof GotoDataContainer)) {
            return null;
        }
        GotoDataContainer gtContainer = (GotoDataContainer)dataContainer;
        IDVTElementWrapper wrapper = gtContainer.getWrapper();
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        Object element = ((RfTreeElementWrapper)wrapper).getRfElement();
        if (element == null) {
            return null;
        }
        HistoryItem reference = gtContainer.getHistoryItem();
        if (reference instanceof UpdateViewEvent && ((elementType = (uvEvent = (UpdateViewEvent)reference).getElementType()) == 4 || elementType == 8 || elementType == 32768) && element instanceof RfClass) {
            RfClass parentClass = (RfClass)element;
            String elementName = uvEvent.getElementName();
            RfNamedElement namedElement = null;
            if (elementType == 4 || elementType == 8) {
                namedElement = parentClass.getLocalMember(RfFunction.class, elementName, false);
            } else if (elementType == 32768) {
                namedElement = parentClass.getLocalMember(RfConstraint.class, elementName, false);
            }
            if (namedElement != null) {
                RfNamedElementActionHyperlink actionHyperlink = null;
                if (namedElement instanceof RfPredefinedFunction) {
                    RfPredefinedFunction predefinedFunction = (RfPredefinedFunction)namedElement;
                    if (!predefinedFunction.isPredefinedOverridden()) {
                        actionHyperlink = RfUtils.createOpenAction(parentClass, project, null);
                    }
                } else {
                    actionHyperlink = RfUtils.createOpenAction(namedElement, project, null);
                }
                if (actionHyperlink != null) {
                    return actionHyperlink;
                }
                return null;
            }
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)element, project, null);
        }
        if (actionHyperlink == null) {
            return null;
        }
        return actionHyperlink;
    }
}

