/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogTypesViewContributorCommon;

public class VlogTypesViewContributor
extends VlogTypesViewContributorCommon {
    public VlogTypesViewContributor() {
        super(new TypesViewLabelProvider(), (IMembersLabelProvider)new TypesViewMembersLabelProvider());
    }

    public MembersViewInput getMembersInput(Object wrapper, StringMatcher stringMatcher) {
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        if (wrapper == null) {
            return emptyResult;
        }
        Object rfElement = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : wrapper;
        if (!(rfElement instanceof RfNamedElement)) {
            return emptyResult;
        }
        RfNamedElement namedElemet = (RfNamedElement)rfElement;
        if (namedElemet instanceof RfTypeAlias) {
            IRfNamedElement assocType = ((RfTypeAlias)namedElemet).getAssociatedType();
            if (!(assocType instanceof RfStruct)) {
                return emptyResult;
            }
            namedElemet = (RfStruct)assocType;
        }
        AtomicBoolean hasGUIFilteredMembers = new AtomicBoolean(false);
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfFunction.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfField.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfCoverpoint.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfActionBlock.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfModport.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfConstraint.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfPropertySequence.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfClockingBlock.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfInstance.class), stringMatcher, hasGUIFilteredMembers);
        this.collectMatchingMembers(elements, namedElemet.getLocalMembers(RfAssertExpect.class), stringMatcher, hasGUIFilteredMembers);
        return new MembersViewInput(elements, hasGUIFilteredMembers.get());
    }

    /*
     * WARNING - void declaration
     */
    private void collectMatchingMembers(Collection<IDVTElementWrapper> result, Iterable<? extends RfNamedElement> members, StringMatcher stringMatcher, AtomicBoolean hasGUIFilteredMembers) {
        if (members == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : members) {
            void var6_6;
            RfNamedElement rfNamedElement2;
            RfActionBlock actionBlock;
            if (rfNamedElement.isPredefined() || rfNamedElement.getName() == null || rfNamedElement.getName().isEmpty() || rfNamedElement instanceof RfField && ((RfField)rfNamedElement).isVariable() || rfNamedElement instanceof RfActionBlock && !(actionBlock = (RfActionBlock)rfNamedElement).isNamedBlock() && (rfNamedElement2 = this.getNamedBeginEndInsideAlways(actionBlock)) == null) continue;
            RfTreeElementWrapper elementWrapper = new RfTreeElementWrapper(var6_6, true);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)this.getMembersViewLabelProvider().getText((Object)elementWrapper))) continue;
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)var6_6, () -> this.getMembersViewLabelProvider().getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                hasGUIFilteredMembers.set(true);
                continue;
            }
            result.add(elementWrapper);
        }
    }

    private RfNamedElement getNamedBeginEndInsideAlways(RfActionBlock actionBlock) {
        if (!actionBlock.isAlways()) {
            return null;
        }
        List<RfActionBlock> localActionBlocks = actionBlock.getLocalMembers(RfActionBlock.class);
        if (localActionBlocks == null || localActionBlocks.isEmpty()) {
            return null;
        }
        RfActionBlock beginEnd = (RfActionBlock)localActionBlocks.iterator().next();
        if (beginEnd.isNamedBlock()) {
            return beginEnd;
        }
        return null;
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof RfNamedElement)) {
            return;
        }
        RfUtils.createOpenAction((IRfNamedElement)elem, project, null).open();
    }
}

