/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.views.types.BaseTypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInput;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class VlogTypesViewContributorCommon
extends BaseTypesViewContributor {
    protected VlogTypesViewContributorCommon(DVTBaseLabelProvider typesViewLabelProvider, IMembersLabelProvider typesViewMembersLabelProvider) {
        super(typesViewLabelProvider, typesViewMembersLabelProvider);
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public TypesViewInput getInput(TypesViewInputConfigurator inputConfigurator) {
        try {
            TypesViewInput input = TypesViewInput.emptyInput();
            if (inputConfigurator == null) {
                return input;
            }
            IProject project = inputConfigurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return input;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return input;
            }
            RfTreeElementWrapper tmpRoot = new RfTreeElementWrapper();
            this.collectTypes(rfProject, tmpRoot, rfProject, inputConfigurator, input);
            if (inputConfigurator.isCanceled()) {
                return TypesViewInput.emptyInput();
            }
            if (tmpRoot.getChildren() == null || tmpRoot.getChildren().isEmpty()) {
                return input;
            }
            int matchCount = this.filterTree(tmpRoot, inputConfigurator);
            if (matchCount >= 0) {
                input.setNrNotFilteredTypes(matchCount);
            }
            if (inputConfigurator.isShowLanguageNameAsRootElement()) {
                int nrTypes = input.getNrTypes();
                String langInfo = String.valueOf(LanguageKind.VLOG.VIEW_NAME) + " [" + (matchCount != -1 ? String.valueOf(matchCount) + "/" + nrTypes : Integer.valueOf(nrTypes)) + ViewsUtils.getUnitName((String)"type", (int)nrTypes, (String)" ", (String)"") + "]";
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VlogLanguageElement<String>(langInfo));
                languageWrapper.addChildren(tmpRoot.getChildren());
                input.setElements(Arrays.asList(new IDVTElementWrapper[]{languageWrapper}));
                return input;
            }
            input.setElements(new ArrayList<RfTreeElementWrapper>(tmpRoot.getChildren()));
            return input;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return TypesViewInput.emptyInput();
        }
    }

    private void collectTypes(RfProject project, RfTreeElementWrapper root, RfNamedElement parent, TypesViewInputConfigurator configurator, TypesViewInput input) {
        if (input == null || configurator == null || configurator.isCanceled() || configurator.shouldStopCollecting()) {
            return;
        }
        boolean ignoreContentFilters = configurator.ignoreContentFilters();
        List<RfNamedElement> childElements = project.getLocalTypes(parent, false, configurator.isCategorySort(), configurator.hideDuplicates());
        for (RfNamedElement element : childElements) {
            List<RfNamedElement> members;
            if (configurator.isCanceled() || configurator.shouldStopCollecting()) {
                return;
            }
            if (!(!(element instanceof RfLibrary) || !((RfLibrary)element).isNonTopFilesLibrary() && !((RfLibrary)element).isDefaultLibrary() || (members = project.getLocalTypes(element, false, configurator.isCategorySort(), configurator.hideDuplicates())) != null && !members.isEmpty())) continue;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(element);
            if (!ignoreContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IRfNamedElement)element, () -> this.getLabelProvider((Object)wrapper).getText((Object)wrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                input.setHasGUIFilteredElements(true);
                if (input.isSearchedElementFiltered()) continue;
                IRfFilterableTreeAccessor view = configurator.getView();
                if ((view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) && ViewsUtilsCommon.matchesPath((Object)((Object)wrapper), (IRfFilterableTreeAccessor)view)) {
                    input.setSearchedElementFiltered(true);
                    continue;
                }
                if (view.getTreeSearchPort() != null && !view.getTreeSearchPort().isEmpty()) {
                    input.setSearchedElementFiltered(this.hasFilteredSearchedPorts(project, element, view));
                    continue;
                }
                if (!element.hasLocalMembers()) continue;
                input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember(project, element, view));
                continue;
            }
            if (element instanceof RfForwardTypedef) continue;
            if (!(element instanceof RfLibrary || element instanceof RfGenerateBlock || element instanceof RfPackage)) {
                input.incrementNrTypes();
            }
            if (this.shouldAddType(wrapper, configurator)) {
                root.addChild(wrapper);
            }
            if (configurator.shouldStopCollecting()) {
                return;
            }
            RfTreeElementWrapper nextRoot = configurator.isCollectingSymbols() ? root : wrapper;
            this.collectTypes(project, nextRoot, element, configurator, input);
        }
    }

    public boolean symbolMatchesQueryKey(ISymbolCollectorPrerequisite symbolPrerequisite, SymbolCollectorConfigurator configurator) {
        if (configurator == null) {
            return false;
        }
        if (!(symbolPrerequisite instanceof IDVTElementWrapper)) {
            return false;
        }
        String queryKey = configurator.getQueryKey();
        Object rfElement = ((IDVTElementWrapper)symbolPrerequisite).getRfElement();
        if (rfElement instanceof RfLibrary) {
            return SymbolQueryKey.LIBRARY.isEqualTo(queryKey);
        }
        if (SymbolQueryKey.EXTENDS.isEqualTo(queryKey)) {
            return this.symbolMatchesExtendsQueryKey(rfElement, configurator);
        }
        if (SymbolQueryKey.isUvmSpecific((String)queryKey)) {
            return this.symbolMatchesUvmQueryKey(rfElement, queryKey);
        }
        return super.symbolMatchesQueryKey(symbolPrerequisite, configurator);
    }

    public boolean symbolMatchesQueryPattern(ISymbolCollectorPrerequisite symbolPrerequisite, SymbolCollectorConfigurator configurator) {
        if (configurator == null) {
            return false;
        }
        if (SymbolQueryKey.EXTENDS.isEqualTo(configurator.getQueryKey())) {
            return true;
        }
        return super.symbolMatchesQueryPattern(symbolPrerequisite, configurator);
    }

    private boolean symbolMatchesExtendsQueryKey(Object rfElement, SymbolCollectorConfigurator configurator) {
        if (!(rfElement instanceof RfClass)) {
            return false;
        }
        RfClass parentClass = ((RfClass)rfElement).getParent();
        while (parentClass != null) {
            if (ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)configurator.getQueryPatternMatcher(), (String)parentClass.getName())) {
                return true;
            }
            parentClass = parentClass.getParent();
        }
        return false;
    }

    private boolean symbolMatchesUvmQueryKey(Object rfElement, String queryKey) {
        if (!(rfElement instanceof RfClass)) {
            return false;
        }
        RfClass rfClass = (RfClass)rfElement;
        while (rfClass != null) {
            if (SymbolQueryKey.symbolMatchesQueryKey((String)rfClass.getName(), (String)queryKey)) {
                return true;
            }
            rfClass = rfClass.getParent();
        }
        return false;
    }

    private int filterTree(RfTreeElementWrapper root, TypesViewInputConfigurator viewConfigurator) {
        if (root == null || viewConfigurator == null) {
            return -1;
        }
        if (!viewConfigurator.getView().isFiltered()) {
            return -1;
        }
        if (viewConfigurator.isCollectingSymbols()) {
            return -1;
        }
        ComplexFilter filter = new ComplexFilter(viewConfigurator.getView(), true){

            public boolean shouldSkipCount(IDVTElementWrapper node) {
                if (node.getRfElement() == null) {
                    return true;
                }
                if (!(node.getRfElement() instanceof RfNamedElement)) {
                    return true;
                }
                RfNamedElement namedElement = (RfNamedElement)node.getRfElement();
                return namedElement instanceof RfLibrary || namedElement instanceof RfPackage || namedElement instanceof RfGenerateBlock || namedElement instanceof RfForwardTypedef;
            }
        };
        ViewsUtils.filterElementComplex((IDVTElementWrapper)root, (ComplexFilter)filter, (IProgressMonitor)viewConfigurator.getMonitor());
        return filter.matchCount;
    }

    private boolean hasFilteredSearchedLocalMember(RfProject project, RfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        if (!parentElement.hasLocalMembers()) {
            return false;
        }
        List<RfNamedElement> childElements = project.getLocalTypes(parentElement, false, false, true);
        for (RfNamedElement element : childElements) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(element)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(project, element, view)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFilteredSearchedPorts(RfProject project, RfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        if (ViewsUtilsCommon.matchesUnfilteredPort((IDVTElementWrapper)new RfTreeElementWrapper(parentElement), (IRfFilterableTreeAccessor)view)) {
            return true;
        }
        if (!parentElement.hasLocalMembers()) {
            return false;
        }
        List<RfNamedElement> childElements = project.getLocalTypes(parentElement, false, false, true);
        for (RfNamedElement element : childElements) {
            if (ViewsUtilsCommon.matchesUnfilteredPort((IDVTElementWrapper)new RfTreeElementWrapper(element), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedPorts(project, element, view)) continue;
            return true;
        }
        return false;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (object == null || !(object instanceof RfNamedElement)) {
                return;
            }
            RfNamedElement element = (RfNamedElement)object;
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(element, project, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof VlogLanguageElement) {
            return false;
        }
        if (rfElement instanceof RfLibrary) {
            return false;
        }
        if (rfElement instanceof RfPackage && ((IDVTElementWrapper)element).getChildren() != null) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.getLabelProvider(element).getText(element));
    }

    protected IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public IRfKind getKind(String rfKindValue) {
        try {
            return RfKind.valueOf(rfKindValue);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

