/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayDeque;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class VlogUVMSequenceTreeUtils {
    public static int getClosedBoundaryOffset(RfHid hid) {
        if (hid == null) {
            return -1;
        }
        ListContainer accesses = hid.getAccesses();
        if (accesses == null) {
            return hid.getOccurrence().getOffset();
        }
        if (accesses.size() < 1) {
            return hid.getOccurrence().getOffset();
        }
        if (!(accesses.get(0) instanceof RfHidAccessArgs)) {
            return -1;
        }
        RfHidAccessArgs hidArg = (RfHidAccessArgs)((Object)accesses.get(0));
        if (hidArg == null) {
            return -1;
        }
        if (hidArg.getArgumentValues().isEmpty()) {
            return hid.getOccurrence().getOffset();
        }
        if (!(hidArg.getArgumentValues().get(hidArg.getArgumentValues().size() - 1) instanceof RfHidOperator)) {
            return -1;
        }
        RfHidOperator hidOperator = (RfHidOperator)hidArg.getArgumentValues().get(hidArg.getArgumentValues().size() - 1);
        if (hidOperator == null) {
            return -1;
        }
        return hidOperator.getCloseBoundary();
    }

    public static int getBlockEndOffset(IDocument document, int startOffset, String partitioning) {
        block6: {
            String[] commentTypes = DVTDocumentUtils.getMLandSLFromPartition((String)partitioning);
            if (commentTypes != null) break block6;
            return -1;
        }
        try {
            int nextChar;
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, startOffset, true);
            boolean codeFound = false;
            while ((nextChar = cs.read()) != -1) {
                if ((char)nextChar == '\n' || (char)nextChar == '\r') {
                    return cs.getOffset() - 1;
                }
                if (((IDocumentExtension3)document).getContentType(partitioning, cs.getOffset() - 1, false).equals("__dftl_partition_content_type")) {
                    codeFound = true;
                    continue;
                }
                if (!codeFound) continue;
                return cs.getOffset() - 1;
            }
            return -1;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getCallEndOffset(IDocument document, int startOffset, String partition) {
        try {
            int nextCharOfCode;
            int nextChar;
            ArrayDeque<Character> parentheses = new ArrayDeque<Character>();
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, startOffset, true);
            int offset = -1;
            boolean codeFound = false;
            while ((nextChar = cs.read()) != -1) {
                offset = cs.getOffset();
                char currentChar = (char)nextChar;
                String contentType = ((IDocumentExtension3)document).getContentType(partition, cs.getOffset() - 1, false);
                if (!contentType.equals("__dftl_partition_content_type")) continue;
                if (currentChar == '(') {
                    codeFound = true;
                    parentheses.add(Character.valueOf(currentChar));
                    continue;
                }
                if (currentChar != ')') continue;
                if (parentheses.isEmpty()) {
                    return -1;
                }
                parentheses.pop();
                if (!codeFound || !parentheses.isEmpty()) continue;
            }
            if ((nextCharOfCode = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)cs.getOffset(), (boolean)true, (String)partition, (boolean)true, (boolean)true)) == -1) {
                return offset;
            }
            return nextCharOfCode;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return -1;
        }
    }
}

