/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.uvmsequencetree.IUVMSequenceTreeViewContributor;
import ro.amiq.dvt.ui.views.uvmsequencetree.UVMSequenceTreeViewInput;
import ro.amiq.dvt.ui.views.uvmsequencetree.UVMSequenceTreeViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfMembersHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.views.VlogSequenceTreeNode;
import ro.amiq.vlogdt.model.reflection.views.VlogUVMSequenceTreeViewContributorCommon;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogUVMSequenceTreeViewContributor
extends VlogUVMSequenceTreeViewContributorCommon
implements IUVMSequenceTreeViewContributor {
    public static final HashSet<String> UVM_OVM_SEARCHED_MACROS = new HashSet<String>(Arrays.asList("uvm_do", "uvm_do_pri", "uvm_do_with", "uvm_do_pri_with", "uvm_do_on", "uvm_do_on_pri", "uvm_do_on_with", "uvm_do_on_pri_with", "uvm_send", "uvm_send_pri", "uvm_rand_send", "uvm_rand_send_pri", "uvm_rand_send_with", "uvm_rand_send_pri_with", "ovm_do", "ovm_do_pri", "ovm_do_with", "ovm_do_pri_with", "ovm_do_on", "ovm_do_on_pri", "ovm_do_on_with", "ovm_do_on_pri_with", "ovm_send", "ovm_send_pri", "ovm_rand_send", "ovm_rand_send_pri", "ovm_rand_send_with", "ovm_rand_send_pri_with"));

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            VlogSequenceTreeNode node = (VlogSequenceTreeNode)((Object)((RfTreeElementWrapper)((Object)wrapper)).getGoToElement());
            if (node == null) {
                return;
            }
            RfNamedElementActionHyperlink actionHyperlink = this.openSequenceTreeAction(node, project, null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private RfNamedElementActionHyperlink openSequenceTreeAction(final VlogSequenceTreeNode node, final IProject project, IRegion region) {
        Action action = new Action(){

            public void run() {
                VlogFileUtils.getInstance().openFile(project, node.getParserPath().path, node.getLine(), node.getLabel());
            }
        };
        RfMembersHolder namedElement = node.getSequence();
        if (namedElement == null) {
            namedElement = node.getActionBlock();
        }
        return new RfNamedElementActionHyperlink(project, namedElement, region, (IAction)action, null);
    }

    public UVMSequenceTreeViewInput getInput(UVMSequenceTreeViewInputConfigurator inputConfigurator, IRfNamedElementAndScope element) {
        this.fHasGUIFilteredMembers = false;
        this.fIsPrependPackage = inputConfigurator.isPrependPackage();
        String bulkDataInfo = "";
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        UVMSequenceTreeViewInput emptyResult = new UVMSequenceTreeViewInput(this.fHasGUIFilteredMembers, Collections.emptyList(), bulkDataInfo);
        try {
            this.fHasGUIFilteredMembers = false;
            if (!inputConfigurator.getHistoryItem().getLanguage().equals((Object)LanguageKind.VLOG)) {
                return emptyResult;
            }
            if (!(inputConfigurator.getHistoryItem() instanceof UpdateViewEvent)) {
                return emptyResult;
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfigurator.getHistoryItem();
            if (!(inputConfigurator.getSource() instanceof IProject)) {
                return emptyResult;
            }
            IProject project = (IProject)inputConfigurator.getSource();
            if (!project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return emptyResult;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return emptyResult;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return emptyResult;
            }
            this.updateExpandedXVMFilters(project);
            List elementScope = (List)ev.getElementScope();
            IDVTElementWrapper rootSequence = this.directToWrappers(rfProject, ev.getElementName(), elementScope);
            if (rootSequence == null) {
                return emptyResult;
            }
            this.filterNonTerminalLeafsAndApplyContentFilters(rootSequence);
            rootSequence = this.filterElement(rootSequence, inputConfigurator.getSearchSegments(), inputConfigurator.getSearchStrictness(), inputConfigurator.getUpdateJob());
            bulkDataInfo = ev.getElementName();
            elements.add(rootSequence);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new UVMSequenceTreeViewInput(this.fHasGUIFilteredMembers, elements, bulkDataInfo);
    }

    protected IDVTElementWrapper directToWrappers(RfProject rfProject, String elementName, List<RfNameTypeScopeHelper> elementScope) {
        RfClass rootSequence = this.getClazz(rfProject, elementName, elementScope);
        return this.directToWrappersClass(rfProject, elementName, rootSequence);
    }

    private RfClass getClazz(RfProject project, String elementName, List<RfNameTypeScopeHelper> elementScope) {
        IRfScopeElement classScope;
        block4: {
            try {
                classScope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
                if (classScope != null && classScope instanceof IRfScope) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        RfClass candidate = ((IRfScope)classScope).getClassWithPrefix(elementName, 1, 1);
        if (classScope instanceof RfClass && candidate == null) {
            candidate = (RfClass)classScope;
        }
        return candidate;
    }

    private IDVTElementWrapper filterElement(IDVTElementWrapper wrapper, StringMatcher[] searchSegments, boolean[] searchStrictness, UpdateJob updateJob) {
        ViewsUtilsCommon.hierarchicalSearch((IDVTElementWrapper)wrapper, (DVTBaseLabelProvider)this.fLabelProvider, (UpdateJob)updateJob, (StringMatcher[])searchSegments, (boolean[])searchStrictness);
        return wrapper;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (matcher != null && !ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element)) && !ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getColumnText(element, 1))) {
            return false;
        }
        return false;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset) {
        RfNamedElement element;
        IProject project;
        block20: {
            IDocument document;
            RfProject rfProject;
            IFile file;
            VlogEditor vlogEditor;
            block19: {
                IDocumentProvider documentProvider;
                IEditorInput editorInput;
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        try {
                                            if (editor instanceof VlogEditor) break block13;
                                            return null;
                                        }
                                        catch (Exception e) {
                                            DVTLogger.INSTANCE.logError((Throwable)e);
                                            return null;
                                        }
                                    }
                                    vlogEditor = (VlogEditor)editor;
                                    editorInput = vlogEditor.getEditorInput();
                                    if (editorInput != null) break block14;
                                    return null;
                                }
                                file = (IFile)editorInput.getAdapter(IFile.class);
                                if (file != null) break block15;
                                return null;
                            }
                            project = file.getProject();
                            if (project != null) break block16;
                            return null;
                        }
                        rfProject = RfManager.getInstance().getRfProject(project);
                        if (rfProject != null) break block17;
                        return null;
                    }
                    documentProvider = vlogEditor.getDocumentProvider();
                    if (documentProvider != null) break block18;
                    return null;
                }
                document = documentProvider.getDocument((Object)editorInput);
                if (document != null) break block19;
                return null;
            }
            element = null;
            RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(rfProject, (ITextEditor)vlogEditor, document, cursorOffset);
            if (elementAndScope == null || elementAndScope.getNamedElement() == null) {
                RfFileDef fileDef = rfProject.getFile((IResource)file);
                if (fileDef != null) {
                    RfDefElement lineScope = fileDef.getScope(cursorOffset, false);
                    element = VlogQuickViewersUtil.getEnclosingFunctionOrClass(lineScope, true);
                }
            } else {
                element = elementAndScope.getNamedElement();
            }
            if (element instanceof RfClass || element instanceof RfFunction) break block20;
            return null;
        }
        UpdateViewEvent updateEvent = VlogQuickViewersUtil.createViewUpdateEvent(element, project, 5);
        return updateEvent;
    }
}

