/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersTopFilePatternExpander;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.uvmsequencetree.SequenceTreeNodeType;
import ro.amiq.vlogdt.model.reflection.NamedElementAndString;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.views.MethodCallAdditionalInfo;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.UVMSequenceTreeClassInfo;
import ro.amiq.vlogdt.model.reflection.views.VlogSequenceTreeNode;
import ro.amiq.vlogdt.model.reflection.views.VlogUVMSequenceTreeViewLabelProvider;
import ro.amiq.vlogdt.parser.RfMacroRefInfo;

public abstract class VlogUVMSequenceTreeViewContributorCommon {
    public static final String UVM_SEQUENCE = "uvm_sequence";
    public static final String OVM_SEQUENCE = "ovm_sequence";
    private static final String BODY = "body";
    private static final String UVM_SEQUENCE_ITEM = "uvm_sequence_item";
    private static final String OVM_SEQUENCE_ITEM = "ovm_sequence_item";
    private static final String OVM_REG = "ovm_reg";
    private static final String UVM_REG = "uvm_reg";
    protected VlogUVMSequenceTreeViewLabelProvider fLabelProvider = new VlogUVMSequenceTreeViewLabelProvider();
    protected boolean fIsPrependPackage;
    protected boolean fHasGUIFilteredMembers;
    protected List<GUIFilter> fExpandedXVMFilters;
    public static final HashSet<String> UVM_OVM_SEARCHED_MACROS = new HashSet<String>(Arrays.asList("uvm_do", "uvm_do_pri", "uvm_do_with", "uvm_do_pri_with", "uvm_do_on", "uvm_do_on_pri", "uvm_do_on_with", "uvm_do_on_pri_with", "uvm_send", "uvm_send_pri", "uvm_rand_send", "uvm_rand_send_pri", "uvm_rand_send_with", "uvm_rand_send_pri_with", "ovm_do", "ovm_do_pri", "ovm_do_with", "ovm_do_pri_with", "ovm_do_on", "ovm_do_on_pri", "ovm_do_on_with", "ovm_do_on_pri_with", "ovm_send", "ovm_send_pri", "ovm_rand_send", "ovm_rand_send_pri", "ovm_rand_send_with", "ovm_rand_send_pri_with"));

    protected RfTreeElementWrapper makeWrapper(IRfNamedElement element) {
        RfTreeElementWrapper result = new RfTreeElementWrapper(element);
        if (this.fIsPrependPackage) {
            result.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, "package");
        }
        return result;
    }

    protected IDVTElementWrapper directToWrappersClass(RfProject rfProject, String elementName, RfClass rootSequence) {
        RfTreeElementWrapper rootSequenceWrapper = null;
        if (rootSequence != null && (rootSequence.isSubClass(rootSequence.getClassWithPrefix(UVM_SEQUENCE, 1, 3)) || rootSequence.isSubClass(rootSequence.getClassWithPrefix(OVM_SEQUENCE, 1, 3)))) {
            RfFunction currentBody = rootSequence.getTaskWithPrefix(BODY, 1, 2, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
            if (currentBody == null) {
                return null;
            }
            VlogSequenceTreeNode rootNode = new VlogSequenceTreeNode(null, rootSequence, rootSequence.getName(), rootSequence.getLine(), rootSequence.getStartOffset(), rootSequence.getFile().getParserPath(), SequenceTreeNodeType.SEQUENCE);
            rootSequenceWrapper = this.makeWrapper(rootSequence);
            rootSequenceWrapper.setGoToElement((Object)rootNode);
            ArrayList<RfTreeElementWrapper> rootSequenceChildren = new ArrayList();
            HashSet<String> knownTaskNames = new HashSet<String>();
            HashMap<IRfScopeElement, List<RfMacroRefInfo>> macrosInCurrentBlock = this.computeMacrosInScope(currentBody, rfProject);
            Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
            rootSequenceChildren = this.getSequenceBodyContent(visited, rootNode, currentBody, rfProject, macrosInCurrentBlock, knownTaskNames);
            this.sortSequenceBodyElements(rootSequenceChildren);
            rootSequenceWrapper.addChildren(rootSequenceChildren);
            rootSequenceWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_ROOT_COMMENT, ViewsUtils.trimText((String)rootSequence.getComment(), (int)100, (boolean)true));
        }
        return rootSequenceWrapper;
    }

    protected List<RfTreeElementWrapper> getSequenceBodyContent(Set<IRfNamedElement> visited, VlogSequenceTreeNode currentNode, RfNamedElement currentBlock, RfProject rfProject, HashMap<IRfScopeElement, List<RfMacroRefInfo>> knownMacros, Set<String> knownTaskNames) {
        if (currentBlock == null || rfProject == null) {
            return Collections.emptyList();
        }
        RfDefElement declaration = currentBlock.getDeclaration();
        if (declaration == null) {
            return Collections.emptyList();
        }
        List<RfTreeElementWrapper> result = new ArrayList<RfTreeElementWrapper>();
        List<RfMacroRefInfo> macrosInCurrentBlock = knownMacros != null && !knownMacros.isEmpty() ? knownMacros.get(declaration) : new ArrayList<RfMacroRefInfo>();
        knownTaskNames = new HashSet<String>(knownTaskNames);
        if (visited.contains(currentBlock)) {
            result.add(new RfTreeElementWrapper(new RfDummyElement("[...recurrence detected]")));
            return result;
        }
        visited.add(currentBlock);
        try {
            switch (currentNode.getNodeType()) {
                case SEQUENCE: {
                    List<RfTreeElementWrapper> actionBlock;
                    List<RfTreeElementWrapper> startAndTaskCalls;
                    List<RfTreeElementWrapper> sequencesInMacros;
                    knownMacros = this.computeMacrosInScope(currentBlock, rfProject);
                    if (knownMacros != null && !knownMacros.isEmpty() && (sequencesInMacros = this.getMacrosInCurrentBlock(visited, macrosInCurrentBlock = knownMacros.get(declaration), rfProject, currentNode, currentBlock, knownMacros, knownTaskNames)) != null) {
                        result.addAll(sequencesInMacros);
                    }
                    if ((startAndTaskCalls = this.getStartAndTaskCallsHids(visited, currentNode, currentBlock, rfProject, macrosInCurrentBlock, knownMacros, knownTaskNames)) != null) {
                        result.addAll(startAndTaskCalls);
                    }
                    if ((actionBlock = this.getActionBlocksFromElement(visited, currentNode, currentBlock, rfProject, knownMacros, macrosInCurrentBlock, knownTaskNames)) != null) {
                        result.addAll(actionBlock);
                    }
                    break;
                }
                case FORK: {
                    RfTreeElementWrapper forkNodeWrapper = new RfTreeElementWrapper(currentNode.getActionBlock());
                    MethodCallAdditionalInfo additionalInfo = new MethodCallAdditionalInfo(currentNode.getParserPath().path, rfProject.getProject(), currentNode.getLine(), null, null, MethodCallAdditionalInfo.CallType.FORK_OR_PROCESS);
                    forkNodeWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO, additionalInfo);
                    forkNodeWrapper.setGoToElement((Object)currentNode);
                    List<RfActionBlock> localActionBlocks = currentBlock.getLocalMembers(RfActionBlock.class);
                    List<RfTreeElementWrapper> forkNodeChildren = this.resolveForkContent(visited, currentNode, currentBlock, rfProject, localActionBlocks, knownMacros, macrosInCurrentBlock, knownTaskNames);
                    forkNodeWrapper.addChildren(forkNodeChildren);
                    result.add(forkNodeWrapper);
                    break;
                }
                case PROCESS: {
                    List<RfTreeElementWrapper> actionBlockForkProcessBlock;
                    List<RfTreeElementWrapper> startAndTaskCallsForkProcessBlock;
                    List<RfTreeElementWrapper> sequencesInMacrosForkProcessBlock = this.getMacrosInCurrentBlock(visited, macrosInCurrentBlock, rfProject, currentNode, currentBlock, knownMacros, knownTaskNames);
                    if (sequencesInMacrosForkProcessBlock != null) {
                        result.addAll(sequencesInMacrosForkProcessBlock);
                    }
                    if ((startAndTaskCallsForkProcessBlock = this.getStartAndTaskCallsHids(visited, currentNode, currentBlock, rfProject, macrosInCurrentBlock, knownMacros, knownTaskNames)) != null) {
                        result.addAll(startAndTaskCallsForkProcessBlock);
                    }
                    if ((actionBlockForkProcessBlock = this.getActionBlocksFromElement(visited, currentNode, currentBlock, rfProject, knownMacros, macrosInCurrentBlock, knownTaskNames)) != null) {
                        result.addAll(actionBlockForkProcessBlock);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        visited.remove(currentBlock);
        result = this.sortSequenceBodyElements(result);
        return result;
    }

    private List<RfTreeElementWrapper> resolveForkContent(Set<IRfNamedElement> visited, VlogSequenceTreeNode currentNode, RfNamedElement currentBlock, RfProject rfProject, List<RfActionBlock> localActionBlocks, HashMap<IRfScopeElement, List<RfMacroRefInfo>> knownMacros, List<RfMacroRefInfo> macrosInCurrentBlock, Set<String> knownTaskNames) {
        RfTreeElementWrapper processDummyNode;
        List<RfTreeElementWrapper> startAndTaskCallsForkProcessBlock;
        List<RfTreeElementWrapper> result = new ArrayList<RfTreeElementWrapper>();
        List<RfTreeElementWrapper> sequencesInMacrosForkProcessBlock = this.getMacrosInCurrentBlock(visited, macrosInCurrentBlock, rfProject, currentNode, currentBlock, knownMacros, knownTaskNames);
        if (sequencesInMacrosForkProcessBlock != null) {
            for (RfTreeElementWrapper seq : sequencesInMacrosForkProcessBlock) {
                VlogSequenceTreeNode element = new VlogSequenceTreeNode((VlogSequenceTreeNode)((Object)seq.getGoToElement()), "process", SequenceTreeNodeType.PROCESS);
                RfTreeElementWrapper processDummyNode2 = new RfTreeElementWrapper(currentNode.getActionBlock());
                processDummyNode2.setGoToElement((Object)element);
                processDummyNode2.addChild(seq);
                result.add(processDummyNode2);
            }
        }
        if ((startAndTaskCallsForkProcessBlock = this.getStartAndTaskCallsHids(visited, currentNode, currentBlock, rfProject, macrosInCurrentBlock, knownMacros, knownTaskNames)) != null) {
            for (RfTreeElementWrapper seq : startAndTaskCallsForkProcessBlock) {
                VlogSequenceTreeNode element = new VlogSequenceTreeNode((VlogSequenceTreeNode)((Object)seq.getGoToElement()), "process", SequenceTreeNodeType.PROCESS);
                processDummyNode = new RfTreeElementWrapper(currentNode.getActionBlock());
                processDummyNode.setGoToElement((Object)element);
                processDummyNode.addChild(seq);
                result.add(processDummyNode);
            }
        }
        if (localActionBlocks != null) {
            for (RfActionBlock localActionBlock : localActionBlocks) {
                if (this.isActionBlockInMacro(localActionBlock, macrosInCurrentBlock)) continue;
                processDummyNode = new RfTreeElementWrapper(localActionBlock);
                VlogSequenceTreeNode actionBlockNode = localActionBlock.hasForkJoin() ? new VlogSequenceTreeNode(currentNode.getSequence(), null, localActionBlock, SequenceTreeNodeType.FORK) : new VlogSequenceTreeNode(currentNode.getSequence(), null, localActionBlock, SequenceTreeNodeType.PROCESS);
                MethodCallAdditionalInfo methodCallAdditionalInfo = new MethodCallAdditionalInfo(actionBlockNode.getParserPath().path, rfProject.getProject(), actionBlockNode.getLine(), null, null, MethodCallAdditionalInfo.CallType.FORK_OR_PROCESS);
                processDummyNode.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO, methodCallAdditionalInfo);
                List<RfTreeElementWrapper> nodes = this.getSequenceBodyContent(visited, actionBlockNode, localActionBlock, rfProject, knownMacros, knownTaskNames);
                processDummyNode.addChildren(nodes);
                VlogSequenceTreeNode clonedGoToElem = new VlogSequenceTreeNode(actionBlockNode, "process", SequenceTreeNodeType.PROCESS);
                processDummyNode.setGoToElement((Object)clonedGoToElem);
                result.add(processDummyNode);
            }
        }
        result = this.sortSequenceBodyElements(result);
        return result;
    }

    private boolean isActionBlockInMacro(RfActionBlock actionBlock, List<RfMacroRefInfo> macrosInCurrentBlock) {
        boolean inMacro = false;
        if (macrosInCurrentBlock != null && !macrosInCurrentBlock.isEmpty()) {
            for (RfMacroRefInfo macro : macrosInCurrentBlock) {
                if (actionBlock.getLine() != macro.getLine()) continue;
                inMacro = true;
                break;
            }
        }
        return inMacro;
    }

    private List<RfTreeElementWrapper> getActionBlocksFromElement(Set<IRfNamedElement> visited, VlogSequenceTreeNode currentSequence, RfNamedElement currentElement, RfProject rfProject, HashMap<IRfScopeElement, List<RfMacroRefInfo>> knownMacros, List<RfMacroRefInfo> macrosInCurrentBlock, Set<String> knownTaskNames) {
        ArrayList<RfTreeElementWrapper> result = new ArrayList<RfTreeElementWrapper>();
        List<RfActionBlock> localActionBlocks = currentElement.getLocalMembers(RfActionBlock.class);
        if (localActionBlocks == null) {
            return Collections.emptyList();
        }
        for (RfActionBlock localActionBlock : localActionBlocks) {
            if (this.isActionBlockInMacro(localActionBlock, macrosInCurrentBlock)) continue;
            VlogSequenceTreeNode actionBlockNode = localActionBlock.hasForkJoin() ? new VlogSequenceTreeNode(currentSequence.getSequence(), null, localActionBlock, SequenceTreeNodeType.FORK) : new VlogSequenceTreeNode(currentSequence.getSequence(), null, localActionBlock, SequenceTreeNodeType.PROCESS);
            List<RfTreeElementWrapper> nodes = this.getSequenceBodyContent(visited, actionBlockNode, localActionBlock, rfProject, knownMacros, knownTaskNames);
            result.addAll(nodes);
        }
        return result;
    }

    private HashMap<IRfScopeElement, List<RfMacroRefInfo>> computeMacrosInScope(RfNamedElement currentBlock, RfProject rfProject) {
        HashMap<IRfScopeElement, List<RfMacroRefInfo>> result = new HashMap<IRfScopeElement, List<RfMacroRefInfo>>();
        if (currentBlock == null || rfProject == null) {
            return result;
        }
        ParserPath filePath = currentBlock.getImplementation().getDefFile().getParserPath();
        List<RfMacroRefInfo> fileMacroRefs = rfProject.getPreprocessingTable().getMacroRefsMapByFile().get(filePath);
        if (fileMacroRefs == null) {
            return result;
        }
        int blockStartOffset = currentBlock.getImplementation().getStartOffset();
        int blockEndOffset = currentBlock.getImplementation().getEndOffset();
        for (RfMacroRefInfo macroRef : fileMacroRefs) {
            if (!UVM_OVM_SEARCHED_MACROS.contains(macroRef.getMacroName()) || macroRef.getStartOffset() <= blockStartOffset || macroRef.getStartOffset() >= blockEndOffset) continue;
            RfDefElement scope = currentBlock.getDeclaration().getDefFile().getScope(macroRef.getStartOffset() - 1, true);
            if (!result.containsKey(scope)) {
                result.put(scope, new ArrayList());
            }
            result.get(scope).add(macroRef);
        }
        return result;
    }

    private List<RfTreeElementWrapper> getMacrosInCurrentBlock(Set<IRfNamedElement> visited, List<RfMacroRefInfo> macrosInCurrentBlock, RfProject rfProject, VlogSequenceTreeNode currentNode, RfNamedElement currentBlock, HashMap<IRfScopeElement, List<RfMacroRefInfo>> knownMacros, Set<String> knownTaskNames) {
        ArrayList<RfTreeElementWrapper> result = new ArrayList<RfTreeElementWrapper>();
        if (macrosInCurrentBlock == null) {
            return result;
        }
        for (RfMacroRefInfo macroRef : macrosInCurrentBlock) {
            UVMSequenceTreeClassInfo uvmSequenceTreeClassInfo = this.getSequenceInfo(rfProject, currentNode.getSequence(), "", currentBlock, macroRef);
            for (RfClass seqClass : uvmSequenceTreeClassInfo.getSequencesClass()) {
                VlogSequenceTreeNode sequenceNode = new VlogSequenceTreeNode(seqClass, seqClass.getName(), macroRef, SequenceTreeNodeType.SEQUENCE);
                RfTreeElementWrapper macroWrapper = this.makeWrapper(seqClass);
                RfFunction currentBodyTask = seqClass.getTaskWithPrefix(BODY, 1, 2, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
                List<RfTreeElementWrapper> hidWrapperChildren = this.getSequenceBodyContent(visited, sequenceNode, currentBodyTask, rfProject, knownMacros, knownTaskNames);
                macroWrapper.addChildren(hidWrapperChildren);
                macroWrapper.setGoToElement((Object)sequenceNode);
                RfField field = null;
                if (!uvmSequenceTreeClassInfo.getSequencesField().isEmpty()) {
                    field = uvmSequenceTreeClassInfo.getSequencesField().get(0);
                }
                MethodCallAdditionalInfo methodCallAdditionalInfo = new MethodCallAdditionalInfo(macroRef.getParserPath().path, rfProject.getProject(), macroRef.getLine(), null, field, MethodCallAdditionalInfo.CallType.MACRO);
                macroWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO, methodCallAdditionalInfo);
                result.add(macroWrapper);
            }
        }
        return result;
    }

    private UVMSequenceTreeClassInfo getSequenceInfo(RfProject rfProject, RfClass currentSequence, String parentHidName, RfNamedElement bodyTask, RfMacroRefInfo macroRef) {
        UVMSequenceTreeClassInfo result = new UVMSequenceTreeClassInfo();
        if (currentSequence == null) {
            return result;
        }
        ArrayList<RfClass> classesResult = new ArrayList<RfClass>();
        ArrayList<RfField> fieldsResult = new ArrayList<RfField>();
        if (!parentHidName.equals("")) {
            RfClass hidClass = currentSequence.getClassWithPrefix(parentHidName, 1, 3);
            if (hidClass == null) {
                return result;
            }
            classesResult.add(hidClass);
        } else {
            List<RfField> fields = this.getSequenceDeclarationFields(rfProject, bodyTask, macroRef);
            for (RfField field : fields) {
                RfClass classFields;
                RfTypesResolver resolver;
                IRfNamedElement associatedType = field.getAssociatedType(resolver = RfTypesResolver.create((IRfScopeElement)bodyTask, rfProject, 14));
                if (associatedType == null) continue;
                if (associatedType instanceof RfTypeAlias) {
                    while (associatedType instanceof RfTypeAlias) {
                        associatedType = ((RfTypeAlias)associatedType).getAssociatedType(resolver);
                    }
                }
                if (associatedType instanceof RfListType) {
                    associatedType = ((RfListType)associatedType).getAssociatedBaseType(resolver);
                }
                if (associatedType == null || (classFields = currentSequence.getClassWithPrefix(associatedType.getName(), 1, 3)) == null) continue;
                classesResult.add(classFields);
                fieldsResult.add(field);
            }
        }
        result.setSequencesClass(classesResult);
        result.setSequencesField(fieldsResult);
        return result;
    }

    private List<RfField> getSequenceDeclarationFields(RfProject rfProject, RfNamedElement bodyTask, RfMacroRefInfo macroRef) {
        RfField variable;
        String name;
        List<RfField> fields = new ArrayList<RfField>();
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(macroRef.getParserPath());
        IRfScopeElement macroScope = fileDef.getScope(macroRef.getStartOffset());
        String macroParam = macroRef.getParams()[0];
        if (macroParam == null) {
            return Collections.emptyList();
        }
        String[] nameAndSelect = NamedElementAndString.getNameAndSelect(macroParam);
        if (nameAndSelect != null && !macroParam.equals(name = nameAndSelect[0])) {
            macroParam = name;
        }
        if (macroScope instanceof RfDefElement && (variable = ((RfDefElement)macroScope).getVarWithPrefix(macroRef.getStartOffset(), macroParam, 1)) != null) {
            fields.add(variable);
        }
        if (fields.isEmpty()) {
            fields = bodyTask.getFieldsWithPrefix(macroParam, 1, 3, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return fields;
    }

    private List<RfTreeElementWrapper> getStartAndTaskCallsHids(final Set<IRfNamedElement> visited, final VlogSequenceTreeNode currentSequence, final RfNamedElement currentElement, final RfProject rfProject, final List<RfMacroRefInfo> macrosInBody, final HashMap<IRfScopeElement, List<RfMacroRefInfo>> knownMacros, final Set<String> knownTaskNames) {
        if (currentSequence == null || currentElement == null || rfProject == null) {
            return Collections.emptyList();
        }
        final ArrayList<RfTreeElementWrapper> result = new ArrayList<RfTreeElementWrapper>();
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (!hid.isMethodCall(false) || !HidUtils.isResolved((IHidObject)hid)) {
                    return true;
                }
                if (macrosInBody != null && !macrosInBody.isEmpty()) {
                    for (RfMacroRefInfo macroRef : macrosInBody) {
                        if (!this.containsOffset(hid, macroRef.getStartOffset())) continue;
                        return true;
                    }
                }
                if (hid.getName().equals("start")) {
                    HidOccurrence occurrence = hid.getOccurrence();
                    if (occurrence != null) {
                        RfClass sequence = currentSequence.getSequence();
                        UVMSequenceTreeClassInfo uvmSequenceTreeClassInfo = VlogUVMSequenceTreeViewContributorCommon.this.getSequenceInfo(rfProject, sequence, hid.getParentAccess().getAssociatedType().getName(), currentElement, null);
                        for (RfClass seqClass : uvmSequenceTreeClassInfo.getSequencesClass()) {
                            VlogSequenceTreeNode sequenceNode = new VlogSequenceTreeNode(currentSequence, seqClass, seqClass.getName(), occurrence.getLine(), occurrence.getOffset(), this.parserPath, SequenceTreeNodeType.SEQUENCE);
                            RfTreeElementWrapper hidWrapper = VlogUVMSequenceTreeViewContributorCommon.this.makeWrapper(seqClass);
                            RfFunction currentBodyTask = seqClass.getTaskWithPrefix(VlogUVMSequenceTreeViewContributorCommon.BODY, 1, 2, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
                            List<RfTreeElementWrapper> hidWrapperChildren = VlogUVMSequenceTreeViewContributorCommon.this.getSequenceBodyContent(visited, sequenceNode, currentBodyTask, rfProject, knownMacros, knownTaskNames);
                            hidWrapper.addChildren(hidWrapperChildren);
                            hidWrapper.setGoToElement((Object)sequenceNode);
                            MethodCallAdditionalInfo additionalInfo = new MethodCallAdditionalInfo(this.parserPath.path, rfProject.getProject(), occurrence.getLine(), hid, null, MethodCallAdditionalInfo.CallType.METHOD_CALL);
                            hidWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO, additionalInfo);
                            result.add(hidWrapper);
                        }
                    }
                } else {
                    IRfNamedElement element = hid.getElement();
                    if (!(element instanceof RfFunction) || !((RfFunction)element).isTask()) {
                        return true;
                    }
                    RfFunction task = (RfFunction)element;
                    HidAccess parentAccess = hid.getParentAccess();
                    if (hid.hasAccesses()) {
                        for (HidAccess access : hid.getAccesses()) {
                            RfClass parentAccessType;
                            if (!(access instanceof RfHidAccessArgs)) continue;
                            RfHidAccessArgs accessArg = (RfHidAccessArgs)access;
                            HidOccurrence occurrence = accessArg.getOccurrence();
                            String taskFullName = String.valueOf(RfElementPath.path((IRfNamedElement)task).toString()) + " " + occurrence.getOffset();
                            if (knownTaskNames.contains(taskFullName)) continue;
                            knownTaskNames.add(taskFullName);
                            VlogSequenceTreeNode sequenceNode = new VlogSequenceTreeNode(currentSequence, currentSequence.getSequence(), null, occurrence.getLine(), occurrence.getOffset(), this.parserPath, SequenceTreeNodeType.SEQUENCE);
                            RfTreeElementWrapper hidWrapper = VlogUVMSequenceTreeViewContributorCommon.this.makeWrapper(element);
                            List<RfTreeElementWrapper> taskChildren = VlogUVMSequenceTreeViewContributorCommon.this.getSequenceBodyContent(visited, sequenceNode, task, rfProject, knownMacros, knownTaskNames);
                            hidWrapper.addChildren(taskChildren);
                            hidWrapper.setGoToElement((Object)sequenceNode);
                            MethodCallAdditionalInfo additionalInfo = new MethodCallAdditionalInfo(this.parserPath.path, rfProject.getProject(), occurrence.getLine(), hid, null, MethodCallAdditionalInfo.CallType.METHOD_CALL);
                            hidWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO, additionalInfo);
                            String seqItemType = this.getSequenceItemType(access);
                            if (seqItemType != null) {
                                hidWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_ARGUMENT_SEQ_ITEM_TYPE, seqItemType);
                            }
                            if (parentAccess != null && (parentAccessType = this.getParentAccessType(parentAccess)) != null) {
                                hidWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_PREPEND_SCOPE_TYPE, parentAccessType);
                            }
                            result.add(hidWrapper);
                        }
                    } else {
                        HidOccurrence occurrence = hid.getOccurrence();
                        if (occurrence != null) {
                            RfClass parentAccessType;
                            String taskFullName = String.valueOf(RfElementPath.path((IRfNamedElement)task).toString()) + " " + occurrence.getOffset();
                            if (knownTaskNames.contains(taskFullName)) {
                                return true;
                            }
                            knownTaskNames.add(taskFullName);
                            VlogSequenceTreeNode sequenceNode = new VlogSequenceTreeNode(currentSequence, currentSequence.getSequence(), null, occurrence.getLine(), occurrence.getOffset(), this.parserPath, SequenceTreeNodeType.SEQUENCE);
                            RfTreeElementWrapper hidWrapper = VlogUVMSequenceTreeViewContributorCommon.this.makeWrapper(element);
                            List<RfTreeElementWrapper> taskChildren = VlogUVMSequenceTreeViewContributorCommon.this.getSequenceBodyContent(visited, sequenceNode, task, rfProject, knownMacros, knownTaskNames);
                            hidWrapper.addChildren(taskChildren);
                            hidWrapper.setGoToElement((Object)sequenceNode);
                            MethodCallAdditionalInfo additionalInfo = new MethodCallAdditionalInfo(this.parserPath.path, rfProject.getProject(), occurrence.getLine(), hid, null, MethodCallAdditionalInfo.CallType.METHOD_CALL);
                            hidWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO, additionalInfo);
                            if (parentAccess != null && (parentAccessType = this.getParentAccessType(parentAccess)) != null) {
                                hidWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_PREPEND_SCOPE_TYPE, parentAccessType);
                            }
                            result.add(hidWrapper);
                        }
                    }
                }
                return true;
            }

            private boolean containsOffset(Hid parentHid, int offset) {
                HidOccurrence occurrence = parentHid.getOccurrence();
                if (occurrence == null) {
                    return false;
                }
                return occurrence.getOffset() == offset;
            }

            private RfClass getParentAccessType(HidAccess parentAccess) {
                if (parentAccess == null) {
                    return null;
                }
                IRfNamedElement assocType = parentAccess.getAssociatedType();
                if (!(assocType instanceof RfClass)) {
                    return null;
                }
                return (RfClass)assocType;
            }

            private String getSequenceItemType(HidAccess hid) {
                IRfNamedElement parentElement;
                if (!(hid instanceof RfHidAccessArgs)) {
                    return null;
                }
                RfHidAccessArgs accessArg = (RfHidAccessArgs)hid;
                if (accessArg.getParentHid() != null && accessArg.getParentHid().getElement() != null && (parentElement = accessArg.getParentHid().getElement()) instanceof RfFunction && !VlogUVMSequenceTreeViewContributorCommon.this.isXVMTask((RfFunction)parentElement)) {
                    return null;
                }
                List<? extends IHidObject> argumentValues = accessArg.getArgumentValues();
                if (argumentValues == null || argumentValues.isEmpty()) {
                    return null;
                }
                IHidObject firstArgument = argumentValues.get(0);
                if (!(firstArgument instanceof RfHidOperator)) {
                    return null;
                }
                IHidObject firstArgumentHid = AssociationUtils.getActualPartRaw((IHidObject)firstArgument, (long)HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
                if (!(firstArgumentHid instanceof RfHid)) {
                    return null;
                }
                IRfNamedElement firstArgumentHidElement = ((RfHid)firstArgumentHid).getElement();
                if (!(firstArgumentHidElement instanceof RfAssociatedType)) {
                    return null;
                }
                RfClass sequence = currentSequence.getSequence();
                RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)sequence, rfProject, 14);
                IRfNamedElement typeElement = ((RfAssociatedType)firstArgumentHidElement).getAssociatedType(resolver);
                if (!(typeElement instanceof RfClass)) {
                    return null;
                }
                if (!(((RfClass)typeElement).isSubClass(((RfClass)typeElement).getClassWithPrefix(VlogUVMSequenceTreeViewContributorCommon.UVM_SEQUENCE_ITEM, 1, 3)) || ((RfClass)typeElement).isSubClass(((RfClass)typeElement).getClassWithPrefix(VlogUVMSequenceTreeViewContributorCommon.OVM_SEQUENCE_ITEM, 1, 3)) || ((RfClass)typeElement).getName().equals(VlogUVMSequenceTreeViewContributorCommon.UVM_SEQUENCE_ITEM) || ((RfClass)typeElement).getName().equals(VlogUVMSequenceTreeViewContributorCommon.OVM_SEQUENCE_ITEM))) {
                    return null;
                }
                return ((RfClass)typeElement).getName();
            }
        };
        RfHidHolder hidHolder = currentElement.getHidHolder();
        if (hidHolder == null) {
            return Collections.emptyList();
        }
        hidHolder.visitHidObject(null, visitor);
        return result;
    }

    protected boolean isXVMTask(RfFunction function) {
        if (function == null || this.fExpandedXVMFilters == null) {
            return false;
        }
        return DVTGUIFilterMatcher.simpleXVMPathMatch((IRfDefElement)function.getDeclaration(), this.fExpandedXVMFilters);
    }

    protected List<RfTreeElementWrapper> sortSequenceBodyElements(List<RfTreeElementWrapper> elements) {
        Collections.sort(elements, (o1, o2) -> {
            VlogSequenceTreeNode node1 = (VlogSequenceTreeNode)((Object)((Object)o1.getGoToElement()));
            VlogSequenceTreeNode node2 = (VlogSequenceTreeNode)((Object)((Object)o2.getGoToElement()));
            return node1.getOffset() - node2.getOffset();
        });
        return elements;
    }

    protected boolean filterNonTerminalLeafsAndApplyContentFilters(IDVTElementWrapper node) {
        if (!node.hasChildren()) {
            return !this.keep(node);
        }
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            IDVTElementWrapper child = (IDVTElementWrapper)iterator.next();
            Object element = child.getRfElement();
            if (element instanceof RfDummyElement && ((RfDummyElement)element).getName().equals("[...recurrence detected]") || !this.filterNonTerminalLeafsAndApplyContentFilters(child)) continue;
            iterator.remove();
        }
        if (node.hasChildren()) {
            return false;
        }
        return !this.keep(node);
    }

    protected boolean keep(IDVTElementWrapper node) {
        IDVTElementWrapper parentNode;
        Object parentRfElement;
        Object rfElement = node.getRfElement();
        if ((rfElement instanceof RfClass || rfElement instanceof RfFunction) && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_SEQUENCE_TREE, (IRfNamedElement)((RfNamedElement)rfElement), () -> this.fLabelProvider.getText(node)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_SEQUENCE_TREE, (IRfNamedElement)((RfNamedElement)(parentRfElement = (parentNode = node.getParent()).getRfElement())), () -> this.fLabelProvider.getText(parentNode)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
            this.fHasGUIFilteredMembers = true;
            return false;
        }
        if (rfElement instanceof RfClass) {
            return true;
        }
        if (rfElement instanceof RfFunction) {
            IDVTElementWrapper parent = node.getParent();
            if (parent == null) {
                return false;
            }
            Object parentElement = parent.getRfElement();
            if (parentElement instanceof RfFunction && !BODY.equals(((RfFunction)parentElement).getName()) && this.isXVMTask((RfFunction)parentElement)) {
                return false;
            }
            if (this.isNotFilterableAPI((RfFunction)rfElement)) {
                return true;
            }
            if (BODY.equals(((RfFunction)rfElement).getName())) {
                return true;
            }
            if (rfElement instanceof RfPredefinedFunction) {
                return false;
            }
            if (!this.isNotFilterableAPI((RfFunction)rfElement) && !node.hasChildren()) {
                return false;
            }
            if (((RfFunction)rfElement).isPure()) {
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isNotFilterableAPI(RfFunction rfElement) {
        if (rfElement == null) {
            return false;
        }
        RfDefElement declaration = rfElement.getDeclaration();
        if (declaration == null) {
            return false;
        }
        RfClass enclosingClass = declaration.getEnclosingScope(RfClass.class);
        if (enclosingClass == null) {
            return false;
        }
        String className = enclosingClass.getName();
        if (UVM_SEQUENCE.equals(className) || OVM_SEQUENCE.equals(className) || UVM_SEQUENCE_ITEM.equals(className) || OVM_SEQUENCE_ITEM.equals(className) || UVM_REG.equals(className) || OVM_REG.equals(className)) {
            return true;
        }
        return enclosingClass.isSubClass(enclosingClass.getClassWithPrefix(UVM_SEQUENCE, 1, 3)) || enclosingClass.isSubClass(enclosingClass.getClassWithPrefix(OVM_SEQUENCE, 1, 3)) || enclosingClass.isSubClass(enclosingClass.getClassWithPrefix(UVM_SEQUENCE_ITEM, 1, 3)) || enclosingClass.isSubClass(enclosingClass.getClassWithPrefix(OVM_SEQUENCE_ITEM, 1, 3)) || enclosingClass.isSubClass(enclosingClass.getClassWithPrefix(UVM_REG, 1, 3)) || enclosingClass.isSubClass(enclosingClass.getClassWithPrefix(OVM_REG, 1, 3));
    }

    protected void updateExpandedXVMFilters(IProject project) {
        this.fExpandedXVMFilters = DVTPredefinedGUIFilters.getXVMFilter();
        DVTGUIFiltersTopFilePatternExpander.expand(this.fExpandedXVMFilters, (IProject)project);
    }
}

