/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.views.MethodCallAdditionalInfo;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.SequenceTreeCommentJob;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.model.reflection.views.VlogSequenceTreeNode;

public class VlogUVMSequenceTreeViewLabelProvider
extends VlogLabelProvider {
    private TypesViewLabelProvider fTypesViewLabelProvider = new TypesViewLabelProvider();
    private final SequenceTreeCommentJob sequenceTreeCommentJob = SequenceTreeCommentJob.getInstance();

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        String result = this.getColumnText(element, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(String instName, String packName) {
        boolean hasPackName;
        StringBuilder result = new StringBuilder("");
        boolean hasInstName = instName != null && !instName.isEmpty();
        boolean bl = hasPackName = packName != null && !packName.isEmpty();
        if (hasInstName) {
            if (hasPackName) {
                result.append(packName);
                result.append("::");
            }
            result.append(instName);
        }
        return result.toString();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)element);
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof RfClass && columnIndex == 0) {
            RfClass clazz = (RfClass)rfElement;
            if (clazz.isSubClass("uvm_sequence", true) || clazz.isSubClass("ovm_sequence", true)) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE);
            }
            if (clazz.isSubClass("uvm_sequence_item", true) || clazz.isSubClass("ovm_sequence_item", true)) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_SEQUENCE_ITEM);
            }
            if (clazz.isInterfaceClass()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
        }
        if (rfElement instanceof RfDummyElement && columnIndex == 0) {
            if (((RfDummyElement)rfElement).getName().equals("[...recurrence detected]")) {
                return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
            }
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (rfElement instanceof RfFunction && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK);
        }
        Object gotoElement = rfWrapper.getGoToElement();
        if (gotoElement instanceof VlogSequenceTreeNode && columnIndex == 0) {
            switch (((VlogSequenceTreeNode)((Object)gotoElement)).getNodeType()) {
                case FORK: {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FORK_JOIN);
                }
                case PROCESS: {
                    return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FORK_JOIN_PROCESS);
                }
            }
        }
        if (rfElement instanceof VlogLanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        RfPackage packagee;
        if (!(element instanceof IDVTElementWrapper)) {
            return "";
        }
        RfTreeElementWrapper wrapper = (RfTreeElementWrapper)((Object)element);
        Object elem = wrapper.getRfElement();
        if (wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(wrapper);
        }
        if (elem instanceof VlogLanguageElement && columnIndex == 0) {
            return (String)((VlogLanguageElement)((Object)elem)).getInfo();
        }
        String packName = "";
        if (wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT) == "package" && elem instanceof RfNamedElement && (packagee = ((RfNamedElement)elem).getEnclosingPackage()) != null) {
            packName = packagee.getName();
        }
        if (elem instanceof RfClass) {
            RfClass sequence = (RfClass)elem;
            if (columnIndex == 0) {
                String instName = "";
                instName = sequence.getName();
                return this.internalGetText(instName, packName);
            }
            return this.getCommentFromWrapper(wrapper);
        }
        if (elem instanceof RfFunction) {
            RfFunction task = (RfFunction)elem;
            if (columnIndex == 0) {
                String instName = "";
                String argType = (String)wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_ARGUMENT_SEQ_ITEM_TYPE);
                String computedScope = null;
                Object prependScope = wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_PREPEND_SCOPE_TYPE);
                if (prependScope instanceof IRfNamedElement) {
                    computedScope = ((IRfNamedElement)prependScope).getName();
                }
                String enclosingScopeName = computedScope == null ? task.getEnclosingScope().getName() : computedScope;
                instName = String.valueOf(enclosingScopeName) + "." + task.getName() + "(" + (argType == null ? "" : argType) + ")";
                return this.internalGetText(instName, packName);
            }
            return this.getCommentFromWrapper(wrapper);
        }
        Object gotoElement = wrapper.getGoToElement();
        if (gotoElement instanceof VlogSequenceTreeNode) {
            switch (((VlogSequenceTreeNode)((Object)gotoElement)).getNodeType()) {
                case FORK: {
                    if (columnIndex == 0) {
                        RfActionBlock actionBlock = ((VlogSequenceTreeNode)((Object)gotoElement)).getActionBlock();
                        return this.internalGetText(this.resolveActionBLockType(actionBlock), "");
                    }
                    return this.getCommentFromWrapper(wrapper);
                }
                case PROCESS: {
                    if (columnIndex == 0) {
                        return this.internalGetText("process", "");
                    }
                    return this.getCommentFromWrapper(wrapper);
                }
            }
        }
        if (elem instanceof String) {
            return "";
        }
        if (elem instanceof RfNamedElement && columnIndex == 0) {
            return this.fTypesViewLabelProvider.getText((Object)wrapper);
        }
        return null;
    }

    public String getCommentFromWrapper(RfTreeElementWrapper wrapper) {
        String comment = (String)wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_ROOT_COMMENT);
        if (comment != null) {
            return ViewsUtils.trimText((String)comment, (int)100, (boolean)true);
        }
        if (!(wrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.SEQ_TREE_METHOD_CALL_INFO) instanceof MethodCallAdditionalInfo)) {
            return "";
        }
        this.sequenceTreeCommentJob.queueWrapper(wrapper);
        if (this.sequenceTreeCommentJob.getState() == 0) {
            this.sequenceTreeCommentJob.schedule();
        }
        return "";
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }

    private String resolveActionBLockType(RfActionBlock block) {
        if (block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN)) {
            return "fork/join";
        }
        if (block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY)) {
            return "fork/join_any";
        }
        if (block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE)) {
            return "fork/join_none";
        }
        if (block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.BEGIN_END)) {
            return "process";
        }
        return null;
    }
}

