/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtilsBase;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.views.RfVHViewUtils;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.views.VlogVHViewContributorCommon;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VlogVHViewContributor
extends VlogVHViewContributorCommon {
    @Override
    public String getTreeLabelText(HistoryItem top) {
        if (top == null || !(top instanceof VHHistoryItem)) {
            return "";
        }
        VHHistoryItem treeHistoryItem = (VHHistoryItem)top;
        RfElementPath objectQName = treeHistoryItem.getObjectQName();
        if (objectQName == null) {
            return "";
        }
        return "[" + treeHistoryItem.getProjectName() + "] " + objectQName.getElementName() + " ";
    }

    @Override
    public void gotoElement(IProject project, Object wrapper) {
        RfClass c;
        RfNamedElementActionHyperlink actionHyperlink;
        if (project == null) {
            return;
        }
        Object obj = this.getRfElementFromWrapper(wrapper);
        if (obj instanceof RfXvmObjectInstance) {
            RfVHViewUtils.openCreateCall(((RfXvmObjectInstance)obj).getCreateCalls(), true, project);
            return;
        }
        if (obj instanceof RfXvmObject && (actionHyperlink = RfUtilsBase.createOpenAction(c = ((RfXvmObject)obj).getRfClass(), project, null)) != null) {
            actionHyperlink.open();
        }
    }

    @Override
    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof RfXvmPort)) {
            return;
        }
        RfField field = ((RfXvmPort)elem).getRfField();
        if (field == null) {
            return;
        }
        RfProject rfProject = field.getRfProject();
        if (rfProject == null) {
            return;
        }
        if (rfProject.getProject() == null) {
            return;
        }
        this.setVHBreadcrumbData(element, rfProject.getProject());
        RfUtilsBase.createOpenAction(field, rfProject.getProject(), null).open();
    }

    @Override
    public String getComment(Object wrapper) {
        return null;
    }

    @Override
    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = null;
        if (wrapper instanceof IDVTElementWrapper) {
            rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        } else if (wrapper instanceof TreePath) {
            rfElement = ((TreePath)wrapper).getElement();
        }
        if (rfElement == null) {
            return false;
        }
        return !ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.treeLabelProvider.getText(wrapper));
    }

    private RfClass getClassFromSelectedWrappedInstance(Object selectedWrapper) {
        Object elem = selectedWrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)selectedWrapper).getRfElement() : selectedWrapper;
        if (!(elem instanceof RfXvmObjectInstance)) {
            return null;
        }
        RfXvmObject object = ((RfXvmObjectInstance)elem).getObject();
        if (object == null) {
            return null;
        }
        return object.getRfClass();
    }

    @Override
    public void openTypeDeclarationAction(Object selectedWrapper, IProject project) {
        RfClass elem = this.getClassFromSelectedWrappedInstance(selectedWrapper);
        if (elem == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = RfUtilsBase.createOpenAction(elem, project, null);
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    @Override
    public void openCreateCallAction(Object selectedWrapper, IProject project) {
        Object elem = selectedWrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)selectedWrapper).getRfElement() : selectedWrapper;
        if (!(elem instanceof RfXvmObjectInstance)) {
            return;
        }
        RfVHViewUtils.openCreateCall(((RfXvmObjectInstance)elem).getCreateCalls(), true, project);
    }

    @Override
    public List<String> getAdditionalContextMenuActionIds(Object selectedWrapper) {
        Object obj;
        if (!(selectedWrapper instanceof IDVTElementWrapper || selectedWrapper instanceof RfXvmBase || selectedWrapper instanceof VHHistoryItem)) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.copyHierarchyPath");
        Object object = obj = selectedWrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)selectedWrapper).getRfElement() : selectedWrapper;
        if (!(obj instanceof RfXvmObjectInstance)) {
            return results;
        }
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.OpenTypeDeclaration");
        return results;
    }

    @Override
    public void openViewForElementAtCursor() {
        VlogQuickViewersUtil.getInstance().openVerificationHierarchyForElementAtCursor();
    }

    @Override
    public void copyHierarchyPathAction(Object element, Object port) {
        String copyHierarchyPathSegmentSeparator = VlogVHViewContributor.getCopyHierarchyPathSegmentSeparator();
        String path = this.computeCopyHierarchyPath(element, port, copyHierarchyPathSegmentSeparator);
        Utils.copyToClipboard((String)path, (int)3);
    }

    @Override
    public Comparator<IDVTElementWrapper> getMembersCategoryComparator() {
        return null;
    }

    @Override
    public void setHasGUIFilteredTree(boolean hasGUIFilteredTree) {
        this.hasGUIFilteredTree = hasGUIFilteredTree;
    }

    @Override
    public boolean hasGUIFilteredTree() {
        return this.hasGUIFilteredTree;
    }

    public static String getCopyHierarchyPathSegmentSeparator() {
        return PrefConst.getCopyHierarchyPathSegmentSepartor();
    }

    @Override
    public void setVHBreadcrumbData(Object treePath, IProject project) {
        try {
            List breadcrumbSegments;
            RfFileDef defFile;
            IRfDefElement declaration;
            if (treePath == null) {
                return;
            }
            Object selectedWrapper = null;
            Object wrapper = null;
            if (treePath instanceof TreePath) {
                selectedWrapper = ((TreePath)treePath).getElement();
            } else if (treePath instanceof IDVTElementWrapper) {
                selectedWrapper = ((IDVTElementWrapper)treePath).getRfElement();
                wrapper = treePath;
            }
            if (!(selectedWrapper instanceof IRfVHBreadcrumbElement)) {
                return;
            }
            Object parent = null;
            IResource file = null;
            boolean addSelf = false;
            if (selectedWrapper instanceof RfXvmPort) {
                IRfNamedElement namedElement = ((RfXvmPort)selectedWrapper).getNamedElement();
                if (namedElement == null) {
                    return;
                }
                declaration = namedElement.getDeclaration();
                if (declaration == null) {
                    return;
                }
                defFile = (RfFileDef)declaration.getDefFile();
                file = (IResource)defFile.getAdapter(IResource.class);
                if (wrapper instanceof IDVTElementWrapper) {
                    parent = ((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MEMBER_PARENT_WRAPPER);
                    if (parent == null) {
                        return;
                    }
                } else {
                    return;
                }
                addSelf = true;
            }
            if (selectedWrapper instanceof RfXvmObjectInstance) {
                if (!((VlogVHBreadcrumbUtils)VlogVHBreadcrumbUtils.getInstance()).isXVMElement((RfXvmObjectInstance)selectedWrapper)) {
                    return;
                }
                List<RfXvmFactory.XVMCreateCall> createCalls = ((RfXvmObjectInstance)selectedWrapper).getCreateCalls();
                RfXvmFactory.XVMCreateCall xvmCreateCall = createCalls.get(createCalls.size() - 1);
                GoToInfo[] goTos = xvmCreateCall.getGoTos();
                GoToInfo goTo = goTos[goTos.length - 1];
                String filePath = goTo.filePath;
                file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, filePath);
            }
            if (selectedWrapper instanceof RfXvmObject) {
                RfClass clazz = ((RfXvmObject)selectedWrapper).getRfClass();
                if (clazz == null) {
                    return;
                }
                declaration = clazz.getDeclaration();
                if (declaration == null) {
                    return;
                }
                defFile = declaration.getDefFile();
                file = (IResource)defFile.getAdapter(IResource.class);
                addSelf = true;
            }
            if (file == null) {
                return;
            }
            List list = breadcrumbSegments = parent instanceof TreePath ? TreePathUtils.getAllElementsToRoot((TreePath)((TreePath)parent), (boolean)addSelf, (boolean)true) : TreePathUtils.getAllElementsToRoot((TreePath)((TreePath)treePath), (boolean)addSelf, (boolean)true);
            if (breadcrumbSegments == null || breadcrumbSegments.isEmpty()) {
                return;
            }
            BreadcrumbInput breadcrumbWrapper = new BreadcrumbInput(project, breadcrumbSegments, VlogVHBreadcrumbUtils.getInstance().getBreadcrumbSerializer());
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbWrapper);
        }
        catch (CoreException e1) {
            DVTLogger.INSTANCE.logError((Throwable)e1);
        }
    }

    public boolean isFactoryUpdateDone(IProject project) {
        if (project == null) {
            return false;
        }
        RfXvmFactory factory = RfVHUtils.getRawXvmFactory(project);
        if (factory == null) {
            return false;
        }
        return factory.isInitDone();
    }

    public void initXVMFactory(IProject project) {
        RfVHUtils.getXvmFactory(project);
    }

    @Override
    protected Boolean adaptsToLanguageKind(Object adapted) {
        return null;
    }
}

