/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.editor.VHDiagramBreadcrumbUtils;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.LabelProviderInput;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.DummyTopSelectionHistoryItem;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VHLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VHPortsLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VHTopDialogLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogInspectViewContributor;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;

public abstract class VlogVHViewContributorCommon
implements IVHViewContributor {
    private static final String OVM_TEST = "ovm_test";
    private static final String UVM_TEST = "uvm_test";
    private static final Comparator<Object> lexicalSorter = (o1, o2) -> {
        boolean firstIsInstance = o1 instanceof RfXvmObjectInstance;
        boolean secondIsInstance = o2 instanceof RfXvmObjectInstance;
        if (firstIsInstance && secondIsInstance) {
            return ((RfXvmObjectInstance)o1).getName().compareTo(((RfXvmObjectInstance)o2).getName());
        }
        if (firstIsInstance) {
            return -1;
        }
        if (secondIsInstance) {
            return 1;
        }
        return 0;
    };
    protected final VHLabelProvider treeLabelProvider = new VHLabelProvider();
    protected final VHTopDialogLabelProvider topDialogLabelProvider = new VHTopDialogLabelProvider();
    protected final VHPortsLabelProvider tableLabelProvider = new VHPortsLabelProvider();
    protected boolean hasGUIFilteredTree;
    protected boolean searchedElementFiltered;
    protected boolean isInterpreterFailed;
    public static final Comparator<RfXvmObject> topDialogCategorySorter = (o1, o2) -> {
        if (o1 == null || o1.getName() == null) {
            return 1;
        }
        if (o2 == null || o2.getName() == null) {
            return -1;
        }
        RfXvmBase.Type type1 = RfXvmFactory.getObjectType(o1);
        String name1 = o1.getName();
        RfXvmBase.Type type2 = RfXvmFactory.getObjectType(o2);
        String name2 = o2.getName();
        if (type1.equals((Object)type2)) {
            return name1.compareTo(name2);
        }
        if (RfXvmBase.Type.ROOT.equals((Object)type1)) {
            return -1;
        }
        if (RfXvmBase.Type.ROOT.equals((Object)type2)) {
            return 1;
        }
        if (RfXvmBase.Type.TEST.equals((Object)type1)) {
            return -1;
        }
        if (RfXvmBase.Type.TEST.equals((Object)type2)) {
            return 1;
        }
        if (RfXvmBase.Type.COMPONENT.equals((Object)type1)) {
            return -1;
        }
        if (RfXvmBase.Type.COMPONENT.equals((Object)type2)) {
            return 1;
        }
        return name1.compareTo(name2);
    };

    public IMembersLabelProvider getMembersViewLabelProvider() {
        return this.tableLabelProvider;
    }

    public MembersViewInput getMembersInput(Object element, StringMatcher stringMatcher) {
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        if (element == null) {
            return emptyResult;
        }
        Object elem = element instanceof IDVTElementWrapper ? ((IDVTElementWrapper)element).getRfElement() : (element instanceof TreePath ? ((TreePath)element).getElement() : element);
        if (elem instanceof RfXvmObjectInstance) {
            elem = ((RfXvmObjectInstance)elem).getObject();
        }
        ArrayList<RfTreeElementWrapper> results = new ArrayList<RfTreeElementWrapper>(4);
        if (elem instanceof IXXVMComponent) {
            IXXVMComponent component = (IXXVMComponent)element;
            List ports = component.getPorts();
            if (ports == null) {
                return new MembersViewInput(results, false);
            }
            for (IXXVMComponent port : ports) {
                RfTreeElementWrapper bw = new RfTreeElementWrapper(port);
                bw.setProject(component.getIProject());
                results.add(bw);
            }
            return new MembersViewInput(results, false);
        }
        if (!(elem instanceof RfXvmObject)) {
            return emptyResult;
        }
        RfXvmObject object = (RfXvmObject)elem;
        for (RfXvmPort port : RfXvmFactory.getAllPorts(object)) {
            RfTreeElementWrapper bw = new RfTreeElementWrapper(port);
            String text = this.tableLabelProvider.getText((Object)bw);
            if (!ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)text)) continue;
            results.add(bw);
        }
        return new MembersViewInput(results, false);
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
    }

    public Comparator<IDVTElementWrapper> getMembersCategoryComparator() {
        return null;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    /*
     * WARNING - void declaration
     */
    public boolean adaptsTo(Object adapted) {
        void dvtTreeElementWrapper;
        DVTTreeElementWrapper namedElement2;
        Object object;
        if (DummyElement.RECURRENCE_NODE.equals(adapted)) {
            return true;
        }
        if (adapted instanceof DummyTopSelectionHistoryItem) {
            return true;
        }
        Boolean adaptsToLanguageKind = this.adaptsToLanguageKind(adapted);
        if (adaptsToLanguageKind != null) {
            return adaptsToLanguageKind;
        }
        if (adapted instanceof TreePath) {
            adapted = ((TreePath)adapted).getElement();
        }
        if (adapted instanceof RfXvmBase) {
            IRfNamedElement namedElement2 = ((RfXvmBase)adapted).getNamedElement();
            if (namedElement2 == null) {
                return false;
            }
            return namedElement2.getLanguageKind() == this.getLanguageKind();
        }
        return adapted instanceof RfTreeElementWrapper || adapted instanceof VHHistoryItem || (object = adapted) instanceof DVTTreeElementWrapper && (namedElement2 = (DVTTreeElementWrapper)object) == (DVTTreeElementWrapper)object && dvtTreeElementWrapper.getLanguageKind().equals((Object)this.getLanguageKind());
    }

    protected abstract Boolean adaptsToLanguageKind(Object var1);

    public void setHasInterpreterFailed(boolean isInterpreterFailed) {
        this.isInterpreterFailed = isInterpreterFailed;
    }

    public boolean hasInterpreterFailed() {
        return this.isInterpreterFailed;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        if (!(wrapper instanceof LabelProviderInput)) {
            return null;
        }
        Object referenceData = ((LabelProviderInput)wrapper).getReferenceData();
        if (!(referenceData instanceof String)) {
            return this.treeLabelProvider;
        }
        String treeID = (String)referenceData;
        if (treeID.equals("default-tree")) {
            return this.treeLabelProvider;
        }
        if (treeID.equals("default-top-dialog")) {
            return this.topDialogLabelProvider;
        }
        return null;
    }

    public String getComment(Object wrapper) {
        return null;
    }

    public void gotoElement(IProject project, Object wrapper) {
    }

    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        return false;
    }

    public List<HistoryItem> getTops(IProject project) {
        if (project == null) {
            return Collections.emptyList();
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return Collections.emptyList();
        }
        ArrayList<HistoryItem> results = new ArrayList<HistoryItem>();
        ArrayList<RfXvmObject> values = new ArrayList<RfXvmObject>();
        List<RfXvmObject> temp = this.getTopUnits(project);
        if (temp != null) {
            values.addAll(temp);
        }
        for (RfXvmObject top : values) {
            HistoryItem item;
            RfElementPath elementPath;
            RfClass clazz = top.getRfClass();
            if (clazz != null && (clazz.isShallowCompiled() || clazz.isIncrementalShallowCompiled()) || clazz != null && (UVM_TEST.equals(clazz.getName()) || OVM_TEST.equals(clazz.getName())) || !RfElementPath.isValid((RfElementPath)(elementPath = RfElementPath.path((IRfNamedElement)clazz))) || (item = VHHistoryItem.parseHistoryItem(project.getName(), elementPath)) == null) continue;
            results.add(item);
        }
        return results;
    }

    public HistoryItem computeHistoryItemFromNamedElement(IProject project, IRfNamedElementAndScope element) {
        if (element == null || project == null) {
            return null;
        }
        RfElementPath xvmObjectQName = null;
        IRfNamedElement namedElement = element.getIRfNamedElement();
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof RfField) {
            RfField field = (RfField)namedElement;
            namedElement = field.getAssociatedType();
        }
        HashSet<IRfNamedElement> visited = new HashSet<IRfNamedElement>();
        visited.add(namedElement);
        while (namedElement instanceof IRfListType || namedElement instanceof IRfTypeAliasElement) {
            if (visited.contains(namedElement = ((IRfAssociatedTypeElement)namedElement).getAssociatedType())) break;
            visited.add(namedElement);
        }
        if (namedElement instanceof RfClass) {
            xvmObjectQName = RfElementPath.path((IRfNamedElement)namedElement);
        }
        if (xvmObjectQName == null) {
            return null;
        }
        HistoryItem item = VHHistoryItem.parseHistoryItem(project.getName(), xvmObjectQName);
        return item;
    }

    private List<RfXvmObject> getTopUnits(IProject project) {
        if (project == null) {
            return Collections.emptyList();
        }
        RfXvmFactory factory = RfVHUtils.getXvmFactory(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        if (factory.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RfXvmObject> results = new ArrayList<RfXvmObject>();
        Set<RfXvmObject> candidates = Collections.newSetFromMap(new IdentityHashMap());
        candidates.addAll(factory.getObjects());
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        for (RfXvmObject cand : candidates) {
            if (!RfXvmBase.Type.TEST.equals((Object)RfXvmFactory.getObjectType(cand))) continue;
            results.add(cand);
        }
        if (results.size() > 1) {
            Collections.sort(results, topDialogCategorySorter);
        }
        return results;
    }

    public String getTreeLabelText(HistoryItem item) {
        return null;
    }

    public boolean acceptsHistoryItem(HistoryItem item) {
        return item instanceof VHHistoryItem;
    }

    public HistoryItem parseHistoryItem(String projectName, String historyItemText) {
        return VHHistoryItem.parseHistoryItem(projectName, historyItemText);
    }

    public void openViewForElementAtCursor() {
    }

    public List<String> getAdditionalContextMenuActionIds(Object selectedWrapper) {
        return null;
    }

    public void openTypeDeclarationAction(Object selectedWrapper, IProject project) {
    }

    public void openCreateCallAction(Object selectedWrapper, IProject project) {
    }

    public void setHasGUIFilteredTree(boolean hasGUIFilteredTree) {
    }

    public boolean hasGUIFilteredTree() {
        return false;
    }

    public void setSearchedElementFiltered(boolean searchedElementFiltered) {
        this.searchedElementFiltered = searchedElementFiltered;
    }

    public boolean isSearchedElementFiltered() {
        return this.searchedElementFiltered;
    }

    public TreePath createRootTreePath(HistoryItem top, TreePath parent, boolean isPrependPackage, IProgressMonitor monitor) {
        RfXvmObject object = this.getXVMObjectFromHistoryItem(top);
        if (object == null) {
            return null;
        }
        VHLabelProvider lProvider = new VHLabelProvider();
        String text = lProvider.getText(object);
        TreePath child = TreePath.child((TreePath)parent, (String)text, (int)0, (Comparator)treePathComparator);
        child.setElement((Object)object);
        return child;
    }

    public List<Object> getChildrenForElement(Object top, IRfFilterableTreeAccessor view, boolean prependPackage, boolean isAlphabeticalSort, boolean showComponentsOnly, IProject project, IProgressMonitor monitor) {
        if (!this.c(project)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        RfXvmObject object = this.computeXvmObject(top);
        if (monitor.isCanceled()) {
            return null;
        }
        if (object == null) {
            return null;
        }
        VHLabelProvider labelProvider = new VHLabelProvider();
        for (RfXvmObjectInstance childInstance : RfXvmFactory.getChildInstances(object)) {
            if (monitor.isCanceled()) {
                return result;
            }
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.VERIFICATION_HIERARCHY, (IRfNamedElement)childInstance.getNamedElement(), () -> labelProvider.getText(childInstance)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (!this.searchedElementFiltered) {
                    if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(childInstance)), (IRfFilterableTreeAccessor)view)) {
                        this.searchedElementFiltered = true;
                    } else if (!RfXvmFactory.getChildInstances(this.computeXvmObject(childInstance)).isEmpty()) {
                        this.searchedElementFiltered = this.hasFilteredSearchedLocalMember(this.computeXvmObject(childInstance), view);
                    }
                }
                this.setHasGUIFilteredTree(true);
                continue;
            }
            if (showComponentsOnly && !RfXvmBase.Type.COMPONENT_INSTANCE.equals((Object)RfXvmFactory.getObjectType(childInstance))) continue;
            result.add(childInstance);
        }
        if (isAlphabeticalSort && !result.isEmpty()) {
            Collections.sort(result, lexicalSorter);
        }
        return result;
    }

    public IRfNamedElement getMemberNamedElement(Object element) {
        if (!(element instanceof IDVTElementWrapper)) {
            return null;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement instanceof RfXvmBase) {
            return ((RfXvmBase)rfElement).getNamedElement();
        }
        if (rfElement instanceof IXXVMComponent) {
            return ((IXXVMComponent)rfElement).getNamedElement();
        }
        return null;
    }

    protected RfXvmObject getXVMObjectFromHistoryItem(HistoryItem top) {
        if (!(top instanceof VHHistoryItem)) {
            return null;
        }
        VHHistoryItem vhi = (VHHistoryItem)top;
        String projectName = vhi.getProjectName();
        RfElementPath objectQName = vhi.getObjectQName();
        if (projectName == null || objectQName == null) {
            return null;
        }
        IProject project = Utils.getProject((String)projectName);
        if (project == null) {
            return null;
        }
        if (!this.c(project)) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfXvmObject object = RfVHUtils.getXvmObject(project, objectQName);
        return object;
    }

    private RfXvmObject computeXvmObject(Object top) {
        if (top instanceof VHHistoryItem) {
            VHHistoryItem vhi = (VHHistoryItem)((Object)top);
            return this.getXVMObjectFromHistoryItem(vhi);
        }
        if (top instanceof RfXvmObject) {
            return (RfXvmObject)top;
        }
        if (top instanceof RfXvmObjectInstance) {
            return ((RfXvmObjectInstance)top).getObject();
        }
        return null;
    }

    private boolean hasFilteredSearchedLocalMember(RfXvmObject parentElement, IRfFilterableTreeAccessor view) {
        if (parentElement != null && !parentElement.hasChildInstances()) {
            return false;
        }
        List<RfXvmObjectInstance> childElements = RfXvmFactory.getChildInstances(parentElement);
        for (RfXvmObjectInstance element : childElements) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(element)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(this.computeXvmObject(element), view)) continue;
            return true;
        }
        return false;
    }

    public String getText(Object dvtElementWrapper, TreePath ... parent) {
        return this.treeLabelProvider.getText(dvtElementWrapper);
    }

    public boolean c(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F7376");
    }

    public GoToInfo getInstanceMarker(List<String> names, List<String> types, IProject project) {
        RfXvmBase data = this.getXVMObject(names, types, project);
        if (!(data instanceof RfXvmObjectInstance)) {
            return null;
        }
        RfXvmObjectInstance xvmInstance = (RfXvmObjectInstance)data;
        List<RfXvmFactory.XVMCreateCall> createCalls = xvmInstance.getCreateCalls();
        if (createCalls == null || createCalls.isEmpty()) {
            return null;
        }
        LinkedHashSet goTos = new LinkedHashSet();
        for (RfXvmFactory.XVMCreateCall createCall : createCalls) {
            Collections.addAll(goTos, createCall.getGoTos());
        }
        if (goTos.isEmpty()) {
            return null;
        }
        Object[] array = goTos.toArray();
        GoToInfo goToInfo = (GoToInfo)array[array.length - 1];
        return goToInfo;
    }

    public void setVHBreadcrumbData(List<String> names, List<String> types, String filePath, IProject project) {
        try {
            RfXvmFactory.XVMPath xvmPath = RfVHUtils.getXVMPath(names, types);
            if (xvmPath == null) {
                return;
            }
            IBreadcrumbSerializer breadcrumbSerializer = VHDiagramBreadcrumbUtils.getUtils((LanguageKind)LanguageKind.VLOG).getBreadcrumbSerializer();
            if (breadcrumbSerializer == null) {
                return;
            }
            List breadcrumbSegments = breadcrumbSerializer.restoreBreadcrumbSegments((Object)xvmPath, project);
            if (breadcrumbSegments == null || breadcrumbSegments.isEmpty()) {
                return;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, filePath);
            if (file == null) {
                return;
            }
            BreadcrumbInput breadcrumbWrapper = new BreadcrumbInput(project, breadcrumbSegments, breadcrumbSerializer);
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbWrapper);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isValidVHElement(List<String> names, List<String> types, IProject project) {
        return this.getXVMObject(names, types, project) instanceof RfXvmObjectInstance;
    }

    private RfXvmBase getXVMObject(List<String> names, List<String> types, IProject project) {
        return RfVHUtils.getXVMObject(RfVHUtils.getXVMPath(names, types), project);
    }

    public GoToInfo getPortMarker(List<String> names, List<String> types, String portName, String portType, IProject project) {
        if (portName == null || portType == null) {
            return null;
        }
        RfXvmBase data = this.getXVMObject(names, types, project);
        if (!(data instanceof RfXvmObjectInstance)) {
            return null;
        }
        RfXvmObjectInstance xvmInstance = (RfXvmObjectInstance)data;
        List<RfXvmPort> allPorts = RfXvmFactory.getAllPorts(xvmInstance.getObject());
        if (allPorts == null || allPorts.isEmpty()) {
            return null;
        }
        for (RfXvmPort port : allPorts) {
            String name = port.getName();
            RfNamedElement portTypeNamedElement = port.getPortType();
            if (portTypeNamedElement == null || !portName.equals(name) || !portType.equals(portTypeNamedElement.getName())) continue;
            RfField portField = port.getRfField();
            return GoToInfo.sourceOf((IRfNamedElement)portField);
        }
        return null;
    }

    public GoToInfo getTypeMarker(List<String> names, List<String> types, IProject project) {
        RfXvmBase xvmBase = this.getXVMObject(names, types, project);
        if (!(xvmBase instanceof RfXvmObjectInstance)) {
            return null;
        }
        RfXvmObject xvmObject = ((RfXvmObjectInstance)xvmBase).getObject();
        if (xvmObject == null) {
            return null;
        }
        IRfNamedElement namedElement = xvmObject.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        GoToInfo declarationGoToInfo = GoToInfo.sourceOf((IRfNamedElement)namedElement);
        if (declarationGoToInfo == null) {
            return null;
        }
        this.setVHBreadcrumbData(names, types, declarationGoToInfo.filePath, project);
        return declarationGoToInfo;
    }

    public GoToInfo getTypeMarker(String type, IProject project) {
        RfDefElement[] classDefs;
        if (type == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        if (type.contains("#")) {
            type = type.substring(0, type.indexOf(35));
        }
        if ((classDefs = rfProject.getAllClassDefs(type)) == null || classDefs.length == 0) {
            return null;
        }
        RfDefElement declaration = classDefs[classDefs.length - 1];
        return GoToInfo.sourceOf((IRfDefElement)declaration, (String)type);
    }

    public void copyHierarchyPathAction(Object selectedWrapper, Object port) {
    }

    public void setVHBreadcrumbData(Object selectedWrapper, IProject project) {
    }

    public String computeCopyHierarchyPath(Object element, Object port, String separator) {
        ViewsUtils.ITreePathAccessor viewsUtils = wrapper -> {
            if (wrapper == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            Object obj = this.getRfElementFromWrapper(wrapper);
            if (obj instanceof RfXvmObjectInstance) {
                result.append(((RfXvmObjectInstance)obj).getName());
                if (((RfXvmObjectInstance)obj).isArray()) {
                    result.append("[0]");
                }
            } else if (obj instanceof RfXvmPort) {
                result.append(((RfXvmPort)obj).getName());
            } else if (obj instanceof RfXvmBase) {
                result.append(((RfXvmBase)obj).getName());
            }
            return result.toString();
        };
        String portPath = ViewsUtils.pathToRoot((Object)port, (String)PrefConst.getCopyHierarchyPathSegmentSepartor(), (ViewsUtils.ITreePathAccessor)viewsUtils);
        if (element != null) {
            String elementPath = ViewsUtils.pathToRoot((Object)element, (String)PrefConst.getCopyHierarchyPathSegmentSepartor(), (ViewsUtils.ITreePathAccessor)viewsUtils);
            portPath = portPath.equals("") ? "" : String.valueOf(separator) + portPath;
            return String.valueOf(elementPath) + portPath;
        }
        return portPath;
    }

    protected Object getRfElementFromWrapper(Object wrapper) {
        if (wrapper instanceof IDVTElementWrapper) {
            return ((IDVTElementWrapper)wrapper).getRfElement();
        }
        if (wrapper instanceof TreePath) {
            return ((TreePath)wrapper).getElement();
        }
        return wrapper;
    }

    public InspectViewInput getInspectContent(IDVTElementWrapper wrapper) {
        IProject project = wrapper.getProject();
        if (project == null) {
            return null;
        }
        Object obj = wrapper.getRfElement();
        if (obj instanceof RfXvmObjectInstance) {
            LinkedList<InspectViewGoToInfo> goTos = new LinkedList<InspectViewGoToInfo>();
            List<RfXvmFactory.XVMCreateCall> createCalls = ((RfXvmObjectInstance)obj).getCreateCalls();
            for (RfXvmFactory.XVMCreateCall createCall : createCalls) {
                GoToInfo[] goToInfoArray = createCall.getGoTos();
                int n = goToInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GoToInfo goTo = goToInfoArray[n2];
                    goTos.add(new InspectViewGoToInfo(goTo));
                    ++n2;
                }
            }
            return DVTInspectViewUtils.getInstance().processGoToInfos(goTos, project, LanguageKind.VLOG);
        }
        if (obj instanceof RfXvmObject) {
            RfClass c = ((RfXvmObject)obj).getRfClass();
            if (c == null) {
                return null;
            }
            return VlogInspectViewContributor.getInstance().processNamedElement(project, c, null, null, null);
        }
        if (obj instanceof RfXvmPort) {
            RfField field = ((RfXvmPort)obj).getRfField();
            if (field == null) {
                return null;
            }
            return VlogInspectViewContributor.getInstance().processNamedElement(project, field, null, null, null);
        }
        return null;
    }
}

