/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.LabelProviderInput;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.uvm.hierarchy.IXVMBrowserViewContributor;
import ro.amiq.dvt.ui.views.uvm.hierarchy.XVMBrowserViewInput;
import ro.amiq.dvt.ui.views.uvm.hierarchy.XVMBrowserViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfScopeUtil;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.THViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.views.XVMBrowserViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.ui.editor.override.VlogOveriddenElementInserter;
import ro.amiq.vlogdt.ui.editor.utils.VlogMethodsInsertConfigurationProvider;

public class VlogXVMBrowserViewContributor
implements IXVMBrowserViewContributor {
    private static final String PORTS_CATEGORY = "Ports";
    private static final String PKG = "_pkg";
    private static final String UVM_PKG = "uvm_pkg";
    private static final String OVM_PKG = "ovm_pkg";
    private static final String VOID = "_void";
    private static final HashSet<String> RANDOM_PREDEFINED_FUNCTIONS = new HashSet<String>(Arrays.asList("pre_randomize", "post_randomize"));
    private static final HashSet<String> XVM_DRIVER = new HashSet<String>(Arrays.asList("ovm_driver", "uvm_driver"));
    private static final HashSet<String> XVM_SEQUENCER = new HashSet<String>(Arrays.asList("ovm_sequencer", "uvm_sequencer"));
    private static final HashSet<String> XVM_SEQUENCE = new HashSet<String>(Arrays.asList("ovm_sequence", "uvm_sequence"));
    private static final HashSet<String> XVM_PORT_BASE = new HashSet<String>(Arrays.asList("ovm_port_base", "uvm_port_base"));
    private static final HashSet<String> XVM_SEQUENCE_ITEM = new HashSet<String>(Arrays.asList("ovm_sequence_item", "uvm_sequence_item"));
    private static final Map<String, String> UVM_COMPONENTS = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("uvm_agent", "Agents");
            this.put("uvm_driver", "Drivers");
            this.put("uvm_env", "Envs");
            this.put("uvm_monitor", "Monitors");
            this.put("uvm_sequence_item", "Items");
            this.put("uvm_reg", "Registers");
            this.put("uvm_reg_backdoor", "Backdoor Registers");
            this.put("uvm_reg_frontdoor", "Frontdoor Registers");
            this.put("uvm_reg_adapter", "Register Adapters");
            this.put("uvm_reg_block", "Register Blocks");
            this.put("uvm_reg_field", "Register Fields");
            this.put("uvm_reg_map", "Register Maps");
            this.put("uvm_reg_predictor", "Register Predictors");
            this.put("uvm_reg_sequence", "Register Sequences");
            this.put("uvm_reg_fifo", "FIFO Registers");
            this.put("uvm_reg_file", "Register Files");
            this.put("uvm_scoreboard", "Scoreboards");
            this.put("uvm_sequencer", "Sequencers");
            this.put("uvm_sequence", "Sequences");
            this.put("uvm_test", "Tests");
            this.put("uvm_component", "Other Components");
            this.put("uvm_object", "Other Objects");
            this.put("uvm_mem", "Memories");
        }
    };
    private static final Set<String> UVM_PORTS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("uvm_port_base");
            this.add("uvm_tlm_if_base");
            this.add("uvm_tlm_extension_base");
            this.add("uvm_sqr_if_base");
            this.add("uvm_tlm_req_rsp_channel");
            this.add("uvm_tlm_fifo_base");
        }
    };
    private static final Map<String, String> OVM_COMPONENTS = new TreeMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ovm_agent", "Agents");
            this.put("ovm_driver", "Drivers");
            this.put("ovm_env", "Envs");
            this.put("ovm_monitor", "Monitors");
            this.put("ovm_sequence_item", "Items");
            this.put("ovm_reg", "Registers");
            this.put("ovm_reg_backdoor", "Backdoor Registers");
            this.put("ovm_reg_frontdoor", "Frontdoor Registers");
            this.put("ovm_reg_adapter", "Register Adapters");
            this.put("ovm_reg_block", "Register Blocks");
            this.put("ovm_reg_field", "Register Fields");
            this.put("ovm_reg_map", "Register Maps");
            this.put("ovm_reg_sequence", "Register Sequences");
            this.put("ovm_reg_fifo", "FIFO Registers");
            this.put("ovm_reg_file", "Register Files");
            this.put("ovm_scoreboard", "Scoreboards");
            this.put("ovm_sequencer", "Sequencers");
            this.put("ovm_sequence", "Sequences");
            this.put("ovm_test", "Tests");
            this.put("ovm_component", "Other Components");
            this.put("ovm_object", "Other Objects");
            this.put("ovm_mem", "Memories");
        }
    };
    private static final Set<String> OVM_PORTS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("ovm_port_base");
            this.add("tlm_if_base");
            this.add("sqr_if_base");
            this.add("tlm_req_rsp_channel");
            this.add("tlm_fifo_base");
        }
    };
    private static final Set<String> NON_XVM_PORTS = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("tlm_if_base");
            this.add("sqr_if_base");
        }
    };
    private THViewLabelProvider fMembersLabelProvider = new THViewLabelProvider(true);
    private XVMBrowserViewLabelProvider fComponentsLabelProvider = new XVMBrowserViewLabelProvider();
    private boolean fHasGUIFilteredMembers;
    private boolean fHasGUIFilteredTree;
    private boolean fHasSearchedElementFiltered;
    private boolean fHasSearchedMemberFiltered;
    private Set<RfClass> fPhysicalSequencers = new HashSet<RfClass>();
    private Map<RfPackage, IDVTElementWrapper> fPackageWrappers = new HashMap<RfPackage, IDVTElementWrapper>();
    boolean fXvmBrowserViewGroupByPackage;
    boolean fXvmBrowserViewPrependPackage;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        Object rfElement = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)rfElement;
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return;
        }
        Object element = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)element, project, null);
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public XVMBrowserViewInput getInput(XVMBrowserViewInputConfigurator inputConfig) {
        List<Object> componentElements = new ArrayList();
        List<Object> memberElements = new ArrayList();
        try {
            IProject project = inputConfig.getProject();
            this.fHasGUIFilteredMembers = false;
            this.fHasGUIFilteredTree = false;
            this.fHasSearchedElementFiltered = false;
            this.fHasSearchedMemberFiltered = false;
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
            rfProject.getXvmFactory();
            if (inputConfig.getElement() != null && inputConfig.getElement().getRfElement() instanceof RfNamedElement) {
                memberElements = this.getSortedMembers(rfProject, inputConfig.getMembersStringMatcher(), ((RfNamedElement)inputConfig.getElement().getRfElement()).getName(), inputConfig.getUpdateJob());
            }
            if (!inputConfig.getUpdateOnlyMembers()) {
                componentElements = this.getComponentsData(rfProject, inputConfig.getComponentsStringMatcher(), inputConfig.getUpdateJob());
            }
            RfTreeElementWrapper tmpRoot = new RfTreeElementWrapper();
            tmpRoot.addChildren(componentElements);
            if (inputConfig.isShowLanguageNameAsRootElement()) {
                String langInfo = LanguageKind.VLOG.VIEW_NAME;
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new VlogLanguageElement<String>(langInfo));
                languageWrapper.addChildren(tmpRoot.getChildren());
                return new XVMBrowserViewInput(Arrays.asList(new IDVTElementWrapper[]{languageWrapper}), memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new XVMBrowserViewInput(componentElements, memberElements, this.fHasGUIFilteredMembers, this.fHasGUIFilteredTree, this.fHasSearchedElementFiltered, this.fHasSearchedMemberFiltered);
    }

    private RfClass getClazz(UpdateViewEvent event) {
        IProject project = Utils.getProject((String)event.getProjectName());
        if (!project.isAccessible()) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return this.getClazz(rfProject, event.getElementName(), (List)event.getElementScope());
    }

    private RfClass getClazz(RfProject project, String elementName, List<RfNameTypeScopeHelper> elementScope) {
        IRfScopeElement classScope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
        if (classScope == null || !(classScope instanceof IRfScope)) {
            return null;
        }
        RfClass candidate = ((IRfScope)classScope).getClassWithPrefix(elementName, 1, 1);
        if (classScope instanceof RfClass && candidate == null) {
            candidate = (RfClass)classScope;
        }
        return candidate;
    }

    private List<IDVTElementWrapper> getComponentsData(RfProject project, StringMatcher matcher, UpdateJob updateJob) {
        this.fPhysicalSequencers = new HashSet<RfClass>();
        List<IDVTElementWrapper> ovmComponents = this.getComponentsData(project, matcher, updateJob, RfXvmFactory.RfXvmType.OVM);
        List<IDVTElementWrapper> uvmComponents = this.getComponentsData(project, matcher, updateJob, RfXvmFactory.RfXvmType.UVM);
        List<IDVTElementWrapper> result = this.mergeTrees(uvmComponents, ovmComponents);
        RfTreeElementWrapper tmp = new RfTreeElementWrapper("");
        tmp.addChildren(result);
        this.sortAndFilter(tmp, matcher, false);
        return tmp.getChildren() == null ? new ArrayList() : tmp.getChildren();
    }

    private List<IDVTElementWrapper> getComponentsData(RfProject project, StringMatcher matcher, UpdateJob updateJob, RfXvmFactory.RfXvmType type) {
        List<Object> result = new ArrayList<IDVTElementWrapper>();
        RfNamedElement xvmPkg = null;
        for (RfPackage pkg : project.getAllPackages(true)) {
            if (!(String.valueOf(type.toString().toLowerCase()) + PKG).equals(pkg.getName())) continue;
            xvmPkg = pkg;
        }
        if (xvmPkg == null) {
            return result;
        }
        RfClass xvmVoid = xvmPkg.getClassWithPrefix(String.valueOf(type.toString().toLowerCase()) + VOID, 1, 1);
        if (xvmVoid == null) {
            return result;
        }
        this.fPackageWrappers.clear();
        this.fXvmBrowserViewGroupByPackage = PrefConst.getUVMBrowserViewGroupByPackage();
        this.fXvmBrowserViewPrependPackage = PrefConst.getUVMBrowserViewPrependPackage();
        this.buildTrees(new HashSet<RfClass>(), xvmVoid, matcher, updateJob, null);
        this.addPorts(type, (RfPackage)xvmPkg, matcher, updateJob);
        this.addPhysicalIcon();
        result = this.fPackageWrappers.keySet().size() == 1 && this.fPackageWrappers.keySet().iterator().next() == null ? this.fPackageWrappers.get(null).getChildren() : new ArrayList<IDVTElementWrapper>(this.fPackageWrappers.values());
        return result;
    }

    private void addPorts(RfXvmFactory.RfXvmType type, RfPackage xvmPkg, StringMatcher matcher, UpdateJob updateJob) {
        for (String port : NON_XVM_PORTS) {
            String portBaseClassName = type == RfXvmFactory.RfXvmType.UVM ? String.valueOf(type.toString().toLowerCase()) + "_" + port : port;
            RfClass portBaseClass = xvmPkg.getClassWithPrefix(portBaseClassName, 1, 1);
            if (portBaseClass == null) continue;
            this.buildTrees(new HashSet<RfClass>(), portBaseClass, matcher, updateJob, null);
        }
    }

    private void addPhysicalIcon() {
        if (this.fPackageWrappers.isEmpty()) {
            return;
        }
        if (this.fPackageWrappers.keySet().size() == 1 && this.fPackageWrappers.keySet().iterator().next() == null) {
            for (IDVTElementWrapper seq : this.fPackageWrappers.get(null).getAllChildren()) {
                if (seq.toString().equals("Sequences")) {
                    this.checkPhysicalSequence(seq);
                }
                if (!seq.toString().equals("Sequencers")) continue;
                this.checkPhysicalSequencer(seq);
            }
        } else {
            for (IDVTElementWrapper value : this.fPackageWrappers.values()) {
                for (IDVTElementWrapper seq : value.getAllChildren()) {
                    if (seq.toString().equals("Sequences")) {
                        this.checkPhysicalSequence(seq);
                    }
                    if (!seq.toString().equals("Sequencers")) continue;
                    this.checkPhysicalSequencer(seq);
                }
            }
        }
    }

    private List<IDVTElementWrapper> mergeTrees(List<IDVTElementWrapper> uvmComponents, List<IDVTElementWrapper> ovmComponents) {
        List<IDVTElementWrapper> result = uvmComponents;
        if (result.isEmpty()) {
            return ovmComponents;
        }
        if (this.fXvmBrowserViewGroupByPackage) {
            for (IDVTElementWrapper ovmPackageWrapper : ovmComponents) {
                String ovmPackageName = ((RfNamedElement)ovmPackageWrapper.getRfElement()).getName();
                if (!result.toString().contains(ovmPackageName)) continue;
                for (IDVTElementWrapper uvmPackageWrapper : result) {
                    RfNamedElement namedElement = (RfNamedElement)uvmPackageWrapper.getRfElement();
                    if (!namedElement.getName().equals(ovmPackageName)) continue;
                    this.mergeXvmCategories(uvmPackageWrapper.getChildren(), ovmPackageWrapper.getChildren());
                }
            }
        } else {
            this.mergeXvmCategories(uvmComponents, ovmComponents);
        }
        return result;
    }

    private void mergeXvmCategories(List<IDVTElementWrapper> uvmCategories, List<IDVTElementWrapper> ovmCategories) {
        for (IDVTElementWrapper ovmCategoryWrapper : ovmCategories) {
            String ovmCategoryName = ((RfNamedElement)ovmCategoryWrapper.getRfElement()).getName();
            if (!uvmCategories.toString().contains(ovmCategoryName)) continue;
            for (IDVTElementWrapper uvmCategoryWrapper : uvmCategories) {
                if (!((RfNamedElement)uvmCategoryWrapper.getRfElement()).getName().equals(ovmCategoryName)) continue;
                for (IDVTElementWrapper child : ovmCategoryWrapper.getChildren()) {
                    uvmCategoryWrapper.addChild(child);
                }
            }
        }
    }

    private boolean sortAndFilter(IDVTElementWrapper w, StringMatcher matcher, boolean matched) {
        if (matcher != null) {
            boolean iMatch = ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fComponentsLabelProvider.getText(w));
            if (iMatch) {
                w.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH, (Object)"*");
            }
            matched = matched || iMatch;
        } else {
            matched = true;
        }
        if (w.getChildren() == null || w.getChildren().isEmpty()) {
            return matched;
        }
        boolean oneChildMatched = false;
        Iterator iterator = w.getChildren().iterator();
        while (iterator.hasNext()) {
            IDVTElementWrapper c = (IDVTElementWrapper)iterator.next();
            boolean childMatched = this.sortAndFilter(c, matcher, matched);
            boolean bl = oneChildMatched = oneChildMatched || childMatched;
            if (childMatched) continue;
            iterator.remove();
        }
        Collections.sort(w.getChildren(), new HierarchyWrappersLexicalSorter());
        return oneChildMatched;
    }

    private Map<PkgCat, RfTreeElementWrapper> buildTrees(Set<RfClass> visited, RfClass clazz, StringMatcher matcher, UpdateJob updateJob, String category) {
        String prependPkgText;
        boolean isUVMCategory = UVM_COMPONENTS.containsKey(clazz.getName());
        boolean isUVMPort = UVM_PORTS.contains(clazz.getName());
        boolean isOVMCategory = OVM_COMPONENTS.containsKey(clazz.getName());
        boolean isOVMPort = OVM_PORTS.contains(clazz.getName());
        if (isUVMCategory) {
            category = UVM_COMPONENTS.get(clazz.getName());
        }
        if (isUVMPort) {
            category = PORTS_CATEGORY;
        }
        if (isOVMCategory) {
            category = OVM_COMPONENTS.get(clazz.getName());
        }
        if (isOVMPort) {
            category = PORTS_CATEGORY;
        }
        boolean isCategory = isOVMCategory || isUVMCategory || isOVMPort || isUVMPort;
        RfPackage myPkg = clazz.getEnclosingPackage();
        String string = prependPkgText = myPkg == null ? "" : String.valueOf(myPkg.getName()) + "::";
        if (myPkg == null) {
            myPkg = XVMBrowserViewLabelProvider.DEFAULT_PKG;
        }
        RfPackage pkgGroup = null;
        if (this.fXvmBrowserViewGroupByPackage) {
            pkgGroup = myPkg;
        }
        HashMap<PkgCat, RfTreeElementWrapper> result = new HashMap<PkgCat, RfTreeElementWrapper>();
        boolean circularInheritance = visited.contains(clazz);
        Set<RfClass> children = clazz.getChildren();
        if (children == null || children.isEmpty() || circularInheritance) {
            if (isCategory) {
                return null;
            }
            this.extractPhysicalSequencers(clazz);
            RfTreeElementWrapper rfTreeElementWrapper = new RfTreeElementWrapper(clazz);
            if (this.fXvmBrowserViewPrependPackage) {
                rfTreeElementWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, prependPkgText);
            }
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_BROWSER_CLASSES, (IRfNamedElement)clazz, () -> this.fComponentsLabelProvider.getText((Object)me)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (!this.fHasSearchedElementFiltered && ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fComponentsLabelProvider.getText((Object)rfTreeElementWrapper))) {
                    this.fHasSearchedElementFiltered = true;
                }
                this.fHasGUIFilteredTree = true;
                return null;
            }
            if (category == null) {
                return null;
            }
            result.put(new PkgCat(pkgGroup, category), rfTreeElementWrapper);
            if (circularInheritance) {
                rfTreeElementWrapper.addChild(new RfTreeElementWrapper(new RfDummyElement("[...recurrence detected]")));
            }
            return result;
        }
        visited.add(clazz);
        if (!isCategory) {
            this.extractPhysicalSequencers(clazz);
        }
        for (RfClass rfClass : children) {
            Map<PkgCat, RfTreeElementWrapper> childTrees;
            RfClass parent;
            if (rfClass instanceof RfSpecializedClass || (parent = rfClass.getParent()) != null && parent.getGenericClass() != clazz || (childTrees = this.buildTrees(new HashSet<RfClass>(visited), rfClass, matcher, updateJob, category)) == null) continue;
            for (Map.Entry<PkgCat, RfTreeElementWrapper> entry : childTrees.entrySet()) {
                PkgCat pkgCat = entry.getKey();
                RfTreeElementWrapper me = (RfTreeElementWrapper)((Object)result.get(pkgCat));
                if (me == null) {
                    if (isCategory) {
                        me = new RfTreeElementWrapper(new RfDummyElement(category));
                    } else {
                        me = new RfTreeElementWrapper(clazz);
                        if (this.fXvmBrowserViewPrependPackage || pkgGroup != pkgCat.pkg) {
                            me.setAdditionalInfo(IDVTElementWrapper.Attribute.PREPEND_TEXT, prependPkgText);
                        }
                        if (pkgGroup != pkgCat.pkg) {
                            me.setAdditionalInfo(IDVTElementWrapper.Attribute.OVR_OUTSIDE_PACKAGE, "");
                        }
                    }
                    result.put(pkgCat, me);
                }
                me.addChild(entry.getValue());
            }
            if (!ViewsUtils.isCanceled((IDVTJob)updateJob)) continue;
            return null;
        }
        if (isCategory) {
            for (Map.Entry entry : result.entrySet()) {
                PkgCat pkgCat = (PkgCat)entry.getKey();
                RfTreeElementWrapper wrapper = (RfTreeElementWrapper)((Object)entry.getValue());
                IDVTElementWrapper packWrapper = this.fPackageWrappers.get(pkgCat.pkg);
                if (packWrapper == null) {
                    packWrapper = new RfTreeElementWrapper(pkgCat.pkg);
                    this.fPackageWrappers.put(pkgCat.pkg, packWrapper);
                }
                boolean added = false;
                if (packWrapper.getChildren() != null && !packWrapper.getChildren().isEmpty()) {
                    for (IDVTElementWrapper child : packWrapper.getChildren()) {
                        if (!((RfNamedElement)child.getRfElement()).getName().equals(((RfNamedElement)wrapper.getRfElement()).getName())) continue;
                        child.addChildren(wrapper.getChildren());
                        added = true;
                    }
                }
                if (added) continue;
                packWrapper.addChild((IDVTElementWrapper)wrapper);
            }
            return null;
        }
        return result;
    }

    public void checkPhysicalSequencer(IDVTElementWrapper seq) {
        Object clazz = seq.getRfElement();
        if (clazz instanceof RfClass && this.isPhysicalSequencer((RfClass)clazz)) {
            seq.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.XVM_BROWSER_IS_PHYSICAL_SEQ, (Object)"");
        }
        if (seq.getChildren() == null) {
            return;
        }
        for (IDVTElementWrapper childElement : seq.getChildren()) {
            this.checkPhysicalSequencer(childElement);
        }
    }

    public void checkPhysicalSequence(IDVTElementWrapper seq) {
        if (seq == null) {
            return;
        }
        if (this.isPhysicalSequence(seq)) {
            seq.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.XVM_BROWSER_IS_PHYSICAL_SEQ, (Object)"");
        }
        if (seq.getChildren() == null) {
            return;
        }
        for (IDVTElementWrapper childElement : seq.getChildren()) {
            this.checkPhysicalSequence(childElement);
        }
    }

    public boolean isPhysicalSequence(IDVTElementWrapper seq) {
        RfClass clazz = null;
        if (seq.getRfElement() instanceof RfClass && this.hasParameter(clazz = (RfClass)seq.getRfElement())) {
            List<RfField> fieldList = clazz.getFieldsWithPrefix("p_sequencer", 1, 2, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
            for (RfField field : fieldList) {
                ReparseInfo.ReparseElement[] reparseElements;
                ReparseInfo reparseInfo;
                IRfNamedElement fieldType = field.getAssociatedType();
                if (fieldType instanceof RfTypeAlias) {
                    fieldType = ((RfTypeAlias)fieldType).getTranslatedType();
                }
                if (!(fieldType instanceof RfClass) || !this.isPhysicalSequencer((RfClass)fieldType) || field.getDeclaration() == null || (reparseInfo = field.getDeclaration().getReparseInfo()) == null) continue;
                ReparseInfo.ReparseElement[] reparseElementArray = reparseElements = reparseInfo.getReparseStack();
                int n = reparseElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ReparseInfo.ReparseElement reparseElement = reparseElementArray[n2];
                    if (reparseElement.getReparseMacroName().equals("uvm_declare_p_sequencer")) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public boolean hasParameter(RfClass clazz) {
        if (clazz == null || clazz.getParent() == null) {
            return false;
        }
        if (XVM_SEQUENCE.contains(clazz.getParent().getName()) && clazz.getParent() instanceof RfSpecializedClass) {
            RfSpecializedClass parent = (RfSpecializedClass)clazz.getParent();
            List<RfField> parameters = parent.getLocalParameters(256);
            if (parameters == null) {
                return false;
            }
            for (IRfNamedElement iRfNamedElement : parameters) {
                IRfNamedElement typeParameterElement;
                IELParamValue typeParameterValue = parent.getElabConstantValue(iRfNamedElement.getName());
                if (ELUtils.isUnsuccessfulEval((IELParamValue)typeParameterValue) || !((typeParameterElement = typeParameterValue.getNamedElement()) instanceof RfClass) || XVM_SEQUENCE_ITEM.contains(((RfClass)typeParameterElement).getName()) || !this.belongsTo(XVM_SEQUENCE_ITEM, (RfClass)typeParameterElement)) continue;
                return true;
            }
        } else {
            return this.hasParameter(clazz.getParent());
        }
        return false;
    }

    public boolean isPhysicalSequencer(RfClass sequencer) {
        return this.fPhysicalSequencers.contains(sequencer);
    }

    public void extractPhysicalSequencers(RfClass clazz) {
        if (clazz == null) {
            return;
        }
        ClassVisitor visitor = new ClassVisitor();
        clazz.visitHidObject(null, visitor);
    }

    public void addOrMerge(RfTreeElementWrapper head, RfTreeElementWrapper seq) {
        if (head == null || seq == null) {
            return;
        }
        if (head.getChildren() == null) {
            head.addChild(seq);
            return;
        }
        for (RfTreeElementWrapper child : head.getChildren()) {
            if (!child.toString().equals(seq.toString())) continue;
            if (seq.getChildren() != null && !seq.getChildren().isEmpty()) {
                this.addOrMerge(child, seq.getChildren().get(0));
            }
            return;
        }
        head.addChild(seq);
    }

    public boolean isOutsidePkg(RfTreeElementWrapper sequences) {
        return sequences.getAdditionalInfo(IDVTElementWrapper.Attribute.OVR_OUTSIDE_PACKAGE) != null;
    }

    public boolean hasNoChildren(RfTreeElementWrapper sequences) {
        return sequences.getChildren() == null || sequences.getChildren().isEmpty();
    }

    public boolean belongsTo(Set<String> className, RfClass memberClass) {
        if (memberClass == null) {
            return false;
        }
        if (className.contains(memberClass.getName())) {
            return true;
        }
        return this.belongsTo(className, memberClass.getParent());
    }

    public boolean belongsTo(String className, RfClass memberClass) {
        if (memberClass == null) {
            return false;
        }
        if (className.equals(memberClass.getName())) {
            return true;
        }
        return this.belongsTo(className, memberClass.getParent());
    }

    private List<IDVTElementWrapper> getSortedMembers(RfProject project, StringMatcher matcher, String elementName, UpdateJob updateJob) {
        RfClass clazz = project.getClass(elementName, false);
        List<IDVTElementWrapper> membersWrappers = this.getMembersWrappers(clazz, matcher, updateJob);
        ArrayList<IDVTElementWrapper> filteredMembers = new ArrayList<IDVTElementWrapper>();
        if (matcher != null && membersWrappers != null) {
            for (IDVTElementWrapper element : membersWrappers) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return new ArrayList<IDVTElementWrapper>();
                }
                String name = "";
                if (element.getRfElement() instanceof RfNamedElement) {
                    name = ((RfNamedElement)element.getRfElement()).getName();
                }
                if (name == null || !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name)) continue;
                filteredMembers.add(element);
            }
            membersWrappers = filteredMembers;
        }
        return membersWrappers;
    }

    private List<IDVTElementWrapper> getMembersWrappers(RfClass clazz, StringMatcher matcher, UpdateJob updateJob) {
        try {
            AbstractCollection elements = new LinkedHashSet<RfNamedElement>();
            ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
            LexicalSorter lexicalSorter = new LexicalSorter();
            if (clazz == null) {
                return result;
            }
            if (PrefConst.getUVMBrowserViewShowUVMMembers()) {
                RfProject rfProject = clazz.getRfProject();
                if (rfProject == null) {
                    return result;
                }
                RfXvmFactory xvmFactory = rfProject.getXvmFactory();
                if (xvmFactory == null) {
                    return result;
                }
                RfXvmObject registeredClass = xvmFactory.getRegisteredObject(clazz);
                List<RfField> rfFields = this.getFields(clazz, true);
                for (RfField rfField : rfFields) {
                    if (!(rfField.getAssociatedType() instanceof RfInterface)) continue;
                    elements.add(rfField);
                }
                if (registeredClass != null) {
                    List<RfXvmField> registeredFields = RfXvmFactory.getRegisteredFields(registeredClass);
                    for (RfXvmField field : registeredFields) {
                        elements.add(field.getRfField());
                    }
                }
                block4: for (RfField field : rfFields) {
                    IRfNamedElement namedElementType = field.getAssociatedType();
                    if (namedElementType instanceof RfListType) {
                        namedElementType = ((RfListType)namedElementType).getAssociatedType();
                    }
                    if (!(namedElementType instanceof RfClass)) continue;
                    RfClass associatedClass = (RfClass)namedElementType;
                    while (associatedClass != null) {
                        RfPackage pkg = associatedClass.getEnclosingPackage();
                        if (pkg != null && (pkg.getName().equals(UVM_PKG) || pkg.getName().equals(OVM_PKG))) {
                            elements.add((RfNamedElement)field);
                            continue block4;
                        }
                        associatedClass = associatedClass.getParent();
                    }
                }
                elements.addAll(this.getUVMFunctionsAndTasks(clazz));
            } else {
                RfNamedElement[] sorted;
                List<RfField> fields = this.getFields(clazz, false);
                if (PrefConst.getUVMBrowserViewSortByCategory()) {
                    RfNamedElement[] sorted2 = fields.toArray(new RfNamedElement[fields.size()]);
                    Arrays.sort(sorted2, lexicalSorter);
                    elements.addAll(Arrays.asList(sorted2));
                } else {
                    elements.addAll(fields);
                }
                if (PrefConst.getUVMBrowserViewSortByCategory()) {
                    NullProtectedList<RfFunction> methods = new NullProtectedList<RfFunction>();
                    methods.addAll(this.getConstructor(clazz));
                    methods.addAll(this.getFunctions(clazz));
                    methods.addAll(this.getTasks(clazz));
                    sorted = methods.toArray(new RfNamedElement[methods.size()]);
                    Arrays.sort(sorted, lexicalSorter);
                    elements.addAll(Arrays.asList(sorted));
                } else {
                    elements.addAll(this.getConstructor(clazz));
                    elements.addAll(this.getFunctions(clazz));
                    elements.addAll(this.getTasks(clazz));
                }
                List<RfField> events = this.getEvents(clazz);
                if (PrefConst.getUVMBrowserViewSortByCategory()) {
                    sorted = events.toArray(new RfNamedElement[events.size()]);
                    Arrays.sort(sorted, lexicalSorter);
                    elements.addAll(Arrays.asList(sorted));
                } else {
                    elements.addAll(events);
                }
                if (!PrefConst.getUVMBrowserViewSortByCategory()) {
                    ArrayList<RfNamedElement> toSort = new ArrayList<RfNamedElement>(elements);
                    Collections.sort(toSort, lexicalSorter);
                    elements = toSort;
                }
            }
            return this.toWrappers(elements, matcher, updateJob);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new ArrayList<IDVTElementWrapper>();
        }
    }

    private List<IDVTElementWrapper> toWrappers(Collection<RfNamedElement> elements, StringMatcher matcher, UpdateJob updateJob) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        boolean uvmBrowserViewShowUVMMembers = PrefConst.getUVMBrowserViewShowUVMMembers();
        boolean uvmBrowserViewShowPredefined = PrefConst.getUVMBrowserViewShowPredefined();
        boolean uvmBrowserViewShowOnlyPublic = PrefConst.getUVMBrowserViewShowOnlyPublic();
        for (RfNamedElement namedElement : elements) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return result;
            }
            if (!uvmBrowserViewShowUVMMembers && (!uvmBrowserViewShowPredefined && namedElement instanceof RfPredefinedFunction && !((RfPredefinedFunction)namedElement).isPredefinedOverridden() || uvmBrowserViewShowOnlyPublic && !namedElement.isPublic())) continue;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(namedElement, true);
            DVTGUIFilterMatcher.GUIFilterResult filterResult = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.UVM_BROWSER_MEMBERS, (IRfNamedElement)namedElement, () -> this.fMembersLabelProvider.getText((Object)wrapper));
            if (filterResult != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (filterResult == DVTGUIFilterMatcher.GUIFilterResult.PREFERENCE) continue;
                if (!this.fHasSearchedMemberFiltered && ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fComponentsLabelProvider.getText((Object)wrapper))) {
                    this.fHasSearchedMemberFiltered = true;
                }
                this.fHasGUIFilteredMembers = true;
                continue;
            }
            result.add(wrapper);
        }
        return result;
    }

    private List<RfField> getFields(RfClass clazz, boolean showUVM) {
        boolean showInherited = PrefConst.getUVMBrowserViewShowAllInherited();
        if (showInherited && !showUVM) {
            return clazz.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return clazz.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private List<RfField> getEvents(RfClass clazz) {
        boolean showInherited = PrefConst.getUVMBrowserViewShowAllInherited();
        if (showInherited) {
            return clazz.getEventsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return clazz.getEventsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private List<RfFunction> getUVMFunctionsAndTasks(RfClass clazz) {
        ArrayList<RfFunction> outFunctions = new ArrayList<RfFunction>();
        ArrayList<RfFunction> functionsAndTasks = new ArrayList<RfFunction>();
        List<RfFunction> localConstructors = clazz.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        List<RfFunction> localFunctions = clazz.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        List<RfFunction> localTasks = clazz.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        functionsAndTasks.addAll(localConstructors);
        functionsAndTasks.addAll(localFunctions);
        functionsAndTasks.addAll(localTasks);
        for (RfFunction function : functionsAndTasks) {
            if (function instanceof RfPredefinedFunction && !((RfPredefinedFunction)function).isPredefinedOverridden() || !this.isUVMElement(function, clazz)) continue;
            outFunctions.add(function);
        }
        return outFunctions;
    }

    private boolean isUVMElement(RfNamedElement namedElement, RfClass parentClass) {
        RfNamedElement localFunction = namedElement;
        do {
            RfPackage pkg;
            if ((pkg = parentClass.getEnclosingPackage()) == null || !pkg.getName().equals(UVM_PKG)) continue;
            localFunction = parentClass.getLocalMember(RfFunction.class, namedElement.getName(), false);
            if (localFunction == null) {
                localFunction = parentClass.getConstructorWithPrefix(namedElement.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (localFunction == null || localFunction.getDeclarations() == null || localFunction.getDeclarations().isEmpty()) continue;
            for (RfDefElement def : localFunction.getDeclarations()) {
                if (!(def instanceof RfFunctionDef) || !((RfFunction)localFunction).isVirtual() && !((RfFunction)localFunction).isConstructor() && (!(localFunction instanceof RfPredefinedFunction) || !((RfPredefinedFunction)localFunction).isPredefinedOverridden())) continue;
                return true;
            }
        } while ((parentClass = parentClass.getParent()) != null);
        return false;
    }

    private List<RfFunction> getFunctions(RfClass clazz) {
        boolean showInherited = PrefConst.getUVMBrowserViewShowAllInherited();
        if (showInherited) {
            return clazz.getFunctionsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return clazz.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private List<RfFunction> getConstructor(RfClass clazz) {
        return clazz.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    private List<RfFunction> getTasks(RfClass clazz) {
        boolean showInherited = PrefConst.getUVMBrowserViewShowAllInherited();
        if (showInherited) {
            return clazz.getTasksWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        }
        return clazz.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        try {
            if (!(element instanceof RfTreeElementWrapper)) {
                return false;
            }
            Object rfElement = ((IDVTElementWrapper)element).getRfElement();
            if (rfElement == null) {
                return false;
            }
            if (referenceData instanceof UpdateViewEvent) {
                UpdateViewEvent event = (UpdateViewEvent)referenceData;
                if (!(rfElement instanceof RfClass)) {
                    return false;
                }
                RfClass clazz = (RfClass)rfElement;
                RfClass eventClazz = this.getClazz(event);
                if (eventClazz == null) {
                    return false;
                }
                return clazz.getName().equals(eventClazz.getName());
            }
            if (referenceData instanceof RfTreeElementWrapper) {
                RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)referenceData);
                Object refElement = rfWrapper.getRfElement();
                if (!(refElement instanceof RfClass)) {
                    return false;
                }
                if (!(rfElement instanceof RfClass)) {
                    return false;
                }
                RfClass clazz = (RfClass)rfElement;
                RfClass refClazz = (RfClass)refElement;
                return clazz.getName().equals(refClazz.getName());
            }
            if (!(rfElement instanceof RfNamedElement) || rfElement instanceof RfDummyElement) {
                return false;
            }
            return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fComponentsLabelProvider.getText(element));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public HistoryItem createHistoryItemForWrapper(IDVTElementWrapper wrapper, IProject project, int updateHistory) {
        Object namedElement;
        block5: {
            block4: {
                try {
                    if (wrapper instanceof RfTreeElementWrapper) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            RfTreeElementWrapper treeElementWrapper = (RfTreeElementWrapper)wrapper;
            namedElement = treeElementWrapper.getRfElement();
            if (namedElement != null && namedElement instanceof RfClass) break block5;
            return null;
        }
        RfClass rfClass = (RfClass)namedElement;
        List<? extends DVTRfNameTypeScopeHelper> scope = RfScopeUtil.getDefOfScopeElement(rfClass);
        String text = "[" + project.getName() + "] " + (rfClass.getEnclosingScope() == null ? "" : String.valueOf(rfClass.getEnclosingScope().getName()) + " :: ") + rfClass.getName();
        return VlogQuickViewersUtil.createViewUpdateEvent(text, project.getName(), rfClass.getName(), scope, 1, updateHistory);
    }

    public void overrideMethod(IDVTElementWrapper componentsWrapper, IDVTElementWrapper memberWrapper) {
        try {
            if (!(memberWrapper.getRfElement() instanceof RfFunction)) {
                return;
            }
            if (!(componentsWrapper.getRfElement() instanceof RfClass)) {
                return;
            }
            RfFunction currentFunction = (RfFunction)((RfNamedElement)memberWrapper.getRfElement());
            RfClass currentClass = (RfClass)((RfNamedElement)componentsWrapper.getRfElement());
            ArrayList<RfFunction> currentClassFunctions = new ArrayList<RfFunction>();
            List<RfFunction> localFunctionAndTasks = currentClass.getLocalMembers(RfFunction.class);
            if (localFunctionAndTasks != null) {
                currentClassFunctions.addAll(localFunctionAndTasks);
            }
            if (currentClassFunctions.contains(currentFunction) && !currentFunction.hasNoDefs(false)) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog messageDialog = new MessageDialog(shell, "Override Methods", null, String.valueOf(currentFunction.getName()) + " is already overidden in " + currentClass.getName(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                messageDialog.open();
                return;
            }
            RfDefElement declaration = currentClass.getDeclaration();
            if (declaration == null) {
                return;
            }
            IResource file = declaration.getFileAdapter();
            if (file == null || !file.exists() || !file.isAccessible()) {
                return;
            }
            int line = declaration.getEndLine();
            IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttribute("lineNumber", line);
            IEditorPart edp = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
            ITextEditor textEditor = (ITextEditor)edp.getAdapter(ITextEditor.class);
            ArrayList<RfFunction> functionsList = new ArrayList<RfFunction>(1);
            functionsList.add(currentFunction);
            VlogMethodsInsertConfigurationProvider configurator = new VlogMethodsInsertConfigurationProvider(currentClass, functionsList, (DVTEditor)textEditor, 0, false);
            VlogOveriddenElementInserter.getInstance().insertSignatures(configurator);
            marker.delete();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean canShowOverrideMethodMenuEntry(IDVTElementWrapper componentsWrapper, IDVTElementWrapper memberWrapper) {
        List<RfFunction> localFunctionsAndTasks;
        RfFunction currentFunction;
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (memberWrapper.getRfElement() instanceof RfFunction) break block6;
                            return false;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return false;
                        }
                    }
                    if (componentsWrapper.getRfElement() instanceof RfClass) break block7;
                    return false;
                }
                currentFunction = (RfFunction)((RfNamedElement)memberWrapper.getRfElement());
                RfClass currentClass = (RfClass)((RfNamedElement)componentsWrapper.getRfElement());
                localFunctionsAndTasks = currentClass.getLocalMembers(RfFunction.class);
                if (localFunctionsAndTasks != null) break block8;
                return true;
            }
            if (!RANDOM_PREDEFINED_FUNCTIONS.contains(currentFunction.getName()) || !currentFunction.hasNoDefs(false)) break block9;
            return true;
        }
        return !localFunctionsAndTasks.contains(currentFunction);
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        Object element;
        Object labelWrapper = null;
        if (wrapper instanceof LabelProviderInput) {
            labelWrapper = ((LabelProviderInput)wrapper).getWrapper();
        }
        if (labelWrapper != null && ((element = ((IDVTElementWrapper)labelWrapper).getRfElement()) instanceof RfClass || element instanceof RfDummyElement || element instanceof RfPackage || element instanceof VlogLanguageElement)) {
            return this.fComponentsLabelProvider;
        }
        return this.fMembersLabelProvider;
    }

    private final class ClassVisitor
    implements IHidVisitor<RfHidAccessArgs> {
        private ClassVisitor() {
        }

        public boolean visit(RfHidAccessArgs hid) {
            MethodCall methodCall = hid.getMethodCall();
            if (methodCall == null || !(methodCall.method instanceof RfFunction)) {
                return true;
            }
            RfFunction method = (RfFunction)methodCall.method;
            String methodName = method.getName();
            if (methodName == null || !methodName.equals("connect")) {
                return true;
            }
            RfNamedElement enclosingClass = method.getEnclosingScope();
            if (!(enclosingClass instanceof RfClass) || !XVM_PORT_BASE.contains(enclosingClass.getName())) {
                return true;
            }
            Hid hidParent = hid.getParentHid();
            while (hidParent != null) {
                if (hidParent.getParentAccess() != null && hidParent.getParentAccess().getAssociatedType() != null) {
                    IRfNamedElement associatedType = hidParent.getParentAccess().getAssociatedType();
                    if (associatedType instanceof RfTypeAlias) {
                        associatedType = ((RfTypeAlias)associatedType).getTranslatedType();
                    }
                    if (!(associatedType instanceof RfClass)) {
                        hidParent = hidParent.getParentHid();
                        continue;
                    }
                    if (!VlogXVMBrowserViewContributor.this.belongsTo(XVM_DRIVER, (RfClass)associatedType) || methodCall.argumentValuesMapRaw == null) {
                        hidParent = hidParent.getParentHid();
                        continue;
                    }
                    for (Map.Entry argumentEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                        IHidObject argument = (IHidObject)argumentEntry.getValue();
                        if (!(argument instanceof RfHid)) continue;
                        RfHid hidParameterParent = (RfHid)argument;
                        while (hidParameterParent != null) {
                            if (hidParameterParent.getParentAccess() != null && hidParameterParent.getParentAccess().getAssociatedType() != null) {
                                IRfNamedElement parentAssociatedType = hidParameterParent.getParentAccess().getAssociatedType();
                                if (parentAssociatedType instanceof RfTypeAlias) {
                                    parentAssociatedType = ((RfTypeAlias)parentAssociatedType).getTranslatedType();
                                }
                                if (parentAssociatedType instanceof RfClass && VlogXVMBrowserViewContributor.this.belongsTo(XVM_SEQUENCER, (RfClass)parentAssociatedType)) {
                                    VlogXVMBrowserViewContributor.this.fPhysicalSequencers.add((RfClass)parentAssociatedType);
                                    return false;
                                }
                            }
                            hidParameterParent = hidParameterParent.getParentHid();
                        }
                    }
                }
                hidParent = hidParent.getParentHid();
            }
            return true;
        }

        public Class<RfHidAccessArgs> getType() {
            return RfHidAccessArgs.class;
        }
    }

    private static class HierarchyWrappersLexicalSorter
    implements Comparator<IDVTElementWrapper> {
        private HierarchyWrappersLexicalSorter() {
        }

        @Override
        public int compare(IDVTElementWrapper o1, IDVTElementWrapper o2) {
            if (!(o1.getRfElement() instanceof RfNamedElement) || !(o2.getRfElement() instanceof RfNamedElement)) {
                return 0;
            }
            if (o1.getRfElement() == XVMBrowserViewLabelProvider.DEFAULT_PKG) {
                return -1;
            }
            if (o2.getRfElement() == XVMBrowserViewLabelProvider.DEFAULT_PKG) {
                return 1;
            }
            String name1 = ((RfNamedElement)o1.getRfElement()).getName();
            String name2 = ((RfNamedElement)o2.getRfElement()).getName();
            return name1.compareTo(name2);
        }
    }

    private static class LexicalSorter
    implements Comparator<Object> {
        private LexicalSorter() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof RfNamedElement && o2 instanceof RfNamedElement) {
                String name1 = ((RfNamedElement)o1).getName();
                String name2 = ((RfNamedElement)o2).getName();
                return name1.compareTo(name2);
            }
            if (o1 instanceof RfXvmField && o2 instanceof RfXvmField) {
                String name1 = ((RfXvmField)o1).getName();
                String name2 = ((RfXvmField)o2).getName();
                return name1.compareTo(name2);
            }
            return -1;
        }
    }

    class PkgCat {
        private RfPackage pkg;
        private String cat;

        public PkgCat(RfPackage pkg, String cat) {
            this.pkg = pkg;
            this.cat = cat;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.cat == null ? 0 : this.cat.hashCode());
            result = 31 * result + (this.pkg == null ? 0 : this.pkg.getName().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PkgCat other = (PkgCat)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.cat == null ? other.cat != null : !this.cat.equals(other.cat)) {
                return false;
            }
            return !(this.pkg == null ? other.pkg != null : !this.pkg.equals(other.pkg));
        }

        private VlogXVMBrowserViewContributor getOuterType() {
            return VlogXVMBrowserViewContributor.this;
        }

        public String toString() {
            return this.pkg + "::" + this.cat;
        }
    }
}

