/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDummyElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogLanguageElement;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;

public class XVMBrowserViewLabelProvider
extends TypesViewLabelProvider {
    public static final RfPackage DEFAULT_PKG = new RfPackage("global scope", false);

    @Override
    public Image getImage(Object wrapper) {
        Object element = ((IDVTElementWrapper)wrapper).getRfElement();
        if (element instanceof IDVTElementWrapper) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element instanceof RfDummyElement) {
            if (((RfDummyElement)element).getName().equals("[...recurrence detected]")) {
                return DVTImages.imageCache.getImage(DVTImages.INSTANCE_LOOP);
            }
            return DVTImages.imageCache.getImage(DVTImages.TYPES);
        }
        if (element instanceof String) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element instanceof VlogLanguageElement) {
            return DVTImages.imageCache.getImage(DVTImages.VLOG_LANGUAGE);
        }
        IRfNamedElement namedElement = (IRfNamedElement)element;
        Image result = null;
        if (namedElement instanceof RfClass) {
            RfXvmFactory xvmFactory;
            RfClass clazz = (RfClass)namedElement;
            RfProject rfProject = clazz.getRfProject();
            result = rfProject == null ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS_GRAY) : ((xvmFactory = rfProject.getXvmFactory()) == null ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS_GRAY) : (clazz.getDeclaration() == null || ((IDVTElementWrapper)wrapper).isGrayIcon() || xvmFactory.getRegisteredObject(clazz) == null || !xvmFactory.getRegisteredObject(clazz).isFactoryRegistered() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS_GRAY) : (clazz.isInterfaceClass() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS))));
            if (((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.OVR_OUTSIDE_PACKAGE) != null) {
                result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_OUTSIDE_PACKAGE, 3));
            }
            if (((IDVTElementWrapper)wrapper).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.XVM_BROWSER_IS_PHYSICAL_SEQ) != null) {
                result = DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(result, DVTImages.OVR_PHYSICAL_CLASS, 3));
            }
        }
        if (element == DEFAULT_PKG) {
            result = DVTImages.imageCache.getImage(DVTImages.PACKAGE_GRAY);
        }
        if (result == null && element == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (result == null) {
            result = ((IRfNamedElement)element).getImage();
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!((IDVTElementWrapper)wrapper).getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return result;
    }

    @Override
    public String getText(Object object) {
        String prepend;
        String result = this.internalGetText(object);
        if (result == null) {
            return "";
        }
        if (object instanceof IDVTElementWrapper && (prepend = (String)((IDVTElementWrapper)object).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PREPEND_TEXT)) != null) {
            return String.valueOf(prepend) + result;
        }
        return result;
    }

    private String internalGetText(Object wrapper) {
        IDVTElementWrapper rfWrapper;
        block13: {
            block12: {
                try {
                    if (wrapper instanceof IDVTElementWrapper) break block12;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            rfWrapper = (IDVTElementWrapper)wrapper;
            if (rfWrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
                this.setBoldFont(rfWrapper);
            }
            if (rfWrapper.getRfElement() instanceof VlogLanguageElement) {
                return (String)((VlogLanguageElement)((Object)rfWrapper.getRfElement())).getInfo();
            }
            if (rfWrapper.getRfElement() instanceof RfDummyElement) {
                return ((RfDummyElement)rfWrapper.getRfElement()).getName();
            }
            if (!(rfWrapper.getRfElement() instanceof RfPackage) || !((RfNamedElement)rfWrapper.getRfElement()).getName().equals("[none]")) break block13;
            return "Global Scope";
        }
        if (!(rfWrapper.getRfElement() instanceof RfClass)) {
            return super.getText(wrapper);
        }
        RfClass rfClass = (RfClass)rfWrapper.getRfElement();
        if (rfClass == null) {
            return super.getText(wrapper);
        }
        RfProject rfProject = rfClass.getRfProject();
        if (rfProject == null) {
            return super.getText(wrapper);
        }
        RfXvmFactory xvmFactory = rfProject.getXvmFactory();
        if (xvmFactory == null) {
            return super.getText(wrapper);
        }
        RfXvmObject xvmObject = xvmFactory.getRegisteredObject(rfClass);
        if (xvmObject == null || !xvmObject.isFactoryRegistered()) {
            return String.valueOf(super.getText(wrapper)) + " [not registered]";
        }
        return super.getText(wrapper);
    }
}

