/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IViewPart;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.ConfigDBView;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.views.XVlogConfigDBViewContributorCommon;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;

public class XVlogConfigDBViewContributor
extends XVlogConfigDBViewContributorCommon {
    public void notifyXViewError() {
        this.deepClean();
        this.resetState();
        Utils.safeRunSynchInUIThread(() -> {
            IViewPart view = ViewsUtils.getViewById((String)this.getID(), (boolean)false);
            if (!(view instanceof ConfigDBView)) {
                return;
            }
            ((ConfigDBView)view).update(BuildEvents.INTERPRETER_FAILED);
        });
    }

    public void notifyXViewSuccess() {
        this.isConfigDBComputed = true;
        Utils.safeRunSynchInUIThread(() -> {
            IViewPart view = ViewsUtils.getHiddenViewById((String)this.getID(), (boolean)false);
            if (!(view instanceof ConfigDBView)) {
                return;
            }
            ((ConfigDBView)view).update(BuildEvents.INTERPRETER_MODE);
        });
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (project == null) {
            return;
        }
        Object obj = wrapper;
        if (wrapper instanceof TreePath) {
            obj = ((TreePath)wrapper).getElement();
        }
        if (obj instanceof IDVTElementWrapper) {
            obj = ((IDVTElementWrapper)obj).getRfElement();
        }
        if (!(obj instanceof IXXVMConfigDBSetGetCallInfo)) {
            return;
        }
        GoToInfo goToInfo = ((IXXVMConfigDBSetGetCallInfo)obj).getGoToInfo();
        if (goToInfo == null) {
            return;
        }
        goToInfo.open(project, true);
    }

    public boolean canHandle(SelectionChangedEvent triggerEvent) {
        return triggerEvent.getSource() instanceof ConfigDBView;
    }

    public Object getInput(Object event) {
        return super.getInput(event);
    }

    public void setHasGuiFilters(boolean filteringEnabled) {
        this.isXVMPathFiltered = filteringEnabled;
    }

    @Override
    protected void setFilterText(ConfigDBView view, String text) {
        TextFilterObject filter = view.getFilter();
        if (filter == null) {
            return;
        }
        filter.setTextFilterText(text);
    }

    public void setBreadcrumbData(Object element, IProject project) {
        try {
            Object obj = element;
            if (element instanceof TreePath) {
                obj = ((TreePath)element).getElement();
            }
            if (obj instanceof IDVTElementWrapper) {
                obj = ((IDVTElementWrapper)obj).getRfElement();
            }
            if (!(obj instanceof IXXVMConfigDBSetGetCallInfo)) {
                return;
            }
            GoToInfo goToInfo = ((IXXVMConfigDBSetGetCallInfo)obj).getGoToInfo();
            if (goToInfo == null) {
                return;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, goToInfo.filePath);
            if (file == null) {
                return;
            }
            List<BreadcrumbSegment> elementsList = this.computeBreadcrumbSegmentsFromConfigDBCall((IXXVMConfigDBSetGetCallInfo)obj, project, file);
            if (elementsList == null || elementsList.isEmpty()) {
                return;
            }
            BreadcrumbInput bcInput = new BreadcrumbInput(project, elementsList, VlogVHBreadcrumbUtils.getInstance().getBreadcrumbSerializer());
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)bcInput);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

