/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IViewPart;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMConfigDBGetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.ConfigDBRevealType;
import ro.amiq.dvt.ui.views.config.db.ConfigDBSortKind;
import ro.amiq.dvt.ui.views.config.db.ConfigDBView;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewFilters;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewModel;
import ro.amiq.dvt.ui.views.config.db.DVTXConfigDBLabelProvider;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.interpreter.factory.chs.AbstractXXVMConfigDBSetGetCallInfo;
import ro.amiq.vlogdt.interpreter.factory.chs.XXVMConfigDBGetValueHolderCallInfo;
import ro.amiq.vlogdt.interpreter.factory.chs.XXVMConfigDBSetValueHolderCallInfo;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;

public abstract class XVlogConfigDBViewContributorCommon
implements IXConfigDBContributor {
    protected static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    public static final AbstractXXVMConfigDBSetGetCallInfo DUMMY_FILTERED_CONFIG_DB_CALL = new XXVMConfigDBSetValueHolderCallInfo(null, null, null, null, null, null, null, null, null, null, false, false);
    protected DVTXConfigDBLabelProvider fLabelProvider = new DVTXConfigDBLabelProvider();
    protected boolean isInterpreterFailed;
    protected boolean isConfigDBComputed;
    protected boolean isXVMPathFiltered;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public String getID() {
        return "ro.amiq.dvt.ui.views.ConfigDBView";
    }

    public boolean adaptsTo(Object adapted) {
        return true;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public String getComment(Object wrapper) {
        return null;
    }

    public boolean hasInterpreterFailed() {
        return this.isInterpreterFailed;
    }

    public void setHasInterpreterFailed(boolean isInterpreterProcessFailed) {
        this.isInterpreterFailed = isInterpreterProcessFailed;
    }

    public void resetState() {
        this.isInterpreterFailed = false;
        this.isConfigDBComputed = false;
    }

    public void serializeModel(Map<String, String> builder, String testName) {
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        if (configDBCalls == null || configDBCalls.isEmpty()) {
            builder.put(this.getID(), XVMBuildPhaseXMLParser.EMPTY_CONFIG_DB_HIERARCHY);
            return;
        }
        builder.put(this.getID(), this.serializeXVMConfigCalls());
    }

    private String serializeXVMConfigCalls() {
        StringBuilder callsSB = new StringBuilder();
        XXVMBuilder.appendToSBUtils(callsSB, "\n", "\t", "<", "config-db-hierarchy", ">");
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        if (configDBCalls == null) {
            throw new IllegalStateException("Unknown to serialize null config db map!");
        }
        for (Map.Entry<String, List<IXXVMConfigDBSetGetCallInfo>> callsTypeList : configDBCalls.entrySet()) {
            String callType = callsTypeList.getKey();
            List<IXXVMConfigDBSetGetCallInfo> calls = callsTypeList.getValue();
            XXVMBuilder.appendToSBUtils(callsSB, "\n", "\t", "\t", "<", "xvm-config-db-type", " ", "config-db-type", "=", "'", DVTStringUtil.replaceAll((Pattern)SPACE_PATTERN, (CharSequence)callType.toUpperCase(), (String)"_"), "'");
            if (calls == null) {
                throw new IllegalStateException("Unknown to serialize null config db calls list!");
            }
            if (calls.isEmpty()) {
                XXVMBuilder.appendToSBUtils(callsSB, "/", ">");
                continue;
            }
            XXVMBuilder.appendToSBUtils(callsSB, ">");
            for (IXXVMConfigDBSetGetCallInfo call : calls) {
                call.serializeConfigDBCall(callsSB, "\t\t\t");
            }
            XXVMBuilder.appendToSBUtils(callsSB, "\n", "\t", "\t", "<", "/", "xvm-config-db-type", ">");
        }
        XXVMBuilder.appendToSBUtils(callsSB, "\n", "\t", "<", "/", "config-db-hierarchy", ">");
        return callsSB.toString();
    }

    public void parseNode(Element rootNode, IProject project, String testName) {
        NodeList childNodes = rootNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        LinkedHashMap<String, List<IXXVMConfigDBSetGetCallInfo>> allConfigDBCalls = new LinkedHashMap<String, List<IXXVMConfigDBSetGetCallInfo>>();
        Arrays.asList(ConfigDBViewFilters.values()).forEach(configDBType -> {
            if (configDBType != ConfigDBViewFilters.HIDE_READ_ONLY_SETTERS) {
                allConfigDBCalls.put(configDBType.getLabel(), new LinkedList());
            }
        });
        int i = 0;
        while (i < childNodes.getLength()) {
            block16: {
                String configDBType2;
                Node node = childNodes.item(i);
                if (node == null || 1 != node.getNodeType() || !"xvm-config-db-type".equals(node.getNodeName())) break block16;
                NamedNodeMap attributes = node.getAttributes();
                Node configDBTypeAttr = attributes.getNamedItem("config-db-type");
                if (configDBTypeAttr == null || "null".equals(configDBTypeAttr.getNodeValue())) {
                    throw new IllegalStateException("Unknown to compute");
                }
                switch (configDBType2 = configDBTypeAttr.getNodeValue()) {
                    case "SETTERS_AND_GETTERS": {
                        this.parseConfigDBType(node.getChildNodes(), (List)allConfigDBCalls.get(ConfigDBViewFilters.SETTERS_AND_GETTERS.getLabel()), project);
                        break;
                    }
                    case "SETTERS_WITHOUT_GETTERS": {
                        this.parseConfigDBType(node.getChildNodes(), (List)allConfigDBCalls.get(ConfigDBViewFilters.SETTERS_WITHOUT_GETTERS.getLabel()), project);
                        break;
                    }
                    case "GETTERS_WITHOUT_SETTERS": {
                        this.parseConfigDBType(node.getChildNodes(), (List)allConfigDBCalls.get(ConfigDBViewFilters.GETTERS_WITHOUT_SETTERS.getLabel()), project);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown Config DB Type!");
                    }
                }
            }
            ++i;
        }
        XXVMBuilder.INSTANCE.loadConfigDBCalls(allConfigDBCalls);
    }

    private void parseConfigDBType(NodeList childNodes, List<IXXVMConfigDBSetGetCallInfo> configDBType, IProject project) {
        if (childNodes == null || childNodes.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node != null && 1 == node.getNodeType()) {
                NamedNodeMap configDBCallAttributes = node.getAttributes();
                if ("xvm-config-db-set".equals(node.getNodeName()) || "xvm-config-db-get".equals(node.getNodeName())) {
                    IXXVMConfigDBSetGetCallInfo call = this.parseCallAttrs(project, configDBCallAttributes, "xvm-config-db-set".equals(node.getNodeName()));
                    configDBType.add(call);
                    NodeList associatedGetters = node.getChildNodes();
                    if (associatedGetters != null && associatedGetters.getLength() != 0) {
                        int j = 0;
                        while (j < associatedGetters.getLength()) {
                            Node getterNode = associatedGetters.item(j);
                            if (getterNode != null && 1 == getterNode.getNodeType()) {
                                if ("xvm-config-db-get".equals(getterNode.getNodeName())) {
                                    IXXVMConfigDBSetGetCallInfo getter = this.parseCallAttrs(project, getterNode.getAttributes(), false);
                                    if (!(call instanceof IXXVMConfigDBSetCallInfo)) {
                                        throw new IllegalStateException("Unknown associated setter for getter");
                                    }
                                    if (!(getter instanceof IXXVMConfigDBGetCallInfo)) {
                                        throw new IllegalStateException("Unknown function call for getter");
                                    }
                                    ((IXXVMConfigDBSetCallInfo)call).addAssociatedConfigDBGet((IXXVMConfigDBGetCallInfo)getter);
                                } else {
                                    throw new IllegalStateException("Unknown evaluation for deserialization of getter");
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public String getTreeLabelText(HistoryItem top) {
        if (top == null) {
            return "";
        }
        String text = top.getText();
        String[] path = DVTStringUtil.split((String)".", (String)text);
        return "[" + top.getProject().getName() + "] " + path[path.length - 1] + " [UVM Elaboration Model]";
    }

    private IXXVMConfigDBSetGetCallInfo parseCallAttrs(IProject project, NamedNodeMap configDBCallAttributes, boolean isSetter) {
        IRfNamedElement methodElement;
        RfElementPath elementPath;
        Node isReadOnlyAttr;
        Node methodElementAttr = configDBCallAttributes.getNamedItem("method-element");
        Node cntxtAttr = configDBCallAttributes.getNamedItem("context");
        Node createCallAttribute = configDBCallAttributes.getNamedItem("create-call");
        Node parameterizedElementAttr = configDBCallAttributes.getNamedItem("parameterized-type");
        Node instNameAttr = configDBCallAttributes.getNamedItem("inst-name");
        Node fieldNameAttr = configDBCallAttributes.getNamedItem("field-name");
        Node valueAttr = configDBCallAttributes.getNamedItem("value");
        Node idAttr = configDBCallAttributes.getNamedItem("id-evaluation");
        Node isXVMPathAttr = configDBCallAttributes.getNamedItem("is-xvm-path");
        Node valueNamedElementAttr = isSetter ? configDBCallAttributes.getNamedItem("named-element") : null;
        Node node = isReadOnlyAttr = isSetter ? configDBCallAttributes.getNamedItem("is-read-only") : null;
        if (methodElementAttr == null || cntxtAttr == null || parameterizedElementAttr == null || instNameAttr == null || fieldNameAttr == null || valueAttr == null || idAttr == null || isXVMPathAttr == null) {
            throw new IllegalStateException("Unable to deserialize attributes of config db calls");
        }
        String methodElem = methodElementAttr.getNodeValue();
        String context = cntxtAttr.getNodeValue();
        String paramElem = parameterizedElementAttr.getNodeValue();
        String instName = instNameAttr.getNodeValue();
        String fldName = fieldNameAttr.getNodeValue();
        String val = valueAttr.getNodeValue();
        int id = Integer.parseInt(idAttr.getNodeValue());
        boolean xvmPath = Boolean.parseBoolean(isXVMPathAttr.getNodeValue());
        boolean isReadOnly = Boolean.parseBoolean(isReadOnlyAttr != null ? isReadOnlyAttr.getNodeValue() : "false");
        IRfNamedElement valueNamedElement = null;
        if (valueNamedElementAttr != null && (elementPath = RfElementPath.fromString((String)valueNamedElementAttr.getNodeValue(), XVlogConfigDBViewContributorCommon.class)) != null) {
            valueNamedElement = elementPath.toNamedElement(project);
        }
        if (!((methodElement = RfElementPath.fromString((String)methodElem, XVlogConfigDBViewContributorCommon.class).toNamedElement(project)) instanceof IRfMethodElement)) {
            throw new IllegalStateException("Unable to compute method element for ");
        }
        GoToInfo goToInfo = createCallAttribute != null ? IXSerializedModelUtils.createGoToInfoFromString(createCallAttribute.getNodeValue()) : GoToInfo.sourceOf((IRfNamedElement)methodElement);
        ParserPath calledFromParserPath = null;
        if (goToInfo != null) {
            calledFromParserPath = new ParserPath(goToInfo.filePath);
        }
        AbstractXXVMConfigDBSetGetCallInfo call = null;
        call = isSetter ? new XXVMConfigDBSetValueHolderCallInfo((IRfMethodElement)methodElement, null, calledFromParserPath, paramElem, context, instName, fldName, val, goToInfo, valueNamedElement, isReadOnly, xvmPath) : new XXVMConfigDBGetValueHolderCallInfo((IRfMethodElement)methodElement, null, calledFromParserPath, paramElem, context, instName, fldName, val, goToInfo, false, xvmPath);
        call.setIdEvaluation(id);
        return call;
    }

    public void deepClean() {
        XXVMBuilder.INSTANCE.deepCleanXVMConfigDBElements();
    }

    public String getText(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof AbstractXXVMConfigDBSetGetCallInfo) {
            return ((AbstractXXVMConfigDBSetGetCallInfo)obj).toString();
        }
        return "";
    }

    public List<TreePath> createTreePath(IProgressMonitor monitor, IProject project, List<ConfigDBViewFilters> filters, boolean groupSorted) {
        if (!this.c(project)) {
            return null;
        }
        if (!this.isConfigDBComputed) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        boolean isEmpty = true;
        for (Map.Entry<String, List<IXXVMConfigDBSetGetCallInfo>> entry : configDBCalls.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return Collections.emptyList();
        }
        int index = 0;
        if (!groupSorted) {
            return this.internalCreateFlatTreePath(monitor, project, filters);
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (Map.Entry<String, List<IXXVMConfigDBSetGetCallInfo>> entry : configDBCalls.entrySet()) {
            String type = entry.getKey();
            ConfigDBViewFilters filterType = ConfigDBViewFilters.valueOf((String)DVTStringUtil.replaceAll((Pattern)SPACE_PATTERN, (CharSequence)type.toUpperCase(), (String)"_"));
            if (filterType == null || filters.contains(filterType)) continue;
            TreePath typeRoot = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)type, (int)index++);
            typeRoot.setElement((Object)new DVTTreeElementWrapper((Object)type));
            paths.add(typeRoot);
        }
        if (this.isXVMPathFiltered) {
            TreePath filteredTypeRoot = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)"Elements filtered By Content Filters", (int)index++);
            filteredTypeRoot.setElement((Object)new DVTTreeElementWrapper((Object)"Elements filtered By Content Filters"));
            paths.add(filteredTypeRoot);
        }
        return paths;
    }

    private List<TreePath> internalCreateFlatTreePath(IProgressMonitor monitor, IProject project, List<ConfigDBViewFilters> filters) {
        LinkedList<TreePath> paths = new LinkedList<TreePath>();
        List<IXXVMConfigDBSetGetCallInfo> sortedCalls = this.allSortedConfigDBCalls(monitor, filters);
        int index = 0;
        for (IXXVMConfigDBSetGetCallInfo call : sortedCalls) {
            TreePath elem = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)call.toString(), (int)index++, (Comparator)ConfigDBViewModel.treePathComparator);
            DVTTreeElementWrapper dvtWrapper = new DVTTreeElementWrapper((Object)call);
            dvtWrapper.setProject(project);
            elem.setElement((Object)dvtWrapper);
            paths.add(elem);
        }
        return paths;
    }

    protected List<IXXVMConfigDBSetGetCallInfo> allSortedConfigDBCalls(IProgressMonitor monitor, List<ConfigDBViewFilters> filters) {
        ArrayList<IXXVMConfigDBSetGetCallInfo> sortedCalls = new ArrayList<IXXVMConfigDBSetGetCallInfo>();
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> calls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        for (Map.Entry<String, List<IXXVMConfigDBSetGetCallInfo>> entry : calls.entrySet()) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            String type = entry.getKey();
            ConfigDBViewFilters filterType = ConfigDBViewFilters.valueOf((String)DVTStringUtil.replaceAll((Pattern)SPACE_PATTERN, (CharSequence)type.toUpperCase(), (String)"_"));
            if (filterType == null || filters.contains(filterType)) continue;
            for (IXXVMConfigDBSetGetCallInfo call : entry.getValue()) {
                if (this.isXVMPathFiltered && call.isXVMPath()) continue;
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                sortedCalls.add(call);
                if (filterType != ConfigDBViewFilters.SETTERS_AND_GETTERS) continue;
                if (!(call instanceof IXXVMConfigDBSetCallInfo)) {
                    throw new IllegalStateException("Illegal Element for root element for multiple associated getters");
                }
                List xAssociatedGetters = ((IXXVMConfigDBSetCallInfo)call).getXAssociatedGetters();
                for (IXXVMConfigDBGetCallInfo getter : xAssociatedGetters) {
                    if (monitor.isCanceled()) {
                        return Collections.emptyList();
                    }
                    sortedCalls.add((IXXVMConfigDBSetGetCallInfo)getter);
                }
            }
        }
        Collections.sort(sortedCalls, (c1, c2) -> c1.getIdEvaluation() - c2.getIdEvaluation());
        return sortedCalls;
    }

    public synchronized List<Object> getChildrenForElement(Object element, IProject project, IProgressMonitor monitor, boolean filterReadOnlySetters) {
        if (!this.c(project)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        if (configDBCalls == null || configDBCalls.isEmpty()) {
            return null;
        }
        boolean isEmpty = true;
        for (Map.Entry<String, List<IXXVMConfigDBSetGetCallInfo>> entry : configDBCalls.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return null;
        }
        if (!(element instanceof DVTTreeElementWrapper)) {
            return null;
        }
        Object typeElement = ((DVTTreeElementWrapper)element).getRfElement();
        if (!(typeElement instanceof String)) {
            return null;
        }
        List<IXXVMConfigDBSetGetCallInfo> configDBType = configDBCalls.get(typeElement);
        if (configDBType == null || configDBType.isEmpty()) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < configDBType.size()) {
            if (monitor.isCanceled()) {
                return result;
            }
            IXXVMConfigDBSetGetCallInfo call = configDBType.get(i);
            if (!(filterReadOnlySetters && call instanceof IXXVMConfigDBSetCallInfo && ((IXXVMConfigDBSetCallInfo)call).isReadOnly() || this.isXVMPathFiltered && call.isXVMPath())) {
                DVTTreeElementWrapper configDBElement = new DVTTreeElementWrapper((Object)call);
                configDBElement.setProject(project);
                result.add(configDBElement);
                if (ConfigDBViewFilters.SETTERS_AND_GETTERS.getLabel().equals(typeElement) && call instanceof IXXVMConfigDBSetCallInfo) {
                    List xAssociatedGetters = ((IXXVMConfigDBSetCallInfo)call).getXAssociatedGetters();
                    xAssociatedGetters.forEach(getter -> {
                        DVTTreeElementWrapper dvtWrapper = new DVTTreeElementWrapper(getter);
                        dvtWrapper.setProject(project);
                        result.add(dvtWrapper);
                    });
                }
            }
            ++i;
        }
        return result;
    }

    public void computeAssociatedReveal(XViewsUtils.GoToInfoWithRevealType infoRevealType, IInterpreterViews view) {
        if (infoRevealType.getType() == ConfigDBRevealType.REVEAL_ASSOCIATED_GETTERS_FOR_SETTER) {
            this.doAssociatedGettersRevealForSetter((ConfigDBView)view, infoRevealType);
        } else if (infoRevealType.getType() == ConfigDBRevealType.REVEAL_ASSOCIATED_SETTER_FOR_GETTER) {
            this.doAssociatedSetterRevealForGetter((ConfigDBView)view, infoRevealType);
        }
    }

    private void doAssociatedGettersRevealForSetter(ConfigDBView view, XViewsUtils.GoToInfoWithRevealType infoRevealType) {
        IXXVMConfigDBSetGetCallInfo associatedSetter = this.findCall(infoRevealType, view.getHideFilters());
        if (associatedSetter == DUMMY_FILTERED_CONFIG_DB_CALL) {
            ViewsUtils.popOKDialog((int)2, (String)"Config DB", (String)"The associated setter is filtered from Config DB View.\nPlease deactivate the view filters.");
            return;
        }
        if (associatedSetter == null) {
            ViewsUtils.popOKDialog((int)2, (String)"Config DB", (String)"The selected setter was not found in the Config DB View!");
            return;
        }
        if (!(associatedSetter instanceof IXXVMConfigDBSetCallInfo)) {
            ViewsUtils.popOKDialog((int)2, (String)"Config DB", (String)"The selected function call is not a setter!");
            return;
        }
        List xAssociatedGetters = ((IXXVMConfigDBSetCallInfo)associatedSetter).getXAssociatedGetters();
        ArrayList<IXXVMConfigDBSetGetCallInfo> calls = new ArrayList<IXXVMConfigDBSetGetCallInfo>();
        calls.add(associatedSetter);
        calls.addAll(xAssociatedGetters);
        this.setFilterText(view, XVlogConfigDBViewContributorCommon.computeQueryFromCalls(calls));
    }

    private void doAssociatedSetterRevealForGetter(ConfigDBView view, XViewsUtils.GoToInfoWithRevealType infoRevealType) {
        IXXVMConfigDBSetGetCallInfo associatedGetter = this.findCall(infoRevealType, view.getHideFilters());
        if (associatedGetter == DUMMY_FILTERED_CONFIG_DB_CALL) {
            ViewsUtils.popOKDialog((int)2, (String)"Config DB", (String)"The associated getter is filtered from Config DB View.\nPlease deactivate the view filters.");
            return;
        }
        if (associatedGetter == null) {
            ViewsUtils.popOKDialog((int)2, (String)"Config DB", (String)"The selected getter was not found in the Config DB View!");
            return;
        }
        if (!(associatedGetter instanceof IXXVMConfigDBGetCallInfo)) {
            ViewsUtils.popOKDialog((int)2, (String)"Config DB", (String)"The selected method call is not a getter!");
            return;
        }
        IXXVMConfigDBSetCallInfo associatedSetCall = ((IXXVMConfigDBGetCallInfo)associatedGetter).getAssociatedSetCall();
        if (associatedSetCall == null) {
            this.setFilterText(view, XVlogConfigDBViewContributorCommon.computeQueryFromCalls(Arrays.asList(associatedGetter)));
            return;
        }
        this.setFilterText(view, XVlogConfigDBViewContributorCommon.computeQueryFromCalls(Arrays.asList(associatedGetter, associatedSetCall)));
    }

    private IXXVMConfigDBSetGetCallInfo findCall(XViewsUtils.GoToInfoWithRevealType infoRevealType, List<ConfigDBViewFilters> filters) {
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        for (Map.Entry<String, List<IXXVMConfigDBSetGetCallInfo>> configCallType : configDBCalls.entrySet()) {
            String type = configCallType.getKey();
            ConfigDBViewFilters filterType = ConfigDBViewFilters.valueOf((String)DVTStringUtil.replaceAll((Pattern)SPACE_PATTERN, (CharSequence)type.toUpperCase(), (String)"_"));
            if (filterType == null) continue;
            boolean isFiltered = filters.contains(filterType);
            for (IXXVMConfigDBSetGetCallInfo call : configCallType.getValue()) {
                GoToInfo goToInfo = call.getGoToInfo();
                if (goToInfo != null && goToInfo.filePath.equals(infoRevealType.filePath) && infoRevealType.line == goToInfo.line) {
                    if (isFiltered) {
                        return DUMMY_FILTERED_CONFIG_DB_CALL;
                    }
                    if (infoRevealType.text == null || "null".equals(call.getContext()) || infoRevealType.text.equals(call.getContext())) {
                        return call;
                    }
                }
                if (!(call instanceof IXXVMConfigDBSetCallInfo)) continue;
                for (IXXVMConfigDBGetCallInfo getCall : ((IXXVMConfigDBSetCallInfo)call).getXAssociatedGetters()) {
                    GoToInfo goToInfoGet;
                    if (infoRevealType.text != null && !infoRevealType.text.equals(getCall.getContext()) || (goToInfoGet = getCall.getGoToInfo()) == null || !infoRevealType.filePath.equals(goToInfoGet.filePath) || infoRevealType.line != goToInfoGet.line) continue;
                    if (isFiltered) {
                        return DUMMY_FILTERED_CONFIG_DB_CALL;
                    }
                    return getCall;
                }
            }
        }
        return null;
    }

    private static String computeQueryFromCalls(List<IXXVMConfigDBSetGetCallInfo> calls) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < calls.size()) {
            IXXVMConfigDBSetGetCallInfo call = calls.get(i);
            String callType = call instanceof IXXVMConfigDBSetCallInfo ? "set" : "get";
            sb.append(callType).append(" [").append(call.getIdEvaluation()).append("]");
            if (i != calls.size() - 1) {
                sb.append(" | ");
            }
            ++i;
        }
        return sb.toString();
    }

    public TreePath createTreePath(GoToInfo goToInfo, IRfNamedElement namedElement) {
        IViewPart view = ViewsUtils.getViewById((String)this.getID(), (boolean)false);
        if (!(view instanceof ConfigDBView)) {
            return null;
        }
        return this.createTreePath(goToInfo, (IInterpreterViews)view, namedElement);
    }

    public TreePath createTreePath(GoToInfo info, IInterpreterViews view, IRfNamedElement rfField) {
        if (!(info instanceof XViewsUtils.GoToInfoWithRevealType)) {
            throw new IllegalStateException("Unknown received element for reveal element");
        }
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        if (configDBCalls.isEmpty()) {
            return null;
        }
        if (!(view instanceof ConfigDBView)) {
            throw new IllegalStateException("Unknown provided view part " + view);
        }
        if (((XViewsUtils.GoToInfoWithRevealType)info).getType() != ConfigDBRevealType.REVEAL_GETTER && ((XViewsUtils.GoToInfoWithRevealType)info).getType() != ConfigDBRevealType.REVEAL_SETTER) {
            return null;
        }
        return this.doSimpleReveal((ConfigDBView)view, (XViewsUtils.GoToInfoWithRevealType)info);
    }

    private TreePath doSimpleReveal(ConfigDBView view, XViewsUtils.GoToInfoWithRevealType infoRevealType) {
        if (view.getSortKind() == ConfigDBSortKind.EXEC_SORT) {
            return this.doExecReveal(view, infoRevealType);
        }
        return this.doGroupedReveal(view, infoRevealType);
    }

    private TreePath doGroupedReveal(ConfigDBView view, XViewsUtils.GoToInfoWithRevealType infoRevealType) {
        List filters = view.getHideFilters();
        Map<String, List<IXXVMConfigDBSetGetCallInfo>> configDBCalls = XXVMBuilder.INSTANCE.getConfigDBCalls();
        int indexType = 0;
        for (Map.Entry<String, List<IXXVMConfigDBSetGetCallInfo>> entry : configDBCalls.entrySet()) {
            String type = entry.getKey();
            ConfigDBViewFilters filterType = ConfigDBViewFilters.valueOf((String)DVTStringUtil.replaceAll((Pattern)SPACE_PATTERN, (CharSequence)type.toUpperCase(), (String)"_"));
            if (filterType == null) continue;
            boolean isFiltered = filters.contains(filterType);
            ++indexType;
            int indexConfigDBCall = 0;
            List<IXXVMConfigDBSetGetCallInfo> configDBCallsByType = entry.getValue();
            int it = 0;
            while (it < configDBCallsByType.size()) {
                ++indexConfigDBCall;
                IXXVMConfigDBSetGetCallInfo configCall = configDBCallsByType.get(it);
                GoToInfo goToInfo = configCall.getGoToInfo();
                if (goToInfo != null && infoRevealType.filePath.equals(goToInfo.filePath) && infoRevealType.line == goToInfo.line) {
                    if (isFiltered) {
                        return TreePath.TOP_DUMMY_TREE_PATH;
                    }
                    if (infoRevealType.text == null || "null".equals(configCall.getContext()) || infoRevealType.text.equals(configCall.getContext())) {
                        return this.createRevealTreePathGroup(indexType, type, indexConfigDBCall, configCall);
                    }
                }
                if ("Setters and Getters".equals(type) && configCall instanceof IXXVMConfigDBSetCallInfo) {
                    List associatedGetters = ((IXXVMConfigDBSetCallInfo)configCall).getXAssociatedGetters();
                    int idGet = 0;
                    while (idGet < associatedGetters.size()) {
                        GoToInfo goToInfoGet;
                        ++indexConfigDBCall;
                        IXXVMConfigDBGetCallInfo getCall = (IXXVMConfigDBGetCallInfo)associatedGetters.get(idGet);
                        if ((infoRevealType.text == null || infoRevealType.text.equals(getCall.getContext())) && (goToInfoGet = getCall.getGoToInfo()) != null && infoRevealType.filePath.equals(goToInfoGet.filePath) && infoRevealType.line == goToInfoGet.line) {
                            if (isFiltered) {
                                return TreePath.TOP_DUMMY_TREE_PATH;
                            }
                            return this.createRevealTreePathGroup(indexType, type, indexConfigDBCall, (IXXVMConfigDBSetGetCallInfo)getCall);
                        }
                        ++idGet;
                    }
                }
                ++it;
            }
        }
        return null;
    }

    private TreePath createRevealTreePathGroup(int indexType, String configDBType, int indexConfigDBCall, IXXVMConfigDBSetGetCallInfo call) {
        TreePath child = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)configDBType, (int)(indexType - 1));
        child.setElement((Object)new DVTTreeElementWrapper((Object)configDBType));
        TreePath toConfigCall = TreePath.child((TreePath)child, (String)call.toString(), (int)(indexConfigDBCall - 1));
        toConfigCall.setElement((Object)new DVTTreeElementWrapper((Object)call));
        return toConfigCall;
    }

    private TreePath doExecReveal(ConfigDBView view, XViewsUtils.GoToInfoWithRevealType infoRevealType) {
        List<IXXVMConfigDBSetGetCallInfo> calls = this.allSortedConfigDBCalls((IProgressMonitor)new NullProgressMonitor(), view.getHideFilters());
        int i = 0;
        while (i < calls.size()) {
            IXXVMConfigDBSetGetCallInfo configCall = calls.get(i);
            GoToInfo goToInfo = configCall.getGoToInfo();
            if (goToInfo != null && infoRevealType.filePath.equals(goToInfo.filePath) && infoRevealType.line == goToInfo.line) {
                TreePath configDBTreePath = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)configCall.toString(), (int)i);
                configDBTreePath.setElement((Object)new DVTTreeElementWrapper((Object)configCall));
                return configDBTreePath;
            }
            ++i;
        }
        return TreePath.TOP_DUMMY_TREE_PATH;
    }

    public List<BreadcrumbSegment> computeBreadcrumbSegmentsFromConfigDBCall(IXXVMConfigDBSetGetCallInfo call, IProject project, IFile file) {
        String context = call.getContext();
        String[] contextElements = DVTStringUtil.split((String)".", (String)context);
        if (contextElements == null || contextElements.length == 0) {
            return null;
        }
        XXVMComponent verificationRoot = (XXVMComponent)XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (verificationRoot == null) {
            return null;
        }
        ArrayList<BreadcrumbSegment> elementsList = new ArrayList<BreadcrumbSegment>();
        XXVMComponent leaf = verificationRoot;
        String[] stringArray = contextElements;
        int n = contextElements.length;
        int n2 = 0;
        while (n2 < n) {
            String elementName = stringArray[n2];
            leaf = (IXXVMComponent)VlogVHBreadcrumbUtils.getInstance().findFirstXVMComponentOccurence((IXXVMObject)leaf, elementName);
            elementsList.add(new BreadcrumbSegment((IRfBreadcrumbElement)leaf));
            ++n2;
        }
        if (leaf == null) {
            return null;
        }
        boolean clazzExists = VlogVHBreadcrumbUtils.getInstance().checkClassExistsInFile(project, file, leaf.getRfClass());
        if (!clazzExists) {
            return null;
        }
        return elementsList;
    }

    public boolean c(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F7376");
    }

    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        return false;
    }

    protected abstract void setFilterText(ConfigDBView var1, String var2);
}

