/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.factory.overrides.DVTXFactoryOverridesLabelProvider;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesView;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesViewFilters;
import ro.amiq.dvt.ui.views.factory.overrides.IXFactoryOverridesContributor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.factory.overrides.XXVMFactoryOverrideElement;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;

public abstract class XVlogFactoryOverridesViewContributorCommon
implements IXFactoryOverridesContributor {
    protected DVTXFactoryOverridesLabelProvider fLabelProvider = new DVTXFactoryOverridesLabelProvider();
    protected boolean isInterpreterFailed;
    protected boolean isFactoryOverridesComputed;

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public String getID() {
        return "ro.amiq.dvt.ui.views.FactoryOverridesView";
    }

    public boolean adaptsTo(Object adapted) {
        return true;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public String getComment(Object wrapper) {
        return null;
    }

    public boolean hasInterpreterFailed() {
        return this.isInterpreterFailed;
    }

    public void setHasInterpreterFailed(boolean isInterpreterProcessFailed) {
        this.isInterpreterFailed = isInterpreterProcessFailed;
    }

    public void resetState() {
        this.isInterpreterFailed = false;
        this.isFactoryOverridesComputed = false;
    }

    public void serializeModel(Map<String, String> builder, String testName) {
        Map<String, List<IXXVMFactoryOverrideElement>> factoryOverrides = XXVMBuilder.INSTANCE.getFactoryOverrides();
        if (factoryOverrides == null || factoryOverrides.isEmpty()) {
            throw new IllegalStateException("Unable to compute UVM Factory Overrides Data!");
        }
        boolean isEmptyMap = true;
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : factoryOverrides.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            isEmptyMap = false;
            break;
        }
        if (isEmptyMap) {
            builder.put(this.getID(), XVMBuildPhaseXMLParser.EMPTY_FACTORY_OVERRIDES_HIERARCHY);
            return;
        }
        builder.put(this.getID(), this.serializeXMLFactoryOverrides());
    }

    private String serializeXMLFactoryOverrides() {
        StringBuilder fOverds = new StringBuilder();
        XXVMBuilder.appendToSBUtils(fOverds, "\n", "\t", "<", "factory-overrides-hierarchy", ">");
        Map<String, List<IXXVMFactoryOverrideElement>> factoryOverrides = XXVMBuilder.INSTANCE.getFactoryOverrides();
        if (factoryOverrides == null) {
            throw new IllegalStateException("Unknown to serialize null factory overrides map!");
        }
        int id = 1;
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> overrideTypeList : factoryOverrides.entrySet()) {
            List<IXXVMFactoryOverrideElement> ovverides = overrideTypeList.getValue();
            for (IXXVMFactoryOverrideElement override : ovverides) {
                override.assignSerializationId(id++);
            }
        }
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> overrideTypeList : factoryOverrides.entrySet()) {
            String overrideType = overrideTypeList.getKey();
            List<IXXVMFactoryOverrideElement> overrides = overrideTypeList.getValue();
            XXVMBuilder.appendToSBUtils(fOverds, "\n", "\t", "\t", "<", "xvm-factory-override-type", " ", "factory-override-type", "=", "'", overrideType, "'");
            if (overrides == null) {
                throw new IllegalStateException("Unknown to serialize null factory overrides list!");
            }
            if (overrides.isEmpty()) {
                XXVMBuilder.appendToSBUtils(fOverds, "/", ">");
                continue;
            }
            XXVMBuilder.appendToSBUtils(fOverds, ">");
            for (IXXVMFactoryOverrideElement element : overrides) {
                element.serializeFactoryOverride(fOverds, "\t\t");
                element.getDuplicates().forEach(duplicate -> duplicate.serializeFactoryOverride(fOverds, "\t\t"));
            }
            XXVMBuilder.appendToSBUtils(fOverds, "\n", "\t", "\t", "<", "/", "xvm-factory-override-type", ">");
        }
        XXVMBuilder.appendToSBUtils(fOverds, "\n", "\t", "<", "/", "factory-overrides-hierarchy", ">", "\n");
        return fOverds.toString();
    }

    public void parseNode(Element rootNode, IProject project, String testName) {
        NodeList childNodes = rootNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        LinkedHashMap<String, List<IXXVMFactoryOverrideElement>> allFactoryOverrides = new LinkedHashMap<String, List<IXXVMFactoryOverrideElement>>();
        allFactoryOverrides.put("Direct", new LinkedList());
        allFactoryOverrides.put("Chain", new LinkedList());
        allFactoryOverrides.put("Unused", new LinkedList());
        int i = 0;
        while (i < childNodes.getLength()) {
            block15: {
                String overrideType;
                Node overrideTypeAttr;
                Node node;
                block16: {
                    node = childNodes.item(i);
                    if (node == null || 1 != node.getNodeType() || !"xvm-factory-override-type".equals(node.getNodeName())) break block15;
                    NamedNodeMap attributes = node.getAttributes();
                    overrideTypeAttr = attributes.getNamedItem("factory-override-type");
                    if (overrideTypeAttr != null && !"null".equals(overrideTypeAttr.getNodeValue())) break block16;
                    DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unknown factory override type ", "factory-override-type", " null", "\n\u2007\n"}));
                    break block15;
                }
                switch (overrideType = overrideTypeAttr.getNodeValue()) {
                    case "Direct": {
                        this.parseOverrideType(node.getChildNodes(), (List)allFactoryOverrides.get("Direct"), project, testName, allFactoryOverrides);
                        break;
                    }
                    case "Chain": {
                        this.parseOverrideType(node.getChildNodes(), (List)allFactoryOverrides.get("Chain"), project, testName, allFactoryOverrides);
                        break;
                    }
                    case "Unused": {
                        this.parseOverrideType(node.getChildNodes(), (List)allFactoryOverrides.get("Unused"), project, testName, allFactoryOverrides);
                        break;
                    }
                    default: {
                        DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unknown factory override type ", "factory-override-type", "=\"", overrideType, "\"", "\n\u2007\n"}));
                    }
                }
            }
            ++i;
        }
        XXVMBuilder.INSTANCE.loadFactoryOverrides(allFactoryOverrides);
    }

    private void parseOverrideType(NodeList childNodes, List<IXXVMFactoryOverrideElement> overrides, IProject project, String testName, Map<String, List<IXXVMFactoryOverrideElement>> allFactoryOverrides) {
        if (childNodes == null || childNodes.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (1 == node.getNodeType() && "xvm-factory-override".equals(node.getNodeName())) {
                NamedNodeMap ovrdAttr = node.getAttributes();
                Node fullInstPathAttr = ovrdAttr.getNamedItem("full-instance-path");
                String fullInstPath = fullInstPathAttr == null || "null".equals(fullInstPathAttr.getNodeValue()) ? "" : fullInstPathAttr.getNodeValue();
                Node origTypeAttr = ovrdAttr.getNamedItem("original-type-name");
                String origType = origTypeAttr == null || "null".equals(origTypeAttr.getNodeValue()) ? "" : origTypeAttr.getNodeValue();
                Node ovrdTypeAttr = ovrdAttr.getNamedItem("override-type-name");
                String ovrdType = ovrdTypeAttr == null || "null".equals(ovrdTypeAttr.getNodeValue()) ? "" : ovrdTypeAttr.getNodeValue();
                Node createCallAttr = ovrdAttr.getNamedItem("create-call");
                String createCall = createCallAttr == null || "null".equals(createCallAttr.getNodeValue()) ? "N/A" : createCallAttr.getNodeValue();
                Node obsoleteAttr = ovrdAttr.getNamedItem("obsolete");
                String obsolete = obsoleteAttr == null || "null".equals(obsoleteAttr.getNodeValue()) ? "" : obsoleteAttr.getNodeValue();
                Node idAttr = ovrdAttr.getNamedItem("id");
                int id = idAttr == null || "null".equals(idAttr.getNodeValue()) ? -1 : Integer.parseInt(idAttr.getNodeValue());
                IRfNamedElement origRfClass = RfElementPath.fromString((String)origType, XVlogFactoryOverridesViewContributorCommon.class).toNamedElement(project);
                IRfNamedElement ovrdRfClass = RfElementPath.fromString((String)ovrdType, XVlogFactoryOverridesViewContributorCommon.class).toNamedElement(project);
                if (ovrdRfClass == null) {
                    DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unknown factory override type ", "factory-override-type", " null", "\n\u2007\n"}));
                } else {
                    XXVMFactoryOverrideElement override = null;
                    override = origRfClass != null ? new XXVMFactoryOverrideElement(fullInstPath, origRfClass, ovrdRfClass, IXSerializedModelUtils.createGoToInfoFromString(createCall), testName) : new XXVMFactoryOverrideElement(fullInstPath, origType, ovrdRfClass, IXSerializedModelUtils.createGoToInfoFromString(createCall), testName);
                    override.assignSerializationId(id);
                    override.setObsolete(Boolean.parseBoolean(obsolete));
                    overrides.add(override);
                    NodeList appliedOnCompsNode = node.getChildNodes();
                    if (appliedOnCompsNode != null && appliedOnCompsNode.getLength() != 0) {
                        int j = 0;
                        while (j < appliedOnCompsNode.getLength()) {
                            Node compNode = appliedOnCompsNode.item(j);
                            if (compNode != null && 1 == compNode.getNodeType()) {
                                if ("xvm-factory-override-applied-on-component".equals(compNode.getNodeName()) || "xvm-factory-override-applied-on-object".equals(compNode.getNodeName())) {
                                    String fullNameComp;
                                    NamedNodeMap compAttr = compNode.getAttributes();
                                    Node fullNameAttr = compAttr.getNamedItem("full-name");
                                    String string = fullNameComp = fullNameAttr == null || "null".equals(fullNameAttr.getNodeValue()) ? "" : fullNameAttr.getNodeValue();
                                    if ("".equals(fullNameComp)) {
                                        throw new IllegalStateException("Unable to compute component name");
                                    }
                                    XXVMBuilder.INSTANCE.incrementFactoryOverridesCount();
                                    override.addAffectedCompName(fullNameComp);
                                } else if ("xvm-factory-override-in-chain".equals(compNode.getNodeName())) {
                                    NamedNodeMap inChain = compNode.getAttributes();
                                    Node chainElemsAttr = inChain.getNamedItem("chain-elements");
                                    String chainElems = chainElemsAttr == null || "null".equals(chainElemsAttr.getNodeValue()) ? "" : chainElemsAttr.getNodeValue();
                                    String[] elementsInChain = DVTStringUtil.split((String)"/", (String)chainElems);
                                    if (elementsInChain == null || elementsInChain.length == 0) {
                                        throw new IllegalStateException("Unable to compute overrides in chain!");
                                    }
                                    ArrayList<IXXVMFactoryOverrideElement> ovrInChain = new ArrayList<IXXVMFactoryOverrideElement>();
                                    int k = 0;
                                    while (k < elementsInChain.length) {
                                        ovrInChain.add(this.findFactoryOverrideById(allFactoryOverrides, Integer.parseInt(elementsInChain[k])));
                                        ++k;
                                    }
                                    override.setOverridesInChain(ovrInChain);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private IXXVMFactoryOverrideElement findFactoryOverrideById(Map<String, List<IXXVMFactoryOverrideElement>> allFactoryOverrides, int id) {
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : allFactoryOverrides.entrySet()) {
            if ("Unused".equals(entry.getKey())) continue;
            List<IXXVMFactoryOverrideElement> ovrds = entry.getValue();
            for (IXXVMFactoryOverrideElement ov : ovrds) {
                if (ov.getId() != id) continue;
                return ov;
            }
        }
        return null;
    }

    public void computeAffectedXVMComponents() {
        try {
            try {
                Map<String, List<IXXVMFactoryOverrideElement>> factoryOverrides = XXVMBuilder.INSTANCE.getFactoryOverrides();
                Map<String, IXXVMComponent> getXComponents = XXVMBuilder.INSTANCE.getxComponents();
                Map<String, IXXVMObject> xObjects = XXVMBuilder.INSTANCE.getXVMObjectsOverrided();
                for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : factoryOverrides.entrySet()) {
                    List<IXXVMFactoryOverrideElement> overrides = entry.getValue();
                    overrides.forEach(override -> {
                        override.getCompsAffectedNames().forEach(name -> {
                            Object[] fullName = DVTStringUtil.split((String)".", (String)name);
                            if (fullName == null || fullName.length == 0) {
                                throw new IllegalStateException("Unable to compute full name");
                            }
                            fullName[0] = "uvm_test_top";
                            String fullCorrectName = DVTStringUtil.join((Object[])fullName, (String)".");
                            if (getXComponents.containsKey(fullCorrectName)) {
                                override.addXXVMAffectedByFactoryOverride((IXXVMObject)getXComponents.get(fullCorrectName));
                            } else if (xObjects.containsKey(fullCorrectName)) {
                                override.addXXVMAffectedByFactoryOverride((IXXVMObject)xObjects.get(fullCorrectName));
                            }
                        });
                        override.getCompsAffectedNames().clear();
                    });
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                XXVMBuilder.INSTANCE.cleanXComponents();
            }
        }
        finally {
            XXVMBuilder.INSTANCE.cleanXComponents();
        }
    }

    public void deepClean() {
        XXVMBuilder.INSTANCE.deepCleanFactoryOverridesElements();
    }

    public List<TreePath> createTreePath(IProgressMonitor monitor, List<FactoryOverridesViewFilters> filters) {
        if (!this.isFactoryOverridesComputed) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        Map<String, List<IXXVMFactoryOverrideElement>> overrides = XXVMBuilder.INSTANCE.getFactoryOverrides();
        if (overrides == null || overrides.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isEmpty = true;
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : overrides.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        int index = 0;
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : overrides.entrySet()) {
            String overrideTypes = entry.getKey();
            FactoryOverridesViewFilters filterType = FactoryOverridesViewFilters.valueOf((String)overrideTypes.toUpperCase());
            if (filterType == null || filters.contains(filterType)) continue;
            TreePath parentRoot = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)overrideTypes, (int)index++);
            parentRoot.setElement((Object)new DVTTreeElementWrapper((Object)overrideTypes));
            paths.add(parentRoot);
        }
        return paths;
    }

    public synchronized List<Object> getChildrenForElement(Object element, IProject project, IProgressMonitor monitor) {
        if (!this.c(project)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        Map<String, List<IXXVMFactoryOverrideElement>> factoryOverrides = XXVMBuilder.INSTANCE.getFactoryOverrides();
        if (factoryOverrides == null || factoryOverrides.isEmpty()) {
            return null;
        }
        boolean isEmpty = true;
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> entry : factoryOverrides.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            isEmpty = false;
            break;
        }
        if (isEmpty) {
            return null;
        }
        if (!(element instanceof DVTTreeElementWrapper)) {
            return null;
        }
        Object typeOverride = ((DVTTreeElementWrapper)element).getRfElement();
        if (!(typeOverride instanceof String)) {
            return null;
        }
        List<IXXVMFactoryOverrideElement> overrides = factoryOverrides.get(typeOverride);
        if (overrides == null || overrides.isEmpty()) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < overrides.size()) {
            IXXVMFactoryOverrideElement factory_override = overrides.get(i);
            List appliedOnComponents = factory_override.getAppliedOnComponents();
            if ("Unused".equals(typeOverride)) {
                DVTTreeElementWrapper elementOverride = new DVTTreeElementWrapper((Object)factory_override);
                result.add(elementOverride);
            } else {
                int j = 0;
                while (j < appliedOnComponents.size()) {
                    IXXVMObject component = (IXXVMObject)appliedOnComponents.get(j);
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    DVTTreeElementWrapper factoryElement = new DVTTreeElementWrapper((Object)factory_override);
                    factoryElement.setAdditionalInfo((Object)"object", (Object)component);
                    result.add(factoryElement);
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public boolean c(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F7376");
    }

    public String getText(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof XXVMFactoryOverrideElement) {
            return ((XXVMFactoryOverrideElement)obj).toString();
        }
        if (obj instanceof IXXVMComponent) {
            return ((IXXVMComponent)obj).getSanitizedFullName();
        }
        return "";
    }

    public void computeElabVHBreadcrumbData(IProject project, TreePath selection) {
        try {
            Object element = selection.getElement();
            if (!(element instanceof DVTTreeElementWrapper)) {
                return;
            }
            Object additionalInfo = ((DVTTreeElementWrapper)element).getAdditionalInfo((Object)"object");
            if (!(additionalInfo instanceof IXXVMComponent)) {
                return;
            }
            IXXVMComponent xxvmComponent = (IXXVMComponent)additionalInfo;
            GoToInfo createCallGoToInfo = xxvmComponent.getCreateCallGoToInfo();
            if (createCallGoToInfo == null) {
                return;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, createCallGoToInfo.filePath);
            if (file == null) {
                return;
            }
            ArrayList<BreadcrumbSegment> elementsList = new ArrayList<BreadcrumbSegment>();
            while (xxvmComponent != null && !DVTXRunBuildPhaseUtils.XVM_ROOT.contains(xxvmComponent.getSVType())) {
                elementsList.add(new BreadcrumbSegment((IRfBreadcrumbElement)xxvmComponent));
                xxvmComponent = xxvmComponent.getParent();
            }
            Collections.reverse(elementsList);
            BreadcrumbInput bcInput = new BreadcrumbInput(project, elementsList, VlogVHBreadcrumbUtils.getInstance().getBreadcrumbSerializer());
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)bcInput);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        return false;
    }

    public TreePath createTreePath(GoToInfo goToInfo, IInterpreterViews view, IRfNamedElement namedElement) {
        return this.createTreePath(goToInfo, namedElement);
    }

    public TreePath createTreePath(GoToInfo info, IRfNamedElement namedElement) {
        Map<String, List<IXXVMFactoryOverrideElement>> factoryOverrides = XXVMBuilder.INSTANCE.getFactoryOverrides();
        if (factoryOverrides.isEmpty()) {
            return null;
        }
        int i = -1;
        for (Map.Entry<String, List<IXXVMFactoryOverrideElement>> overridesTypes : factoryOverrides.entrySet()) {
            ++i;
            String type = overridesTypes.getKey();
            List<IXXVMFactoryOverrideElement> overrides = overridesTypes.getValue();
            if (overrides == null || overrides.isEmpty()) continue;
            int indexOvrd = 0;
            int it = 0;
            while (it < overrides.size()) {
                IXXVMFactoryOverrideElement ovrd = overrides.get(it);
                GoToInfo goToInfo = ovrd.getGoToInfo();
                if (goToInfo != null) {
                    boolean isOvrdFoundThroughCreateCall = false;
                    for (IXXVMObject component : ovrd.getAppliedOnComponents()) {
                        GoToInfo componentCreateCallGoToInfo = component.getCreateCallGoToInfo();
                        if (componentCreateCallGoToInfo == null || !Objects.equals(componentCreateCallGoToInfo.filePath, info.filePath) || componentCreateCallGoToInfo.line != info.line || !Objects.equals(namedElement, ovrd.getOverrideType())) continue;
                        isOvrdFoundThroughCreateCall = true;
                        break;
                    }
                    if (isOvrdFoundThroughCreateCall || info.filePath.equals(goToInfo.filePath) && info.line == goToInfo.line) {
                        String toStringFOvrd = ovrd.toString();
                        TreePath child = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)type, (int)i);
                        child.setElement((Object)new DVTTreeElementWrapper((Object)type));
                        TreePath toOverride = TreePath.child((TreePath)child, (String)toStringFOvrd, (int)indexOvrd);
                        DVTTreeElementWrapper factoryElement = new DVTTreeElementWrapper((Object)ovrd);
                        if (!ovrd.getAppliedOnComponents().isEmpty()) {
                            factoryElement.setAdditionalInfo((Object)"object", (Object)((IXXVMObject)ovrd.getAppliedOnComponents().get(0)));
                        }
                        toOverride.setElement((Object)factoryElement);
                        return toOverride;
                    }
                    indexOvrd += ovrd.getAppliedOnComponents().size();
                }
                ++it;
            }
        }
        return null;
    }

    public String getTreeLabelText(HistoryItem top) {
        if (top == null) {
            return "";
        }
        String text = top.getText();
        String[] path = DVTStringUtil.split((String)".", (String)text);
        return "[" + top.getProject().getName() + "] " + path[path.length - 1] + " [UVM Elaboration Model]";
    }

    public long getTotalFactoryOverrides() {
        return XXVMBuilder.INSTANCE.getTotalFactoryOverrides();
    }

    public boolean canHandle(SelectionChangedEvent triggerEvent) {
        return triggerEvent.getSource() instanceof FactoryOverridesView;
    }

    public Object getInput(Object event) {
        if (!(event instanceof InspectViewUpdateEvent)) {
            return null;
        }
        if (((InspectViewUpdateEvent)event).getType() != InspectViewUpdateEventCommon.TYPE.WRAPPER) {
            return null;
        }
        IDVTElementWrapper wrapper = (IDVTElementWrapper)((InspectViewUpdateEvent)event).getElement();
        IProject project = ((InspectViewUpdateEvent)event).getProject();
        if (project == null) {
            return null;
        }
        if (!this.c(project)) {
            return null;
        }
        Object obj = wrapper.getRfElement();
        if (!(obj instanceof IXXVMFactoryOverrideElement)) {
            return null;
        }
        IXXVMFactoryOverrideElement factoryOverride = (IXXVMFactoryOverrideElement)obj;
        LinkedList<InspectViewGoToInfo> goTos = new LinkedList<InspectViewGoToInfo>();
        if (factoryOverride.isChain()) {
            this.getRecursiveGoToInfos(factoryOverride.getOverridesInChain(), goTos);
        } else {
            GoToInfo goToInfo = factoryOverride.getGoToInfo();
            if (goToInfo == null) {
                return null;
            }
            goTos.add(new InspectViewGoToInfo(goToInfo));
        }
        factoryOverride.getDuplicates().forEach(duplicate -> {
            boolean bl = goTos.add(new InspectViewGoToInfo(duplicate.getGoToInfo(), null, "Duplicate"));
        });
        Object component = wrapper.getAdditionalInfo((Object)"object");
        if (!(component instanceof IXXVMObject)) {
            return DVTInspectViewUtils.getInstance().processGoToInfos(goTos, project, LanguageKind.VLOG);
        }
        goTos.add(new InspectViewGoToInfo(((IXXVMObject)component).getCreateCallGoToInfo()));
        return DVTInspectViewUtils.getInstance().processGoToInfos(goTos, project, LanguageKind.VLOG);
    }

    private void getRecursiveGoToInfos(List<IXXVMFactoryOverrideElement> overridesInChain, List<InspectViewGoToInfo> goTos) {
        for (IXXVMFactoryOverrideElement override : overridesInChain) {
            if (override.isChain()) {
                this.getRecursiveGoToInfos(override.getOverridesInChain(), goTos);
                continue;
            }
            goTos.add(new InspectViewGoToInfo(override.getGoToInfo()));
        }
    }
}

