/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.registers.IRegistersViewContributor;
import ro.amiq.dvt.ui.views.registers.IXRegistersContributor;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegBlock;
import ro.amiq.vlogdt.interpreter.views.registers.XXVMRegister;
import ro.amiq.vlogdt.model.reflection.views.IVlogRegistersViewContributor;

public abstract class XVlogRegistersViewContributorCommon
implements IXRegistersContributor,
IVlogRegistersViewContributor {
    protected boolean isInterpreterFailed;
    protected boolean isRegistersComputed;

    static void sortRegistersListByAddress(List<? extends Object> registers) {
        Collections.sort(registers, (r1, r2) -> {
            if (!(r1 instanceof IXXVMRegBlock) || !(r2 instanceof IXXVMRegBlock)) {
                return 0;
            }
            IXXVMRegBlock.RegisterKind k1 = ((IXXVMRegBlock)r1).getKind();
            IXXVMRegBlock.RegisterKind k2 = ((IXXVMRegBlock)r2).getKind();
            if (k1 == IXXVMRegBlock.RegisterKind.REGISTER && k2 == IXXVMRegBlock.RegisterKind.REGISTER) {
                int compareToAddressBaseValue = ((IXXVMRegBlock)r1).getAddressBase16().compareTo(((IXXVMRegBlock)r2).getAddressBase16());
                if (compareToAddressBaseValue == 0) {
                    return ((IXXVMRegBlock)r1).getName().compareTo(((IXXVMRegBlock)r2).getName());
                }
                return compareToAddressBaseValue;
            }
            if (r1 instanceof IXXVMRegBlock && r2 instanceof IXXVMRegBlock) {
                return ((IXXVMRegBlock)r1).getName().compareTo(((IXXVMRegBlock)r2).getName());
            }
            return 0;
        });
    }

    public String getID() {
        return "ro.amiq.dvt.ui.views.RegistersView";
    }

    public boolean hasInterpreterFailed() {
        return this.isInterpreterFailed;
    }

    public void setHasInterpreterFailed(boolean isInterpreterProcessFailed) {
        this.isInterpreterFailed = isInterpreterProcessFailed;
    }

    public void resetState() {
        this.isInterpreterFailed = false;
        this.isRegistersComputed = false;
    }

    public void serializeModel(Map<String, String> builder, String testName) {
        List<IXXVMRegBlock> rootBlockRegisters = XXVMBuilder.INSTANCE.getRootBlockRegisters();
        if (rootBlockRegisters == null || rootBlockRegisters.isEmpty()) {
            builder.put(this.getID(), XVMBuildPhaseXMLParser.EMPTY_REGISTER_HIERARCHY);
            return;
        }
        builder.put(this.getID(), this.serializeXMLRegisters());
    }

    public String getTreeLabelText(HistoryItem top) {
        if (top == null) {
            return "";
        }
        String text = top.getText();
        String[] path = DVTStringUtil.split((String)".", (String)text);
        return "[" + top.getProject().getName() + "] " + path[path.length - 1] + " [UVM Elaboration Model]";
    }

    private String serializeXMLRegisters() {
        StringBuilder regs = new StringBuilder();
        XXVMBuilder.appendToSBUtils(regs, "\n", "\t", "<", "register-hierarchy", ">");
        List<IXXVMRegBlock> rootBlockRegisters = XXVMBuilder.INSTANCE.getRootBlockRegisters();
        if (rootBlockRegisters == null) {
            throw new IllegalStateException("Unknown to serialize null registers list!");
        }
        for (IXXVMRegBlock block : rootBlockRegisters) {
            if (!(block instanceof XXVMRegBlock)) {
                throw new IllegalStateException("Unknown to serialize this type of element!");
            }
            block.serializeRegister(regs, "\t\t");
        }
        XXVMBuilder.appendToSBUtils(regs, "\n", "\t", "<", "/", "register-hierarchy", ">");
        return regs.toString();
    }

    public void parseNode(Element rootNode, IProject project, String testName) {
        NodeList childNodes = rootNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        LinkedList<IXXVMRegBlock> rootRegisters = new LinkedList<IXXVMRegBlock>();
        this.parseChildrenRegBlocks(rootRegisters, childNodes, null, project);
        XXVMBuilder.INSTANCE.loadRegisters(rootRegisters);
    }

    public void parseChildrenRegBlocks(List<IXXVMRegBlock> rootRegisters, NodeList childNodes, IXXVMRegBlock parent, IProject project) {
        if (childNodes == null || childNodes.getLength() == 0) {
            return;
        }
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node != null && 1 == node.getNodeType()) {
                Node createCallAttribute;
                NamedNodeMap attributes = node.getAttributes();
                XXVMRegBlock regBlock = null;
                if ("xvm-reg-block".equals(node.getNodeName())) {
                    Node namedAttribute = attributes.getNamedItem("name");
                    createCallAttribute = attributes.getNamedItem("create-call");
                    Node namedElementAttribute = attributes.getNamedItem("named-element");
                    Node namedElementClassAttribute = attributes.getNamedItem("named-element-class");
                    Node commentAttribute = attributes.getNamedItem("comment");
                    regBlock = new XXVMRegBlock(namedAttribute.getNodeValue(), null);
                    regBlock.setCreateCallGoToInfo(IXSerializedModelUtils.createGoToInfoFromString(createCallAttribute.getNodeValue()));
                    if (namedElementAttribute.getNodeValue() != null && !namedElementAttribute.getNodeValue().isEmpty()) {
                        regBlock.setRfNamedElement(RfElementPath.fromString((String)(namedElementAttribute == null ? "" : namedElementAttribute.getNodeValue()), XVlogRegistersViewContributorCommon.class).toNamedElement(project));
                    }
                    if (namedElementClassAttribute.getNodeValue() != null && !namedElementClassAttribute.getNodeValue().isEmpty()) {
                        regBlock.setRfClass(RfElementPath.fromString((String)(namedElementClassAttribute == null ? "" : namedElementClassAttribute.getNodeValue()), XVlogRegistersViewContributorCommon.class).toNamedElement(project));
                    }
                    if (commentAttribute.getNodeValue() != null && !"null".equals(commentAttribute.getNodeValue())) {
                        regBlock.setComment(commentAttribute == null ? "" : commentAttribute.getNodeValue());
                    }
                    this.parseChildrenRegBlocks(rootRegisters, node.getChildNodes(), regBlock, project);
                }
                if ("xvm-register".equals(node.getNodeName())) {
                    Node nameAttribute = attributes.getNamedItem("name");
                    createCallAttribute = attributes.getNamedItem("create-call");
                    Node fullNameAttribute = attributes.getNamedItem("full-name");
                    Node addressAttribute = attributes.getNamedItem("address");
                    Node rightsAttribute = attributes.getNamedItem("rights");
                    Node sequencerAttribute = attributes.getNamedItem("sequencer");
                    Node namedElementAttribute = attributes.getNamedItem("named-element");
                    Node namedElementClassAttribute = attributes.getNamedItem("named-element-class");
                    Node commentAttribute = attributes.getNamedItem("comment");
                    RfElementPath namedElementPath = RfElementPath.fromString((String)(namedElementAttribute == null ? "" : namedElementAttribute.getNodeValue()), XVlogRegistersViewContributorCommon.class);
                    IRfNamedElement namedElement = null;
                    if (namedElementPath != null) {
                        namedElement = namedElementPath.toNamedElement(project);
                    }
                    RfElementPath classElementPath = RfElementPath.fromString((String)(namedElementClassAttribute == null ? "" : namedElementClassAttribute.getNodeValue()), XVlogRegistersViewContributorCommon.class);
                    IRfNamedElement rfClass = null;
                    if (classElementPath != null) {
                        rfClass = classElementPath.toNamedElement(project);
                    }
                    DVTNumber parseNumber = XVlogContributorUtils.internalParseNumber(addressAttribute.getNodeValue(), null, false);
                    regBlock = new XXVMRegister(nameAttribute == null ? "" : nameAttribute.getNodeValue(), fullNameAttribute == null ? "" : fullNameAttribute.getNodeValue(), parseNumber == null ? IELParamValue.UNDEFINED_VALUE : ELParamValues.ParamValueNumber.of((DVTNumber)parseNumber), rightsAttribute == null ? "" : rightsAttribute.getNodeValue(), sequencerAttribute == null ? "" : sequencerAttribute.getNodeValue(), commentAttribute == null ? "" : commentAttribute.getNodeValue(), parent, namedElement, rfClass);
                    ((XXVMRegister)regBlock).setCreateCallGoToInfo(IXSerializedModelUtils.createGoToInfoFromString(createCallAttribute.getNodeValue()));
                    XXVMBuilder.INSTANCE.incrementRegisterCount();
                }
                if (regBlock != null) {
                    if (parent == null) {
                        rootRegisters.add(regBlock);
                    } else {
                        parent.addChildren(regBlock);
                    }
                }
            }
            ++i;
        }
    }

    public void sortRegisters(List<IXXVMRegBlock> children, boolean sortByName) {
        if (sortByName) {
            IRegistersViewContributor.sortRegistersListByName(children);
        } else {
            XVlogRegistersViewContributorCommon.sortRegistersListByAddress(children);
        }
    }

    public synchronized List<TreePath> createRootTreePath(IProgressMonitor monitor, IProject project) {
        if (!this.isRegistersComputed) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        List<? extends IXXVMRegBlock> rootRegisters = this.computeRegistersModelTree(project, monitor);
        if (rootRegisters == null || rootRegisters.isEmpty()) {
            return Collections.emptyList();
        }
        IRegistersViewContributor.sortRegistersListByName(rootRegisters);
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        int i = 0;
        while (i < rootRegisters.size()) {
            TreePath parentRoot = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)rootRegisters.get(i).getName(), (int)i);
            parentRoot.setElement((Object)rootRegisters.get(i));
            paths.add(parentRoot);
            ++i;
        }
        return paths;
    }

    public List<TreePath> createFlatTreePath(IProgressMonitor monitor, IProject project, boolean sortByName) {
        if (!this.isRegistersComputed) {
            return null;
        }
        return IVlogRegistersViewContributor.super.createFlatTreePath(monitor, project, sortByName);
    }

    public synchronized List<Object> getChildrenForElement(Object top, boolean sortByName, IProject project, IProgressMonitor monitor) {
        if (!this.c(project)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (!(top instanceof XXVMRegBlock)) {
            return null;
        }
        XXVMRegBlock parentBlock = (XXVMRegBlock)top;
        ArrayList<IXXVMRegBlock> result = new ArrayList<IXXVMRegBlock>();
        for (IXXVMRegBlock child : parentBlock.getChildren()) {
            if (monitor.isCanceled()) {
                return new ArrayList<IXXVMRegBlock>(result);
            }
            result.add(child);
        }
        this.sortRegisters(result, sortByName);
        return new ArrayList<IXXVMRegBlock>(result);
    }

    public TreePath createTreePath(GoToInfo goToInfo, IInterpreterViews view, IRfNamedElement namedElement) {
        return this.createTreePath(goToInfo, namedElement);
    }

    public List<XXVMRegister> computeRegistersModelFlat(IProject project, IProgressMonitor monitor) {
        return XXVMBuilder.INSTANCE.computeRegistersFlat();
    }

    public List<? extends IXXVMRegBlock> computeRegistersModelTree(IProject project, IProgressMonitor monitor) {
        return XXVMBuilder.INSTANCE.getRootBlockRegisters();
    }

    public void deepClean() {
        XXVMBuilder.INSTANCE.deepCleanRegistersElements();
    }

    public boolean c(IProject project) {
        return IVlogRegistersViewContributor.super.c(project);
    }

    public boolean isStatic() {
        return false;
    }

    public GoToInfo computeGoToInfo(TreePath path) {
        return null;
    }

    public void buildModel(IProject project) {
    }

    public boolean isModelBuildDone(IProject project) {
        return true;
    }

    public TreePath createTreePath(GoToInfo goToInfo, IRfNamedElement namedElement) {
        return IVlogRegistersViewContributor.super.createTreePath(goToInfo, namedElement);
    }

    public long getTotalRegisterCount() {
        return XXVMBuilder.INSTANCE.getTotalRegistersCount();
    }
}

