/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.views.XVlogVHViewContributorCommon;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;

public class XVlogVHViewContributor
extends XVlogVHViewContributorCommon {
    @Override
    public void setVHBreadcrumbData(Object element, IProject project) {
        try {
            boolean portSelection = false;
            if (element instanceof IDVTElementWrapper) {
                element = ((IDVTElementWrapper)element).getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MEMBER_PARENT_WRAPPER);
                portSelection = true;
            }
            if (!(element instanceof TreePath)) {
                return;
            }
            Object selectedWrapper = ((TreePath)element).getElement();
            if (!(selectedWrapper instanceof XXVMComponent)) {
                return;
            }
            XXVMComponent xxvmComponent = (XXVMComponent)selectedWrapper;
            GoToInfo goToInfo = null;
            goToInfo = portSelection ? xxvmComponent.getDeclarationTypeGoToInfo() : xxvmComponent.getCreateCallGoToInfo();
            if (goToInfo == null) {
                return;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, goToInfo.filePath);
            if (file == null) {
                return;
            }
            List breadcrumbSegments = TreePathUtils.getAllElementsToRoot((TreePath)((TreePath)element), (boolean)portSelection, (boolean)true);
            if (breadcrumbSegments == null || breadcrumbSegments.isEmpty()) {
                return;
            }
            BreadcrumbInput breadcrumbWrapper = new BreadcrumbInput(project, breadcrumbSegments, VlogVHBreadcrumbUtils.getInstance().getBreadcrumbSerializer());
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbWrapper);
        }
        catch (CoreException e1) {
            DVTLogger.INSTANCE.logError((Throwable)e1);
        }
    }

    @Override
    public void gotoElement(IProject project, Object wrapper) {
        GoToInfo declarationTypeGoToInfo;
        TreePath parent;
        if (project == null) {
            return;
        }
        Object obj = this.getRfElementFromWrapper(wrapper);
        if (!(obj instanceof IXXVMComponent)) {
            return;
        }
        RfProject rfProject = XVlogContributorUtils.xGetRfProject(project);
        if (rfProject == null) {
            return;
        }
        IXXVMComponent xvmTreeComponent = (IXXVMComponent)obj;
        if (wrapper instanceof TreePath && (parent = ((TreePath)wrapper).getParent()) != null && "/".equals(parent.toString()) && (declarationTypeGoToInfo = xvmTreeComponent.getDeclarationTypeGoToInfo()) != null) {
            declarationTypeGoToInfo.open(project, true);
            return;
        }
        GoToInfo createCall = xvmTreeComponent.getCreateCallGoToInfo();
        if (createCall != null) {
            createCall.open(project, true);
        }
    }

    @Override
    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof IXXVMComponent)) {
            return;
        }
        XXVMComponent xxvmTreePortComponent = (XXVMComponent)elem;
        GoToInfo instanceMarker = xxvmTreePortComponent.getCreateCallGoToInfo();
        if (instanceMarker == null) {
            return;
        }
        this.setVHBreadcrumbData(element, project);
        instanceMarker.open(project, true);
    }

    @Override
    public void openViewForElementAtCursor() {
        VlogQuickViewersUtil.getInstance().openVerificationHierarchyForElementAtCursor();
    }

    public void notifyXViewError() {
        this.resetState();
        ro.amiq.dvt.ui.Utils.safeRunSynchInUIThread(() -> {
            IViewPart view = ViewsUtils.getViewById((String)this.getID(), (boolean)false);
            if (!(view instanceof VerificationHierarchyView)) {
                return;
            }
            ((VerificationHierarchyView)view).clean();
            ((VerificationHierarchyView)view).update(BuildEvents.INTERPRETER_FAILED);
        });
    }

    public void notifyXViewSuccess() {
        this.isRootElementComputed = true;
        ro.amiq.dvt.ui.Utils.safeRunSynchInUIThread(() -> {
            IViewPart view = ViewsUtils.getHiddenViewById((String)this.getID(), (boolean)false);
            if (!(view instanceof VerificationHierarchyView)) {
                return;
            }
            ((VerificationHierarchyView)view).update(BuildEvents.INTERPRETER_MODE);
        });
    }

    @Override
    public List<String> getAdditionalContextMenuActionIds(Object selectedWrapper) {
        GoToInfo goToType;
        if (!(selectedWrapper instanceof XXVMComponent) && !(selectedWrapper instanceof TreePath)) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.copyHierarchyPath");
        GoToInfo goToInfo = goToType = selectedWrapper instanceof XXVMComponent ? ((XXVMComponent)selectedWrapper).getCreateCallGoToInfo() : null;
        if (goToType == null) {
            return results;
        }
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.OpenTypeDeclaration");
        return results;
    }

    @Override
    public void copyHierarchyPathAction(Object selectedWrapper, Object port) {
        String copyHierarchyPathSegmentSeparator = this.getCopyHierarchyPathSegmentSeparator();
        String path = this.computeCopyHierarchyPath(selectedWrapper, port, copyHierarchyPathSegmentSeparator);
        Utils.copyToClipboard((String)path, (int)3);
    }

    private String getCopyHierarchyPathSegmentSeparator() {
        return PrefConst.getCopyHierarchyPathSegmentSepartor();
    }

    @Override
    public String getID() {
        return "ro.amiq.dvt.ui.views.VerificationHierarchyView";
    }

    @Override
    public void saveCHDDiagram(IProject project, String chdFileName) {
        IXXVMComponent rootComponent = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (this.isDummyRoot(rootComponent)) {
            rootComponent = this.getChild(rootComponent);
        }
        if (rootComponent == null) {
            throw new IllegalStateException("Unable to save CHD Diagram!");
        }
        String projectPath = project.getLocation().toOSString();
        if (!(rootComponent instanceof XXVMComponent)) {
            throw new IllegalStateException("Unable to save CHD Diagram!");
        }
        StringBuilder result = this.collectXMLComponents();
        if (result.length() == 0) {
            throw new IllegalStateException("Unable to save CHD Diagram!");
        }
        String uvmDiagramFileName = ((XXVMComponent)rootComponent).getUVMDiagramFileName();
        String uvmDiagramFullPath = String.valueOf(projectPath) + "/" + uvmDiagramFileName;
        if (chdFileName != null) {
            uvmDiagramFullPath = uvmDiagramFullPath.replace(uvmDiagramFileName, chdFileName);
            uvmDiagramFileName = chdFileName;
        }
        XConsole console = XConsoleRegistry.getConsole((IProject)project, (boolean)false, (boolean)false);
        console.print("\nWriting diagram into " + uvmDiagramFullPath + " ...");
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedWriter outputStreamWriter = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(uvmDiagramFullPath))));){
                outputStreamWriter.write(result.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            console.print(DVTStringUtil.appendString((Object[])new Object[]{"*** Error: Write diagram failed: ", e, "\u2007\n"}));
        }
        String fileName = uvmDiagramFileName;
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(() -> {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IFile iFile = project.getFile(fileName);
                iFile.refreshLocal(0, null);
                IDE.openEditor((IWorkbenchPage)page, (IFile)iFile);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    @Override
    protected Boolean adaptsToLanguageKind(Object adapted) {
        return null;
    }
}

