/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.views;

import java.io.File;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.diagrams.editor.VHDiagramBreadcrumbUtils;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IXVHContributor;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.interpreter.utils.IXSerializedModelUtils;
import ro.amiq.vlogdt.interpreter.utils.XVlogContributorUtils;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMObject;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMPortComponent;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItemUVMElabStatus;
import ro.amiq.vlogdt.model.reflection.views.VHXVLOGLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VHXVLOGPortsLabelProvider;

public abstract class XVlogVHViewContributorCommon
implements IXVHContributor {
    protected boolean isRootElementComputed;
    protected boolean isInterpreterFailed;
    protected final VHXVLOGLabelProvider treeLabelProvider = new VHXVLOGLabelProvider();
    protected final VHXVLOGPortsLabelProvider tableLabelProvider = new VHXVLOGPortsLabelProvider();

    public IMembersLabelProvider getMembersViewLabelProvider() {
        return this.tableLabelProvider;
    }

    public MembersViewInput getMembersInput(Object element, StringMatcher stringMatcher) {
        if (element == null) {
            return new MembersViewInput(Collections.emptyList(), false);
        }
        if (!(element instanceof IXXVMComponent)) {
            return null;
        }
        ArrayList<RfTreeElementWrapper> results = new ArrayList<RfTreeElementWrapper>(4);
        IXXVMComponent component = (IXXVMComponent)element;
        for (IXXVMComponent port : component.getPorts()) {
            RfTreeElementWrapper bw = new RfTreeElementWrapper(port);
            bw.setProject(component.getIProject());
            String text = this.tableLabelProvider.getText((Object)bw);
            if (!ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)text)) continue;
            results.add(bw);
        }
        return new MembersViewInput(results, false);
    }

    public String getHistoryItemName(HistoryItem top) {
        if (!(top instanceof VHHistoryItem)) {
            throw new IllegalStateException("Unsupported element " + top.getClass());
        }
        RfElementPath objectQName = ((VHHistoryItem)top).getObjectQName();
        IRfNamedElement namedElement = objectQName.toNamedElement(top.getProject());
        if (namedElement == null) {
            throw new IllegalStateException("Unsupported element " + namedElement);
        }
        return namedElement.getName();
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
    }

    public Comparator<IDVTElementWrapper> getMembersCategoryComparator() {
        return null;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public boolean adaptsTo(Object adapted) {
        Boolean adaptsToLanguageKind = this.adaptsToLanguageKind(adapted);
        if (adaptsToLanguageKind != null) {
            return adaptsToLanguageKind;
        }
        if (adapted instanceof RfTreeElementWrapper) {
            return true;
        }
        if (adapted instanceof DVTTreeElementWrapper) {
            adapted = ((DVTTreeElementWrapper)adapted).getRfElement();
        }
        if (adapted instanceof TreePath) {
            adapted = ((TreePath)adapted).getElement();
        }
        if (DummyElement.RECURRENCE_NODE.equals(adapted)) {
            return true;
        }
        return adapted instanceof CHUVMComponent;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.treeLabelProvider;
    }

    public String getComment(Object wrapper) {
        return null;
    }

    public void gotoElement(IProject project, Object wrapper) {
    }

    protected Object getRfElementFromWrapper(Object wrapper) {
        if (wrapper instanceof IDVTElementWrapper) {
            return ((IDVTElementWrapper)wrapper).getRfElement();
        }
        if (wrapper instanceof TreePath) {
            return ((TreePath)wrapper).getElement();
        }
        return wrapper;
    }

    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        return false;
    }

    public List<HistoryItem> getTops(IProject project) {
        if (!this.c(project)) {
            return Collections.emptyList();
        }
        RfProject rfProject = XVlogContributorUtils.xGetRfProject(project);
        if (rfProject == null) {
            return Collections.emptyList();
        }
        IFolder modelsFolder = project.getFolder("dvt_uvm_elaboration_models");
        if (modelsFolder == null) {
            return Collections.emptyList();
        }
        List uvmElaborationModels = XUVMElaborationStarters.getStarter((LanguageKind)this.getLanguageKind()).getUVMBuildPhaseSerializedModels(project, false);
        if (uvmElaborationModels == null || uvmElaborationModels.isEmpty()) {
            return Collections.emptyList();
        }
        RfClass uvmBaseClass = rfProject.getClass("uvm_test", false);
        RfClass ovmBaseClass = rfProject.getClass("ovm_test", false);
        ArrayList<IRfNamedElement> elements = new ArrayList<IRfNamedElement>();
        if (uvmBaseClass instanceof RfClass) {
            this.getRecursiveClassChildren(elements, uvmBaseClass);
        }
        if (ovmBaseClass instanceof RfClass) {
            this.getRecursiveClassChildren(elements, ovmBaseClass);
        }
        HashMap elementsToResults = new HashMap();
        for (File model : uvmElaborationModels) {
            Document document;
            try {
                document = XVMBuildPhaseXMLParser.getRuntimeElabDocumentMetadata((File)model);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                continue;
            }
            RfElementPath rootElementPath = RfElementPath.fromString((String)XVMBuildPhaseXMLParser.INSTANCE.getRootElementPath(document), XVlogVHViewContributorCommon.class);
            String timestamp = XVMBuildPhaseXMLParser.INSTANCE.getTimestamp(document);
            String elabStatus = XVMBuildPhaseXMLParser.INSTANCE.getElabModelStatus(document);
            for (IRfNamedElement element : elements) {
                List results;
                HistoryItem item;
                RfElementPath elementPath = RfElementPath.path((IRfNamedElement)element);
                if (elementPath == null || !elementPath.equals((Object)rootElementPath) || (item = VHHistoryItem.parseHistoryItem(project.getName(), elementPath)) == null) continue;
                if (timestamp != null) {
                    item.addTimestamp(timestamp);
                }
                try {
                    if (elabStatus != null) {
                        ((VHHistoryItem)item).setUvmElabStatus(VHHistoryItemUVMElabStatus.valueOf(elabStatus.toUpperCase()));
                    }
                }
                catch (IllegalArgumentException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                if ((results = (List)elementsToResults.get(element)) == null) {
                    elementsToResults.put(element, new ArrayList());
                }
                results = (List)elementsToResults.get(element);
                results.add(item);
            }
        }
        ArrayList<HistoryItem> finalResults = new ArrayList<HistoryItem>();
        for (IRfNamedElement element : elements) {
            List elementResults = (List)elementsToResults.get(element);
            if (elementResults == null) continue;
            finalResults.addAll(elementResults);
        }
        Collections.reverse(finalResults);
        return finalResults;
    }

    private void getRecursiveClassChildren(List<IRfNamedElement> elements, RfClass clazz) {
        Set<RfClass> children = clazz.getChildren();
        if (children == null) {
            return;
        }
        for (RfClass child : children) {
            RfClass genericClass = child.getGenericClass();
            if (elements.contains(genericClass)) continue;
            if (!child.hasVirtualQualifier()) {
                elements.add(child);
            }
            this.getRecursiveClassChildren(elements, child);
        }
    }

    public String getTreeLabelText(HistoryItem top) {
        if (top == null) {
            return "";
        }
        String text = top.getText();
        String[] path = DVTStringUtil.split((String)".", (String)text);
        return "[" + top.getProject().getName() + "] " + path[path.length - 1] + " [UVM Elaboration Model]";
    }

    public boolean acceptsHistoryItem(HistoryItem item) {
        return item instanceof VHHistoryItem;
    }

    public HistoryItem parseHistoryItem(String projectName, String historyItemText) {
        return null;
    }

    public synchronized List<Object> getChildrenForElement(Object top, IRfFilterableTreeAccessor view, boolean prependPackage, boolean isAlphabeticalSort, boolean showComponentsOnly, IProject project, IProgressMonitor monitor) {
        if (!this.c(project)) {
            return null;
        }
        if (!(top instanceof IXXVMComponent)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        XXVMComponent object = (XXVMComponent)top;
        if (monitor.isCanceled()) {
            return null;
        }
        for (IXXVMComponent childInstance : object.getChildren()) {
            if (monitor.isCanceled()) {
                return result;
            }
            result.add(childInstance);
        }
        return result;
    }

    public void openViewForElementAtCursor() {
    }

    public List<String> getAdditionalContextMenuActionIds(Object selectedWrapper) {
        return null;
    }

    public void openTypeDeclarationAction(Object selectedWrapper, IProject project) {
        if (!(selectedWrapper instanceof XXVMComponent)) {
            return;
        }
        XXVMComponent xxvmTreeComponent = (XXVMComponent)selectedWrapper;
        GoToInfo declarationTypeGoToInfo = xxvmTreeComponent.getDeclarationTypeGoToInfo();
        if (declarationTypeGoToInfo == null) {
            return;
        }
        declarationTypeGoToInfo.open(project, true);
    }

    public String computeCopyHierarchyPath(Object selectedWrapper, Object port, String separator) {
        ViewsUtils.ITreePathAccessor viewsUtils = wrapper -> {
            if (wrapper == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            Object obj = this.getRfElementFromWrapper(wrapper);
            if (obj instanceof XXVMComponent) {
                IXXVMComponent parent = ((IXXVMComponent)obj).getParent();
                if (parent instanceof XXVMComponent && DVTXRunBuildPhaseUtils.XVM_ROOT.contains(((XXVMComponent)parent).getSVType())) {
                    result.append(((XXVMComponent)obj).getSVType());
                } else {
                    result.append(((XXVMComponent)obj).getName());
                }
                return result.toString();
            }
            return result.toString();
        };
        String portPath = ViewsUtils.pathToRoot((Object)port, (String)PrefConst.getCopyHierarchyPathSegmentSepartor(), (ViewsUtils.ITreePathAccessor)viewsUtils);
        if (selectedWrapper != null) {
            String elementPath = ViewsUtils.pathToRoot((Object)selectedWrapper, (String)PrefConst.getCopyHierarchyPathSegmentSepartor(), (ViewsUtils.ITreePathAccessor)viewsUtils);
            portPath = portPath.equals("") ? "" : String.valueOf(separator) + portPath;
            return String.valueOf(elementPath) + portPath;
        }
        return portPath;
    }

    public void openCreateCallAction(Object selectedWrapper, IProject project) {
    }

    public void setHasGUIFilteredTree(boolean hasGUIFilteredTree) {
    }

    public boolean hasGUIFilteredTree() {
        return false;
    }

    public boolean isSearchedElementFiltered() {
        return false;
    }

    public void setSearchedElementFiltered(boolean searchedElementFiltered) {
    }

    public TreePath createRootTreePath(HistoryItem top, TreePath parent, boolean isPrependPackage, String testName, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        XXVMComponent component = (XXVMComponent)XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (component == null) {
            return null;
        }
        IXXVMComponent mainComponent = this.getTestComponent(component, testName);
        if (mainComponent == null) {
            return null;
        }
        if (top instanceof VHHistoryItem) {
            RfElementPath objectQName = ((VHHistoryItem)top).getObjectQName();
            IRfNamedElement historyItemNE = objectQName.toNamedElement(((VHHistoryItem)top).getProject());
            IRfNamedElement rfClass = mainComponent.getRfClass();
            if (rfClass instanceof RfSpecializedClass) {
                rfClass = ((RfSpecializedClass)rfClass).getGenericClass();
            }
            if (historyItemNE.equals(rfClass)) {
                return this.createTreePathForComponent(mainComponent);
            }
            IXXVMComponent topComponent = this.findComponentWithNE(mainComponent.getChildren(), historyItemNE);
            if (topComponent == null) {
                return null;
            }
            return this.createTreePathForComponent(topComponent);
        }
        return this.createTreePathForComponent(mainComponent);
    }

    public TreePath createRootTreePath(HistoryItem top, TreePath parent, boolean isPrependPackage, IProgressMonitor monitor) {
        return this.createRootTreePath(top, parent, isPrependPackage, null, monitor);
    }

    private IXXVMComponent getTestComponent(XXVMComponent component, String testName) {
        List<IXXVMComponent> children = component.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (IXXVMComponent child : children) {
            RfClass childRfClass;
            IRfNamedElement childNamedElement = child.getRfClass();
            if (!(childNamedElement instanceof RfClass) || !(childRfClass = (RfClass)childNamedElement).isSubClass("uvm_test", true) && !childRfClass.isSubClass("ovm_test", true) || testName != null && !testName.equals(child.getTypeName())) continue;
            return child;
        }
        return null;
    }

    private TreePath createTreePathForComponent(IXXVMComponent topComponent) {
        TreePath parentRoot = TreePath.child((TreePath)TreePath.TOP_DUMMY_TREE_PATH, (String)topComponent.getSVType(), (int)0);
        parentRoot.setElement((Object)topComponent);
        return parentRoot;
    }

    private IXXVMComponent findComponentWithNE(List<IXXVMComponent> children, IRfNamedElement namedElement) {
        for (IXXVMComponent child : children) {
            IRfNamedElement rfClass = child.getRfClass();
            if (rfClass instanceof RfSpecializedClass) {
                rfClass = ((RfSpecializedClass)rfClass).getGenericClass();
            }
            if (namedElement.equals(rfClass)) {
                return child;
            }
            IXXVMComponent comp = this.findComponentWithNE(child.getChildren(), namedElement);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    public String getText(Object dvtElementWrapper, TreePath ... parent) {
        if (!(dvtElementWrapper instanceof XXVMComponent)) {
            return "";
        }
        if (parent != null && parent[0] == TreePath.TOP_DUMMY_TREE_PATH) {
            return ((XXVMComponent)dvtElementWrapper).getSVType();
        }
        return String.valueOf(((XXVMComponent)dvtElementWrapper).getName()) + " : " + ((XXVMComponent)dvtElementWrapper).getSVType();
    }

    public boolean c(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F7376");
    }

    public GoToInfo getInstanceMarker(List<String> names, List<String> types, IProject project) {
        LinkedList<BreadcrumbSegment> breadcrumbSegments = new LinkedList<BreadcrumbSegment>();
        IXXVMComponent component = this.getXVMObject(names, breadcrumbSegments);
        if (component == null) {
            return null;
        }
        GoToInfo createCallGoToInfo = component.getCreateCallGoToInfo();
        if (createCallGoToInfo == null) {
            return null;
        }
        if (!breadcrumbSegments.isEmpty()) {
            breadcrumbSegments.remove(breadcrumbSegments.size() - 1);
        }
        this.setVHBreadcrumbData(createCallGoToInfo.filePath, project, breadcrumbSegments);
        return createCallGoToInfo;
    }

    private IXXVMComponent getXVMObject(List<String> names, List<BreadcrumbSegment> breadcrumbSegments) {
        IXXVMComponent comp = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (!(comp instanceof XXVMComponent)) {
            return null;
        }
        XXVMComponent rootComponent = (XXVMComponent)comp;
        Iterator<String> namesIterator = names.iterator();
        return this.getXVMObject(namesIterator, rootComponent.getChildren(), breadcrumbSegments);
    }

    private IXXVMComponent getXVMObject(Iterator<String> names, List<IXXVMComponent> children, List<BreadcrumbSegment> breadcrumbSegments) {
        if (names == null || !names.hasNext() || children == null || children.isEmpty()) {
            return null;
        }
        String name = names.next();
        for (IXXVMComponent child : children) {
            String childName = child.getName();
            if (childName == null || !childName.equals(name)) continue;
            breadcrumbSegments.add(new BreadcrumbSegment((IRfBreadcrumbElement)child));
            return !names.hasNext() ? child : this.getXVMObject(names, child.getChildren(), breadcrumbSegments);
        }
        return null;
    }

    public boolean isValidVHElement(List<String> names, List<String> types, IProject project) {
        return this.getXVMObject(names, new LinkedList<BreadcrumbSegment>()) != null;
    }

    public void setVHBreadcrumbData(List<String> names, List<String> types, String filePath, IProject project) {
        LinkedList<BreadcrumbSegment> breadcrumbSegments = new LinkedList<BreadcrumbSegment>();
        IXXVMComponent component = this.getXVMObject(names, breadcrumbSegments);
        if (component == null) {
            return;
        }
        this.setVHBreadcrumbData(filePath, project, breadcrumbSegments);
    }

    protected void setVHBreadcrumbData(String filePath, IProject project, List<BreadcrumbSegment> breadcrumbSegments) {
        try {
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, filePath);
            if (file == null) {
                return;
            }
            BreadcrumbInput breadcrumbWrapper = new BreadcrumbInput(project, breadcrumbSegments, VHDiagramBreadcrumbUtils.getUtils((LanguageKind)LanguageKind.VLOG).getBreadcrumbSerializer());
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbWrapper);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public GoToInfo getTypeMarker(List<String> names, List<String> types, IProject project) {
        LinkedList<BreadcrumbSegment> breadcrumbSegments = new LinkedList<BreadcrumbSegment>();
        IXXVMComponent component = this.getXVMObject(names, breadcrumbSegments);
        if (component == null) {
            return null;
        }
        GoToInfo declarationGoToInfo = component.getDeclarationTypeGoToInfo();
        if (declarationGoToInfo == null) {
            return null;
        }
        this.setVHBreadcrumbData(declarationGoToInfo.filePath, project, breadcrumbSegments);
        return declarationGoToInfo;
    }

    public GoToInfo getTypeMarker(String type, IProject project) {
        return null;
    }

    public void copyHierarchyPathAction(Object selectedWrapper, Object port) {
    }

    public void setVHBreadcrumbData(Object treePath, IProject project) {
    }

    public void setHasInterpreterFailed(boolean isInterpreterFailed) {
        this.isInterpreterFailed = isInterpreterFailed;
    }

    public boolean hasInterpreterFailed() {
        return this.isInterpreterFailed;
    }

    public void deepClean() {
        XXVMBuilder.INSTANCE.deepCleanVerificationHierarchyElements();
    }

    public String getID() {
        return "ro.amiq.dvt.ui.views.VerificationHierarchyView";
    }

    public void saveCHDDiagram(IProject project, String chdFileName) {
    }

    public StringBuilder collectXMLComponents() {
        StringBuilder result = new StringBuilder();
        result.append("<?xml version='1.0' encoding='UTF-8'?>");
        result.append("\n<component-hierarchy version='2'>");
        StringBuilder componentsSB = new StringBuilder();
        StringBuilder connectionsSB = new StringBuilder();
        IXXVMComponent comp = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (!(comp instanceof XXVMComponent)) {
            return new StringBuilder();
        }
        XXVMComponent rootComponent = (XXVMComponent)comp;
        if (rootComponent.getChildren() != null) {
            for (IXXVMComponent child : rootComponent.getChildren()) {
                child.collectXML(componentsSB, connectionsSB, "\t");
            }
        }
        if (componentsSB.length() != 0) {
            result.append((CharSequence)componentsSB);
        }
        if (connectionsSB.length() != 0) {
            result.append("\n\t<connections>");
            result.append((CharSequence)connectionsSB);
            result.append("\n\t</connections>");
        }
        result.append("\n</component-hierarchy>\n");
        return result;
    }

    public void serializeModel(Map<String, String> builder, String testName) {
        IXXVMComponent xvmRootComponent = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (xvmRootComponent == null) {
            builder.put(this.getID(), XVMBuildPhaseXMLParser.EMPTY_COMPONENTS_HIERARCHY);
        }
        builder.put(this.getID(), this.serializeXMLComponents(testName));
    }

    private String serializeXMLComponents(String testName) {
        Map<String, IXXVMObject> xvmObjectsOverrided;
        StringBuilder comps = new StringBuilder();
        StringBuilder connections = new StringBuilder();
        XXVMBuilder.appendToSBUtils(comps, "\n", "\t", "<", "component-hierarchy", ">");
        IXXVMComponent rootComponent = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (!(rootComponent instanceof XXVMComponent)) {
            throw new IllegalStateException("Unknown serialization element!");
        }
        if (((XXVMComponent)rootComponent).getChildren() != null) {
            for (IXXVMComponent child : ((XXVMComponent)rootComponent).getChildren()) {
                IRfNamedElement childNamedElement = child.getRfClass();
                if (!(childNamedElement instanceof RfClass)) {
                    throw new IllegalStateException("Unable to compute RfClass from element " + child);
                }
                RfClass childRfClass = (RfClass)childNamedElement;
                if (!childRfClass.isSubClass("uvm_test", true) && !childRfClass.isSubClass("ovm_test", true) || testName != null && !testName.equals(child.getTypeName())) continue;
                child.serializeComponent(comps, connections, "\t\t");
            }
        }
        if (connections.length() != 0) {
            XXVMBuilder.appendToSBUtils(comps, "\n", "\t", "\t", "<", "connections", ">");
            comps.append((CharSequence)connections);
            XXVMBuilder.appendToSBUtils(comps, "\n", "\t", "\t", "<", "/", "connections", ">");
        }
        if ((xvmObjectsOverrided = XXVMBuilder.INSTANCE.getXVMObjectsOverrided()) == null || xvmObjectsOverrided.isEmpty()) {
            XXVMBuilder.appendToSBUtils(comps, "\n", "\t", "<", "/", "component-hierarchy", ">");
            return comps.toString();
        }
        for (Map.Entry<String, IXXVMObject> objectEntry : xvmObjectsOverrided.entrySet()) {
            IXXVMObject xObject = objectEntry.getValue();
            StringBuilder objectStringBuilder = new StringBuilder();
            xObject.serializeBasicData(objectStringBuilder);
            XXVMBuilder.appendToSBUtils(comps, "\n", "\t", "\t", "<", "xvm-object-affected", objectStringBuilder.toString(), "/", ">");
        }
        XXVMBuilder.appendToSBUtils(comps, "\n", "\t", "<", "/", "component-hierarchy", ">");
        return comps.toString();
    }

    public void parseNode(Element rootNode, IProject project, String testName) {
        NodeList childNodes = rootNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        XXVMComponent rootComponent = null;
        HashMap<String, IXXVMComponent> allComponents = new HashMap<String, IXXVMComponent>();
        LinkedHashMap<String, IXXVMObject> xObjects = new LinkedHashMap<String, IXXVMObject>();
        String className = "uvm_root";
        IRfNamedElement uvmRootRfClass = XVlogContributorUtils.xGetClass(XVlogContributorUtils.xGetRfProject(project), className);
        XXVMComponent xvmRootComp = new XXVMComponent("", null, className, className, null, GoToInfo.sourceOf((IRfNamedElement)uvmRootRfClass), null, uvmRootRfClass, null, false);
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node != null && 1 == node.getNodeType()) {
                if ("xvm-component".equals(node.getNodeName())) {
                    NamedNodeMap attributes = node.getAttributes();
                    if (attributes == null || attributes.getLength() == 0) {
                        DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to compute attributes for root component", "\n\u2007\n"}));
                    } else {
                        Node createCallAttribute = attributes.getNamedItem("create-call");
                        String nodeValue = createCallAttribute == null ? "N/A" : createCallAttribute.getNodeValue();
                        IXSerializedModelUtils.createGoToInfoFromString(nodeValue);
                        Node createCallClassAttribute = attributes.getNamedItem("declaration-class");
                        Node fullNameAttribute = attributes.getNamedItem("full-name");
                        if (fullNameAttribute == null) {
                            DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to find attribute ", "full-name", " for root component", "\n\u2007\n"}));
                        } else {
                            Node nameAttribute = attributes.getNamedItem("name");
                            Node svTypeAttribute = attributes.getNamedItem("sv-type");
                            Node typeAttribute = attributes.getNamedItem("type");
                            Node namedElementAttribute = attributes.getNamedItem("named-element");
                            Node namedElementAttributeClass = attributes.getNamedItem("named-element-class");
                            Node isFactoryOverridenAttribute = attributes.getNamedItem("is-factory-overriden");
                            boolean isFactoryOverridenAttributeValue = isFactoryOverridenAttribute != null && Boolean.parseBoolean(isFactoryOverridenAttribute.getNodeValue());
                            rootComponent = new XXVMComponent(nameAttribute == null ? "" : nameAttribute.getNodeValue(), IXSerializedModelUtils.withFullNameFromString(fullNameAttribute.getNodeValue()), typeAttribute == null ? "" : typeAttribute.getNodeValue(), svTypeAttribute == null ? "" : svTypeAttribute.getNodeValue(), IXSerializedModelUtils.createGoToInfoFromString(createCallAttribute == null ? "N/A" : createCallAttribute.getNodeValue()), IXSerializedModelUtils.createGoToInfoFromString(createCallClassAttribute == null ? "N/A" : createCallClassAttribute.getNodeValue()), RfElementPath.pathInProject((RfElementPath)RfElementPath.fromString((String)(namedElementAttribute == null ? "" : namedElementAttribute.getNodeValue())), (IProject)project), RfElementPath.fromString((String)(namedElementAttributeClass == null ? "" : namedElementAttributeClass.getNodeValue()), XVlogVHViewContributorCommon.class).toNamedElement(project), xvmRootComp, isFactoryOverridenAttributeValue);
                            ZonedDateTime zone = Instant.now().atZone(ZoneId.systemDefault());
                            String timeStamp = zone.format(DateTimeFormatter.ofPattern("u-MM-dd HH:mm:ss"));
                            String chdFilename = "uvm_diagram_" + timeStamp + ".chd";
                            rootComponent.setCHDFileName(chdFilename);
                            allComponents.put(fullNameAttribute.getNodeValue(), rootComponent);
                            this.parseChildrenComponents(node.getChildNodes(), rootComponent, allComponents, project);
                        }
                    }
                } else {
                    if ("connections".equals(node.getNodeName())) {
                        NodeList connections = node.getChildNodes();
                        int j = 0;
                        while (j < connections.getLength()) {
                            Node conn = connections.item(j);
                            if (conn != null && 1 == conn.getNodeType() && "connection".equals(conn.getNodeName())) {
                                NamedNodeMap connAttributes = conn.getAttributes();
                                if (connAttributes == null || connAttributes.getLength() == 0) {
                                    DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to load connection source and destination ports", "\n\u2007\n"}));
                                } else {
                                    Node sourceAttribute = connAttributes.getNamedItem("source");
                                    Node destinationAttribute = connAttributes.getNamedItem("destination");
                                    if (sourceAttribute == null || destinationAttribute == null) {
                                        DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to load connection attribute source or destination port", "\n\u2007\n"}));
                                    } else {
                                        String source = sourceAttribute.getNodeValue();
                                        String destination = destinationAttribute.getNodeValue();
                                        if (source == null || source.isEmpty() || destination == null || destination.isEmpty()) {
                                            DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to load value source or destination port, empty value", "\n\u2007\n"}));
                                        } else {
                                            IXXVMComponent sourcePort = (IXXVMComponent)allComponents.get(source);
                                            IXXVMComponent destinationPort = (IXXVMComponent)allComponents.get(destination);
                                            if (!(sourcePort instanceof XXVMPortComponent)) {
                                                DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Could not find source port ", source, " for connection source=\"", source, "\" connected to destionation=\"", destination, "\". Expected port type, found ", sourcePort == null ? "null" : String.valueOf(sourcePort.getInternalType()) + " of sv-type " + sourcePort.getSVType(), "\n\u2007\n"}));
                                            } else if (!(destinationPort instanceof XXVMPortComponent)) {
                                                DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Could not find destination port ", destination, " for connection source=\"", source, "\" connected to destionation=\"", destination, "\". Expected port type, found ", destinationPort == null ? "null" : String.valueOf(destinationPort.getInternalType()) + " of sv-type " + destinationPort.getSVType(), "\n\u2007\n"}));
                                            } else {
                                                ((XXVMPortComponent)sourcePort).connectedTo((XXVMPortComponent)destinationPort);
                                            }
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if ("xvm-object-affected".equals(node.getNodeName())) {
                        NamedNodeMap objAttributes = node.getAttributes();
                        if (objAttributes == null || objAttributes.getLength() == 0) {
                            DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to load objects affected by fatory overrides attributes", "\n\u2007\n"}));
                        } else {
                            Node attrNameNode = objAttributes.getNamedItem("name");
                            Node attrFullNameNode = objAttributes.getNamedItem("full-name");
                            Node attrTypeNode = objAttributes.getNamedItem("type");
                            Node attrSVTypeNode = objAttributes.getNamedItem("sv-type");
                            Node attrCreateElementNode = objAttributes.getNamedItem("create-call");
                            Node attrDeclarationClassNode = objAttributes.getNamedItem("declaration-class");
                            Node attrNamedElementNode = objAttributes.getNamedItem("named-element");
                            Node attrNamedElementClass = objAttributes.getNamedItem("named-element-class");
                            String name = "";
                            String fullName = "";
                            String type = "";
                            String svType = "";
                            GoToInfo createCallGoToInfo = null;
                            GoToInfo declarationClassGoToInfo = null;
                            IRfNamedElement namedElement = RfElementPath.pathInProject((RfElementPath)RfElementPath.fromString((String)(attrNamedElementNode == null ? "" : attrNamedElementNode.getNodeValue())), (IProject)project).toNamedElement();
                            IRfNamedElement rfClass = RfElementPath.fromString((String)(attrNamedElementClass == null ? "" : attrNamedElementClass.getNodeValue()), XVlogVHViewContributorCommon.class).toNamedElement(project);
                            if (attrNameNode != null) {
                                name = attrNameNode.getNodeValue();
                            }
                            if (attrFullNameNode != null) {
                                fullName = attrFullNameNode.getNodeValue();
                            }
                            if (attrTypeNode != null) {
                                type = attrTypeNode.getNodeValue();
                            }
                            if (attrSVTypeNode != null) {
                                svType = attrSVTypeNode.getNodeValue();
                            }
                            if (attrCreateElementNode != null) {
                                createCallGoToInfo = IXSerializedModelUtils.createGoToInfoFromString(attrCreateElementNode.getNodeValue());
                            }
                            if (attrDeclarationClassNode != null) {
                                declarationClassGoToInfo = IXSerializedModelUtils.createGoToInfoFromString(attrDeclarationClassNode.getNodeValue());
                            }
                            xObjects.put(fullName, new XXVMObject(name, DVTStringUtil.split((String)".", (String)fullName), type, svType, namedElement, rfClass, createCallGoToInfo, declarationClassGoToInfo));
                        }
                    }
                }
            }
            ++i;
        }
        if (rootComponent == null) {
            return;
        }
        XXVMBuilder.INSTANCE.addComponent(xvmRootComp, rootComponent);
        XXVMBuilder.INSTANCE.loadComponents(allComponents);
        XXVMBuilder.INSTANCE.loadXObjects(xObjects);
        XXVMBuilder.INSTANCE.loadRootComponent(xvmRootComp);
    }

    private void parseChildrenComponents(NodeList childNodes, IXXVMComponent parentComponent, Map<String, IXXVMComponent> allComponents, IProject project) {
        if (childNodes == null || childNodes.getLength() == 0) {
            return;
        }
        XConsoleRegistry.getConsole((IProject)project, (boolean)false, (boolean)false);
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node != null && 1 == node.getNodeType() && ("xvm-port".equals(node.getNodeName()) || "xvm-component".equals(node.getNodeName()))) {
                boolean isPort = "xvm-port".equals(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                if (attributes == null || attributes.getLength() == 0) {
                    DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to load ", isPort ? "port" : "component", " attributes", "\"\n\u2007\n"}));
                } else {
                    Node createCallAttribute = attributes.getNamedItem("create-call");
                    Node createCallClassAttribute = attributes.getNamedItem("declaration-class");
                    Node fullNameAttribute = attributes.getNamedItem("full-name");
                    if (fullNameAttribute == null) {
                        DVTLogger.INSTANCE.logError(DVTStringUtil.appendString((Object[])new Object[]{System.lineSeparator(), "*** Error: ", "Unable to find ", isPort ? "port" : "component ", "full-name", " attribute", "\"\n\u2007\n"}));
                    } else {
                        Node nameAttribute = attributes.getNamedItem("name");
                        Node svTypeAttribute = attributes.getNamedItem("sv-type");
                        Node typeAttribute = attributes.getNamedItem("type");
                        Node namedElementAttribute = attributes.getNamedItem("named-element");
                        Node namedElementAttributeClass = attributes.getNamedItem("named-element-class");
                        Node isFactoryOverridenAttribute = attributes.getNamedItem("is-factory-overriden");
                        boolean isFactoryOverridenAttributeValue = isFactoryOverridenAttribute != null && Boolean.parseBoolean(isFactoryOverridenAttribute.getNodeValue());
                        XXVMComponent component = null;
                        component = isPort ? new XXVMPortComponent(nameAttribute == null ? "" : nameAttribute.getNodeValue(), IXSerializedModelUtils.withFullNameFromString(fullNameAttribute.getNodeValue()), typeAttribute == null ? "" : typeAttribute.getNodeValue(), svTypeAttribute == null ? "" : svTypeAttribute.getNodeValue(), IXSerializedModelUtils.createGoToInfoFromString(createCallAttribute == null ? "N/A" : createCallAttribute.getNodeValue()), IXSerializedModelUtils.createGoToInfoFromString(createCallClassAttribute == null ? "N/A" : createCallClassAttribute.getNodeValue()), RfElementPath.pathInProject((RfElementPath)RfElementPath.fromString((String)(namedElementAttribute == null ? "" : namedElementAttribute.getNodeValue()), XVlogVHViewContributorCommon.class), (IProject)project), RfElementPath.fromString((String)(namedElementAttributeClass == null ? "" : namedElementAttributeClass.getNodeValue()), XVlogVHViewContributorCommon.class).toNamedElement(project), parentComponent, isFactoryOverridenAttributeValue) : new XXVMComponent(nameAttribute == null ? "" : nameAttribute.getNodeValue(), IXSerializedModelUtils.withFullNameFromString(fullNameAttribute.getNodeValue()), typeAttribute == null ? "" : typeAttribute.getNodeValue(), svTypeAttribute == null ? "" : svTypeAttribute.getNodeValue(), IXSerializedModelUtils.createGoToInfoFromString(createCallAttribute == null ? "N/A" : createCallAttribute.getNodeValue()), IXSerializedModelUtils.createGoToInfoFromString(createCallClassAttribute == null ? "N/A" : createCallClassAttribute.getNodeValue()), RfElementPath.pathInProject((RfElementPath)RfElementPath.fromString((String)(namedElementAttribute == null ? "" : namedElementAttribute.getNodeValue()), XVlogVHViewContributorCommon.class), (IProject)project), RfElementPath.fromString((String)(namedElementAttributeClass == null ? "" : namedElementAttributeClass.getNodeValue()), XVlogVHViewContributorCommon.class).toNamedElement(project), parentComponent, isFactoryOverridenAttributeValue);
                        allComponents.put(fullNameAttribute.getNodeValue(), component);
                        XXVMBuilder.INSTANCE.addComponent(parentComponent, component);
                        if (!isPort) {
                            this.parseChildrenComponents(node.getChildNodes(), component, allComponents, project);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected boolean isDummyRoot(IXXVMComponent rootComponent) {
        if (rootComponent == null) {
            return true;
        }
        return rootComponent.getName() == null && rootComponent.getRfClass() == null && rootComponent.getNamedElement() == null && rootComponent.getCreateCallGoToInfo() == null;
    }

    protected IXXVMComponent getChild(IXXVMComponent rootComponent) {
        if (!(rootComponent instanceof XXVMComponent)) {
            return null;
        }
        XXVMComponent root = (XXVMComponent)rootComponent;
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return null;
        }
        List<IXXVMComponent> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public boolean isXVMDatabaseReady() {
        return (XXVMComponent)XXVMBuilder.INSTANCE.getXVMRootComponent() != null;
    }

    public void resetState() {
        this.isRootElementComputed = false;
        this.isInterpreterFailed = false;
    }

    protected abstract Boolean adaptsToLanguageKind(Object var1);

    public void resetViewContent() {
        this.deepClean();
        this.resetState();
        XXVMBuilder.INSTANCE.resetIsComputed();
    }

    public boolean canHandle(SelectionChangedEvent triggerEvent) {
        return triggerEvent.getSource() instanceof VerificationHierarchyView || triggerEvent.getSource() instanceof VerificationHierarchyPortsView;
    }

    public Object getInput(Object event) {
        if (((InspectViewUpdateEvent)event).getType() != InspectViewUpdateEventCommon.TYPE.WRAPPER) {
            return null;
        }
        IDVTElementWrapper wrapper = (IDVTElementWrapper)((InspectViewUpdateEvent)event).getElement();
        IProject project = wrapper.getProject();
        if (project == null) {
            return null;
        }
        if (!this.c(project)) {
            return null;
        }
        Object obj = wrapper.getRfElement();
        if (!(obj instanceof IXXVMComponent)) {
            return null;
        }
        IXXVMComponent component = (IXXVMComponent)obj;
        return DVTInspectViewUtils.getInstance().processGoToInfo(project, new InspectViewGoToInfo(component.getCreateCallGoToInfo()), 0);
    }
}

