/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.xvm;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;
import ro.amiq.vlogdt.parser.ReparseInfo;

public class RfXvmFactory
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final List<String> PORT_BASES = Arrays.asList("uvm_port_base", "ovm_port_base");
    private static final List<String> FIFO_BASES = Arrays.asList("uvm_tlm_fifo", "tlm_fifo_base");
    public static final String M_UVM_FIELD_AUTOMATION = "__m_uvm_field_automation";
    public static final String M_OVM_FIELD_AUTOMATION = "m_field_automation";
    public static final String M_UVM_IEEE_FIELD_AUTOMATION = "__m_uvm_execute_field_op";
    public static final String UVM_OVM_START = "start";
    private static final String UVM_ROOT = "uvm_root";
    private static final String OVM_ROOT = "ovm_root";
    private static final List<String> XVM_ROOT = Arrays.asList("uvm_root", "ovm_root");
    public static final String UVM_TEST = "uvm_test";
    public static final String OVM_TEST = "ovm_test";
    private static final List<String> XVM_TEST = Arrays.asList("uvm_test", "ovm_test");
    private static final String TEST_TOP = "_test_top";
    private static final String UVM_OBJECT_REGISTRY = "uvm_object_registry";
    private static final String OVM_OBJECT_REGISTRY = "ovm_object_registry";
    private static final String UVM_COMPONENT_REGISTRY = "uvm_component_registry";
    private static final String OVM_COMPONENT_REGISTRY = "ovm_component_registry";
    private static final String UVM_BITSTREAM_TYPE = "uvm_bitstream_t";
    private static final String OVM_BITSTREAM_TYPE = "ovm_bitstream_t";
    private static final String UVM_PKG = "uvm_pkg";
    private static final String OVM_PKG = "ovm_pkg";
    public static final Set<String> XVM_REGISTRY_SET = new HashSet<String>(Arrays.asList("uvm_component_registry", "uvm_object_registry", "ovm_component_registry", "ovm_object_registry"));
    private static final Set<String> XVM_PORT_BASES = new HashSet<String>(Arrays.asList("uvm_port_base", "uvm_tlm_if_base", "uvm_tlm_extension_base", "uvm_sqr_if_base", "uvm_tlm_req_rsp_channel", "uvm_tlm_fifo_base", "ovm_port_base", "tlm_if_base", "sqr_if_base", "tlm_req_rsp_channel", "tlm_fifo_base"));
    private static final String TYPE_ID = "type_id";
    private static final String COLON_COLON = "::";
    public static final String CREATE_FUNCTION_NAME = "create";
    private static final String TYPE_ID_CREATE = "::type_id::create";
    public static final String CREATE_COMPONENT = "create_component";
    private static final String CAST_OPERATOR = "$cast";
    private static final String PKG = "_pkg";
    private static final String UVM_COMPONENT_BASE = "uvm_component";
    private static final String OVM_COMPONENT_BASE = "ovm_component";
    private RfProject fRfProject;
    private XvmObjectsMap fXvmObjects;
    private boolean fInitDone;
    private Map<RfXvmType, RfPackage> fXvmPkg = new EnumMap<RfXvmType, RfPackage>(RfXvmType.class);
    private Map<RfXvmType, RfClass> fXvmRoot = new EnumMap<RfXvmType, RfClass>(RfXvmType.class);
    private Map<RfClass, List<RfXvmPort>> fPortsCache = new HashMap<RfClass, List<RfXvmPort>>();
    public static final long IS_BLOCKING_ASSIGNMENT_QUALIFIER = HidUtils.toQualifiersSet((HidOperatorQualifier[])new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_ASSIGN, HidOperatorQualifier.IS_BLOCKING_ASSIGN});

    public static boolean isCreateCall(IHidObject hidObject) {
        boolean isAccessArg;
        boolean isBlockingAssign = HidUtils.isOperator((IHidObject)hidObject) && ((HidOperator)hidObject).hasOccurrence(IS_BLOCKING_ASSIGNMENT_QUALIFIER);
        boolean isCast = RfXvmFactory.isCast(hidObject);
        boolean bl = isAccessArg = !isBlockingAssign && !isCast && hidObject instanceof IHidAccessArgs;
        if (!(isBlockingAssign || isAccessArg || isCast)) {
            return false;
        }
        IHid working = HidUtils.getHidFrom((IHidObject)hidObject);
        IHidObject workingHidObject = hidObject;
        if (working instanceof IHidImplicit) {
            return false;
        }
        if (isCast) {
            IHidObject lhValue;
            List castArguments = ((IHidAccessArgs)hidObject).getArgumentValues();
            IHidObject iHidObject = lhValue = castArguments != null && castArguments.size() == 2 ? (IHidObject)castArguments.get(1) : null;
            if (lhValue instanceof IHidOperator) {
                workingHidObject = HidUtils.getOperatorFrom(lhValue);
            }
        }
        IHidObject rhValue = null;
        if ((isBlockingAssign || isCast) && workingHidObject instanceof HidOperator) {
            ListContainer rhValues = ((HidOperator)workingHidObject).getRHValues();
            rhValue = rhValues != null && rhValues.size() == 1 ? (IHidObject)rhValues.get(0) : null;
            working = HidUtils.getHidFrom(rhValue);
        }
        if (working instanceof IHidImplicit) {
            return false;
        }
        return RfXvmFactory.isTypeIdCreateOrCreateComponentHid(working);
    }

    public static boolean isConnectCall(IHidObject hidObject) {
        if (!(hidObject instanceof IHidAccessArgs)) {
            return false;
        }
        Hid hid = ((HidAccess)hidObject).getParentHid();
        if (hid == null) {
            return false;
        }
        if (!"connect".equals(hid.getName())) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (element == null) {
            return false;
        }
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        if (!RfXvmFactory.checkPort(enclosingScope)) {
            return false;
        }
        Hid portHid = hid.getParentHid();
        return portHid != null;
    }

    public RfXvmFactory(RfProject rfProject) {
        this.fRfProject = rfProject;
    }

    public static boolean isCast(IHidObject hidObject) {
        if (!(hidObject instanceof RfHidAccessArgs)) {
            return false;
        }
        Hid parentHid = ((RfHidAccessArgs)hidObject).getParentHid();
        if (parentHid == null) {
            return false;
        }
        return parentHid.getName() == null ? false : HidUtils.isHidAccess((IHidObject)hidObject) && CAST_OPERATOR.equals(parentHid.getName());
    }

    public static boolean checkPortFIFO(Hid portHid) {
        IRfNamedElement rfElement = portHid.getElement();
        if (rfElement == null) {
            return false;
        }
        IRfScopeElement rfElementScope = rfElement.getEnclosingScope();
        if (rfElementScope == null) {
            return false;
        }
        if (!(rfElementScope instanceof RfClass)) {
            return false;
        }
        RfClass rfClassElementScope = (RfClass)rfElementScope;
        for (String fifo_base : FIFO_BASES) {
            if (!rfClassElementScope.isSubClass(fifo_base, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPort(IRfScopeElement enclosingScope) {
        if (!(enclosingScope instanceof RfClass)) {
            return false;
        }
        RfClass rfClassElementScope = (RfClass)enclosingScope;
        for (String port_base : PORT_BASES) {
            if (!rfClassElementScope.isSubClass(port_base, true)) continue;
            return true;
        }
        return false;
    }

    public void init() {
        try {
            this.fInitDone = false;
            this.initType(RfXvmType.OVM);
            this.initType(RfXvmType.UVM);
            if (this.fXvmPkg.get((Object)RfXvmType.OVM) == null && this.fXvmPkg.get((Object)RfXvmType.UVM) == null) {
                return;
            }
            if (this.fXvmRoot.get((Object)RfXvmType.OVM) == null && this.fXvmRoot.get((Object)RfXvmType.UVM) == null) {
                return;
            }
            XvmObjectsMap xvmObjects = new XvmObjectsMap();
            this.collectXvmClasses(xvmObjects);
            this.solveXvmTestName(RfXvmType.OVM, xvmObjects);
            this.solveXvmTestName(RfXvmType.UVM, xvmObjects);
            this.createObjectInstances(xvmObjects);
            this.fXvmObjects = xvmObjects;
        }
        finally {
            this.fInitDone = true;
        }
    }

    public boolean isInitDone() {
        return this.fInitDone;
    }

    public boolean isInit() {
        return this.fXvmObjects != null;
    }

    private void initType(RfXvmType type) {
        for (RfPackage pkg : this.fRfProject.getAllPackages(true)) {
            if (!(String.valueOf(type.toString().toLowerCase()) + PKG).equals(pkg.getName())) continue;
            this.fXvmPkg.put(type, pkg);
            break;
        }
        if (this.fXvmPkg.get((Object)type) == null) {
            DVTLogger.INSTANCE.logInfo("[XVM Factory] This is not an " + type.toString() + " based environment as it does not contain the " + type.toString().toLowerCase() + "_pkg package declaration.");
            return;
        }
        this.fXvmRoot.put(type, this.fXvmPkg.get((Object)type).getClassWithPrefix(String.valueOf(type.toString().toLowerCase()) + "_root", 1, 1));
        if (this.fXvmRoot.get((Object)type) == null) {
            DVTLogger.INSTANCE.logInfo("[XVM Factory] This is not an " + type.toString() + " based environment as it does not contain the " + type.toString().toLowerCase() + "_root class declaration.");
            return;
        }
    }

    public void deepClean() {
        this.fInitDone = false;
        if (this.fXvmObjects != null) {
            this.fXvmObjects.deepClean();
        }
        this.fXvmObjects = null;
        if (this.fXvmPkg != null) {
            this.fXvmPkg.clear();
        }
        if (this.fXvmRoot != null) {
            this.fXvmRoot.clear();
        }
        if (this.fPortsCache != null) {
            this.fPortsCache.clear();
        }
        this.fRfProject = null;
    }

    private void collectXvmClasses(XvmObjectsMap xvmObjects) {
        RfClass ovmObjectBaseClass;
        RfClass uvmObjectBaseClass = this.fRfProject.getClass("uvm_pkg::uvm_object", true);
        if (uvmObjectBaseClass != null) {
            this.collectXvmClasses(xvmObjects, RfXvmType.UVM, uvmObjectBaseClass, false);
        }
        if ((ovmObjectBaseClass = this.fRfProject.getClass("ovm_pkg::ovm_object", true)) != null) {
            this.collectXvmClasses(xvmObjects, RfXvmType.OVM, ovmObjectBaseClass, false);
        }
    }

    private void collectXvmClasses(XvmObjectsMap xvmObjects, RfXvmType xvmType, RfClass xvmClass, boolean isComponent) {
        if (xvmObjects.get(xvmClass) != null) {
            return;
        }
        boolean bl = !isComponent && !(xvmType.equals((Object)RfXvmType.UVM) ? UVM_COMPONENT_BASE : OVM_COMPONENT_BASE).equals(xvmClass.getName()) ? false : (isComponent = true);
        if (isComponent) {
            xvmObjects.put(xvmClass, new RfXvmComponent(this, xvmClass, xvmType, this.isFactoryRegistered(xvmClass)));
        } else {
            xvmObjects.put(xvmClass, new RfXvmObject(this, xvmClass, xvmType, this.isFactoryRegistered(xvmClass)));
        }
        Set<RfClass> childClasses = xvmClass.getChildren();
        if (childClasses == null || childClasses.isEmpty()) {
            return;
        }
        for (RfClass childClass : childClasses) {
            this.collectXvmClasses(xvmObjects, xvmType, childClass, isComponent);
        }
    }

    private boolean isFactoryRegistered(RfClass rfClass) {
        if (XVM_ROOT.contains(rfClass.getName())) {
            return true;
        }
        RfTypeAlias type = rfClass.getLocalMember(RfTypeAlias.class, TYPE_ID, false);
        if (type == null || !TYPE_ID.equals(type.getName())) {
            return false;
        }
        RfNamedElement enclosingScope = type.getEnclosingScope();
        if (rfClass != enclosingScope) {
            return false;
        }
        RfDefElement declaration = type.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ReparseInfo reparseInfo = declaration.getReparseInfo();
        if (reparseInfo == null || (long)reparseInfo.getReparseStackSize() == 0L) {
            return false;
        }
        RfNamedElement associatedType = type.getAssociatedTypeNoParams2();
        return associatedType != null && XVM_REGISTRY_SET.contains(associatedType.getName());
    }

    private void solveXvmTestName(RfXvmType type, XvmObjectsMap xvmObjects) {
        String xvmTestName = type == RfXvmType.UVM ? BuildConfigManager.getUvmTestname((IProject)this.fRfProject.getProject()) : BuildConfigManager.getOvmTestname((IProject)this.fRfProject.getProject());
        if (xvmTestName != null && !xvmTestName.isEmpty()) {
            RfXvmObject testXvmObject = this.findObject(xvmTestName, xvmObjects);
            if (!xvmObjects.containsKey(this.fXvmRoot.get((Object)type))) {
                DVTLogger.INSTANCE.logInfo("[XVM Factory] +" + type.toString() + "_TESTNAME+" + xvmTestName + " specified but this is not an " + type.toString() + " based environment as it does not contain the uvm_root class definition.");
            } else if (testXvmObject == null) {
                DVTLogger.INSTANCE.logInfo("[XVM Factory] +" + type.toString() + "_TESTNAME+" + xvmTestName + " specified but class " + xvmTestName + " is not registered with the factory.");
            } else {
                RfXvmObject rootXvmObject = xvmObjects.get(this.fXvmRoot.get((Object)type));
                RfXvmObjectInstance testInstance = new RfXvmObjectInstance(String.valueOf(type.toString().toLowerCase()) + TEST_TOP, null, testXvmObject);
                rootXvmObject.addChildInstance(testInstance);
            }
        }
    }

    private void createObjectInstances(XvmObjectsMap xvmObjects) {
        try {
            for (RfXvmObject rfXvmObject : xvmObjects.values()) {
                List<RfFunction> functionsAndTasks = rfXvmObject.getRfClass().getLocalMembers(RfFunction.class);
                if (functionsAndTasks == null) continue;
                for (RfFunction fun : functionsAndTasks) {
                    Collection<XVMCreateCall> calls = this.getCreateCalls(fun);
                    if (calls == null) continue;
                    for (XVMCreateCall call : calls) {
                        try {
                            this.createObjectInstance(call, fun, xvmObjects);
                        }
                        catch (XvmFactoryException e) {
                            DVTLogger.INSTANCE.logInfo("[XVM Factory] " + e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Collection<XVMCreateCall> getCreateCalls(IRfNamedElement source) {
        if (source == null) {
            return null;
        }
        CreateCallVisitor visitor = new CreateCallVisitor();
        source.visitHidObject(null, (IHidVisitor)visitor);
        Collection<XVMCreateCall> xvmCreateCalls = visitor.getObjects();
        if (xvmCreateCalls == null) {
            return null;
        }
        LinkedList<XVMCreateCall> result = new LinkedList<XVMCreateCall>(xvmCreateCalls);
        Collections.sort(result, (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            IHidObject call1 = o1.call;
            IHidObject call2 = o2.call;
            if (call1 == null && call2 == null) {
                return 0;
            }
            if (call1 == null) {
                return 1;
            }
            if (call2 == null) {
                return -1;
            }
            HidOccurrence occurence1 = HidUtils.getOccurrence((IHidObject)o1.call);
            HidOccurrence occurence2 = HidUtils.getOccurrence((IHidObject)o2.call);
            if (occurence1 == null && occurence2 == null) {
                return 0;
            }
            if (occurence1 == null) {
                return 1;
            }
            if (occurence2 == null) {
                return -1;
            }
            return occurence1.getOffset() - occurence2.getOffset();
        });
        return result;
    }

    private RfXvmObject findObject(String name, XvmObjectsMap xvmObjects) {
        if (name == null) {
            return null;
        }
        for (RfXvmObject obj : xvmObjects.values()) {
            if (!name.equals(obj.getName())) continue;
            return obj;
        }
        return null;
    }

    private void createObjectInstance(XVMCreateCall create, RfNamedElement enclosingScope, XvmObjectsMap xvmObjects) throws XvmFactoryException {
        DataType fieldDataType;
        List argValues;
        boolean isCreateComponent;
        IHid fieldHid;
        IHidObject methodCallHidObject = create.call;
        enclosingScope = create.scope != null ? create.scope : enclosingScope;
        RfField field = null;
        String instanceName = "";
        boolean isCast = RfXvmFactory.isCast(methodCallHidObject);
        if (isCast && methodCallHidObject instanceof RfHidAccessArgs) {
            List<? extends IHidObject> argumentsValue = ((RfHidAccessArgs)methodCallHidObject).getArgumentValues();
            if (argumentsValue == null || argumentsValue.isEmpty()) {
                throw new XvmFactoryException("Create_component call wrong arguments");
            }
            IHidOperator hidArgument = HidUtils.getOperatorFrom((IHidObject)argumentsValue.get(0));
            if (hidArgument == null || hidArgument.getRHValues() == null || hidArgument.getRHValues().isEmpty()) {
                throw new XvmFactoryException("Create_component call wrong arguments");
            }
            fieldHid = HidUtils.getHidFrom((IHidObject)((IHidObject)hidArgument.getRHValues().get(0)));
        } else {
            fieldHid = HidUtils.isOperator((IHidObject)methodCallHidObject) ? HidUtils.getHidFrom((IHidObject)((HidOperator)methodCallHidObject).getLHValue()) : null;
        }
        IRfNamedElement element = null;
        if (fieldHid != null) {
            element = HidUtils.getResolvedElement((IHidObject)fieldHid);
            if (element == null) {
                element = enclosingScope.semanticGetMember(fieldHid.getName(), fieldHid, null, enclosingScope, null, true, true, false);
            }
            if (!(element instanceof RfField)) {
                throw new XvmFactoryException("Create call not assigned to a component field");
            }
            instanceName = element.getName();
            field = (RfField)element;
        }
        IRfNamedElement type = null;
        RfXvmObject xvmObject = null;
        RfXvmType xvmObjectType = null;
        IHidObject rhObject = null;
        if (HidUtils.isOperator((IHidObject)methodCallHidObject)) {
            ListContainer rhValues = ((HidOperator)methodCallHidObject).getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                throw new XvmFactoryException("Create call not found in assignment");
            }
            rhObject = (IHidObject)rhValues.get(0);
        } else if (isCast && methodCallHidObject instanceof RfHidAccessArgs) {
            IHidOperator operatorArgument;
            List<? extends IHidObject> argumentsValue = ((RfHidAccessArgs)methodCallHidObject).getArgumentValues();
            if (argumentsValue != null && !argumentsValue.isEmpty() && (operatorArgument = HidUtils.getOperatorFrom((IHidObject)argumentsValue.get(1))) != null && operatorArgument.getRHValues() != null && !operatorArgument.getRHValues().isEmpty()) {
                rhObject = (IHidObject)operatorArgument.getRHValues().get(0);
            }
        } else {
            rhObject = methodCallHidObject;
        }
        Hid methodCallHid = (Hid)HidUtils.getHidFrom((IHidObject)rhObject);
        if (methodCallHid == null) {
            throw new XvmFactoryException("Create call not found in assignment");
        }
        String methodCallName = methodCallHid.getName();
        Hid typeHid = methodCallHid.getParentHid() != null ? methodCallHid.getParentHid().getParentHid() : null;
        boolean bl = isCreateComponent = methodCallName != null && methodCallName.contains(CREATE_COMPONENT);
        if (isCreateComponent && rhObject instanceof IHidAccessArgs) {
            Set firstArg;
            argValues = ((IHidAccessArgs)rhObject).getArgumentValues();
            if (argValues != null && argValues.size() == 2 && (firstArg = MethodCallUtils.getValueHids((IHidObject)((IHidObject)argValues.get(0)), (Set)HidFlatteningOption.NONE_EXCLUDED)) != null && firstArg.iterator().hasNext()) {
                IHid firstArgument = (IHid)firstArg.iterator().next();
                String requestedTypeName = null;
                if (firstArgument != null) {
                    requestedTypeName = firstArgument.getName();
                }
                if (requestedTypeName != null && requestedTypeName.length() > 2 && requestedTypeName.startsWith("\"") && requestedTypeName.endsWith("\"")) {
                    requestedTypeName = requestedTypeName.substring(1, requestedTypeName.length() - 1);
                    type = this.computeCreateComponentType(enclosingScope, requestedTypeName);
                }
            }
        } else {
            type = HidUtils.getResolvedElement((IHidObject)typeHid);
            if (type == null && typeHid != null) {
                type = enclosingScope.semanticGetMember(typeHid.getName(), (IHid)typeHid, null, enclosingScope, null, true, true, false);
            }
        }
        if (type instanceof RfTypeAlias) {
            type = ((RfTypeAlias)type).getTranslatedType();
        }
        if (type instanceof RfSpecializedClass) {
            type = ((RfSpecializedClass)type).getGenericClass();
        }
        if (!(type instanceof RfClass) || !this.isFactoryRegistered((RfClass)type)) {
            return;
        }
        xvmObject = xvmObjects.get((RfClass)type);
        if (xvmObject == null) {
            throw new XvmFactoryException("Type " + type + " is not registered with the XVM factory");
        }
        xvmObjectType = xvmObject.getType();
        if (rhObject instanceof IHidAccessArgs && (argValues = ((IHidAccessArgs)rhObject).getArgumentValues()) != null && !argValues.isEmpty()) {
            Set firstArgValue = MethodCallUtils.getValueHids((IHidObject)((IHidObject)argValues.get(0)), (Set)HidFlatteningOption.NONE_EXCLUDED);
            if (firstArgValue.isEmpty()) {
                throw new XvmFactoryException("Unexpected number of arguments");
            }
            IHid next = null;
            String candidate = null;
            if (firstArgValue.iterator().hasNext()) {
                next = (IHid)firstArgValue.iterator().next();
            }
            if (next != null) {
                candidate = next.getName();
            }
            if (isCreateComponent) {
                Set secondArgValue = MethodCallUtils.getValueHids((IHidObject)((IHidObject)argValues.get(1)), (Set)HidFlatteningOption.NONE_EXCLUDED);
                if (secondArgValue.isEmpty()) {
                    throw new XvmFactoryException("Unexpected number of arguments");
                }
                if (secondArgValue.iterator().hasNext()) {
                    next = (IHid)secondArgValue.iterator().next();
                    candidate = next.getName();
                }
            }
            if (candidate != null && candidate.length() > 2 && candidate.startsWith("\"") && candidate.endsWith("\"") && DVTStringUtil.isIdentifier((String)(candidate = candidate.substring(1, candidate.length() - 1)))) {
                instanceName = candidate;
            }
        }
        RfXvmObject parentXvmObject = null;
        RfClass enclosingClass = enclosingScope.getEnclosingScope(RfClass.class);
        parentXvmObject = xvmObjects.get(enclosingClass);
        if (parentXvmObject == null && xvmObjectType != null) {
            parentXvmObject = xvmObjects.get(this.fXvmRoot.get((Object)xvmObjectType));
        }
        if (parentXvmObject == null) {
            throw new XvmFactoryException("Could not find parent component" + HidUtils.toNiceString((IHidObject)methodCallHidObject));
        }
        RfXvmObjectInstance instance = new RfXvmObjectInstance(instanceName, field, xvmObject);
        DataType dataType = fieldDataType = field != null ? field.getDataType() : null;
        if (fieldDataType != null && fieldDataType.getUnpackedDimension() != null && !fieldDataType.getUnpackedDimension().isEmpty()) {
            instance.setArray();
        }
        if (parentXvmObject.hasChildInstance(instance)) {
            instance = parentXvmObject.getChildInstance(instance);
        } else {
            parentXvmObject.addChildInstance(instance);
        }
        instance.getCreateCalls().add(create);
    }

    private static boolean isSupportedCreateComponentCall(IHid methodHid) {
        if (!(methodHid instanceof RfHid)) {
            return false;
        }
        ListContainer list = ((RfHid)methodHid).getAccesses();
        if (list == null) {
            return false;
        }
        List<? extends IHidObject> argValues = ((RfHidAccessArgs)((Object)list.get(0))).getArgumentValues();
        Set secondArg = MethodCallUtils.getValueHids((IHidObject)argValues.get(1), (Set)HidFlatteningOption.NONE_EXCLUDED);
        if (secondArg == null || !secondArg.iterator().hasNext()) {
            return false;
        }
        IHid secondArgument = (IHid)secondArg.iterator().next();
        if (secondArgument == null) {
            return false;
        }
        switch (secondArgument.getHidKind()) {
            case ACCESS: {
                Hid parentHid = ((HidAccess)secondArgument).getParentHid();
                IRfNamedElement parentElement = parentHid.getElement();
                if (!(parentElement instanceof IRfFieldElement)) break;
                IRfNamedElement associated = ((IRfFieldElement)parentElement).getAssociatedType();
                return associated instanceof RfStringType && "string".equals(associated.getName());
            }
            case HID: {
                Hid hid = (Hid)secondArgument;
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof IRfFieldElement)) break;
                IRfNamedElement associated = ((IRfFieldElement)element).getAssociatedType();
                return associated instanceof RfStringType && "string".equals(associated.getName());
            }
            case IMPLICIT: {
                return "string".equals(((RfHidImplicit)secondArgument).guessTypeName(true));
            }
        }
        return false;
    }

    private IRfNamedElement computeCreateComponentType(RfNamedElement enclosingScope, String requestedTypeName) {
        if (enclosingScope == null) {
            return null;
        }
        RfNamedElement workingEnclosingScope = enclosingScope;
        if (requestedTypeName.contains(COLON_COLON)) {
            String packageName = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)requestedTypeName)[0];
            requestedTypeName = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)requestedTypeName)[1];
            List<RfPackage> packages = workingEnclosingScope.getRfProject().getAllPackages(true);
            for (RfPackage pack : packages) {
                if (!pack.getName().equals(packageName)) continue;
                workingEnclosingScope = pack;
                break;
            }
        }
        IRfNamedElement element = workingEnclosingScope.semanticGetMember(requestedTypeName, null, null, workingEnclosingScope, null, true, true, false);
        return element;
    }

    private static boolean isTypeIdCreateOrCreateComponentHid(IHid methodCallHid) {
        String hidString = HidUtils.toNiceString((IHidObject)methodCallHid);
        return HidUtils.isHid((IHidObject)methodCallHid) && (hidString.endsWith(TYPE_ID_CREATE) || hidString.equals(CREATE_COMPONENT) && RfXvmFactory.isSupportedCreateComponentCall(methodCallHid));
    }

    public static List<RfXvmPort> getAllPorts(RfXvmObject root) {
        if (root == null) {
            return Collections.emptyList();
        }
        ArrayList<RfXvmPort> result = new ArrayList<RfXvmPort>();
        RfClass rootClass = root.getRfClass();
        RfXvmFactory factory = root.getFactory();
        if (factory == null) {
            return Collections.emptyList();
        }
        do {
            List<RfXvmPort> ownPorts;
            if ((ownPorts = factory.getOwnPorts(rootClass)) == null) continue;
            result.addAll(ownPorts);
        } while ((rootClass = rootClass.getParent()) != null);
        return result;
    }

    public List<RfXvmPort> getOwnPorts(RfClass rootClass) {
        if (rootClass == null) {
            return Collections.emptyList();
        }
        if (this.fPortsCache.containsKey(rootClass)) {
            return this.fPortsCache.get(rootClass);
        }
        List<RfXvmPort> result = RfXvmFactory.computeClassPorts(rootClass);
        this.fPortsCache.put(rootClass, result);
        return result;
    }

    private static List<RfXvmPort> computeClassPorts(RfClass clazz) {
        ArrayList<RfXvmPort> result = new ArrayList<RfXvmPort>();
        List<RfField> classFields = clazz.getFields();
        if (classFields == null) {
            return result;
        }
        for (RfField field : classFields) {
            if (!RfXvmFactory.isPortForXvmObject(field)) continue;
            RfXvmPort port = new RfXvmPort(field);
            DataType fieldDataType = field.getDataType();
            if (fieldDataType != null && fieldDataType.getUnpackedDimension() != null && !fieldDataType.getUnpackedDimension().isEmpty()) {
                port.setArray();
            }
            result.add(port);
        }
        return result;
    }

    public static boolean isPortForXvmObject(RfField field) {
        if (field == null) {
            return false;
        }
        RfNamedElement assType = field.getAssociatedTypeNoParams2();
        while (assType != null && !(assType instanceof RfClass)) {
            if (!(assType instanceof RfAssociatedType)) break;
            assType = ((RfAssociatedType)assType).getAssociatedTypeNoParams2();
        }
        if (!(assType instanceof RfClass)) {
            return false;
        }
        RfClass parent = (RfClass)assType;
        while (parent != null && !XVM_PORT_BASES.contains(parent.getName())) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    public static boolean isXVMFieldAutomationFunction(IRfNamedElement function) {
        if (function == null || function.getName() == null) {
            return false;
        }
        String fctName = function.getName();
        return M_UVM_FIELD_AUTOMATION.equals(fctName) || M_UVM_IEEE_FIELD_AUTOMATION.equals(fctName) || M_OVM_FIELD_AUTOMATION.equals(fctName);
    }

    public static boolean isXVMBitStreamType(ISDataType dataType) {
        if (dataType == null || dataType.getAliasType() == null) {
            return false;
        }
        IRfTypeAliasElement aliasType = dataType.getAliasType();
        String aliasName = aliasType.getName();
        IRfScopeElement aliasEnclosingScope = aliasType.getEnclosingScope();
        if (aliasEnclosingScope == null) {
            return false;
        }
        return UVM_BITSTREAM_TYPE.equals(aliasName) && UVM_PKG.equals(aliasEnclosingScope.getName()) || OVM_BITSTREAM_TYPE.equals(aliasName) && OVM_PKG.equals(aliasEnclosingScope.getName());
    }

    public static List<RfXvmField> getRegisteredFields(RfXvmObject xvmObject) {
        if (xvmObject == null) {
            return Collections.emptyList();
        }
        if (xvmObject.getRegisteredFields() != null) {
            return xvmObject.getRegisteredFields();
        }
        final ArrayList<RfXvmField> result = new ArrayList<RfXvmField>();
        final RfClass rfClass = xvmObject.getRfClass();
        List<RfFunction> fieldAutomationCandidates = rfClass.getFunctionsWithPrefix(M_UVM_FIELD_AUTOMATION, 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
        if (fieldAutomationCandidates != null) {
            fieldAutomationCandidates.addAll(rfClass.getFunctionsWithPrefix(M_OVM_FIELD_AUTOMATION, 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC));
        } else {
            fieldAutomationCandidates = rfClass.getFunctionsWithPrefix(M_OVM_FIELD_AUTOMATION, 1, 1, IRfNamedElement.AccessModifier.SHOW_PUBLIC);
        }
        if (fieldAutomationCandidates == null || fieldAutomationCandidates.isEmpty()) {
            return result;
        }
        RfFunction fieldAutomationFunction = fieldAutomationCandidates.get(0);
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                RfField field = rfClass.getLocalMember(RfField.class, hid.getName(), false);
                if (field != null) {
                    result.add(new RfXvmField(field));
                }
                return true;
            }
        };
        fieldAutomationFunction.visitHidObject(fieldAutomationFunction.getRfProject(), visitor);
        xvmObject.setRegisteredFields(result);
        return result;
    }

    public RfXvmObject getRegisteredObject(RfClass clazz) {
        if (this.fXvmObjects == null) {
            return null;
        }
        return this.fXvmObjects.get(clazz);
    }

    public RfXvmObject getRegisteredObject(String clazzName) {
        if (clazzName == null || this.fXvmObjects == null) {
            return null;
        }
        for (RfXvmObject object : this.fXvmObjects.values()) {
            if (!clazzName.equals(object.getRfClass().getName())) continue;
            return object;
        }
        return null;
    }

    public Collection<RfXvmObject> getObjects() {
        if (this.fXvmObjects == null) {
            return Collections.emptyList();
        }
        return this.fXvmObjects.values();
    }

    public boolean isEmpty() {
        return this.fXvmObjects == null || this.fXvmObjects.isEmpty();
    }

    private void prettyPrintInternal(DVTBuildConsole console, String indent, RfXvmObject root) {
        if (root == null) {
            return;
        }
        for (RfXvmObjectInstance i : RfXvmFactory.getChildInstances(root)) {
            console.print(String.valueOf(indent) + i);
            this.prettyPrintInternal(console, String.valueOf(indent) + "    ", i.getObject());
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static List<RfXvmObjectInstance> getChildInstances(RfXvmObject root) {
        if (root == null) {
            return Collections.emptyList();
        }
        result = new ArrayDeque<RfXvmObjectInstance>();
        visited = Collections.newSetFromMap(new IdentityHashMap<K, V>());
        if (root.hasChildInstances()) {
            childInstances = root.getChildInstances();
            visited.addAll(childInstances);
            result.addAll(childInstances);
        }
        if (root.getRfClass() != null) ** GOTO lbl25
        return new ArrayList<RfXvmObjectInstance>(result);
        while ((rootFactory = root.getFactory()) != null && (rootFactoryObjects = rootFactory.fXvmObjects) != null && (root = rootFactoryObjects.get(root.getRfClass().getParent())) != null) {
            if (root.hasChildInstances()) {
                childInstances = new ArrayList<RfXvmObjectInstance>(root.getChildInstances());
                i = childInstances.size() - 1;
                while (i >= 0) {
                    childInstance = (RfXvmObjectInstance)childInstances.get(i);
                    if (!visited.contains(childInstance)) {
                        result.addFirst(childInstance);
                        visited.add(childInstance);
                    }
                    --i;
                }
            }
lbl25:
            // 4 sources

            if (root.getRfClass() != null && root.getRfClass().getParent() != null) continue;
        }
        return new ArrayList<RfXvmObjectInstance>(result);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static RfXvmObjectInstance findChildInstance(RfXvmObject root, RfField field) {
        if (root == null) {
            return null;
        }
        instanceOfField = root.getChildInstance(field);
        if (instanceOfField != null) {
            return instanceOfField;
        }
        if (root.getRfClass() != null) ** GOTO lbl11
        return null;
        while ((rootFactory = root.getFactory()) != null && (rootFactoryObjects = rootFactory.fXvmObjects) != null && (root = rootFactoryObjects.get(root.getRfClass().getParent())) != null) {
            if (root.hasChildInstances() && (childInstanceOfField = root.getChildInstance(field)) != null) {
                return childInstanceOfField;
            }
lbl11:
            // 3 sources

            if (root.getRfClass() != null && root.getRfClass().getParent() != null) continue;
        }
        return null;
    }

    public static RfXvmBase.Type getObjectType(RfXvmBase base) {
        if (base == null) {
            return RfXvmBase.Type.UNKNOWN;
        }
        if (base instanceof RfXvmObjectInstance) {
            RfXvmBase.Type objType = RfXvmFactory.getObjectType(((RfXvmObjectInstance)base).getObject());
            if (RfXvmBase.Type.COMPONENT.equals((Object)objType)) {
                return RfXvmBase.Type.COMPONENT_INSTANCE;
            }
            return RfXvmBase.Type.OBJECT_INSTANCE;
        }
        if (base instanceof RfXvmPort) {
            return RfXvmBase.Type.PORT;
        }
        if (base instanceof RfXvmField) {
            return RfXvmBase.Type.FIELD;
        }
        if (!(base instanceof RfXvmObject)) {
            return RfXvmBase.Type.UNKNOWN;
        }
        RfXvmObject obj = (RfXvmObject)base;
        if (XVM_ROOT.contains(obj.getName())) {
            return RfXvmBase.Type.ROOT;
        }
        RfClass rootClass = obj.getRfClass();
        if (rootClass != null) {
            RfClass parent = rootClass;
            while (parent != null && !XVM_TEST.contains(parent.getName())) {
                parent = parent.getParent();
            }
            if (parent != null) {
                return RfXvmBase.Type.TEST;
            }
        }
        if (obj instanceof RfXvmComponent) {
            return RfXvmBase.Type.COMPONENT;
        }
        return RfXvmBase.Type.OBJECT;
    }

    public void prettyPrint() {
        this.prettyPrint(RfXvmType.OVM);
        this.prettyPrint(RfXvmType.UVM);
    }

    private void prettyPrint(RfXvmType type) {
        if (this.fXvmObjects == null || this.fXvmRoot == null) {
            return;
        }
        RfXvmObject root = this.fXvmObjects.get(this.fXvmRoot.get((Object)type));
        if (root == null || !root.hasChildInstances()) {
            return;
        }
        DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole((IProject)this.fRfProject.getProject());
        console.print("");
        console.print("============================================");
        console.print("==== Default " + type.toString() + " Verification Topology ====");
        console.print("============================================");
        this.prettyPrintInternal(console, "", root);
        console.print("============================================");
        console.print("");
        console.print("");
        console.print("============================================");
        console.print("==== " + type.toString() + " Classes ====");
        console.print("============================================");
        for (RfXvmObject object : this.fXvmObjects.values()) {
            if (object.getType() != type) continue;
            console.print(object.toString());
        }
        console.print("============================================");
        console.print("");
    }

    static class CreateCallVisitor
    implements IHidVisitor<IHidObject> {
        Map<IHidObject, XVMCreateCall> createCalls;
        ParserPath parserPath;
        RfNamedElement scope;
        Map<IHidObject, IHidObject> visited = new IdentityHashMap<IHidObject, IHidObject>();

        CreateCallVisitor() {
        }

        public void setHolder(IHidHolder holder) {
            if (HidUtils.isHidHolder((IHidObject)holder)) {
                this.scope = (RfNamedElement)((HidHolder)holder).getScope();
            }
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Collection<XVMCreateCall> getObjects() {
            if (this.createCalls == null) {
                return null;
            }
            return this.createCalls.values();
        }

        public boolean visit(IHidObject hidObject) {
            boolean isAccessArg;
            boolean isBlockingAssign = HidUtils.isOperator((IHidObject)hidObject) && ((HidOperator)hidObject).hasOccurrence(IS_BLOCKING_ASSIGNMENT_QUALIFIER);
            boolean isCast = RfXvmFactory.isCast(hidObject);
            boolean bl = isAccessArg = !isBlockingAssign && !isCast && hidObject instanceof IHidAccessArgs;
            if (!(isBlockingAssign || isAccessArg || isCast)) {
                return true;
            }
            IHid working = HidUtils.getHidFrom((IHidObject)hidObject);
            IHidObject workingHidObject = hidObject;
            if (isCast) {
                IHidObject lhValue;
                List castArguments = ((IHidAccessArgs)hidObject).getArgumentValues();
                IHidObject iHidObject = lhValue = castArguments != null && castArguments.size() == 2 ? (IHidObject)castArguments.get(1) : null;
                if (lhValue instanceof IHidOperator) {
                    workingHidObject = HidUtils.getOperatorFrom(lhValue);
                }
            }
            IHidObject rhValue = null;
            if ((isBlockingAssign || isCast) && workingHidObject instanceof HidOperator) {
                ListContainer rhValues = ((HidOperator)workingHidObject).getRHValues();
                rhValue = rhValues != null && rhValues.size() == 1 ? (IHidObject)rhValues.get(0) : null;
                working = HidUtils.getHidFrom(rhValue);
            }
            if (!RfXvmFactory.isTypeIdCreateOrCreateComponentHid(working)) {
                return true;
            }
            if (rhValue != null) {
                this.visited.put(rhValue, rhValue);
            } else {
                if (this.visited.containsKey(hidObject)) {
                    return true;
                }
                this.visited.put(hidObject, hidObject);
            }
            XVMCreateCall create = XVMCreateCall.of(hidObject, this.parserPath, this.scope);
            if (create != null) {
                if (this.createCalls == null) {
                    this.createCalls = new IdentityHashMap<IHidObject, XVMCreateCall>();
                }
                this.createCalls.put(rhValue != null ? rhValue : hidObject, create);
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    public static class RfXVMPath {
        private RfXvmObject top;
        private List<RfXvmObjectInstance> instances;

        public RfXVMPath(RfXvmObject top, List<RfXvmObjectInstance> instances) {
            this.top = top;
            this.instances = instances;
        }

        public RfXvmObject getTop() {
            return this.top;
        }

        public List<RfXvmObjectInstance> getInstances() {
            return this.instances;
        }
    }

    public static enum RfXvmType {
        OVM,
        UVM;

    }

    public static class XVMCreateCall {
        public final IHidObject call;
        public final ParserPath path;
        public final RfNamedElement scope;
        public GoToInfo[] cachedGoTos;

        private XVMCreateCall(IHidObject createCall, ParserPath path, RfNamedElement scope) {
            this.call = createCall;
            this.path = path;
            this.scope = scope;
        }

        static XVMCreateCall of(IHidObject createCall, ParserPath path, RfNamedElement scope) {
            if (createCall == null || path == null || scope == null) {
                return null;
            }
            return new XVMCreateCall(createCall, path, scope);
        }

        @NotNull
        public GoToInfo[] getGoTos() {
            if (this.cachedGoTos == null) {
                IHidObject working = this.call;
                switch (working.getHidKind()) {
                    case ACCESS: {
                        if (working instanceof IHidAccessArgs) {
                            HidOccurrence occurrence;
                            IHidAccessArgs hidAccess = (IHidAccessArgs)working;
                            LanguageKind languageKind = null;
                            if (hidAccess instanceof RfHidAccess) {
                                languageKind = ((RfHidAccess)hidAccess).getLanguageKind();
                            }
                            if ((occurrence = ((HidAccess)hidAccess).getOccurrence()) != null) {
                                this.cachedGoTos = new GoToInfo[1];
                                this.cachedGoTos[0] = GoToInfo.of((String)this.path.path, (int)occurrence.getOffset(), (int)occurrence.getVirtualOffset(), (int)occurrence.getLine(), (String)"", (LanguageKind)languageKind);
                                break;
                            }
                            this.cachedGoTos = new GoToInfo[0];
                            break;
                        }
                        if (((HidAccess)working).getParentHid() == null) break;
                        working = ((HidAccess)working).getParentHid();
                    }
                    case HID: 
                    case OPERATOR: {
                        HidOccurrence occurrence;
                        LanguageKind languageKind = null;
                        if (working instanceof RfHidOperator) {
                            languageKind = ((RfHidOperator)working).getLanguageKind();
                        }
                        if ((occurrence = ((IHidOccurrenceHolder)working).getOccurrence()) != null) {
                            this.cachedGoTos = new GoToInfo[1];
                            this.cachedGoTos[0] = GoToInfo.of((String)this.path.path, (int)occurrence.getOffset(), (int)occurrence.getVirtualOffset(), (int)occurrence.getLine(), (String)"", (LanguageKind)languageKind);
                            break;
                        }
                        this.cachedGoTos = new GoToInfo[0];
                    }
                }
            }
            return this.cachedGoTos;
        }
    }

    public static class XVMPath {
        List<XVMPathPoint> points = new ArrayList<XVMPathPoint>();

        public List<XVMPathPoint> getPoints() {
            return this.points;
        }

        public final boolean addPoint(String name, String type) {
            if (name == null || type == null) {
                return false;
            }
            return this.points.add(new XVMPathPoint(name, type));
        }

        public final XVMPathIterator iterator() {
            return new XVMPathIterator();
        }

        public final XVMPathPoint getFirst() {
            return !this.points.isEmpty() ? this.points.get(0) : null;
        }

        public final XVMPathPoint getLast() {
            return !this.points.isEmpty() ? this.points.get(this.points.size() - 1) : null;
        }

        public int length() {
            return this.points.size();
        }

        public String toString() {
            return this.points.toString();
        }

        public class XVMPathIterator
        implements Iterator<XVMPathPoint> {
            int index = 0;

            public XVMPathIterator() {
                this(0);
            }

            public XVMPathIterator(int index) {
                this.index = index;
            }

            @Override
            public boolean hasNext() {
                return this.index < XVMPath.this.points.size();
            }

            @Override
            public XVMPathPoint next() {
                if (this.index >= XVMPath.this.points.size()) {
                    throw new NoSuchElementException();
                }
                return XVMPath.this.points.get(this.index++);
            }

            public XVMPathIterator clone() {
                return new XVMPathIterator(this.index);
            }
        }

        public static class XVMPathPoint {
            public final String name;
            public final String type;

            public XVMPathPoint(String name, String type) {
                this.name = name;
                this.type = type;
            }

            public String getName() {
                return this.name;
            }

            public String getType() {
                return this.type;
            }

            public String toString() {
                return String.valueOf(this.name) + " : " + this.type;
            }
        }
    }

    private static class XvmFactoryException
    extends Exception {
        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }

        public XvmFactoryException(String message) {
            super(message);
        }
    }

    static class XvmObjectsMap
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<RfElementPath, RfXvmObject> fMap = new LinkedHashMap<RfElementPath, RfXvmObject>();

        XvmObjectsMap() {
        }

        public boolean containsKey(RfClass clazz) {
            return this.fMap.containsKey(RfElementPath.path((IRfNamedElement)clazz));
        }

        public boolean isEmpty() {
            return this.fMap.isEmpty();
        }

        public void put(RfClass rfClass, RfXvmObject theObject) {
            this.fMap.put(RfElementPath.path((IRfNamedElement)rfClass), theObject);
        }

        public Collection<RfXvmObject> values() {
            return this.fMap.values();
        }

        public RfXvmObject get(RfClass clazz) {
            return this.fMap.get(RfElementPath.path((IRfNamedElement)clazz));
        }

        public void deepClean() {
            if (this.fMap == null) {
                return;
            }
            for (Map.Entry<RfElementPath, RfXvmObject> entry : this.fMap.entrySet()) {
                entry.getValue().deepClean();
            }
            this.fMap.clear();
        }
    }
}

