/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.xvm;

import java.io.Serializable;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;

public class RfXvmObject
extends RfXvmBase
implements IRfVHBreadcrumbElement {
    private static final long serialVersionUID = 1L;
    private RfXvmFactory fFactory;
    private RfClass fRfClass;
    private RfXvmFactory.RfXvmType fType;
    private Map<RfXvmObjectInstance, RfXvmObjectInstance> fChildInstances;
    private Map<RfField, RfXvmObjectInstance> fChildInstancesByLhField;
    private List<RfXvmField> fRegisteredFields;
    private boolean fIsFactoryRegistered;

    public RfXvmObject(RfXvmFactory factory, RfClass rfClass, RfXvmFactory.RfXvmType type, boolean isFactoryRegistered) {
        this.fRfClass = rfClass;
        this.fFactory = factory;
        this.fType = type;
        this.fIsFactoryRegistered = isFactoryRegistered;
    }

    public boolean isFactoryRegistered() {
        return this.fIsFactoryRegistered;
    }

    public RfXvmFactory getFactory() {
        return this.fFactory;
    }

    public RfXvmFactory.RfXvmType getType() {
        return this.fType;
    }

    @Override
    public IRfNamedElement getNamedElement() {
        return this.fRfClass;
    }

    public RfClass getRfClass() {
        return this.fRfClass;
    }

    RfXvmObjectInstance addChildInstance(RfXvmObjectInstance instance) {
        if (this.fChildInstances == null) {
            this.fChildInstances = new LinkedHashMap<RfXvmObjectInstance, RfXvmObjectInstance>();
        }
        if (this.fChildInstancesByLhField == null) {
            this.fChildInstancesByLhField = new IdentityHashMap<RfField, RfXvmObjectInstance>();
        }
        this.fChildInstancesByLhField.put(instance.getLHField(), instance);
        return this.fChildInstances.put(instance, instance);
    }

    public RfXvmObjectInstance getChildInstance(RfField lhField) {
        return this.fChildInstancesByLhField == null ? null : this.fChildInstancesByLhField.get(lhField);
    }

    RfXvmObjectInstance getChildInstance(RfXvmObjectInstance instance) {
        if (this.fChildInstances == null) {
            return null;
        }
        return this.fChildInstances.get(instance);
    }

    public boolean hasChildInstance(RfXvmObjectInstance instance) {
        if (this.fChildInstances == null) {
            return false;
        }
        return this.fChildInstances.containsKey(instance);
    }

    Collection<RfXvmObjectInstance> getChildInstances() {
        if (this.fChildInstances == null) {
            return null;
        }
        return this.fChildInstances.values();
    }

    public boolean hasChildInstances() {
        return this.fChildInstances != null && !this.fChildInstances.isEmpty();
    }

    public String getName() {
        if (this.fRfClass == null) {
            return "";
        }
        return this.fRfClass.getName();
    }

    public IRfScopeElement getEnclosingScope() {
        return this.getNamedElement().getEnclosingScope();
    }

    List<RfXvmField> getRegisteredFields() {
        return this.fRegisteredFields;
    }

    void setRegisteredFields(List<RfXvmField> registeredFields) {
        this.fRegisteredFields = registeredFields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.fRfClass != null ? this.fRfClass.toString() : "");
        List<RfXvmPort> ports = this.fFactory.getOwnPorts(this.fRfClass);
        if (!ports.isEmpty()) {
            builder.append("\n    [Ports:");
            for (RfXvmPort port : ports) {
                builder.append(String.valueOf(port.toString()) + ", ");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("]");
        }
        if (this.fRegisteredFields != null && !this.fRegisteredFields.isEmpty()) {
            builder.append("\n    [Fields:");
            for (RfXvmField field : this.fRegisteredFields) {
                builder.append(String.valueOf(field.toString()) + ", ");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("]");
        }
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fRfClass == null ? 0 : this.fRfClass.hashCode());
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfXvmObject other = (RfXvmObject)obj;
        if (this.fRfClass == null ? other.fRfClass != null : !this.fRfClass.equals(other.fRfClass)) {
            return false;
        }
        return this.fType == other.fType;
    }

    @Override
    public void deepClean() {
        this.fFactory = null;
        this.fRfClass = null;
        this.fType = null;
        if (this.fChildInstances != null) {
            for (Map.Entry<RfXvmObjectInstance, RfXvmObjectInstance> entry : this.fChildInstances.entrySet()) {
                entry.getKey().deepClean();
            }
            this.fChildInstances.clear();
        }
        this.fChildInstances = null;
        if (this.fChildInstancesByLhField != null) {
            for (Map.Entry<Serializable, RfXvmObjectInstance> entry : this.fChildInstancesByLhField.entrySet()) {
                entry.getValue().deepClean();
            }
            this.fChildInstancesByLhField.clear();
        }
        this.fChildInstancesByLhField = null;
        if (this.fRegisteredFields != null) {
            for (RfXvmField rfXvmField : this.fRegisteredFields) {
                rfXvmField.deepClean();
            }
            this.fRegisteredFields.clear();
        }
        this.fRegisteredFields = null;
        this.fIsFactoryRegistered = false;
    }

    public List<? extends IRfVHBreadcrumbElement> getAllVHChildren() {
        return RfXvmFactory.getChildInstances(this);
    }
}

