/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.model.reflection.xvm;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;

public class RfXvmObjectInstance
extends RfXvmBase
implements IRfVHBreadcrumbElement {
    private static final long serialVersionUID = 2L;
    private List<RfXvmFactory.XVMCreateCall> methodCalls = new ArrayList<RfXvmFactory.XVMCreateCall>();
    private RfField lhField;
    @NotNull
    private RfXvmObject object;
    private String name;
    private boolean isArray;

    public RfXvmObjectInstance(String name, RfField field, RfXvmObject object) {
        this.name = name;
        this.lhField = field;
        this.object = object;
    }

    public List<RfXvmFactory.XVMCreateCall> getCreateCalls() {
        return this.methodCalls;
    }

    public RfXvmObject getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public IRfScopeElement getEnclosingScope() {
        return this.getNamedElement().getEnclosingScope();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        if (this.name == null || this.object == null) {
            return "";
        }
        return String.valueOf(this.name) + (this.isArray ? "[]" : "") + " : " + this.object.getName();
    }

    void setArray() {
        this.isArray = true;
    }

    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public IRfNamedElement getNamedElement() {
        return this.lhField != null ? this.lhField : (this.object != null ? this.object.getNamedElement() : null);
    }

    public RfField getLHField() {
        return this.lhField;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isArray ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfXvmObjectInstance other = (RfXvmObjectInstance)obj;
        if (this.isArray != other.isArray) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }

    @Override
    public void deepClean() {
        this.methodCalls.clear();
        this.lhField = null;
        this.object = null;
        this.name = null;
    }

    public List<? extends IRfVHBreadcrumbElement> getAllVHChildren() {
        return RfXvmFactory.getChildInstances(this.object);
    }
}

